/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedAssessmentFacade
implements Serializable,
PublishedAssessmentIfc,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(PublishedAssessmentFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    public static final Integer ACTIVE_STATUS = 1;
    public static final Integer INACTIVE_STATUS = 0;
    public static final Integer ANY_STATUS = 2;
    private PublishedAssessmentIfc data;
    private AssessmentFacade assessment;
    private Long publishedAssessmentId;
    private Long assessmentId;
    private Boolean isTemplate = Boolean.FALSE;
    private Long parentId;
    private String title;
    private String description;
    private String comments;
    private Long typeId;
    private Integer instructorNotification;
    private Integer testeeNotification;
    private Integer multipartAllowed;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private AssessmentAccessControlIfc publishedAccessControl;
    private EvaluationModelIfc publishedEvaluationModel;
    private AssessmentFeedbackIfc publishedFeedback;
    private Set publishedMetaDataSet;
    private Map<String, String> publishedMetaDataMap = new HashMap<String, String>();
    private Set publishedSectionSet;
    private Set publishedSecuredIPAddressSet;
    private String releaseTo;
    private Date startDate;
    private Date dueDate;
    private Date retractDate;
    private int submissionSize;
    private Integer lateHandling;
    private Boolean unlimitedSubmissions;
    private Integer submissionsAllowed;
    private Integer scoringType;
    private Integer feedbackDelivery;
    private Integer feedbackComponentOption;
    private Integer feedbackAuthoring;
    private Date feedbackDate;
    private String ownerSiteName;
    private Set publishedAssessmentAttachmentSet;
    private boolean hasAssessmentGradingData;
    private int inProgressCount;
    private int submittedCount;
    private Date lastNeedResubmitDate;
    private boolean activeStatus;
    private Map releaseToGroups;
    private int enrolledStudentCount;
    private Integer timeLimit;
    private String lastModifiedDateForDisplay;
    private int groupCount;
    private boolean selected;

    public PublishedAssessmentFacade() {
    }

    public PublishedAssessmentFacade(Long id, String title, String createdBy) {
        this.publishedAssessmentId = id;
        this.title = title;
        this.createdBy = createdBy;
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Map releaseToGroups) {
        this(id, title, releaseTo, startDate, dueDate, releaseToGroups, null, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Map releaseToGroups, Date lastModifiedDate, String lastModifiedBy) {
        this(id, title, releaseTo, startDate, dueDate, null, null, releaseToGroups, lastModifiedDate, lastModifiedBy, null, null, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Integer status, Map releaseToGroups, Date lastModifiedDate, String lastModifiedBy) {
        this(id, title, releaseTo, startDate, dueDate, null, status, releaseToGroups, lastModifiedDate, lastModifiedBy, null, null, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Integer status, Map releaseToGroups, Date lastModifiedDate, String lastModifiedBy, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed) {
        this.publishedAssessmentId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.status = status;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
        this.releaseToGroups = releaseToGroups;
        this.lateHandling = lateHandling;
        this.unlimitedSubmissions = unlimitedSubmissions;
        this.submissionsAllowed = submissionsAllowed;
        this.setGroupCount();
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, null, null, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, null, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, status, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status, Date lastModifiedDate) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, status, lastModifiedDate, null);
    }

    public PublishedAssessmentFacade(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status, Date lastModifiedDate, Integer timeLimit) {
        this.publishedAssessmentId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.feedbackDelivery = feedbackDelivery;
        this.feedbackComponentOption = feedbackComponentOption;
        this.feedbackAuthoring = feedbackAuthoring;
        this.feedbackDate = feedbackDate;
        this.lateHandling = lateHandling;
        this.unlimitedSubmissions = unlimitedSubmissions != null ? unlimitedSubmissions : Boolean.TRUE;
        this.submissionsAllowed = submissionsAllowed == null ? Integer.valueOf(0) : submissionsAllowed;
        this.scoringType = scoringType;
        this.status = status;
        this.lastModifiedDate = lastModifiedDate;
        this.timeLimit = timeLimit;
    }

    public PublishedAssessmentFacade(Long id, String title, AssessmentAccessControlIfc publishedAccessControl) {
        this.publishedAssessmentId = id;
        this.title = title;
        this.publishedAccessControl = publishedAccessControl;
    }

    public PublishedAssessmentFacade(PublishedAssessmentIfc data, Boolean loadSection) {
        this.setProperties(data);
        if (loadSection.equals(Boolean.TRUE)) {
            this.publishedSectionSet = data.getSectionSet();
        }
    }

    public PublishedAssessmentFacade(PublishedAssessmentIfc data) {
        this.setProperties(data);
        this.publishedSectionSet = data.getSectionSet();
    }

    public PublishedAssessmentFacade(PublishedAssessmentIfc data, Map releaseToGroups) {
        this.setProperties(data);
        this.publishedSectionSet = data.getSectionSet();
        this.releaseToGroups = releaseToGroups;
    }

    public PublishedAssessmentFacade(AssessmentIfc data) {
        this((PublishedAssessmentIfc)data);
    }

    private void setProperties(PublishedAssessmentIfc data) {
        this.data = data;
        this.publishedAssessmentId = data.getPublishedAssessmentId();
        this.assessmentId = data.getAssessmentId();
        this.title = data.getTitle();
        this.description = data.getDescription();
        this.comments = data.getComments();
        this.publishedMetaDataSet = data.getAssessmentMetaDataSet();
        this.instructorNotification = data.getInstructorNotification();
        this.testeeNotification = data.getTesteeNotification();
        this.multipartAllowed = data.getMultipartAllowed();
        this.status = data.getStatus();
        this.createdBy = data.getCreatedBy();
        this.createdDate = data.getCreatedDate();
        this.lastModifiedBy = data.getLastModifiedBy();
        this.lastModifiedDate = data.getLastModifiedDate();
        this.publishedAccessControl = data.getAssessmentAccessControl();
        this.publishedFeedback = data.getAssessmentFeedback();
        this.publishedEvaluationModel = data.getEvaluationModel();
        this.publishedMetaDataMap = data.getAssessmentMetaDataMap(this.publishedMetaDataSet);
        this.publishedSecuredIPAddressSet = data.getSecuredIPAddressSet();
        this.publishedAssessmentAttachmentSet = data.getAssessmentAttachmentSet();
    }

    public Long getPublishedAssessmentId() {
        return this.publishedAssessmentId;
    }

    public void setPublishedAssessmentId(Long publishedAssessmentId) {
        this.publishedAssessmentId = publishedAssessmentId;
        this.data.setAssessmentBaseId(publishedAssessmentId);
    }

    public AssessmentIfc getAssessment() {
        return this.assessment;
    }

    public void setAssessment(AssessmentIfc assessment) {
        this.assessment = (AssessmentFacade)assessment;
        AssessmentData d = (AssessmentData)this.assessment.getData();
        this.data.setAssessmentId(d.getAssessmentBaseId());
    }

    public Long getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(Long assessmentId) {
        this.setAssessmentBaseId(assessmentId);
    }

    public Long getAssessmentBaseId() {
        return this.assessmentId;
    }

    public void setAssessmentBaseId(Long id) {
        this.assessmentId = id;
        this.data.setAssessmentBaseId(id);
    }

    public Boolean getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(Boolean isTemplate) {
    }

    public Long getParentId() {
        return null;
    }

    public void setParentId(Long parentId) {
    }

    public Long getAssessmentTemplateId() {
        return null;
    }

    public void setAssessmentTemplateId(Long assessmentTemplateId) {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.data != null) {
            this.data.setTitle(title);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
        this.data.setComments(comments);
    }

    public Integer getInstructorNotification() {
        return this.instructorNotification;
    }

    public void setInstructorNotification(Integer instructorNotification) {
        this.instructorNotification = instructorNotification;
        this.data.setInstructorNotification(instructorNotification);
    }

    public Integer getTesteeNotification() {
        return this.testeeNotification;
    }

    public void setTesteeNotification(Integer testeeNotification) {
        this.testeeNotification = testeeNotification;
        this.data.setTesteeNotification(testeeNotification);
    }

    public Integer getMultipartAllowed() {
        return this.multipartAllowed;
    }

    public void setMultipartAllowed(Integer multipartAllowed) {
        this.multipartAllowed = multipartAllowed;
        this.data.setMultipartAllowed(multipartAllowed);
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.data.setStatus(status);
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.data.setCreatedBy(createdBy);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        this.data.setCreatedDate(createdDate);
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        this.data.setLastModifiedDate(lastModifiedDate);
    }

    public AssessmentAccessControlIfc getAssessmentAccessControl() {
        return this.publishedAccessControl;
    }

    public void setAssessmentAccessControl(AssessmentAccessControlIfc publishedAccessControl) {
        this.publishedAccessControl = publishedAccessControl;
        this.data.setAssessmentAccessControl(publishedAccessControl);
    }

    public EvaluationModelIfc getEvaluationModel() {
        return this.publishedEvaluationModel;
    }

    public void setEvaluationModel(EvaluationModelIfc publishedEvaluationModel) {
        this.publishedEvaluationModel = publishedEvaluationModel;
        this.data.setEvaluationModel(publishedEvaluationModel);
    }

    public AssessmentFeedbackIfc getAssessmentFeedback() {
        return this.publishedFeedback;
    }

    public void setAssessmentFeedback(AssessmentFeedbackIfc assessmentFeedback) {
        this.publishedFeedback = assessmentFeedback;
    }

    public Set getAssessmentMetaDataSet() {
        return this.publishedMetaDataSet;
    }

    public void setAssessmentMetaDataSet(Set publishedMetaDataSet) {
        this.publishedMetaDataSet = publishedMetaDataSet;
        this.data.setAssessmentMetaDataSet(publishedMetaDataSet);
        this.publishedMetaDataMap = this.getAssessmentMetaDataMap(publishedMetaDataSet);
    }

    public HashMap getAssessmentMetaDataMap(Set publishedMetaDataSet) {
        HashMap<String, String> publishedMetaDataMap = new HashMap<String, String>();
        if (publishedMetaDataSet != null) {
            for (PublishedMetaData publishedMetaData : publishedMetaDataSet) {
                publishedMetaDataMap.put(publishedMetaData.getLabel(), publishedMetaData.getEntry());
            }
        }
        return publishedMetaDataMap;
    }

    public HashMap getAssessmentMetaDataMap() {
        HashMap<String, String> publishedMetaDataMap = new HashMap<String, String>();
        if (this.publishedMetaDataSet != null) {
            for (PublishedMetaData publishedMetaData : this.publishedMetaDataSet) {
                publishedMetaDataMap.put(publishedMetaData.getLabel(), publishedMetaData.getEntry());
            }
        }
        return publishedMetaDataMap;
    }

    public String getAssessmentMetaDataByLabel(String label) {
        return this.publishedMetaDataMap.get(label);
    }

    public void addAssessmentMetaData(String label, String entry) {
        this.publishedMetaDataMap = this.getAssessmentMetaDataMap();
        if (this.publishedMetaDataMap.get(label) != null) {
            for (PublishedMetaData metadata : this.publishedMetaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            PublishedMetaData metadata = null;
            if (entry != null && !"".equals(entry.trim())) {
                metadata = new PublishedMetaData((AssessmentBaseIfc)this.data, label, entry);
                this.publishedMetaDataSet.add(metadata);
            }
            this.setAssessmentMetaDataSet(this.publishedMetaDataSet);
        }
    }

    public void updateAssessmentMetaData(String label, String entry) {
        this.addAssessmentMetaData(label, entry);
    }

    public Set getSectionSet() {
        return this.publishedSectionSet;
    }

    public void setSectionSet(Set sectionSet) {
        this.publishedSectionSet = sectionSet;
        this.data.setSectionSet(sectionSet);
    }

    public Set getSecuredIPAddressSet() {
        return this.publishedSecuredIPAddressSet;
    }

    public void setSecuredIPAddressSet(Set publishedSecuredIPAddressSet) {
        this.publishedSecuredIPAddressSet = publishedSecuredIPAddressSet;
        this.data.setSecuredIPAddressSet(publishedSecuredIPAddressSet);
    }

    public PublishedAssessmentIfc getData() {
        return this.data;
    }

    public TypeIfc getType() {
        return null;
    }

    public ArrayList getSectionArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.publishedSectionSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getSectionArraySorted() {
        ArrayList list = this.getSectionArray();
        Collections.sort(list);
        return list;
    }

    public String getReleaseTo() {
        return this.releaseTo;
    }

    public Date getStartDate() {
        if (this.startDate == null && this.publishedAccessControl != null) {
            return this.publishedAccessControl.getStartDate();
        }
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getDueDate() {
        if (this.dueDate == null && this.publishedAccessControl != null) {
            return this.publishedAccessControl.getDueDate();
        }
        return this.dueDate;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
    }

    public int getSubmissionSize() {
        return this.submissionSize;
    }

    public void setSubmissionSize(int size) {
        this.submissionSize = size;
    }

    public SectionDataIfc getSection(Long sequence) {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(sequence.intValue() - 1);
    }

    public SectionDataIfc getDefaultSection() {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(0);
    }

    public Integer getLateHandling() {
        return this.lateHandling;
    }

    public Boolean getUnlimitedSubmissions() {
        return this.unlimitedSubmissions;
    }

    public Integer getSubmissionsAllowed() {
        return this.submissionsAllowed;
    }

    public Integer getScoringType() {
        return this.scoringType;
    }

    public Date getRetractDate() {
        if (this.retractDate == null && this.publishedAccessControl != null) {
            return this.publishedAccessControl.getRetractDate();
        }
        return this.retractDate;
    }

    public void setRetractDate(Date date) {
        this.retractDate = date;
    }

    public Integer getFeedbackDelivery() {
        return this.feedbackDelivery;
    }

    public Integer getFeedbackComponentOption() {
        return this.feedbackComponentOption;
    }

    public void setFeedbackComponentOption(Integer feedbackComponentOption) {
        this.feedbackComponentOption = feedbackComponentOption;
    }

    public Integer getFeedbackAuthoring() {
        return this.feedbackAuthoring;
    }

    public Date getFeedbackDate() {
        return this.feedbackDate;
    }

    public void setOwnerSite(String ownerSiteName) {
        this.ownerSiteName = ownerSiteName;
    }

    public String getOwnerSite() {
        PublishedAssessmentService service = new PublishedAssessmentService();
        String ownerSiteId = service.getPublishedAssessmentOwner(this.publishedAssessmentId);
        log.debug("**** ownerSiteId=" + ownerSiteId);
        this.ownerSiteName = AgentFacade.getSiteName(ownerSiteId);
        return this.ownerSiteName;
    }

    public String getOwnerSiteId() {
        PublishedAssessmentService service = new PublishedAssessmentService();
        return service.getPublishedAssessmentOwner(this.publishedAssessmentId);
    }

    public Double getTotalScore() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (SectionDataIfc s : this.publishedSectionSet) {
            ArrayList list = s.getItemArray();
            Iterator iter2 = null;
            if (s.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && s.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                ArrayList randomsample = new ArrayList();
                Integer numberToBeDrawn = 0;
                if (s.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    numberToBeDrawn = new Integer(s.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                }
                int samplesize = numberToBeDrawn;
                for (int i = 0; i < samplesize; ++i) {
                    randomsample.add(list.get(i));
                }
                iter2 = randomsample.iterator();
            } else {
                iter2 = list.iterator();
            }
            while (iter2.hasNext()) {
                ItemDataIfc item = (ItemDataIfc)iter2.next();
                total = total.add(BigDecimal.valueOf(item.getScore()));
            }
        }
        return total.doubleValue();
    }

    public PublishedAssessmentFacade clonePublishedAssessment() {
        try {
            return (PublishedAssessmentFacade)this.clone();
        }
        catch (CloneNotSupportedException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public Set getAssessmentAttachmentSet() throws DataFacadeException {
        return this.publishedAssessmentAttachmentSet;
    }

    public void setAssessmentAttachmentSet(Set publishedAssessmentAttachmentSet) {
        this.publishedAssessmentAttachmentSet = publishedAssessmentAttachmentSet;
        this.data.setAssessmentAttachmentSet(publishedAssessmentAttachmentSet);
    }

    public List getAssessmentAttachmentList() {
        ArrayList<AssessmentAttachmentIfc> list = new ArrayList<AssessmentAttachmentIfc>();
        if (this.publishedAssessmentAttachmentSet != null) {
            for (AssessmentAttachmentIfc a : this.publishedAssessmentAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public String getHasMetaDataForQuestions() {
        return this.publishedMetaDataMap.get("hasMetaDataForQuestions");
    }

    public Map getReleaseToGroups() {
        return this.releaseToGroups;
    }

    public boolean getHasAssessmentGradingData() {
        return this.hasAssessmentGradingData;
    }

    public void setHasAssessmentGradingData(boolean hasAssessmentGradingData) {
        this.hasAssessmentGradingData = hasAssessmentGradingData;
    }

    public void setGroupCount() {
        this.groupCount = this.releaseToGroups != null ? this.releaseToGroups.size() : 0;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getInProgressCount() {
        return this.inProgressCount;
    }

    public void setInProgressCount(int inProgressCount) {
        this.inProgressCount = inProgressCount;
    }

    public int getSubmittedCount() {
        return this.submittedCount;
    }

    public void setSubmittedCount(int submittedCount) {
        this.submittedCount = submittedCount;
    }

    public int getEnrolledStudentCount() {
        return this.enrolledStudentCount;
    }

    public void setEnrolledStudentCount(int enrolledStudentCount) {
        this.enrolledStudentCount = enrolledStudentCount;
    }

    public Date getLastNeedResubmitDate() {
        return this.lastNeedResubmitDate;
    }

    public void setLastNeedResubmitDate(Date lastNeedResubmitDate) {
        this.lastNeedResubmitDate = lastNeedResubmitDate;
        this.data.setLastNeedResubmitDate(lastNeedResubmitDate);
    }

    public Integer getTimeLimit() {
        if (this.timeLimit == null && this.publishedAccessControl != null) {
            return this.publishedAccessControl.getTimeLimit();
        }
        return this.timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean getActiveStatus() {
        return this.activeStatus;
    }

    public void setActiveStatus(boolean activeStatus) {
        this.activeStatus = activeStatus;
    }

    public String getLastModifiedDateForDisplay() {
        return this.lastModifiedDateForDisplay;
    }

    public void setLastModifiedDateForDisplay(String lastModifiedDateForDisplay) {
        this.lastModifiedDateForDisplay = lastModifiedDateForDisplay;
    }

    public void setLateHandling(Integer lateHandling) {
        this.lateHandling = lateHandling;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

