/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.ItemHashUtil;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class PublishedItemFacadeQueries
extends HibernateDaoSupport
implements PublishedItemFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(PublishedItemFacadeQueries.class);
    private ItemHashUtil itemHashUtil;
    private static final Map<String, String> BACKFILL_ALL_HASHES_HQL = new HashMap<String, String>(){
        {
            this.put("total.item.count.hql", "select count(*) from PublishedItemData");
            this.put("total.hash.backfillable.item.count.hql", "select count(*) from PublishedItemData as item where item.hash is null or item.itemHash is null");
            this.put("all.backfillable.item.ids.hql", "select item.id from PublishedItemData as item where item.hash is null or item.itemHash is null");
            this.put("items.by.id.hql", "select item from PublishedItemData as item where item.id in ({ID_PARAMS})");
        }
    };
    private static final Map<String, String> BACKFILL_CURRENT_HASHES_HQL = new HashMap<String, String>(){
        {
            this.put("total.item.count.hql", "select count(*) from PublishedItemData");
            this.put("total.hash.backfillable.item.count.hql", "select count(*) from PublishedItemData as item where item.hash is null");
            this.put("all.backfillable.item.ids.hql", "select item.id from PublishedItemData as item where item.hash is null");
            this.put("items.by.id.hql", "select item from PublishedItemData as item where item.id in ({ID_PARAMS})");
        }
    };

    public void setItemHashUtil(ItemHashUtil itemHashUtil) {
        this.itemHashUtil = itemHashUtil;
    }

    @Override
    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    @Override
    public PublishedItemFacade getItem(Long itemId, String agent) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    @Override
    public PublishedItemFacade getItem(String itemId) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)Long.valueOf(itemId));
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    @Override
    public Boolean itemExists(String itemId) {
        try {
            if (this.getHibernateTemplate().get(PublishedItemData.class, (Serializable)Long.valueOf(itemId)) == null) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, ItemFacade> getPublishedItemsByHash(String hash) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from PublishedItemData where hash = ? ");
            q.setString(0, hash);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<String, ItemFacade> itemFacadeMap = new HashMap<String, ItemFacade>();
        for (int i = 0; i < list1.size(); ++i) {
            PublishedItemData a = (PublishedItemData)list1.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)a);
            itemFacadeMap.put(f.getItemIdString(), f);
        }
        return itemFacadeMap;
    }

    @Override
    public void deleteItemContent(Long itemId, String agent) {
        Set set;
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemTextSet();
                    item.setItemTextSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleteItemTextSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemMetaDataSet();
                    item.setItemMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleteItemMetaDataSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemFeedbackSet();
                    item.setItemFeedbackSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting ItemFeedbackSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void updateItemTagBindingsHavingTag(TagServiceHelper.TagView tagView) {
        this.getHibernateTemplate().bulkUpdate("update PublishedItemTag it set it.tagLabel = ?, it.tagCollectionId = ?, it.tagCollectionName = ? where it.tagId = ?", new Object[]{tagView.tagLabel, tagView.tagCollectionId, tagView.tagCollectionName, tagView.tagId});
    }

    @Override
    public void deleteItemTagBindingsHavingTagId(String tagId) {
        this.getHibernateTemplate().bulkUpdate("delete PublishedItemTag it where it.tagId = ?", new Object[]{tagId});
    }

    @Override
    public void updateItemTagBindingsHavingTagCollection(TagServiceHelper.TagCollectionView tagCollectionView) {
        this.getHibernateTemplate().bulkUpdate("update PublishedItemTag it set it.tagCollectionName = ? where it.tagCollectionId = ?", new Object[]{tagCollectionView.tagCollectionName, tagCollectionView.tagCollectionId});
    }

    @Override
    public void deleteItemTagBindingsHavingTagCollectionId(String tagCollectionId) {
        this.getHibernateTemplate().bulkUpdate("delete PublishedItemTag it where it.tagCollectionId = ?", new Object[]{tagCollectionId});
    }

    @Override
    public BackfillItemHashResult backfillItemHashes(int batchSize, boolean backfillBaselineHashes) {
        return this.itemHashUtil.backfillItemHashes(batchSize, backfillBaselineHashes ? BACKFILL_ALL_HASHES_HQL : BACKFILL_CURRENT_HASHES_HQL, PublishedItemData.class, i -> {
            String hash = this.itemHashUtil.hashItemUnchecked((ItemDataIfc)i);
            if (StringUtils.isEmpty((CharSequence)i.getHash())) {
                i.setHash(hash);
            }
            if (backfillBaselineHashes && StringUtils.isEmpty((CharSequence)((PublishedItemData)i).getItemHash())) {
                ((PublishedItemData)i).setItemHash(hash);
            }
            return i;
        }, this.getHibernateTemplate());
    }

    @Override
    public List<Long> getPublishedItemsIdsByHash(String hash) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab.itemId from PublishedItemData ab where ab.hash = ? ");
            q.setString(0, hash);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        return list1;
    }

    @Override
    public Long getPublishedAssessmentId(Long itemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s.assessment.publishedAssessmentId from PublishedSectionData s, PublishedItemData i where s.id = i.section AND i.itemId = ?");
            q.setLong(0, itemId.longValue());
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        if (list1.isEmpty()) {
            return -1L;
        }
        return (Long)list1.get(0);
    }

    @Override
    public void removeItemAttachment(Long itemAttachmentId) {
        PublishedItemAttachment itemAttachment = (PublishedItemAttachment)this.getHibernateTemplate().load(PublishedItemAttachment.class, (Serializable)itemAttachmentId);
        ItemDataIfc item = itemAttachment.getItem();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item == null) continue;
                Set set = item.getItemAttachmentSet();
                set.remove(itemAttachment);
                this.getHibernateTemplate().delete(this.getHibernateTemplate().merge((Object)itemAttachment));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("Error while trying to delete PublishedItemAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }
}

