/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolAccessData;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.util.api.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class QuestionPoolFacadeQueries
extends HibernateDaoSupport
implements QuestionPoolFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(QuestionPoolFacadeQueries.class);
    private static final String VERSION_START = " - ";
    private final FormattedText formattedText = (FormattedText)ComponentManager.get(FormattedText.class);

    @Override
    public IdImpl getQuestionPoolId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getQuestionPoolId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getQuestionPoolId(long id) {
        return new IdImpl(id);
    }

    @Override
    public List getAllPools() {
        return this.getHibernateTemplate().find("from QuestionPoolData", new Object[0]);
    }

    public List getAllPoolsByAgent(String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from QuestionPoolData a  where a.questionPoolId in (select ac.questionPoolId from QuestionPoolAccessData ac where agentId = :agent) ");
            q.setString("agent", agentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return list;
    }

    @Override
    public QuestionPoolIteratorFacade getAllPools(String agentId) {
        ArrayList<QuestionPoolFacade> qpList = new ArrayList<QuestionPoolFacade>();
        HibernateCallback hcb = session -> session.createQuery("from QuestionPoolData a where a.ownerId = :id").setString("id", agentId).list();
        List poolList = (List)this.getHibernateTemplate().execute(hcb);
        try {
            Map<Long, Long> counts = this.getSubPoolSizes(agentId).stream().collect(Collectors.toMap(pool -> pool[0], pool -> pool[1]));
            Iterator iterator = poolList.iterator();
            while (iterator.hasNext()) {
                QuestionPoolData qpp;
                Long subPoolSize = counts.get((qpp = (QuestionPoolData)iterator.next()).getQuestionPoolId());
                qpp.setSubPoolSize(Long.valueOf(subPoolSize == null ? 0L : subPoolSize));
                qpList.add(this.getQuestionPool(qpp));
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        return new QuestionPoolIteratorFacade(qpList);
    }

    @Override
    public QuestionPoolIteratorFacade getAllPoolsWithAccess(String agentId) {
        ArrayList<QuestionPoolFacade> qpList = new ArrayList<QuestionPoolFacade>();
        Map<Long, Long> counts = this.getSubPoolSizes(agentId).stream().collect(Collectors.toMap(pool -> pool[0], pool -> pool[1]));
        List poolList = this.getAllPoolsByAgent(agentId);
        try {
            for (QuestionPoolData qpp : poolList) {
                qpp.setSubPoolSize(counts.get(qpp.getQuestionPoolId()));
                qpList.add(this.getQuestionPool(qpp));
            }
        }
        catch (Exception e) {
            log.warn("Error in getAllPoolsWithAccess: " + e.getMessage(), (Throwable)e);
        }
        return new QuestionPoolIteratorFacade(qpList);
    }

    @Override
    public List<QuestionPoolFacade> getBasicInfoOfAllPools(String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new QuestionPoolData(a.questionPoolId, a.title, a.parentPoolId)from QuestionPoolData a where a.questionPoolId  in (select ac.questionPoolId from QuestionPoolAccessData ac where agentId = :agent)");
            q.setString("agent", agentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<QuestionPoolFacade> poolList = new ArrayList<QuestionPoolFacade>();
        for (int i = 0; i < list.size(); ++i) {
            QuestionPoolData a = (QuestionPoolData)list.get(i);
            QuestionPoolFacade f = new QuestionPoolFacade(a.getQuestionPoolId(), a.getTitle(), a.getParentPoolId());
            poolList.add(f);
        }
        return poolList;
    }

    private QuestionPoolFacade getQuestionPool(QuestionPoolData qpp) {
        try {
            return new QuestionPoolFacade((QuestionPoolDataIfc)qpp);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private List getAllItemsInThisPoolOnlyAndDetachFromAssessment(Long questionPoolId) {
        List list = this.getAllItemsInThisPoolOnly(questionPoolId);
        ArrayList<ItemData> newlist = new ArrayList<ItemData>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            if (itemdata.getSection() == null) {
                newlist.add(itemdata);
                continue;
            }
            itemdata.removeMetaDataByType("POOLID");
            this.getHibernateTemplate().saveOrUpdate((Object)itemdata);
        }
        return newlist;
    }

    private List getAllItemsInThisPoolOnly(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = :id");
            q.setLong("id", questionPoolId.longValue());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<ItemData> newlist = new ArrayList<ItemData>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            String itemId = itemdata.getItemId().toString();
            if (this.getPoolIdsByItem(itemId).size() != 1) continue;
            newlist.add(itemdata);
        }
        return newlist;
    }

    @Override
    public List getAllItems(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = :id order by ab.itemId");
            q.setLong("id", questionPoolId.longValue());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return list;
    }

    @Override
    public List getAllItemsIds(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select qpi.itemId from QuestionPoolItemData qpi where qpi.questionPoolId = ?");
            q.setLong(0, questionPoolId.longValue());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return list;
    }

    @Override
    public List getAllItemFacadesOrderByItemText(Long questionPoolId, String orderBy, String ascending) {
        ItemFacade itemFacade;
        log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: orderBy = {}", (Object)orderBy);
        List list = this.getAllItems(questionPoolId);
        log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: size = {}", (Object)list.size());
        HashMap<String, Vector<Integer>> hp = new HashMap<String, Vector<Integer>>();
        Vector<ItemFacade> facadeVector = new Vector<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: i = {}", (Object)i);
            ItemData itemData = (ItemData)list.get(i);
            itemFacade = new ItemFacade((ItemDataIfc)itemData);
            facadeVector.add(itemFacade);
            log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getItemId = {}", (Object)itemData.getItemId());
            log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getText = {}", (Object)itemData.getText());
            String text = this.formattedText.stripHtmlFromText(itemFacade.getText(), false, true);
            log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getTextHtmlStrippedAll = '{}'", (Object)text);
            Vector<Integer> origValueV = (Vector<Integer>)hp.get(text);
            if (origValueV == null) {
                log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: origValueV is null");
                origValueV = new Vector<Integer>();
            }
            origValueV.add(i);
            hp.put(text, origValueV);
        }
        Vector v = new Vector(hp.keySet());
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        Iterator it = v.iterator();
        if (ascending != null && "false".equals(ascending)) {
            for (int l = v.size() - 1; l >= 0; --l) {
                String key = (String)v.get(l);
                Vector orderdValueV = (Vector)hp.get(key);
                for (Integer value : orderdValueV) {
                    ItemData itemdata = (ItemData)list.get(value);
                    ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
                    itemList.add(f);
                }
            }
        } else {
            while (it.hasNext()) {
                String key = (String)it.next();
                Vector orderdValueV = (Vector)hp.get(key);
                for (Integer value : orderdValueV) {
                    log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: sorted (value) = {}", (Object)value);
                    itemFacade = (ItemFacade)facadeVector.get(value);
                    itemList.add(itemFacade);
                }
            }
        }
        return itemList;
    }

    @Override
    public List getAllItemFacadesOrderByItemType(Long questionPoolId, String orderBy, String ascending) {
        log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: orderBy=" + orderBy);
        HibernateCallback hcb = session -> {
            Query q = "false".equals(ascending) ? session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi, TypeD t where ab.itemId=qpi.itemId and ab.typeId=t.typeId and qpi.questionPoolId = :id order by t." + orderBy + " desc") : session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi, TypeD t where ab.itemId=qpi.itemId and ab.typeId=t.typeId and qpi.questionPoolId = :id order by t." + orderBy);
            q.setLong("id", questionPoolId.longValue());
            log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: getQueryString() = " + q.getQueryString());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        log.debug("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: size = {}", (Object)list.size());
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
            itemList.add(f);
        }
        return itemList;
    }

    @Override
    public List getAllItemFacades(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = :id order by ab.itemId");
            q.setLong("id", questionPoolId.longValue());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
            itemList.add(f);
        }
        return itemList;
    }

    private void populateQuestionPoolItemDatas(QuestionPoolData qpp) {
        try {
            Set questionPoolItems = qpp.getQuestionPoolItems();
            if (questionPoolItems != null) {
                List itemList = this.getAllItems(qpp.getQuestionPoolId());
                qpp.setQuestions((Collection)itemList);
                qpp.setSubPoolSize(Long.valueOf(this.getSubPoolSize(qpp.getQuestionPoolId())));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ItemFacade getItem(String id) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)((Object)id));
        return new ItemFacade((ItemDataIfc)item);
    }

    @Override
    public QuestionPoolFacade getPool(Long poolId, String agent) {
        try {
            QuestionPoolData qpp = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)poolId);
            this.setPoolAccessType(qpp, agent);
            this.populateQuestionPoolItemDatas(qpp);
            return this.getQuestionPool(qpp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setPoolAccessType(QuestionPoolData qpp, String agentId) {
        try {
            QuestionPoolAccessData qpa = this.getQuestionPoolAccessData(qpp.getQuestionPoolId(), agentId);
            if (qpa != null) {
                qpp.setAccessTypeId(qpa.getAccessTypeId());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    @Override
    public QuestionPoolAccessData getQuestionPoolAccessData(Long poolId, String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from QuestionPoolAccessData as qpa where qpa.questionPoolId = :id and qpa.agentId = :agent");
            q.setLong("id", poolId.longValue());
            q.setString("agent", agentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return (QuestionPoolAccessData)list.get(0);
    }

    @Override
    public void addItemsToSection(Collection ids, long sectionId) {
    }

    @Override
    public void addItemToPool(QuestionPoolItemData qpi) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)qpi);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving item to pool: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deletePool(Long poolId, String agent, Tree tree) {
        try {
            HibernateCallback hcb;
            QuestionPoolData questionPool = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)poolId);
            List itemList = this.getAllItemsInThisPoolOnlyAndDetachFromAssessment(poolId);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)itemList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn("problem delete all items in pool: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    hcb = session -> {
                        Query q = session.createQuery("select qpi from QuestionPoolItemData as qpi where qpi.questionPoolId = :id");
                        q.setLong("id", poolId.longValue());
                        return q.list();
                    };
                    List list = (List)this.getHibernateTemplate().execute(hcb);
                    ArrayList<ItemMetaDataIfc> metaList = new ArrayList<ItemMetaDataIfc>();
                    for (int j = 0; j < list.size(); ++j) {
                        Long itemId = ((QuestionPoolItemData)list.get(j)).getItemId();
                        String query = "from ItemMetaData as meta where meta.item.itemId = :id and meta.label = :label";
                        List m = this.getHibernateTemplate().findByNamedParam(query, new String[]{"id", "label"}, new Object[]{itemId, "POOLID"});
                        if (m.size() <= 0) continue;
                        ItemMetaDataIfc meta = (ItemMetaDataIfc)m.get(0);
                        meta.setEntry(null);
                        metaList.add(meta);
                    }
                    try {
                        for (ItemMetaDataIfc meta : metaList) {
                            this.getHibernateTemplate().saveOrUpdate((Object)meta);
                        }
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn("problem delete question and questionpool map inside itemMetaData: {}", (Object)e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                    if (list.size() > 0) {
                        questionPool.setQuestionPoolItems(new HashSet());
                        this.getHibernateTemplate().deleteAll((Collection)list);
                        retryCount = 0;
                        continue;
                    }
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn("problem delete question and questionpool map: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            hcb = session -> {
                Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa, QuestionPoolData as qpp where qpa.questionPoolId = qpp.questionPoolId and (qpp.questionPoolId = :qid or qpp.parentPoolId = :pid) ");
                q.setLong("qid", poolId.longValue());
                q.setLong("pid", poolId.longValue());
                return q.list();
            };
            List qpaList = (List)this.getHibernateTemplate().execute(hcb);
            retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)qpaList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn("problem delete question pool access data: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            HibernateCallback hcb2 = session -> {
                Query q = session.createQuery("select qp from QuestionPoolData as qp where qp.id = :id");
                q.setLong("id", poolId.longValue());
                return q.list();
            };
            List qppList = (List)this.getHibernateTemplate().execute(hcb2);
            retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)qppList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn("problem delete all pools: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            Iterator citer = tree.getChildList(poolId).iterator();
            while (citer.hasNext()) {
                this.deletePool((Long)citer.next(), agent, tree);
            }
        }
        catch (DataAccessException e) {
            log.warn("error deleting pool. " + e.getMessage());
        }
    }

    @Override
    public void movePool(String agentId, Long sourcePoolId, Long destPoolId) {
        try {
            QuestionPoolFacade sourcePool = this.getPool(sourcePoolId, agentId);
            if (destPoolId.equals(QuestionPoolFacade.ROOT_POOL) && !sourcePoolId.equals(QuestionPoolFacade.ROOT_POOL)) {
                sourcePool.setParentPoolId(QuestionPoolFacade.ROOT_POOL);
                int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)((QuestionPoolData)sourcePool.getData()));
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn("problem moving pool: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
            } else {
                QuestionPoolFacade destPool = this.getPool(destPoolId, agentId);
                sourcePool.setParentPoolId(destPool.getQuestionPoolId());
                int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)((QuestionPoolData)sourcePool.getData()));
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn("problem update source pool: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.warn(e.getMessage());
        }
    }

    @Override
    public boolean isDescendantOf(QuestionPoolFacade destPool, QuestionPoolFacade sourcePool) {
        Long tempPoolId = destPool.getQuestionPoolId();
        try {
            while (tempPoolId != null && !tempPoolId.equals(QuestionPoolFacade.ROOT_POOL)) {
                QuestionPoolFacade tempPool = this.getPoolById(tempPoolId);
                if (tempPool.getParentPoolId().equals(sourcePool.getQuestionPoolId())) {
                    return true;
                }
                tempPoolId = tempPool.getParentPoolId();
            }
            return false;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return false;
        }
    }

    @Override
    public void removeItemFromPool(Long itemId, Long poolId) {
        QuestionPoolItemData qpi = new QuestionPoolItemData(poolId, itemId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete(this.getHibernateTemplate().merge((Object)qpi));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete item from pool: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void moveItemToPool(Long itemId, Long sourceId, Long destId) {
        QuestionPoolItemData qpi = new QuestionPoolItemData(sourceId, itemId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete(this.getHibernateTemplate().merge((Object)qpi));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete old mapping: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        QuestionPoolItemData qpi2 = new QuestionPoolItemData(destId, itemId);
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)qpi2);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving new mapping: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public QuestionPoolFacade savePool(QuestionPoolFacade pool) {
        boolean insert = false;
        try {
            QuestionPoolData qpp = (QuestionPoolData)pool.getData();
            qpp.setLastModified(new Date());
            qpp.setLastModifiedById(AgentFacade.getAgentString());
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            if (qpp.getQuestionPoolId() == null || qpp.getQuestionPoolId().equals(new Long("0"))) {
                insert = true;
            }
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().saveOrUpdate((Object)qpp);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn("problem saving Or Update pool: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            if (insert) {
                QuestionPoolAccessData qpa = new QuestionPoolAccessData(qpp.getQuestionPoolId(), qpp.getOwnerId(), QuestionPoolData.ADMIN);
                retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().save((Object)qpa);
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn("problem saving pool: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
                long parentPoolId = qpp.getParentPoolId();
                String ownerId = qpp.getOwnerId();
                if (parentPoolId != 0L) {
                    List listSubpool = new ArrayList();
                    try {
                        listSubpool = this.getHibernateTemplate().findByNamedParam("from QuestionPoolAccessData as qpa where qpa.questionPoolId = :id and qpa.agentId <> :agent", new String[]{"id", "agent"}, new Object[]{parentPoolId, ownerId});
                    }
                    catch (Exception e1) {
                        log.warn("problem finding pool: " + e1.getMessage());
                    }
                    for (QuestionPoolAccessData questioPoolData : listSubpool) {
                        qpa = new QuestionPoolAccessData(qpp.getQuestionPoolId(), questioPoolData.getAgentId(), QuestionPoolData.READ_COPY);
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                        while (retryCount > 0) {
                            try {
                                this.getHibernateTemplate().save((Object)qpa);
                                retryCount = 0;
                            }
                            catch (DataAccessException e) {
                                log.warn("problem saving pool: " + e.getMessage());
                                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock((Exception)((Object)e), retryCount);
                            }
                        }
                    }
                }
            }
            return pool;
        }
        catch (RuntimeException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    @Override
    public List getSubPools(Long poolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from QuestionPoolData as qpp where qpp.parentPoolId = :id");
            q.setLong("id", poolId.longValue());
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<Long[]> getSubPoolSizes(String agent) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a.questionPoolId, (select count(*) from QuestionPoolData b where b.parentPoolId=a.questionPoolId) from QuestionPoolData a where a.ownerId = :id");
            q.setCacheable(true);
            q.setString("id", agent);
            return q.list();
        };
        List objectResult = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<Long[]> longResult = new ArrayList<Long[]>(objectResult.size());
        for (Object[] array : objectResult) {
            longResult.add(new Long[]{((Number)array[0]).longValue(), ((Number)array[1]).longValue()});
        }
        return longResult;
    }

    @Override
    public long getSubPoolSize(Long poolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select count(qpp) from QuestionPoolData qpp where qpp.parentPoolId = :id");
            q.setCacheable(true);
            q.setLong("id", poolId.longValue());
            return (Number)q.uniqueResult();
        };
        return ((Number)this.getHibernateTemplate().execute(hcb)).longValue();
    }

    @Override
    public boolean hasSubPools(Long poolId) {
        long poolSize = this.getSubPoolSize(poolId);
        return poolSize >= 0L;
    }

    @Override
    public boolean poolIsUnique(Long questionPoolId, String title, Long parentPoolId, String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new QuestionPoolData(a.questionPoolId, a.title, a.parentPoolId)from QuestionPoolData a where a.questionPoolId != :qid and a.title = :title and a.parentPoolId = :pid and a.ownerId = :agent");
            q.setLong("qid", questionPoolId.longValue());
            q.setString("title", title);
            q.setLong("pid", parentPoolId.longValue());
            q.setString("agent", agentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        boolean isUnique = true;
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                QuestionPoolData q = (QuestionPoolData)list.get(i);
                if (!title.equals(q.getTitle().trim())) continue;
                isUnique = false;
                break;
            }
        }
        return isUnique;
    }

    @Override
    public List<Long> getPoolIdsByAgent(String agentId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa where qpa.agentId = :id");
            q.setString("id", agentId);
            return q.list();
        };
        List qpaList = (List)this.getHibernateTemplate().execute(hcb);
        try {
            for (QuestionPoolAccessData qpa : qpaList) {
                idList.add(qpa.getQuestionPoolId());
            }
            return idList;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public List getPoolIdsByItem(String itemId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select qpi from QuestionPoolItemData as qpi where qpi.itemId = :id");
            q.setString("id", itemId);
            return q.list();
        };
        List qpiList = (List)this.getHibernateTemplate().execute(hcb);
        try {
            for (QuestionPoolItemData qpa : qpiList) {
                idList.add(qpa.getQuestionPoolId());
            }
            return idList;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            boolean haveCommonRoot = false;
            boolean duplicate = false;
            QuestionPoolFacade oldPool = this.getPool(sourceId, agentId);
            String oldPoolName = oldPool.getDisplayName();
            if (destId.equals(oldPool.getParentPoolId())) {
                duplicate = true;
            }
            if (!duplicate) {
                haveCommonRoot = tree.haveCommonRoot(sourceId, destId);
            }
            if (haveCommonRoot && tree.isDescendantOf(destId, sourceId)) {
                return;
            }
            QuestionPoolFacade newPool = (QuestionPoolFacade)oldPool.clone();
            newPool.setParentPoolId(destId);
            newPool.setQuestionPoolId(0L);
            newPool.setOwnerId(AgentFacade.getAgentString());
            if (!haveCommonRoot) {
                if (duplicate) {
                    this.resetTitle(destId, newPool, oldPoolName, prependString1, prependString2);
                } else {
                    newPool.updateDisplayName(oldPoolName);
                }
            }
            newPool = this.savePool(newPool);
            Iterator iter = oldPool.getQuestions().iterator();
            ArrayList<ItemDataIfc> itemDataArray = new ArrayList<ItemDataIfc>();
            while (iter.hasNext()) {
                ItemDataIfc itemData = (ItemDataIfc)iter.next();
                ItemFacade itemFacade = this.copyItemFacade2(itemData);
                ItemDataIfc newItemData = itemFacade.getData();
                itemDataArray.add(newItemData);
            }
            newPool.setQuestionPoolItems(this.prepareQuestions(newPool.getQuestionPoolId(), itemDataArray));
            newPool.setQuestions(itemDataArray);
            newPool = this.savePool(newPool);
            Set qpItems = newPool.getQuestionPoolItems();
            for (QuestionPoolItemData qpItem : qpItems) {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/copied, itemId=" + qpItem.getItemId()), (boolean)true));
            }
            for (Long childPoolId : tree.getChildList(sourceId)) {
                this.copyPool(tree, agentId, childPoolId, newPool.getQuestionPoolId(), prependString1, prependString2);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Long add() {
        QuestionPoolData questionPool = new QuestionPoolData();
        questionPool.setTitle("Daisy Happy Pool");
        questionPool.setOwnerId("1");
        questionPool.setDateCreated(new Date());
        questionPool.setLastModifiedById("1");
        questionPool.setLastModified(new Date());
        this.getHibernateTemplate().save((Object)questionPool);
        return questionPool.getQuestionPoolId();
    }

    @Override
    public QuestionPoolFacade getPoolById(Long questionPoolId) {
        QuestionPoolFacade questionPoolFacade = null;
        try {
            QuestionPoolData questionPool;
            if (!questionPoolId.equals(QuestionPoolFacade.ROOT_POOL) && (questionPool = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)questionPoolId)) != null) {
                questionPoolFacade = new QuestionPoolFacade((QuestionPoolDataIfc)questionPool);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return questionPoolFacade;
    }

    @Override
    public Map getQuestionPoolItemMap() {
        HashMap<Long, QuestionPoolItemData> h = new HashMap<Long, QuestionPoolItemData>();
        String query = "from QuestionPoolItemData";
        List l = this.getHibernateTemplate().find(query, new Object[0]);
        for (int i = 0; i < l.size(); ++i) {
            QuestionPoolItemData q = (QuestionPoolItemData)l.get(i);
            h.put(q.getItemId(), q);
        }
        return h;
    }

    public Set prepareQuestions(Long questionPoolId, List itemDataArray) {
        HashSet<QuestionPoolItemData> set = new HashSet<QuestionPoolItemData>();
        for (ItemDataIfc itemData : itemDataArray) {
            set.add(new QuestionPoolItemData(questionPoolId, itemData.getItemId(), (ItemData)itemData));
        }
        return set;
    }

    private void resetTitle(Long destId, QuestionPoolFacade newPool, String oldPoolName, String prependString1, String prependString2) {
        List siblings = this.getSubPools(destId);
        int num = 0;
        int startIndex = 0;
        int endIndex = 0;
        int maxNum = 0;
        StringBuilder prependString = new StringBuilder(prependString1);
        prependString.append(" ");
        prependString.append(prependString2);
        prependString.append(" ");
        for (int l = 0; l < siblings.size(); ++l) {
            QuestionPoolData a = (QuestionPoolData)siblings.get(l);
            String n = a.getTitle();
            if (n.startsWith(prependString.toString()) && n.equals(prependString + oldPoolName) && maxNum < 1) {
                maxNum = 1;
            }
            if (!n.startsWith(prependString1 + "(")) continue;
            startIndex = n.indexOf("(");
            endIndex = n.indexOf(")");
            try {
                String partialPoolName = n.substring(endIndex + 2).replaceFirst(prependString2 + " ", "").trim();
                num = Integer.parseInt(n.substring(startIndex + 1, endIndex));
                if (!oldPoolName.equals(partialPoolName) || num <= maxNum) continue;
                maxNum = num;
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("rename title of duplicate pool:" + e.getMessage());
            }
        }
        if (maxNum == 0) {
            newPool.updateDisplayName(prependString + oldPoolName);
        } else {
            newPool.updateDisplayName(prependString1 + "(" + (maxNum + 1) + ") " + prependString2 + " " + oldPoolName);
        }
    }

    @Override
    public Long copyItemFacade(ItemDataIfc itemData) {
        ItemFacade item = this.getItemFacade(itemData);
        ItemService itemService = new ItemService();
        Long itemId = itemService.saveItem(item).getItemId();
        return itemId;
    }

    @Override
    public ItemFacade copyItemFacade2(ItemDataIfc itemData) {
        ItemFacade item = this.getItemFacade(itemData);
        ItemService itemService = new ItemService();
        return itemService.saveItem(item);
    }

    private ItemFacade getItemFacade(ItemDataIfc itemData) {
        ItemFacade item = new ItemFacade();
        item.setScore(itemData.getScore());
        item.setDiscount(itemData.getDiscount());
        item.setHint(itemData.getHint());
        item.setStatus(itemData.getStatus());
        item.setTypeId(itemData.getTypeId());
        item.setCreatedBy(AgentFacade.getAgentString());
        item.setCreatedDate(new Date());
        item.setLastModifiedBy(AgentFacade.getAgentString());
        item.setLastModifiedDate(new Date());
        item.setHasRationale(itemData.getHasRationale());
        item.setTriesAllowed(itemData.getTriesAllowed());
        item.setDuration(itemData.getDuration());
        item.setAnswerOptionsRichCount(itemData.getAnswerOptionsRichCount());
        item.setAnswerOptionsSimpleOrRich(itemData.getAnswerOptionsSimpleOrRich());
        item.setDescription(itemData.getDescription());
        item.setItemTextSet(this.copyItemText(item.getData(), itemData));
        item.setItemMetaDataSet(this.copyMetaData(item.getData(), itemData));
        item.setItemTagSet(this.copyTags(item.getData(), itemData));
        item.setItemAttachmentSet(this.copyAttachment(item.getData(), itemData));
        item.setInstruction(AssessmentService.copyStringAttachment(itemData.getInstruction()));
        if (itemData.getCorrectItemFeedback() != null && !itemData.getCorrectItemFeedback().equals("")) {
            item.setCorrectItemFeedback(AssessmentService.copyStringAttachment(itemData.getCorrectItemFeedback()));
        }
        if (itemData.getInCorrectItemFeedback() != null && !itemData.getInCorrectItemFeedback().equals("")) {
            item.setInCorrectItemFeedback(AssessmentService.copyStringAttachment(itemData.getInCorrectItemFeedback()));
        }
        if (itemData.getGeneralItemFeedback() != null && !itemData.getGeneralItemFeedback().equals("")) {
            item.setGeneralItemFeedback(AssessmentService.copyStringAttachment(itemData.getGeneralItemFeedback()));
        }
        return item;
    }

    private Set copyItemText(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        HashSet<ItemText> toItemTextSet = new HashSet<ItemText>();
        Set fromItemTextSet = fromItemData.getItemTextSet();
        for (ItemText fromItemText : fromItemTextSet) {
            ItemText toItemText = new ItemText();
            toItemText.setItem(toItemData);
            toItemText.setSequence(fromItemText.getSequence());
            toItemText.setText(fromItemText.getText());
            toItemText.setRequiredOptionsCount(fromItemText.getRequiredOptionsCount());
            HashSet<Answer> toAnswerSet = new HashSet<Answer>();
            Set fromAnswerSet = fromItemText.getAnswerSet();
            for (Answer fromAnswer : fromAnswerSet) {
                Answer toAnswer = new Answer((ItemTextIfc)toItemText, fromAnswer.getText(), fromAnswer.getSequence(), fromAnswer.getLabel(), fromAnswer.getIsCorrect(), fromAnswer.getGrade(), fromAnswer.getScore(), fromAnswer.getPartialCredit(), fromAnswer.getDiscount(), null);
                HashSet<AnswerFeedback> toAnswerFeedbackSet = new HashSet<AnswerFeedback>();
                Set fromAnswerFeedbackSet = fromAnswer.getAnswerFeedbackSet();
                for (AnswerFeedback fromAnswerFeedback : fromAnswerFeedbackSet) {
                    toAnswerFeedbackSet.add(new AnswerFeedback((AnswerIfc)toAnswer, fromAnswerFeedback.getTypeId(), fromAnswerFeedback.getText()));
                    toAnswer.setAnswerFeedbackSet(toAnswerFeedbackSet);
                }
                toAnswerSet.add(toAnswer);
                toItemText.setAnswerSet(toAnswerSet);
            }
            toItemTextSet.add(toItemText);
        }
        return toItemTextSet;
    }

    private Set copyMetaData(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        HashSet<ItemMetaData> toSet = new HashSet<ItemMetaData>();
        Set fromSet = fromItemData.getItemMetaDataSet();
        for (ItemMetaData itemMetaData : fromSet) {
            toSet.add(new ItemMetaData(toItemData, itemMetaData.getLabel(), itemMetaData.getEntry()));
        }
        return toSet;
    }

    private HashSet copyTags(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        HashSet<ItemTag> toSet = new HashSet<ItemTag>();
        Set fromSet = fromItemData.getItemTagSet();
        for (ItemTag itemTag : fromSet) {
            toSet.add(new ItemTag(toItemData, itemTag.getTagId(), itemTag.getTagLabel(), itemTag.getTagCollectionId(), itemTag.getTagCollectionName()));
        }
        return toSet;
    }

    private Set copyAttachment(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        AssessmentService assessmentService = new AssessmentService();
        Set toSet = assessmentService.copyItemAttachmentSet((ItemData)toItemData, fromItemData.getItemAttachmentSet());
        return toSet;
    }

    @Override
    public Integer getCountItemFacades(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select count(ab) from ItemData ab, QuestionPoolItemData qpi where ab.itemId = qpi.itemId and qpi.questionPoolId = :id");
            q.setLong("id", questionPoolId.longValue());
            q.setCacheable(true);
            return (Number)q.uniqueResult();
        };
        return ((Number)this.getHibernateTemplate().execute(hcb)).intValue();
    }

    @Override
    public Map<Long, Integer> getCountItemFacadesForUser(String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select qpi.questionPoolId, count(ab) from ItemData ab, QuestionPoolItemData qpi, QuestionPoolData qpd, QuestionPoolAccessData qpad where ab.itemId = qpi.itemId and qpi.questionPoolId = qpd.questionPoolId AND qpd.questionPoolId = qpad.questionPoolId AND qpad.agentId = :agent AND qpad.accessTypeId != :access group by qpi.questionPoolId");
            q.setString("agent", agentId);
            q.setLong("access", QuestionPoolData.ACCESS_DENIED.longValue());
            q.setCacheable(true);
            return q.list();
        };
        HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        for (Object[] result : list) {
            counts.put(((Number)result[0]).longValue(), ((Number)result[1]).intValue());
        }
        return counts;
    }

    @Override
    public void addQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        QuestionPoolAccessData qpad = new QuestionPoolAccessData(questionPoolId, user, accessTypeId);
        this.getHibernateTemplate().saveOrUpdate((Object)qpad);
        for (Long childPoolId : tree.getChildList(questionPoolId)) {
            this.addQuestionPoolAccess(tree, user, childPoolId, accessTypeId);
        }
    }

    @Override
    public void removeQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        QuestionPoolAccessData qpad = new QuestionPoolAccessData(questionPoolId, user, accessTypeId);
        this.getHibernateTemplate().delete(this.getHibernateTemplate().merge((Object)qpad));
        for (Long childPoolId : tree.getChildList(questionPoolId)) {
            this.removeQuestionPoolAccess(tree, user, childPoolId, accessTypeId);
        }
    }

    @Override
    public List<AgentFacade> getAgentsWithAccess(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa where qpa.questionPoolId = :id");
            q.setLong("id", questionPoolId.longValue());
            return q.list();
        };
        List qpaList = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AgentFacade> agents = new ArrayList<AgentFacade>();
        for (QuestionPoolAccessData pool : qpaList) {
            AgentFacade agent = new AgentFacade(pool.getAgentId());
            agents.add(agent);
        }
        return agents;
    }

    public List<QuestionPoolData> getAllPoolsForTransfer(List<Long> selectedPoolIds) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("FROM QuestionPoolData a WHERE a.questionPoolId IN (:ids)");
            q.setParameterList("ids", (Collection)selectedPoolIds);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private String createQueryString(List<Long> poolIds) {
        String poolIdQueryString = "";
        String prefix = "";
        for (Long poolId : poolIds) {
            poolIdQueryString = poolIdQueryString + prefix + poolId.toString();
            prefix = ",";
        }
        return poolIdQueryString;
    }

    private void updatePool(QuestionPoolData pooldata) {
        try {
            this.getHibernateTemplate().update((Object)pooldata);
        }
        catch (Exception e) {
            log.warn("problem update the pool name" + e.getMessage());
        }
    }

    private String renameDuplicate(String title) {
        if (title == null) {
            title = "";
        }
        String rename = "";
        int index = title.lastIndexOf(VERSION_START);
        if (index > -1) {
            String mainPart = "";
            String versionPart = title.substring(index);
            if (index > 0) {
                mainPart = title.substring(0, index);
            }
            int nIndex = index + VERSION_START.length();
            String version = title.substring(nIndex);
            int versionNumber = 0;
            try {
                versionNumber = Integer.parseInt(version);
                if (versionNumber < 2) {
                    versionNumber = 2;
                }
                versionPart = VERSION_START + (versionNumber + 1);
                rename = mainPart + versionPart;
            }
            catch (NumberFormatException ex) {
                rename = title + VERSION_START + "2";
            }
        } else {
            rename = title + VERSION_START + "2";
        }
        return rename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferPoolsOwnership(String ownerId, List<Long> transferPoolIds) {
        Session session = null;
        List<QuestionPoolData> transferPoolsData = this.getAllPoolsForTransfer(transferPoolIds);
        ArrayList<Long> needUpdatedPoolParentIdList = new ArrayList<Long>();
        ArrayList<Long> updatePoolOwnerIdList = new ArrayList<Long>();
        for (QuestionPoolData poolTransfer : transferPoolsData) {
            Long poolId = poolTransfer.getQuestionPoolId();
            updatePoolOwnerIdList.add(poolId);
            Long poolIdRemoveParent = poolTransfer.getParentPoolId();
            if (poolIdRemoveParent.equals(new Long("0")) || transferPoolIds.contains(poolIdRemoveParent)) continue;
            needUpdatedPoolParentIdList.add(poolId);
        }
        String updateOwnerIdInPoolTableQueryString = this.createQueryString(updatePoolOwnerIdList);
        String removeParentPoolString = "";
        if (needUpdatedPoolParentIdList.size() > 0) {
            removeParentPoolString = this.createQueryString(needUpdatedPoolParentIdList);
        }
        try {
            session = this.getSessionFactory().openSession();
            session.beginTransaction();
            String query = "";
            if (!"".equals(updateOwnerIdInPoolTableQueryString)) {
                query = "UPDATE SAM_QUESTIONPOOLACCESS_T SET agentid = :id WHERE questionpoolid IN (" + updateOwnerIdInPoolTableQueryString + ") AND accesstypeid = 34";
                session.createSQLQuery(query).setString("id", ownerId).executeUpdate();
                query = "UPDATE SAM_QUESTIONPOOL_T SET ownerid = :id WHERE questionpoolid IN (" + updateOwnerIdInPoolTableQueryString + ")";
                session.createSQLQuery(query).setString("id", ownerId).executeUpdate();
                session.flush();
            }
            if (!"".equals(removeParentPoolString)) {
                query = "UPDATE SAM_QUESTIONPOOL_T SET parentpoolid = 0 WHERE questionpoolid IN (" + removeParentPoolString + ")";
                session.createSQLQuery(query).executeUpdate();
                session.flush();
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception ex) {
                    log.warn("Could not close session", (Throwable)ex);
                }
            }
        }
        for (QuestionPoolData pooldata : transferPoolsData) {
            String title;
            Long poolId = pooldata.getQuestionPoolId();
            boolean isUnique = this.poolIsUnique(poolId, title = pooldata.getTitle(), new Long("0"), ownerId);
            if (isUnique) continue;
            String string = title;
            synchronized (string) {
                log.debug("Questionpool " + title + " is not unique.");
                int count = 0;
                while (!isUnique) {
                    title = this.renameDuplicate(title);
                    log.debug("renameDuplicate (title): " + title);
                    isUnique = this.poolIsUnique(poolId, title, new Long("0"), ownerId);
                    if (count++ <= 99) continue;
                }
            }
            pooldata.setTitle(title);
            pooldata.setOwnerId(ownerId);
            if (!"".equals(removeParentPoolString) && needUpdatedPoolParentIdList.contains(poolId)) {
                pooldata.setParentPoolId(new Long("0"));
            }
            this.updatePool(pooldata);
        }
    }
}

