/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProvider;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProviderCompat;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentGradeInfoProvider
implements ExternalAssignmentProvider,
ExternalAssignmentProviderCompat {
    private static final Logger log = LoggerFactory.getLogger(AssessmentGradeInfoProvider.class);
    private GradebookExternalAssessmentService geaService;
    private UserDirectoryService userDirectoryService;
    private SiteService siteService;
    private MemoryService memoryService;
    private Cache<String, Boolean> groupedCache;
    private Cache<String, PublishedAssessmentIfc> pubAssessmentCache;

    public void init() {
        log.info("INIT and Register Samigo AssessmentGradeInfoProvider");
        this.geaService.registerExternalAssignmentProvider((ExternalAssignmentProvider)this);
        this.groupedCache = this.memoryService.getCache("org.sakaiproject.tool.assessment.integration.helper.integrated.AssessmentGradeInfoProvider.groupedCache");
        this.pubAssessmentCache = this.memoryService.getCache("org.sakaiproject.tool.assessment.integration.helper.integrated.AssessmentGradeInfoProvider.pubAssessmentCache");
    }

    public void destroy() {
        log.info("DESTROY and unregister Samigo AssessmentGradeInfoProvider");
        this.geaService.unregisterExternalAssignmentProvider(this.getAppKey());
    }

    public String getAppKey() {
        return "samigo";
    }

    private PublishedAssessmentIfc getPublishedAssessment(String id) {
        PublishedAssessmentIfc a = (PublishedAssessmentIfc)this.pubAssessmentCache.get((Object)id);
        if (a != null) {
            log.debug("Returning assessment {} from cache", (Object)id);
            return a;
        }
        this.pubAssessmentCache.remove((Object)id);
        PublishedAssessmentService pas = new PublishedAssessmentService();
        try {
            a = pas.getPublishedAssessment(id);
            this.pubAssessmentCache.put((Object)id, (Object)a);
        }
        catch (Exception e) {
            log.debug("Assessment lookup failed for ID: {} -- {}", (Object)id, (Object)e.getMessage());
            a = null;
        }
        return a;
    }

    public boolean isAssignmentDefined(String externalAppName, String id) {
        if (!StringUtils.isNumeric((CharSequence)id)) {
            return false;
        }
        GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
        String toolName = gbsHelper.getAppName();
        if (!StringUtils.equals((CharSequence)externalAppName, (CharSequence)this.getAppKey()) && !StringUtils.equals((CharSequence)externalAppName, (CharSequence)toolName)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Samigo provider isAssignmentDefined: " + id);
        }
        Long longId = Long.parseLong(id);
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().isPublishedAssessmentIdValid(longId);
    }

    public boolean isAssignmentGrouped(String id) {
        boolean grouped;
        block5: {
            if (!StringUtils.isNumeric((CharSequence)id)) {
                return false;
            }
            log.debug("Samigo provider isAssignmentGrouped: {}", (Object)id);
            Boolean g = null;
            if (this.groupedCache.containsKey((Object)id) && (g = (Boolean)this.groupedCache.get((Object)id)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("returning grouped value from cache: " + id);
                }
                return g;
            }
            PublishedAssessmentService pas = new PublishedAssessmentService();
            grouped = false;
            try {
                grouped = pas.isReleasedToGroups(id);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Assignment lookup failed for ID: " + id + " -- " + e.getMessage());
            }
        }
        this.groupedCache.put((Object)id, (Object)grouped);
        return grouped;
    }

    public boolean isAssignmentVisible(String id, String userId) {
        PublishedAssessmentIfc pub;
        if (log.isDebugEnabled()) {
            log.debug("Samigo provider isAssignmentVisible: " + id + ", " + userId);
        }
        if ((pub = this.getPublishedAssessment(id)) == null) {
            return false;
        }
        boolean isAuthorized = false;
        boolean isAuthenticated = false;
        String releaseTo = pub.getAssessmentAccessControl().getReleaseTo();
        if (releaseTo != null && releaseTo.indexOf("Anonymous Users") > -1) {
            isAuthenticated = true;
            isAuthorized = true;
        } else {
            boolean bl = isAuthenticated = userId != null && !"".equals(userId);
            if (isAuthenticated) {
                isAuthorized = releaseTo.indexOf("Selected Groups") > -1 ? this.checkMembershipForGroupRelease(pub, userId) : this.checkMembership(pub, userId);
            }
        }
        return isAuthorized;
    }

    public List<String> getExternalAssignmentsForCurrentUser(String gradebookUid) {
        List<PublishedAssessmentFacade> all = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments("title", true, gradebookUid);
        ArrayList<String> externalIds = new ArrayList<String>();
        for (PublishedAssessmentIfc publishedAssessmentIfc : all) {
            externalIds.add(publishedAssessmentIfc.getPublishedAssessmentId().toString());
        }
        return externalIds;
    }

    public List<String> getAllExternalAssignments(String gradebookUid) {
        List<PublishedAssessmentFacade> allPublished = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments2("title", true, gradebookUid);
        ArrayList<String> allExternals = new ArrayList<String>();
        for (PublishedAssessmentFacade pub : allPublished) {
            String assessmentId = pub.getPublishedAssessmentId().toString();
            allExternals.add(assessmentId);
        }
        return allExternals;
    }

    public Map<String, List<String>> getAllExternalAssignments(String gradebookUid, Collection<String> studentIds) {
        List<PublishedAssessmentFacade> allPublished = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments2("title", true, gradebookUid);
        HashMap allExternals = new HashMap();
        for (String studentId : studentIds) {
            allExternals.put(studentId, new HashSet());
        }
        Set<String> siteUserIds = this.getSiteUserIds(gradebookUid);
        Map<String, Set<String>> userIdGroupIds = this.getUserGroups(gradebookUid, studentIds);
        Map<String, Set<String>> groupIdUserIds = this.invertMapSet(userIdGroupIds);
        for (PublishedAssessmentFacade pub : allPublished) {
            String assessmentId = pub.getPublishedAssessmentId().toString();
            String releaseTo = pub.getReleaseTo();
            if (releaseTo == null || assessmentId == null) continue;
            if (releaseTo.indexOf("Anonymous Users") > -1) {
                for (String string : studentIds) {
                    ((Set)allExternals.get(string)).add(assessmentId);
                }
                continue;
            }
            if ("Selected Groups".equals(releaseTo)) {
                Set<String> authorizedGroups = this.getAuthorizedGroups(assessmentId);
                for (String groupId : authorizedGroups) {
                    if (!groupIdUserIds.containsKey(groupId)) continue;
                    for (String userId : groupIdUserIds.get(groupId)) {
                        if (!allExternals.containsKey(userId)) continue;
                        ((Set)allExternals.get(userId)).add(assessmentId);
                    }
                }
                continue;
            }
            for (String string : studentIds) {
                if (!siteUserIds.contains(string)) continue;
                ((Set)allExternals.get(string)).add(assessmentId);
            }
        }
        HashMap<String, List<String>> allExternalsList = new HashMap<String, List<String>>();
        for (String studentId : allExternals.keySet()) {
            allExternalsList.put(studentId, new ArrayList((Collection)allExternals.get(studentId)));
        }
        return allExternalsList;
    }

    private Set<String> getAuthorizedGroups(String assessmentId) {
        List<AuthorizationData> authorizations = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", assessmentId);
        HashSet<String> authorizedGroups = new HashSet<String>();
        if (authorizations != null && authorizations.size() > 0) {
            for (AuthorizationData ad : authorizations) {
                authorizedGroups.add(ad.getAgentIdString());
            }
        }
        return authorizedGroups;
    }

    private Set<String> getSiteUserIds(String siteId) {
        HashSet<String> userIds;
        block3: {
            userIds = new HashSet<String>();
            try {
                Site site = this.siteService.getSite(siteId);
                for (Member m : site.getMembers()) {
                    userIds.add(m.getUserId());
                }
            }
            catch (IdUnusedException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Site not found when attempting to retrieve its users: " + siteId);
            }
        }
        return userIds;
    }

    private Map<String, Set<String>> getUserGroups(String siteId, Collection<String> studentIds) {
        HashMap<String, Set<String>> userIdGroupIds;
        block5: {
            userIdGroupIds = new HashMap<String, Set<String>>();
            for (String studentId : studentIds) {
                userIdGroupIds.put(studentId, new HashSet());
            }
            try {
                Site site = this.siteService.getSite(siteId);
                for (Group g : site.getGroups()) {
                    for (Member m : g.getMembers()) {
                        String userId = m.getUserId();
                        if (!userIdGroupIds.containsKey(userId)) continue;
                        ((Set)userIdGroupIds.get(userId)).add(g.getId());
                    }
                }
            }
            catch (IdUnusedException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Site not found when attempting to retrieve user groups: " + siteId);
            }
        }
        return userIdGroupIds;
    }

    private Map<String, Set<String>> invertMapSet(Map<String, Set<String>> mapSet) {
        HashMap<String, Set<String>> inverted = new HashMap<String, Set<String>>();
        for (String key : mapSet.keySet()) {
            Set<String> values = mapSet.get(key);
            for (String value : values) {
                if (!inverted.containsKey(value)) {
                    inverted.put(value, new HashSet());
                }
                ((Set)inverted.get(value)).add(key);
            }
        }
        return inverted;
    }

    private boolean checkMembership(PublishedAssessmentIfc pub, String userId) {
        boolean isMember = false;
        List<AuthorizationData> l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("VIEW_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size(); ++i) {
            String siteId = l.get(i).getAgentIdString();
            try {
                isMember = this.siteService.getSite(siteId).getUserRole(userId) != null;
            }
            catch (IdUnusedException e) {
                log.info("Site with ID: " + siteId + " does not exists but is authorized for assessment id: " + pub.getPublishedAssessmentId());
            }
            if (isMember) break;
        }
        return isMember;
    }

    private boolean checkMembershipForGroupRelease(PublishedAssessmentIfc pub, String userId) {
        String groupId;
        boolean isMember = false;
        List<AuthorizationData> l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("OWN_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        if (l == null || l.isEmpty()) {
            return false;
        }
        String siteId = l.get(0).getAgentIdString();
        Collection siteGroupsContainingUser = null;
        try {
            siteGroupsContainingUser = this.siteService.getSite(siteId).getGroupsWithMember(userId);
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size() && !(isMember = this.isUserInAuthorizedGroup(groupId = l.get(i).getAgentIdString(), siteGroupsContainingUser)); ++i) {
        }
        return isMember;
    }

    private boolean isUserInAuthorizedGroup(String authorizedGroupId, Collection userGroups) {
        if (userGroups == null || userGroups.isEmpty() || authorizedGroupId == null || authorizedGroupId.equals("")) {
            return false;
        }
        for (Group group : userGroups) {
            if (!group.getId().equals(authorizedGroupId)) continue;
            return true;
        }
        return false;
    }

    public GradebookExternalAssessmentService getGradebookExternalAssessmentService() {
        return this.geaService;
    }

    public void setGradebookExternalAssessmentService(GradebookExternalAssessmentService geaService) {
        this.geaService = geaService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.memoryService = memoryService;
    }
}

