/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

class EMIScore
implements Comparable<EMIScore> {
    long itemId = 0L;
    long itemTextId = 0L;
    long answerId = 0L;
    boolean correct = false;
    double score = 0.0;
    double effectiveScore = 0.0;

    public EMIScore(Long itemId, Long itemTextId, Long answerId, boolean correct, Double score) {
        this.itemId = itemId == null ? 0L : itemId;
        this.itemTextId = itemTextId == null ? 0L : itemTextId;
        this.answerId = answerId == null ? 0L : answerId;
        this.correct = correct;
        this.score = score == null ? 0.0 : score;
    }

    @Override
    public int compareTo(EMIScore o) {
        if (this.correct == o.correct) {
            int c = Double.compare(o.score, this.score);
            if (c == 0) {
                if (this.itemId != o.itemId) {
                    return (int)(this.itemId - o.itemId);
                }
                if (this.itemTextId != o.itemTextId) {
                    return (int)(this.itemTextId - o.itemTextId);
                }
                if (this.answerId != o.answerId) {
                    return (int)(this.answerId - o.answerId);
                }
                return this.hashCode() - o.hashCode();
            }
            return c;
        }
        return this.correct ? -1 : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.itemId;
        result = 31 * result + (int)this.itemTextId;
        result = 31 * result + (int)this.answerId;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EMIScore other = (EMIScore)obj;
        return this.itemId == other.itemId && this.itemTextId == other.itemTextId && this.answerId == other.answerId;
    }

    public String toString() {
        return this.itemId + ":" + this.itemTextId + ":" + this.answerId + "(" + this.correct + ":" + this.score + ":" + this.effectiveScore + ")";
    }
}

