/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.authz.QualifierData;
import org.sakaiproject.tool.assessment.data.ifc.authz.AuthorizationIfc;
import org.sakaiproject.tool.assessment.data.ifc.authz.QualifierIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.authz.AuthorizationFacade;
import org.sakaiproject.tool.assessment.facade.authz.AuthorizationFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.authz.QualifierFacade;
import org.sakaiproject.tool.assessment.facade.authz.QualifierIteratorFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AuthorizationFacadeQueries
extends HibernateDaoSupport
implements AuthorizationFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(AuthorizationFacadeQueries.class);

    public QualifierIteratorFacade getQualifierParents(final String qualifierId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from QualifierData as p, QualifierData as c, QualifierHierarchyData as q where p.qualifierId=q.parentId and c.qualifierId=q.childId and q.childId=?");
                q.setString(0, qualifierId);
                return q.list();
            }
        };
        List parents = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<QualifierFacade> a = new ArrayList<QualifierFacade>();
        for (int i = 0; i < parents.size(); ++i) {
            QualifierData data = (QualifierData)parents.get(i);
            QualifierFacade qf = new QualifierFacade((QualifierIfc)data);
            a.add(qf);
        }
        return new QualifierIteratorFacade(a);
    }

    public QualifierIteratorFacade getQualifierChildren(final String qualifierId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from QualifierData as p, QualifierData as c, QualifierHierarchyData as q where p.qualifierId=q.parentId and c.qualifierId=q.childId and q.parentId=?");
                q.setString(0, qualifierId);
                return q.list();
            }
        };
        List children = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<QualifierFacade> a = new ArrayList<QualifierFacade>();
        for (int i = 0; i < children.size(); ++i) {
            QualifierData data = (QualifierData)children.get(i);
            QualifierFacade qf = new QualifierFacade((QualifierIfc)data);
            a.add(qf);
        }
        return new QualifierIteratorFacade(a);
    }

    public void showQualifiers(QualifierIteratorFacade iter) {
        while (iter.hasNextQualifier()) {
        }
    }

    public void addAuthz(AuthorizationIfc a) {
        AuthorizationData data = a instanceof AuthorizationFacade ? (AuthorizationData)((AuthorizationFacade)a).getData() : (AuthorizationData)a;
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem adding authorization: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void addQualifier(QualifierIfc q) {
        QualifierData data = q instanceof QualifierFacade ? (QualifierData)((QualifierFacade)q).getData() : (QualifierData)q;
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem adding Qualifier: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public static void main(String[] args) throws DataFacadeException {
        AuthorizationFacadeQueries instance = new AuthorizationFacadeQueries();
        if (args[0].equals("listChild")) {
            QualifierIteratorFacade childrenIter = instance.getQualifierChildren(args[1]);
            instance.showQualifiers(childrenIter);
        }
        if (args[0].equals("addAuthz")) {
            AuthorizationFacade a = new AuthorizationFacade(args[1], args[2], args[3], new Date(), null, "2", new Date(), Boolean.TRUE);
            instance.addAuthz(a);
        }
        System.exit(0);
    }
}

