/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz.integrated;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AuthzQueriesFacade
extends HibernateDaoSupport
implements AuthzQueriesFacadeAPI {
    private static final Logger LOG = Logger.getLogger(AuthzQueriesFacade.class);
    private static ResourceBundle res = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.facade.authz.resource.AuthzResource");
    private static final String HQL_QUERY_CHECK_AUTHZ = "select from org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as data where data.agentIdString = :agentId and data.functionId = :functionId and data.qualifierId = :qualifierId";
    private static final String HQL_QUERY_BY_AGENT_FUNC = "select from org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as item where item.agentIdString = :agentId and item.functionId = :functionId";
    private static final String HQL_QUERY_ASSESS_BY_AGENT_FUNC = "select asset from org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData as asset, org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as authz where asset.assessmentBaseId=authz.qualifierId and authz.agentIdString = :agentId and authz.functionId = :functionId";

    public boolean hasPrivilege(String functionName) {
        String context = ToolManager.getCurrentPlacement().getContext();
        boolean privilege = SecurityService.unlock((String)functionName, (String)("/site/" + context));
        return privilege;
    }

    public boolean isAuthorized(String agentId, final String functionId, final String qualifierId) {
        String query = "select a from AuthorizationData a where a.functionId=? and a.qualifierId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a from AuthorizationData a where a.functionId=? and a.qualifierId=?");
                q.setString(0, functionId);
                q.setString(1, qualifierId);
                return q.list();
            }
        };
        List authorizationList = this.getHibernateTemplate().executeFind(hcb);
        String currentSiteId = null;
        if (ToolManager.getCurrentPlacement() != null) {
            currentSiteId = ToolManager.getCurrentPlacement().getContext();
        }
        if (currentSiteId == null) {
            return false;
        }
        String currentAgentId = UserDirectoryService.getCurrentUser().getId();
        for (int i = 0; i < authorizationList.size(); ++i) {
            AuthorizationData a = (AuthorizationData)authorizationList.get(i);
            String siteId = a.getAgentIdString();
            if ("AUTHENTICATED_USERS".equals(siteId) && currentAgentId != null) {
                return true;
            }
            if ("ANONYMOUS_USERS".equals(siteId)) {
                return true;
            }
            if (!currentSiteId.equals(siteId)) continue;
            return true;
        }
        return false;
    }

    public boolean checkAuthorization(final String agentId, final String functionId, final String qualifierId) {
        if (functionId == null || qualifierId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        final String queryAgentId = ToolManager.getCurrentPlacement().getContext();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(AuthzQueriesFacade.HQL_QUERY_CHECK_AUTHZ);
                if (agentId == null) {
                    query.setString("agentId", queryAgentId);
                } else {
                    query.setString("agentId", agentId);
                }
                query.setString("functionId", functionId);
                query.setString("qualifierId", qualifierId);
                return query.uniqueResult();
            }
        };
        AuthorizationData result = (AuthorizationData)this.getHibernateTemplate().execute(hcb);
        return result != null;
    }

    public AuthorizationData createAuthorization(String agentId, String functionId, String qualifierId) {
        if (agentId == null || functionId == null || qualifierId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        AuthorizationData ad = new AuthorizationData();
        Calendar cal = Calendar.getInstance();
        Date lastModifiedDate = cal.getTime();
        ad.setAgentIdString(agentId);
        ad.setFunctionId(functionId);
        ad.setQualifierId(qualifierId);
        ad.setLastModifiedBy(UserDirectoryService.getCurrentUser().getId());
        ad.setLastModifiedDate(lastModifiedDate);
        this.getHibernateTemplate().save((Object)ad);
        return ad;
    }

    public ArrayList getAssessments(final String agentId, final String functionId) {
        ArrayList<AuthorizationData> returnList = new ArrayList<AuthorizationData>();
        if (agentId == null || functionId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(AuthzQueriesFacade.HQL_QUERY_BY_AGENT_FUNC);
                query.setString("agentId", agentId);
                query.setString("functionId", functionId);
                return query.list();
            }
        };
        List result = (List)this.getHibernateTemplate().execute(hcb);
        for (int i = 0; i < result.size(); ++i) {
            AuthorizationData ad = (AuthorizationData)result.get(i);
            returnList.add(ad);
        }
        return returnList;
    }

    public ArrayList getAssessmentsByAgentAndFunction(final String agentId, final String functionId) {
        ArrayList<AssessmentBaseData> returnList = new ArrayList<AssessmentBaseData>();
        if (agentId == null || functionId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(AuthzQueriesFacade.HQL_QUERY_ASSESS_BY_AGENT_FUNC);
                query.setString("agentId", agentId);
                query.setString("functionId", functionId);
                return query.list();
            }
        };
        List result = (List)this.getHibernateTemplate().execute(hcb);
        for (int i = 0; i < result.size(); ++i) {
            AssessmentBaseData ad = (AssessmentBaseData)result.get(i);
            returnList.add(ad);
        }
        return returnList;
    }

    public void removeAuthorizationByQualifier(String qualifierId, boolean isPublishedAssessment) {
        String query = "select a from AuthorizationData a where a.qualifierId=" + qualifierId;
        String clause = "";
        clause = isPublishedAssessment ? " and (a.functionId='OWN_PUBLISHED_ASSESSMENT' or a.functionId='TAKE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT_FEEDBACK' or a.functionId='GRADE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT')" : " and a.functionId='EDIT_ASSESSMENT'";
        List l = this.getHibernateTemplate().find(query + clause);
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    public void removeAuthorizationByQualifierAndFunction(String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId=? and a.functionId=?";
        List l = this.getHibernateTemplate().find(query, (Object[])new String[]{qualifierId, functionId});
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    public void removeAuthorizationByAgentQualifierAndFunction(String agentId, String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId=? and a.agentIdString=? and a.functionId=?";
        List l = this.getHibernateTemplate().find(query, (Object[])new String[]{qualifierId, agentId, functionId});
        if (l != null && l.size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)l);
        }
    }

    public HashMap getAuthorizationToViewAssessments(String agentId) {
        HashMap<String, AuthorizationData> h = new HashMap<String, AuthorizationData>();
        List l = this.getAuthorizationByAgentAndFunction(agentId, "VIEW_PUBLISHED_ASSESSMENT");
        for (int i = 0; i < l.size(); ++i) {
            AuthorizationData a = (AuthorizationData)l.get(i);
            h.put(a.getQualifierId(), a);
        }
        return h;
    }

    public List getAuthorizationByAgentAndFunction(String agentId, String functionId) {
        String query = "select a from AuthorizationData a where a.agentIdString=? and a.functionId=?";
        return this.getHibernateTemplate().find(query, (Object[])new String[]{agentId, functionId});
    }

    public List getAuthorizationByFunctionAndQualifier(String functionId, String qualifierId) {
        return this.getHibernateTemplate().find("select a from AuthorizationData a where a.functionId=? and a.qualifierId=?", (Object[])new String[]{functionId, qualifierId});
    }

    public boolean checkMembership(String siteId) {
        boolean isMember = false;
        try {
            String realmName = "/site/" + siteId;
            AuthzGroup siteAuthzGroup = AuthzGroupService.getAuthzGroup((String)realmName);
            if (siteAuthzGroup.getUserRole(AgentFacade.getAgentString()) != null) {
                isMember = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMember;
    }
}

