/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.calendar.api.Calendar;
import org.sakaiproject.calendar.api.CalendarEvent;
import org.sakaiproject.calendar.api.CalendarEventEdit;
import org.sakaiproject.calendar.api.CalendarService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.api.TimeRange;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.cover.ToolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarServiceHelperImpl
implements CalendarServiceHelper {
    private static final Log log = LogFactory.getLog(CalendarServiceHelperImpl.class);
    private CalendarService calendarService;
    private Boolean calendarExistsForSite = null;
    private Map<String, Boolean> calendarExistCache = new HashMap<String, Boolean>();
    private String calendarTitle;

    @Override
    public String getString(String key, String defaultValue) {
        return ServerConfigurationService.getString((String)key, (String)defaultValue);
    }

    @Override
    public String calendarReference(String siteId, String container) {
        return this.calendarService.calendarReference(siteId, container);
    }

    @Override
    public Calendar getCalendar(String ref) throws IdUnusedException, PermissionException {
        return this.calendarService.getCalendar(ref);
    }

    public CalendarService getCalendarService() {
        return this.calendarService;
    }

    public void setCalendarService(CalendarService calendarService) {
        this.calendarService = calendarService;
    }

    @Override
    public void removeCalendarEvent(String siteId, String eventId) {
        try {
            String calendarId = this.calendarReference(siteId, SiteService.MAIN_CONTAINER);
            Calendar calendar = this.getCalendar(calendarId);
            if (calendar != null && eventId != null && !"".equals(eventId)) {
                try {
                    CalendarEvent calendarEvent = calendar.getEvent(eventId);
                    calendar.removeEvent(calendar.getEditEvent(calendarEvent.getId(), "calendar.delete"));
                }
                catch (PermissionException e) {
                    log.warn((Object)e);
                }
                catch (InUseException e) {
                    log.warn((Object)e);
                }
                catch (IdUnusedException e) {
                    log.warn((Object)e);
                }
            }
        }
        catch (IdUnusedException e) {
            log.warn((Object)e);
        }
        catch (PermissionException e) {
            log.warn((Object)e);
        }
    }

    @Override
    public String addCalendarEvent(String siteId, String title, String desc, long dateTime, List<Group> groupRestrictions, String calendarEventType) {
        String eventId = null;
        String calendarId = this.calendarReference(siteId, SiteService.MAIN_CONTAINER);
        try {
            Calendar calendar = this.getCalendar(calendarId);
            if (calendar != null) {
                TimeRange timeRange = TimeService.newTimeRange((long)dateTime, (long)0L);
                CalendarEvent.EventAccess eAccess = CalendarEvent.EventAccess.SITE;
                if (groupRestrictions != null && groupRestrictions.size() > 0) {
                    eAccess = CalendarEvent.EventAccess.GROUPED;
                }
                CalendarEvent event = calendar.addEvent(timeRange, title, desc, calendarEventType, "", eAccess, groupRestrictions, EntityManager.newReferenceList());
                eventId = event.getId();
                if (event.getId() != null) {
                    CalendarEventEdit edit = calendar.getEditEvent(event.getId(), "calendar.new");
                    edit.setDescriptionFormatted(desc);
                    calendar.commitEvent(edit);
                }
            }
        }
        catch (IdUnusedException e) {
            log.warn((Object)e);
        }
        catch (InUseException e) {
            log.warn((Object)e);
        }
        catch (PermissionException e) {
            log.warn((Object)e);
        }
        return eventId;
    }

    @Override
    public void updateAllCalendarEvents(PublishedAssessmentFacade pub, String releaseTo, String[] groupsAuthorized, String dueDateTitlePrefix, boolean addDueDateToCalendar, String eventDesc) {
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        String newDueDateEventId = null;
        try {
            String calendarDueDateEventId = pub.getAssessmentMetaDataByLabel("CALENDAR_DUE_DATE_EVENT_ID");
            if (calendarDueDateEventId != null) {
                this.removeCalendarEvent(AgentFacade.getCurrentSiteId(), calendarDueDateEventId);
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        List<Group> authorizedGroups = this.getAuthorizedGroups(releaseTo, groupsAuthorized);
        if (addDueDateToCalendar && pub.getAssessmentAccessControl().getDueDate() != null) {
            newDueDateEventId = this.addCalendarEvent(AgentFacade.getCurrentSiteId(), dueDateTitlePrefix + pub.getTitle(), eventDesc, pub.getAssessmentAccessControl().getDueDate().getTime(), authorizedGroups, "Deadline");
        }
        boolean found = false;
        PublishedMetaData meta = null;
        for (PublishedMetaData pubMetData : pub.getAssessmentMetaDataSet()) {
            if (!"CALENDAR_DUE_DATE_EVENT_ID".equals(pubMetData.getLabel())) continue;
            meta = pubMetData;
            meta.setEntry(newDueDateEventId);
            found = true;
            break;
        }
        if (!found) {
            meta = new PublishedMetaData((AssessmentBaseIfc)pub.getData(), "CALENDAR_DUE_DATE_EVENT_ID", newDueDateEventId);
        }
        publishedAssessmentService.saveOrUpdateMetaData(meta);
    }

    private List<Group> getAuthorizedGroups(String releaseTo, String[] authorizedGroupsArray) {
        ArrayList<Group> authorizedGroups = null;
        if ("Selected Groups".equals(releaseTo) && authorizedGroupsArray != null && authorizedGroupsArray.length > 0) {
            authorizedGroups = new ArrayList<Group>();
            Site site = null;
            try {
                site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                Collection groups = site.getGroups();
                if (groups != null && groups.size() > 0) {
                    for (Group group : groups) {
                        for (int i = 0; i < authorizedGroupsArray.length; ++i) {
                            if (!authorizedGroupsArray[i].equals(group.getId())) continue;
                            authorizedGroups.add(group);
                        }
                    }
                }
            }
            catch (IdUnusedException ex) {
                // empty catch block
            }
        }
        return authorizedGroups;
    }

    public Boolean getCalendarExistsForSite() {
        String siteContext = ToolManager.getCurrentPlacement().getContext();
        if (this.calendarExistCache.containsKey(siteContext)) {
            return this.calendarExistCache.get(siteContext);
        }
        Site site = null;
        try {
            site = SiteService.getSite((String)siteContext);
            if (site.getToolForCommonId("sakai.schedule") != null) {
                this.calendarExistCache.put(siteContext, Boolean.TRUE);
                return true;
            }
            this.calendarExistCache.put(siteContext, Boolean.FALSE);
            return false;
        }
        catch (Exception e) {
            log.warn((Object)"Exception thrown while getting site", (Throwable)e);
            return false;
        }
    }

    public void setCalendarExistsForSite(Boolean calendarExistsForSite) {
        this.calendarExistsForSite = calendarExistsForSite;
    }

    public String getCalendarTitle() {
        return ToolManager.getTool((String)"sakai.schedule").getTitle();
    }

    public void setCalendarTitle(String calendarTitle) {
        this.calendarTitle = calendarTitle;
    }
}

