/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;

public class PublishedAssessmentService
extends AssessmentService {
    private static Log log = LogFactory.getLog(PublishedAssessmentService.class);

    public ArrayList getBasicInfoOfAllPublishedAssessments(String agentId, String orderBy, boolean ascending, String siteId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments(orderBy, ascending, siteId);
    }

    public ArrayList getBasicInfoOfAllPublishedAssessments2(String orderBy, boolean ascending, String siteId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments2(orderBy, ascending, siteId);
    }

    public ArrayList getAllActivePublishedAssessments(String orderBy) {
        return this.getAllPublishedAssessments(orderBy, PublishedAssessmentFacade.ACTIVE_STATUS);
    }

    public ArrayList getAllActivePublishedAssessments(int pageSize, int pageNumber, String orderBy) {
        return this.getAllPublishedAssessments(pageSize, pageNumber, orderBy, PublishedAssessmentFacade.ACTIVE_STATUS);
    }

    public ArrayList getAllInActivePublishedAssessments(String orderBy) {
        return this.getAllPublishedAssessments(orderBy, PublishedAssessmentFacade.INACTIVE_STATUS);
    }

    public ArrayList getAllInActivePublishedAssessments(int pageSize, int pageNumber, String orderBy) {
        return this.getAllPublishedAssessments(pageSize, pageNumber, orderBy, PublishedAssessmentFacade.INACTIVE_STATUS);
    }

    public ArrayList getAllPublishedAssessments(String orderBy, Integer status) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getAllPublishedAssessments(orderBy, status);
    }

    public ArrayList getAllPublishedAssessments(int pageSize, int pageNumber, String orderBy, Integer status) {
        try {
            if (pageSize > 0 && pageNumber > 0) {
                return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getAllPublishedAssessments(pageSize, pageNumber, orderBy, status);
            }
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getAllPublishedAssessments(orderBy, status);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public PublishedAssessmentFacade getPublishedAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessment(Long.valueOf(assessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public PublishedAssessmentFacade getPublishedAssessment(String assessmentId, boolean withGroupsInfo) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessment(Long.valueOf(assessmentId), withGroupsInfo);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentIfc getAssessment(Long assessmentId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessment(assessmentId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public Long getPublishedAssessmentId(String assessmentId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentId(new Long(assessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public PublishedAssessmentFacade publishAssessment(AssessmentFacade assessment) throws Exception {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().publishAssessment(assessment);
    }

    public PublishedAssessmentFacade publishPreviewAssessment(AssessmentFacade assessment) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().publishPreviewAssessment(assessment);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void deleteAllSecuredIP(PublishedAssessmentIfc assessment) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().deleteAllSecuredIP(assessment);
    }

    public void saveAssessment(PublishedAssessmentFacade assessment) {
        try {
            PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().saveOrUpdate(assessment);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void removeAssessment(String assessmentId) {
        this.removeAssessment(assessmentId, null);
    }

    public void removeAssessment(String assessmentId, String action) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().removeAssessment(new Long(assessmentId), action);
    }

    public ArrayList getBasicInfoOfAllActivePublishedAssessments(String orderBy, boolean ascending) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllActivePublishedAssessments(orderBy, siteAgentId, ascending);
    }

    public ArrayList getBasicInfoOfAllInActivePublishedAssessments(String orderBy, boolean ascending) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllInActivePublishedAssessments(orderBy, siteAgentId, ascending);
    }

    public PublishedAssessmentFacade getSettingsOfPublishedAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getSettingsOfPublishedAssessment(new Long(assessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public PublishedItemData loadPublishedItem(String itemId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().loadPublishedItem(new Long(itemId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public PublishedItemText loadPublishedItemText(String itemTextId) {
        try {
            return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().loadPublishedItemText(new Long(itemTextId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ArrayList getBasicInfoOfLastSubmittedAssessments(String agentId, String orderBy, boolean ascending) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfLastSubmittedAssessments(agentId, orderBy, ascending);
    }

    public HashMap getTotalSubmissionPerAssessment(String agentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getTotalSubmissionPerAssessment(agentId);
    }

    public HashMap getTotalSubmissionPerAssessment(String agentId, String siteId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getTotalSubmissionPerAssessment(agentId, siteId);
    }

    public Integer getTotalSubmission(String agentId, String publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getTotalSubmission(agentId, new Long(publishedAssessmentId));
    }

    public PublishedAssessmentFacade getPublishedAssessmentIdByAlias(String alias) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentIdByAlias(alias);
    }

    public void saveOrUpdateMetaData(PublishedMetaData meta) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().saveOrUpdateMetaData(meta);
    }

    public HashMap getFeedbackHash() {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getFeedbackHash();
    }

    public HashMap getAllAssessmentsReleasedToAuthenticatedUsers() {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getAllAssessmentsReleasedToAuthenticatedUsers();
    }

    public String getPublishedAssessmentOwner(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentOwner(publishedAssessmentId.toString());
    }

    public boolean publishedAssessmentTitleIsUnique(String assessmentBaseId, String title) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().publishedAssessmentTitleIsUnique(new Long(assessmentBaseId), title);
    }

    public boolean hasRandomPart(String publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().hasRandomPart(new Long(publishedAssessmentId));
    }

    public List getContainRandomPartAssessmentIds(Collection assessmentIds) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getContainRandomPartAssessmentIds(assessmentIds);
    }

    public PublishedItemData getFirstPublishedItem(String publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getFirstPublishedItem(new Long(publishedAssessmentId));
    }

    public List getPublishedItemIds(String publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedItemIds(new Long(publishedAssessmentId));
    }

    public HashSet getPublishedItemSet(Long publishedAssessmentId, Long sectionId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedItemSet(publishedAssessmentId, sectionId);
    }

    public Long getItemType(String publishedItemId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getItemType(new Long(publishedItemId));
    }

    public HashMap preparePublishedItemTextHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, ItemTextIfc> map = new HashMap<Long, ItemTextIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                ArrayList itemTextArray = item.getItemTextArray();
                for (int k = 0; k < itemTextArray.size(); ++k) {
                    ItemTextIfc itemText = (ItemTextIfc)itemTextArray.get(k);
                    map.put(itemText.getId(), itemText);
                }
            }
        }
        return map;
    }

    public HashMap preparePublishedItemHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, ItemDataIfc> map = new HashMap<Long, ItemDataIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                map.put(item.getItemId(), item);
            }
        }
        return map;
    }

    public HashMap preparePublishedAnswerHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, AnswerIfc> map = new HashMap<Long, AnswerIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                ArrayList itemTextArray = item.getItemTextArray();
                for (int k = 0; k < itemTextArray.size(); ++k) {
                    ItemTextIfc itemText = (ItemTextIfc)itemTextArray.get(k);
                    ArrayList answerArray = itemText.getAnswerArraySorted();
                    for (int m = 0; m < answerArray.size(); ++m) {
                        AnswerIfc answer = (AnswerIfc)answerArray.get(m);
                        if (answer == null) continue;
                        answer.setScore(item.getScore());
                        answer.setDiscount(item.getDiscount());
                        map.put(answer.getId(), answer);
                    }
                }
            }
        }
        return map;
    }

    public HashMap prepareFIBItemHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, ItemDataIfc> map = new HashMap<Long, ItemDataIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                if (!item.getTypeId().equals(8L)) continue;
                map.put(item.getItemId(), item);
            }
        }
        return map;
    }

    public HashMap prepareFINItemHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, ItemDataIfc> map = new HashMap<Long, ItemDataIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                if (!item.getTypeId().equals(11L)) continue;
                map.put(item.getItemId(), item);
            }
        }
        return map;
    }

    public HashMap prepareMCMRItemHash(PublishedAssessmentIfc publishedAssessment) {
        HashMap<Long, ItemDataIfc> map = new HashMap<Long, ItemDataIfc>();
        ArrayList sectionArray = publishedAssessment.getSectionArray();
        for (int i = 0; i < sectionArray.size(); ++i) {
            SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
            ArrayList itemArray = section.getItemArray();
            for (int j = 0; j < itemArray.size(); ++j) {
                ItemDataIfc item = (ItemDataIfc)itemArray.get(j);
                if (!item.getTypeId().equals(2L)) continue;
                map.put(item.getItemId(), item);
            }
        }
        return map;
    }

    public HashSet getSectionSetForAssessment(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getSectionSetForAssessment(publishedAssessmentId);
    }

    public HashSet getSectionSetForAssessment(PublishedAssessmentIfc assessment) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getSectionSetForAssessment(assessment);
    }

    public boolean isRandomDrawPart(Long publishedAssessmentId, Long publishedSectionId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().isRandomDrawPart(publishedAssessmentId, publishedSectionId);
    }

    public PublishedAssessmentData getBasicInfoOfPublishedAssessment(String publishedId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfPublishedAssessment(new Long(publishedId));
    }

    public String getPublishedAssessmentSiteId(String publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentSiteId(publishedAssessmentId);
    }

    public Integer getPublishedItemCount(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedItemCount(publishedAssessmentId);
    }

    public Integer getPublishedSectionCount(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedSectionCount(publishedAssessmentId);
    }

    public PublishedAttachmentData getPublishedAttachmentData(Long attachmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAttachmentData(attachmentId);
    }

    public void updateAssessmentLastModifiedInfo(AssessmentIfc publishedAssessmentFacade) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().updateAssessmentLastModifiedInfo((PublishedAssessmentFacade)publishedAssessmentFacade);
    }

    public void saveOrUpdateSection(SectionFacade section) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().saveOrUpdateSection(section);
    }

    public void removeItemAttachment(String itemAttachmentId) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().removeItemAttachment(Long.valueOf(itemAttachmentId));
    }

    public PublishedSectionFacade addSection(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().addSection(publishedAssessmentId);
    }

    public PublishedSectionFacade getSection(String publishedsectionId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getSection(Long.valueOf(publishedsectionId));
    }

    public AssessmentAccessControlIfc loadPublishedAccessControl(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().loadPublishedAccessControl(publishedAssessmentId);
    }

    public void saveOrUpdatePublishedAccessControl(AssessmentAccessControlIfc publishedAccessControl) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().saveOrUpdatePublishedAccessControl(publishedAccessControl);
    }

    public boolean isReleasedToGroups(String publishedAssessmentId) {
        if (publishedAssessmentId == null) {
            return false;
        }
        PublishedAssessmentFacade pub = this.getPublishedAssessment(publishedAssessmentId);
        if (pub == null) {
            return false;
        }
        return pub.getAssessmentAccessControl().getReleaseTo().equals("Selected Groups");
    }

    public Integer getPublishedAssessmentStatus(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentStatus(publishedAssessmentId);
    }

    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        AssessmentAttachmentIfc attachment = null;
        try {
            PublishedAssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries();
            attachment = queries.createAssessmentAttachment(assessment, resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeAssessmentAttachment(String attachmentId) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().removeAssessmentAttachment(new Long(attachmentId));
    }

    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        SectionAttachmentIfc attachment = null;
        try {
            PublishedAssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries();
            attachment = queries.createSectionAttachment(section, resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeSectionAttachment(String attachmentId) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().removeSectionAttachment(new Long(attachmentId));
    }

    public void saveOrUpdateAttachments(List list) {
        PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().saveOrUpdateAttachments(list);
    }

    public TreeMap getGroupsForSite() {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getGroupsForSite();
    }

    public PublishedAssessmentFacade getPublishedAssessmentInfoForRemove(Long publishedAssessmentId) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedAssessmentInfoForRemove(publishedAssessmentId);
    }

    public HashMap getToGradebookPublishedAssessmentSiteIdMap() {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getToGradebookPublishedAssessmentSiteIdMap();
    }

    public ArrayList getBasicInfoOfLastOrHighestOrAverageSubmittedAssessmentsByScoringOption(String agentId, String siteId, boolean allAssessments) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfLastOrHighestOrAverageSubmittedAssessmentsByScoringOption(agentId, siteId, allAssessments);
    }
}

