/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.questionpool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.shared.SharedException;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.QuestionPoolServiceException;
import org.sakaiproject.tool.assessment.shared.api.questionpool.QuestionPoolServiceAPI;

public class QuestionPoolServiceImpl
implements QuestionPoolServiceAPI {
    private static Log log = LogFactory.getLog(QuestionPoolServiceImpl.class);

    public List getAllPools(String agentId) {
        ArrayList<QuestionPoolFacade> list = new ArrayList<QuestionPoolFacade>();
        try {
            QuestionPoolService service = new QuestionPoolService();
            QuestionPoolIteratorFacade iter = service.getAllPools(agentId);
            while (iter.hasNext()) {
                QuestionPoolFacade pool = iter.next();
                list.add(pool);
            }
            return list;
        }
        catch (SharedException ex) {
            throw new QuestionPoolServiceException(ex);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getBasicInfoOfAllPools(String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getBasicInfoOfAllPools(agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public QuestionPoolDataIfc getPool(Long poolId, String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPool(poolId, agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getPoolIdsByItem(String itemId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPoolIdsByItem(itemId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean hasItem(String itemId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.hasItem(itemId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getPoolIdsByAgent(String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPoolIdsByAgent(agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getSubPools(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getSubPools(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public int getSubPoolSize(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getSubPoolSize(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean hasSubPools(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.hasSubPools(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getAllItemsSorted(Long poolId, String orderBy, String ascending) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getAllItemsSorted(poolId, orderBy, ascending);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getAllItems(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getAllItems(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void addItemToPool(String itemId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.addItemToPool(itemId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void moveItemToPool(String itemId, Long sourceId, Long destId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.moveItemToPool(itemId, sourceId, destId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean isDescendantOf(Long poolA, Long poolB, String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.isDescendantOf(poolA, poolB, agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void movePool(String agentId, Long sourceId, Long destId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.movePool(agentId, sourceId, destId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void deletePool(Long poolId, String agentId, Tree tree) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.deletePool(poolId, agentId, tree);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void removeQuestionFromPool(String questionId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.removeQuestionFromPool(questionId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.copyPool(tree, agentId, sourceId, destId, prependString1, prependString2);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public QuestionPoolDataIfc savePool(QuestionPoolDataIfc pool) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            Long poolId = pool.getQuestionPoolId();
            String agentId = null;
            try {
                agentId = pool.getOwner().getIdString();
            }
            catch (Exception ax) {
                throw new QuestionPoolServiceException(ax);
            }
            QuestionPoolFacade facade = service.getPool(poolId, agentId);
            return service.savePool(facade);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public Map getQuestionPoolItemMap() {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getQuestionPoolItemMap();
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }
}

