/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AuthzQueriesFacade
extends HibernateDaoSupport
implements AuthzQueriesFacadeAPI {
    private static Log log = LogFactory.getLog(AuthzQueriesFacade.class);
    private static ResourceBundle res = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.facade.authz.resource.AuthzResource");

    @Override
    public boolean hasPrivilege(String functionName) {
        return true;
    }

    @Override
    public boolean isAuthorized(String agentId, String function, String qualifier) {
        return true;
    }

    @Override
    public AuthorizationData createAuthorization(String agentId, String functionId, String qualifierId) {
        AuthorizationData a = new AuthorizationData(agentId, functionId, qualifierId, new Date(), new Date(), AgentFacade.getAgentString(), new Date(), Boolean.TRUE);
        this.getHibernateTemplate().save((Object)a);
        return a;
    }

    @Override
    public void removeAuthorizationByQualifier(String qualifierId, boolean isPublishedAssessment) {
        String query = res.getString("select_authdata_q_id") + qualifierId + "'";
        String clause = "";
        clause = isPublishedAssessment ? " and (a.functionId='OWN_PUBLISHED_ASSESSMENT' or a.functionId='TAKE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT_FEEDBACK' or a.functionId='GRADE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT')" : " and a.functionId='EDIT_ASSESSMENT'";
        List l = this.getHibernateTemplate().find(query + clause);
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    @Override
    public void removeAuthorizationByQualifierAndFunction(String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId=" + qualifierId;
        String clause = " and a.functionId='" + functionId + "'";
        List l = this.getHibernateTemplate().find(query + clause);
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    @Override
    public void removeAuthorizationByAgentQualifierAndFunction(String agentId, String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId=" + qualifierId;
        String clause = " and a.agentId='" + agentId + "'";
        List l = this.getHibernateTemplate().find(query + clause);
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    @Override
    public HashMap getAuthorizationToViewAssessments(String agentId) {
        HashMap<String, AuthorizationData> h = new HashMap<String, AuthorizationData>();
        List l = this.getAuthorizationByAgentAndFunction(agentId, res.getString("VIEW_PUB"));
        for (int i = 0; i < l.size(); ++i) {
            AuthorizationData a = (AuthorizationData)l.get(i);
            h.put(a.getQualifierId(), a);
        }
        return h;
    }

    @Override
    public List getAuthorizationByAgentAndFunction(String agentId, String functionId) {
        try {
            String query = res.getString("select_authdata_a_id") + agentId + res.getString("and_f_id") + functionId + "'";
            List list = this.getHibernateTemplate().find(query);
            return list;
        }
        catch (DataAccessException ex) {
            log.warn((Object)("getAuthorizationByAgentAndFunction " + (Object)((Object)ex)));
            return new ArrayList();
        }
    }

    @Override
    public List getAuthorizationByFunctionAndQualifier(String functionId, String qualifierId) {
        try {
            String query = res.getString("select_authdata_f_id") + functionId + res.getString("and_q_id") + qualifierId + "'";
            List list = this.getHibernateTemplate().find(query);
            return list;
        }
        catch (DataAccessException ex) {
            log.warn((Object)("getAuthorizationByAgentAndFunction " + (Object)((Object)ex)));
            return new ArrayList();
        }
    }

    @Override
    public boolean checkMembership(String siteId) {
        return true;
    }

    public boolean checkAuthorization(String agentId, String functionId, String qualifierId) {
        throw new UnsupportedOperationException("Method checkAuthorization() not yet implemented for standalone context.");
    }

    public ArrayList getAssessments(String agentId, String functionId) {
        throw new UnsupportedOperationException("Method getAssessments() not yet implemented for standalone context.");
    }

    public ArrayList getAssessmentsByAgentAndFunction(String agentId, String functionId) {
        throw new UnsupportedOperationException("Method getAssessmentsByAgentAndFunction() not yet implemented for standalone context.");
    }
}

