/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.util.MathUtils;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.cover.ToolManager;

public class GradebookServiceHelperImpl
implements GradebookServiceHelper {
    private static Log log = LogFactory.getLog(GradebookServiceHelperImpl.class);

    @Override
    public boolean gradebookExists(String gradebookUId, GradebookService g) {
        log.debug((Object)("GradebookService = " + g));
        if (gradebookUId == null) {
            return false;
        }
        return g.isGradebookDefined(gradebookUId);
    }

    @Override
    public boolean isGradebookExist(String siteId) {
        Site currentSite = this.getCurrentSite(siteId);
        if (currentSite == null) {
            return false;
        }
        SitePage page = null;
        String toolId = null;
        try {
            List pageList = currentSite.getPages();
            for (int i = 0; i < pageList.size(); ++i) {
                page = (SitePage)pageList.get(i);
                List pageToolList = page.getTools();
                try {
                    toolId = ((ToolConfiguration)pageToolList.get(0)).getTool().getId();
                }
                catch (Exception ee) {
                    log.warn((Object)(siteId + " contains a page (" + page.getTitle() + ") without a valid tool registration"));
                }
                if (toolId != null && toolId.equalsIgnoreCase("sakai.gradebook.tool")) {
                    return true;
                }
                if (toolId == null || !toolId.equalsIgnoreCase("sakai.gradebook.gwt.rpc")) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        return false;
    }

    private Site getCurrentSite(String id) {
        Site site = null;
        try {
            site = SiteService.getSite((String)id);
        }
        catch (IdUnusedException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return site;
    }

    @Override
    public void removeExternalAssessment(String gradebookUId, String publishedAssessmentId, GradebookService g) throws Exception {
        if (g.isGradebookDefined(gradebookUId)) {
            g.removeExternalAssessment(gradebookUId, publishedAssessmentId);
        }
    }

    @Override
    public boolean isAssignmentDefined(String assessmentTitle, GradebookService g) throws Exception {
        String gradebookUId = GradebookFacade.getGradebookUId();
        return g.isAssignmentDefined(gradebookUId, assessmentTitle);
    }

    @Override
    public boolean addToGradebook(PublishedAssessmentData publishedAssessment, GradebookService g) throws Exception {
        boolean added = false;
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        if (g.isGradebookDefined(gradebookUId)) {
            Tool tool = ToolManager.getTool((String)"sakai.samigo");
            String appName = null;
            if (tool == null) {
                log.warn((Object)"could not get tool named sakai.samigo, so we're going to assume we're called 'Tests & Quizzes'");
                appName = "Tests & Quizzes";
            } else {
                appName = tool.getTitle();
            }
            String title = StringEscapeUtils.unescapeHtml((String)publishedAssessment.getTitle());
            if (!g.isAssignmentDefined(gradebookUId, title)) {
                g.addExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, title, publishedAssessment.getTotalScore().doubleValue(), publishedAssessment.getAssessmentAccessControl().getDueDate(), appName);
                added = true;
            }
        }
        return added;
    }

    @Override
    public boolean updateGradebook(PublishedAssessmentIfc publishedAssessment, GradebookService g) throws Exception {
        log.debug((Object)"updateGradebook start");
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        log.debug((Object)"before g.isAssignmentDefined()");
        g.updateExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, publishedAssessment.getTitle(), publishedAssessment.getTotalScore().doubleValue(), publishedAssessment.getAssessmentAccessControl().getDueDate());
        return true;
    }

    @Override
    public void updateExternalAssessmentScore(AssessmentGradingIfc ag, GradebookService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        GradingService gradingService = new GradingService();
        PublishedAssessmentIfc pub = gradingService.getPublishedAssessmentByAssessmentGradingId(ag.getAssessmentGradingId().toString());
        String gradebookUId = pubService.getPublishedAssessmentOwner(pub.getPublishedAssessmentId());
        if (gradebookUId == null) {
            return;
        }
        float fScore = MathUtils.round((float)ag.getFinalScore().floatValue(), (int)2);
        Double score = Float.valueOf(fScore).doubleValue();
        log.info((Object)("rounded:  " + ag.getFinalScore() + " to: " + score.toString()));
        g.updateExternalAssessmentScore(gradebookUId, ag.getPublishedAssessmentId().toString(), ag.getAgentId(), score);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }

    @Override
    public void updateExternalAssessmentScores(Long publishedAssessmentId, Map studentUidsToScores, GradebookService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(publishedAssessmentId);
        if (gradebookUId == null) {
            return;
        }
        g.updateExternalAssessmentScores(gradebookUId, publishedAssessmentId.toString(), studentUidsToScores);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }
}

