/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeType {
    private static Log log = LogFactory.getLog(MimeType.class);
    private static HashMap extensionMime = new HashMap();
    private static HashMap mimeExtension = new HashMap();
    private static boolean loaded = false;
    private static final String UNKNOWN_EXTENSION = ".unknown_binary";

    public static void main(String[] args) {
        log.info((Object)("mime for BMP= " + MimeType.get("BMP")));
        log.info((Object)("mime for .zip= " + MimeType.get(".zip")));
        log.info((Object)("mime for .HTM= " + MimeType.get(".HTM")));
        log.info((Object)("extension for application/x-tar= " + MimeType.getExtension("application/x-tar")));
        log.info((Object)("extension for application/x-gzip= " + MimeType.getExtension("application/x-gzip")));
    }

    public static String get(String extension) {
        if (!loaded) {
            MimeType.init();
        }
        if (extension == null) {
            return "";
        }
        String ext = extension.toLowerCase();
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        return "" + extensionMime.get(ext);
    }

    public static String getExtension(String mimeType) {
        if (!loaded) {
            MimeType.init();
        }
        if (mimeType == null) {
            return UNKNOWN_EXTENSION;
        }
        String mime = mimeType.toLowerCase();
        String extension = "" + mimeExtension.get(mime);
        if ("null".equals(extension)) {
            extension = UNKNOWN_EXTENSION;
        }
        return extension;
    }

    private static void init() {
        extensionMime.put(".aif", "audio/x-aiff");
        extensionMime.put(".aifc", "audio/x-aiff");
        extensionMime.put(".aiff", "audio/x-aiff");
        extensionMime.put(".au", "audio/basic");
        extensionMime.put(".avi", "video/x-msvideo");
        extensionMime.put(".bmp", "image/x-MS-bmp");
        extensionMime.put(".cpio", "application/x-cpio");
        extensionMime.put(".csh", "application/x-csh");
        extensionMime.put(".dvi", "application/x-dvi");
        extensionMime.put(".fif", "application/fractals");
        extensionMime.put(".gif", "image/gif");
        extensionMime.put(".gtar", "application/x-gtar");
        extensionMime.put(".gz", "application/x-gzip");
        extensionMime.put(".hqx", "application/mac-binhex40");
        extensionMime.put(".htm", "text/html");
        extensionMime.put(".html", "text/html");
        extensionMime.put(".ief", "image/ief");
        extensionMime.put(".jf", "application/x-javascript");
        extensionMime.put(".latex", "application/x-latex");
        extensionMime.put(".ls", "application/x-javascript");
        extensionMime.put(".mocha", "application/x-javascript");
        extensionMime.put(".mov", "video/quicktime");
        extensionMime.put(".mpeg", "video/mpeg");
        extensionMime.put(".pac", "application/x-ns-proxy-autoconfig");
        extensionMime.put(".pbm", "image/x-portable-bitmap");
        extensionMime.put(".pnm", "image/x-portable-anymap");
        extensionMime.put(".ppm", "image/x-portable-pixmap");
        extensionMime.put(".ps", "application/postscript");
        extensionMime.put(".ras", "image/x-cmu-raster");
        extensionMime.put(".rgb", "image/x-rgb");
        extensionMime.put(".rtf", "application/rtf");
        extensionMime.put(".shar", "appliation/x-shar");
        extensionMime.put(".sit", "application/x-stuffit");
        extensionMime.put(".tar", "application/x-tar");
        extensionMime.put(".tcl", "application/x-tcl");
        extensionMime.put(".tex", "application/x-tex");
        extensionMime.put(".tif", "image/tiff");
        extensionMime.put(".tiff", "image/tiff");
        extensionMime.put(".txt", "text/plain");
        extensionMime.put(".xhtml", "text/xhtml");
        extensionMime.put(".xml", "text/xml");
        extensionMime.put(".xsd", "text/xml");
        extensionMime.put(".xsl", "text/xml");
        extensionMime.put(".xslt", "text/xml");
        extensionMime.put(".wav", "audio/x-wav");
        extensionMime.put(".xbm", "image/x-bitmap");
        extensionMime.put(".xpm", "image/x-pixmap");
        extensionMime.put(".xwd", "image/xwindowdump");
        extensionMime.put(".z", "application/x-compress");
        extensionMime.put(".zip", "application/x-zip-compressed");
        mimeExtension.put("application/x-shar", ".shar");
        mimeExtension.put("application/fractals", ".fif");
        mimeExtension.put("application/mac-binhex40", ".hqx");
        mimeExtension.put("application/postscript", ".ps");
        mimeExtension.put("application/rtf", ".rtf");
        mimeExtension.put("application/x-compress", ".z");
        mimeExtension.put("application/x-cpio", ".cpio");
        mimeExtension.put("application/x-csh", ".csh");
        mimeExtension.put("application/x-dvi", ".dvi");
        mimeExtension.put("application/x-gtar", ".gtar");
        mimeExtension.put("application/x-gzip", ".gz");
        mimeExtension.put("application/x-javascript", ".jf");
        mimeExtension.put("application/x-javascript", ".ls");
        mimeExtension.put("application/x-javascript", ".mocha");
        mimeExtension.put("application/x-latex", ".latex");
        mimeExtension.put("application/x-ns-proxy-autoconfig", ".pac");
        mimeExtension.put("application/x-stuffit", ".sit");
        mimeExtension.put("application/x-tar", ".tar");
        mimeExtension.put("application/x-tcl", ".tcl");
        mimeExtension.put("application/x-tex", ".tex");
        mimeExtension.put("application/x-zip-compressed", ".zip");
        mimeExtension.put("audio/basic", ".au");
        mimeExtension.put("audio/x-aiff", ".aiff");
        mimeExtension.put("audio/x-wav", ".wav");
        mimeExtension.put("image/gif", ".gif");
        mimeExtension.put("image/ief", ".ief");
        mimeExtension.put("image/tiff", ".tif");
        mimeExtension.put("image/x-MS-bmp", ".bmp");
        mimeExtension.put("image/x-bitmap", ".xbm");
        mimeExtension.put("image/x-cmu-raster", ".ras");
        mimeExtension.put("image/x-pixmap", ".xpm");
        mimeExtension.put("image/x-portable-anymap", ".pnm");
        mimeExtension.put("image/x-portable-bitmap", ".pbm");
        mimeExtension.put("image/x-portable-pixmap", ".ppm");
        mimeExtension.put("image/x-rgb", ".rgb");
        mimeExtension.put("image/xwindowdump", ".xwd");
        mimeExtension.put("text/html", ".html");
        mimeExtension.put("text/plain", ".txt");
        mimeExtension.put("text/xhtml", ".xhtml");
        mimeExtension.put("text/xml", ".xml");
        mimeExtension.put("video/mpeg", ".mpeg");
        mimeExtension.put("video/quicktime", ".mov");
        mimeExtension.put("video/x-msvideo", ".avi");
    }
}

