/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.SimpleExpression;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.dao.grading.StudentGradingSummaryData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.StudentGradingSummaryIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueries;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.AutoSubmitAssessmentsJob;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AssessmentGradingFacadeQueries
extends HibernateDaoSupport
implements AssessmentGradingFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(AssessmentGradingFacadeQueries.class);
    private SiteService siteService;

    @Override
    public List getTotalScores(String publishedId, String which) {
        return this.getTotalScores(publishedId, which, true);
    }

    @Override
    public List getTotalScores(final String publishedId, String which, final boolean getSubmittedOnly) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q = null;
                    if (getSubmittedOnly) {
                        q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId ASC, a.finalScore DESC, a.submittedDate DESC");
                        q.setLong(0, Long.parseLong(publishedId));
                        q.setBoolean(1, true);
                    } else {
                        q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId ASC, a.finalScore DESC, a.submittedDate DESC");
                        q.setLong(0, Long.parseLong(publishedId));
                        q.setBoolean(1, true);
                        q.setBoolean(2, false);
                        q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                    }
                    return q.list();
                }
            };
            List list = this.getHibernateTemplate().executeFind(hcb);
            if (which.equals(EvaluationModelIfc.LAST_SCORE.toString())) {
                HibernateCallback hcb2 = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q = null;
                        if (getSubmittedOnly) {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId ASC, a.submittedDate DESC");
                            q.setLong(0, Long.parseLong(publishedId));
                            q.setBoolean(1, true);
                        } else {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId ASC, a.submittedDate DESC");
                            q.setLong(0, Long.parseLong(publishedId));
                            q.setBoolean(1, true);
                            q.setBoolean(2, false);
                            q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                        }
                        return q.list();
                    }
                };
                list = this.getHibernateTemplate().executeFind(hcb2);
            }
            if (which.equals(EvaluationModelIfc.ALL_SCORE.toString()) || which.equals(EvaluationModelIfc.AVERAGE_SCORE.toString())) {
                return list;
            }
            Iterator items = list.iterator();
            ArrayList<AssessmentGradingData> newlist = new ArrayList<AssessmentGradingData>();
            String agentid = null;
            AssessmentGradingData data = (AssessmentGradingData)items.next();
            data.setPublishedAssessmentId(Long.valueOf(publishedId));
            agentid = data.getAgentId();
            newlist.add(data);
            block2: while (items.hasNext()) {
                while (items.hasNext()) {
                    data = (AssessmentGradingData)items.next();
                    if (data.getAgentId().equals(agentid)) continue;
                    agentid = data.getAgentId();
                    newlist.add(data);
                    continue block2;
                }
            }
            return newlist;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    @Override
    public List getAllSubmissions(final String publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=?");
                q.setLong(0, Long.parseLong(publishedId));
                q.setBoolean(1, true);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getAllAssessmentGradingData(final Long publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.status <> ? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedId.longValue());
                q.setInteger(1, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (AssessmentGradingData adata : list) {
            Set itemGradingSet = this.getItemGradingSet(adata.getAssessmentGradingId());
            adata.setItemGradingSet(itemGradingSet);
        }
        return list;
    }

    @Override
    public HashMap getItemScores(Long publishedId, Long itemId, String which) {
        List scores = this.getTotalScores(publishedId.toString(), which);
        return this.getItemScores(itemId, scores);
    }

    @Override
    public HashMap getItemScores(final Long itemId, List scores) {
        try {
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            final Iterator iter = scores.iterator();
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Criteria criteria = session.createCriteria(ItemGradingData.class);
                    Disjunction disjunction = Expression.disjunction();
                    ArrayList<Long> gradingIdList = new ArrayList<Long>();
                    while (iter.hasNext()) {
                        AssessmentGradingData data = (AssessmentGradingData)iter.next();
                        gradingIdList.add(data.getAssessmentGradingId());
                    }
                    List tempList = new ArrayList();
                    for (int i = 0; i < gradingIdList.size(); i += 50) {
                        if (i + 50 > gradingIdList.size()) {
                            tempList = gradingIdList.subList(i, gradingIdList.size());
                            disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                            continue;
                        }
                        tempList = gradingIdList.subList(i, i + 50);
                        disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                    }
                    if (itemId.equals(0L)) {
                        criteria.add((Criterion)disjunction);
                    } else {
                        SimpleExpression pubCriterion = Expression.eq((String)"publishedItemId", (Object)itemId);
                        criteria.add((Criterion)Expression.and((Criterion)pubCriterion, (Criterion)disjunction));
                    }
                    criteria.addOrder(Order.asc((String)"agentId"));
                    criteria.addOrder(Order.desc((String)"submittedDate"));
                    return criteria.list();
                }
            };
            List temp = (List)this.getHibernateTemplate().execute(hcb);
            for (ItemGradingData data : temp) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    @Override
    public HashMap getLastItemGradingData(final Long publishedId, final String agentId) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status<>? order by a.submittedDate DESC");
                    q.setLong(0, publishedId.longValue());
                    q.setString(1, agentId);
                    q.setBoolean(2, false);
                    q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                    return q.list();
                }
            };
            List scores = this.getHibernateTemplate().executeFind(hcb);
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            if (scores.isEmpty()) {
                return new HashMap();
            }
            AssessmentGradingData gdata = (AssessmentGradingData)scores.toArray()[0];
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            if (gdata.getForGrade().booleanValue()) {
                return new HashMap();
            }
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    @Override
    public HashMap getStudentGradingData(String assessmentGradingId) {
        try {
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            AssessmentGradingData gdata = this.load(new Long(assessmentGradingId));
            log.debug((Object)("****#6, gdata=" + gdata));
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    @Override
    public HashMap getSubmitData(final Long publishedId, final String agentId, final Integer scoringoption, final Long assessmentGradingId) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    log.debug((Object)("scoringoption = " + scoringoption));
                    if (EvaluationModelIfc.LAST_SCORE.equals(scoringoption)) {
                        Query q = null;
                        if (assessmentGradingId == null) {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate DESC");
                            q.setLong(0, publishedId.longValue());
                            q.setString(1, agentId);
                            q.setBoolean(2, true);
                        } else {
                            q = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId=? ");
                            q.setLong(0, assessmentGradingId.longValue());
                        }
                        return q.list();
                    }
                    Query q1 = null;
                    if (assessmentGradingId == null) {
                        q1 = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.finalScore DESC, a.submittedDate DESC");
                        q1.setLong(0, publishedId.longValue());
                        q1.setString(1, agentId);
                        q1.setBoolean(2, true);
                    } else {
                        q1 = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId=? ");
                        q1.setLong(0, assessmentGradingId.longValue());
                    }
                    return q1.list();
                }
            };
            List scores = this.getHibernateTemplate().executeFind(hcb);
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            if (scores.isEmpty()) {
                return new HashMap();
            }
            AssessmentGradingData gdata = (AssessmentGradingData)scores.toArray()[0];
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    @Override
    public Long add(AssessmentGradingData a) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)a);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem adding assessmentGrading: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        return a.getAssessmentGradingId();
    }

    @Override
    public int getSubmissionSizeOfPublishedAssessment(Long publishedAssessmentId) {
        Object[] values = new Object[]{true, publishedAssessmentId};
        List size = this.getHibernateTemplate().find("select count(a) from AssessmentGradingData a where a.forGrade=? and a.publishedAssessmentId=?", values);
        Iterator iter = size.iterator();
        if (iter.hasNext()) {
            int i = (Integer)iter.next();
            return i;
        }
        return 0;
    }

    @Override
    public Long saveMedia(byte[] media, String mimeType) {
        log.debug((Object)("****" + AgentFacade.getAgentString() + "saving media...size=" + media.length + " " + new Date()));
        MediaData mediaData = new MediaData(media, mimeType);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)mediaData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving media with mimeType: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        log.debug((Object)("****" + AgentFacade.getAgentString() + "saved media." + new Date()));
        return mediaData.getMediaId();
    }

    @Override
    public Long saveMedia(MediaData mediaData) {
        log.debug((Object)("****" + mediaData.getFilename() + " saving media...size=" + mediaData.getFileSize() + " " + new Date()));
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)mediaData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving media: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        log.debug((Object)("****" + mediaData.getFilename() + " saved media." + new Date()));
        return mediaData.getMediaId();
    }

    @Override
    public void removeMediaById(Long mediaId) {
        this.removeMediaById(mediaId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaById(Long mediaId, Long itemGradingId) {
        File mediaFile;
        String mediaLocation = null;
        Session session = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        Statement statement0 = null;
        try {
            session = this.getSessionFactory().openSession();
            conn = session.connection();
            log.debug((Object)("****Connection=" + conn));
            String query0 = "select LOCATION from SAM_MEDIA_T where MEDIAID=?";
            statement0 = conn.prepareStatement(query0);
            statement0.setLong(1, mediaId);
            rs = statement0.executeQuery();
            if (rs.next()) {
                mediaLocation = rs.getString("LOCATION");
            }
            log.debug((Object)("****mediaLocation=" + mediaLocation));
            String query = "delete from SAM_MEDIA_T where MEDIAID=?";
            statement = conn.prepareStatement(query);
            statement.setLong(1, mediaId);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (statement0 != null) {
                try {
                    statement0.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (mediaLocation != null && (mediaFile = new File(mediaLocation)).delete()) {
            log.warn((Object)("problem removing file. mediaLocation = " + mediaLocation));
        }
        if (itemGradingId != null) {
            ItemGradingData itemGradingData = this.getItemGrading(itemGradingId);
            itemGradingData.setAutoScore(Float.valueOf(0.0f));
            this.saveItemGrading((ItemGradingIfc)itemGradingData);
        }
    }

    @Override
    public MediaData getMedia(Long mediaId) {
        MediaData mediaData = (MediaData)this.getHibernateTemplate().load(MediaData.class, (Serializable)mediaId);
        return mediaData;
    }

    @Override
    public ArrayList getMediaArray(final Long itemGradingId) {
        log.debug((Object)("*** itemGradingId =" + itemGradingId));
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from MediaData m where m.itemGradingData.itemGradingId=?");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            a.add((MediaData)list.get(i));
        }
        log.debug((Object)("*** no. of media =" + a.size()));
        return a;
    }

    @Override
    public ArrayList getMediaArray2(final Long itemGradingId) {
        log.debug((Object)("*** itemGradingId =" + itemGradingId));
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new MediaData(m.mediaId, m.filename, m.fileSize, m.duration, m.createdDate)  from MediaData m where m.itemGradingData.itemGradingId=?");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            a.add((MediaData)list.get(i));
        }
        log.debug((Object)("*** no. of media =" + a.size()));
        return a;
    }

    @Override
    public HashMap getMediaItemGradingHash(final Long assessmentGradingId) {
        log.debug((Object)("*** assessmentGradingId =" + assessmentGradingId));
        HashMap map = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i from MediaData m, ItemGradingData i where m.itemGradingData.itemGradingId = i.itemGradingId and i.assessmentGradingId = ? ");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            ItemGradingData itemGradingData = (ItemGradingData)list.get(i);
            ArrayList<ItemGradingData> al = new ArrayList<ItemGradingData>();
            al.add(itemGradingData);
            map.put(itemGradingData.getPublishedItemId(), al);
        }
        log.debug((Object)("*** no. of media =" + map.size()));
        return map;
    }

    @Override
    public ArrayList getMediaArray(ItemGradingData item) {
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        List list = this.getHibernateTemplate().find("from MediaData m where m.itemGradingData=?", (Object)item);
        for (int i = 0; i < list.size(); ++i) {
            a.add((MediaData)list.get(i));
        }
        log.debug((Object)("*** no. of media =" + a.size()));
        return a;
    }

    @Override
    public List getMediaArray(Long publishedId, Long publishedItemId, String which) {
        try {
            HashMap itemScores = this.getItemScores(publishedId, publishedItemId, which);
            final List list = (List)itemScores.get(publishedItemId);
            log.debug((Object)("list size list.size() = " + list.size()));
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Criteria criteria = session.createCriteria(MediaData.class);
                    Disjunction disjunction = Expression.disjunction();
                    ArrayList<Long> itemGradingIdList = new ArrayList<Long>();
                    for (int i = 0; i < list.size(); ++i) {
                        ItemGradingIfc itemGradingData = (ItemGradingIfc)list.get(i);
                        itemGradingIdList.add(itemGradingData.getItemGradingId());
                    }
                    List tempList = new ArrayList();
                    for (int i = 0; i < itemGradingIdList.size(); i += 50) {
                        if (i + 50 > itemGradingIdList.size()) {
                            tempList = itemGradingIdList.subList(i, itemGradingIdList.size());
                            disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                            continue;
                        }
                        tempList = itemGradingIdList.subList(i, i + 50);
                        disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                    }
                    criteria.add((Criterion)disjunction);
                    return criteria.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hcb);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    @Override
    public ItemGradingData getLastItemGradingDataByAgent(final Long publishedItemId, final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.publishedItemId=? and i.agentId=?");
                q.setLong(0, publishedItemId.longValue());
                q.setString(1, agentId);
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        if (itemGradings.size() == 0) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public ItemGradingData getItemGradingData(final Long assessmentGradingId, final Long publishedItemId) {
        log.debug((Object)("****assessmentGradingId=" + assessmentGradingId));
        log.debug((Object)("****publishedItemId=" + publishedItemId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId = ? and i.publishedItemId=?");
                q.setLong(0, assessmentGradingId.longValue());
                q.setLong(1, publishedItemId.longValue());
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        if (itemGradings.size() == 0) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public AssessmentGradingData load(Long id) {
        AssessmentGradingData gdata = (AssessmentGradingData)this.getHibernateTemplate().load(AssessmentGradingData.class, (Serializable)id);
        gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
        return gdata;
    }

    @Override
    public ItemGradingData getItemGrading(Long id) {
        return (ItemGradingData)this.getHibernateTemplate().load(ItemGradingData.class, (Serializable)id);
    }

    @Override
    public AssessmentGradingData getLastSavedAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status<>? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (assessmentGradings.size() != 0) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getLastSubmittedAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString, Long assessmentGradingId) {
        AssessmentGradingData ag;
        block2: {
            List assessmentGradings;
            block1: {
                ag = null;
                HibernateCallback hcb = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate desc");
                        q.setLong(0, publishedAssessmentId.longValue());
                        q.setString(1, agentIdString);
                        q.setBoolean(2, true);
                        return q.list();
                    }
                };
                assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
                if (assessmentGradingId != null) break block1;
                if (assessmentGradings.size() <= 0) break block2;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block2;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        return ag;
    }

    @Override
    public AssessmentGradingIfc getLastAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (assessmentGradings.size() != 0) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public void saveItemGrading(ItemGradingIfc item) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)((ItemGradingData)item));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving itemGrading: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAssessmentGrading(AssessmentGradingIfc assessment) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)((AssessmentGradingData)assessment));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem inserting/updating assessmentGrading: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getMediaStream(Long mediaId) {
        byte[] b = new byte[4000];
        Session session = null;
        Connection conn = null;
        InputStream in = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            Object o;
            session = this.getSessionFactory().openSession();
            conn = session.connection();
            log.debug((Object)("****Connection=" + conn));
            String query = "select MEDIA from SAM_MEDIA_T where MEDIAID=?";
            statement = conn.prepareStatement(query);
            statement.setLong(1, mediaId);
            rs = statement.executeQuery();
            if (rs.next() && (o = rs.getObject("MEDIA")) != null) {
                int ch;
                in = rs.getBinaryStream("MEDIA");
                in.mark(0);
                int len = 0;
                while ((ch = in.read()) != -1) {
                    ++len;
                }
                b = new byte[len];
                in.reset();
                in.read(b, 0, len);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return b;
    }

    @Override
    public List getAssessmentGradingIds(final Long publishedItemId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select g.assessmentGradingId from  ItemGradingData g where g.publishedItemId=?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public AssessmentGradingIfc getHighestAssessmentGrading(final Long publishedAssessmentId, final String agentId) {
        AssessmentGradingData ag = null;
        String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and  a.agentId=? order by a.finalScore desc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and  a.agentId=? order by a.finalScore desc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentId);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (assessmentGradings.size() != 0) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingIfc getHighestSubmittedAssessmentGrading(final Long publishedAssessmentId, final String agentId, Long assessmentGradingId) {
        AssessmentGradingData ag;
        block2: {
            List assessmentGradings;
            block1: {
                ag = null;
                String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by a.finalScore desc, a.submittedDate desc";
                HibernateCallback hcb = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by a.finalScore desc, a.submittedDate desc");
                        q.setLong(0, publishedAssessmentId.longValue());
                        q.setString(1, agentId);
                        q.setBoolean(2, true);
                        return q.list();
                    }
                };
                assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
                if (assessmentGradingId != null) break block1;
                if (assessmentGradings.size() <= 0) break block2;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block2;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        return ag;
    }

    @Override
    public List getLastAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getLastSubmittedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getLastSubmittedOrGradedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getHighestAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getHighestSubmittedOrGradedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public HashMap getLastAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug((Object)("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore()));
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    @Override
    public HashMap getHighestAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a,  PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a,  PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Float finalScore = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug((Object)("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore()));
            if (i == 0) {
                currentAgent = g.getAgentId();
                finalScore = g.getFinalScore();
            }
            if (currentAgent.equals(g.getAgentId()) && (finalScore == null && g.getFinalScore() == null || finalScore != null && finalScore.equals(g.getFinalScore()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            finalScore = g.getFinalScore();
        }
        return h;
    }

    @Override
    public Set getItemGradingSet(final Long assessmentGradingId) {
        String query = "from ItemGradingData i where i.assessmentGradingId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        HashSet s = new HashSet();
        for (int i = 0; i < itemGradings.size(); ++i) {
            s.add(itemGradings.get(i));
        }
        return s;
    }

    @Override
    public HashMap getAssessmentGradingByItemGradingId(final Long publishedAssessmentId) {
        List aList = this.getAllSubmissions(publishedAssessmentId.toString());
        HashMap<Long, AssessmentGradingData> aHash = new HashMap<Long, AssessmentGradingData>();
        for (int j = 0; j < aList.size(); ++j) {
            AssessmentGradingData a = (AssessmentGradingData)aList.get(j);
            aHash.put(a.getAssessmentGradingId(), a);
        }
        String query = "select new ItemGradingData(i.itemGradingId, a.assessmentGradingId)  from ItemGradingData i, AssessmentGradingData a  where i.assessmentGradingId=a.assessmentGradingId  and a.publishedAssessmentId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new ItemGradingData(i.itemGradingId, a.assessmentGradingId)  from ItemGradingData i, AssessmentGradingData a  where i.assessmentGradingId=a.assessmentGradingId  and a.publishedAssessmentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        HashMap<Long, AssessmentGradingData> h = new HashMap<Long, AssessmentGradingData>();
        for (int i = 0; i < l.size(); ++i) {
            ItemGradingData o = (ItemGradingData)l.get(i);
            h.put(o.getItemGradingId(), (AssessmentGradingData)aHash.get(o.getAssessmentGradingId()));
        }
        return h;
    }

    @Override
    public void deleteAll(Collection c) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().deleteAll(c);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem inserting assessmentGrading: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAll(Collection c) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdateAll(c);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem inserting assessmentGrading: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByAssessmentGradingId(final Long assessmentGradingId) {
        PublishedAssessmentIfc pub = null;
        String query = "select p from PublishedAssessmentData p, AssessmentGradingData a  where a.publishedAssessmentId=p.publishedAssessmentId and a.assessmentGradingId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from PublishedAssessmentData p, AssessmentGradingData a  where a.publishedAssessmentId=p.publishedAssessmentId and a.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List pubList = this.getHibernateTemplate().executeFind(hcb);
        if (pubList != null && pubList.size() > 0) {
            pub = (PublishedAssessmentIfc)pubList.get(0);
        }
        return pub;
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByPublishedItemId(final Long publishedItemId) {
        PublishedAssessmentIfc pub = null;
        String query = "select p from PublishedAssessmentData p, PublishedItemData i  where p.publishedAssessmentId=i.section.assessment.publishedAssessmentId and i.itemId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from PublishedAssessmentData p, PublishedItemData i  where p.publishedAssessmentId=i.section.assessment.publishedAssessmentId and i.itemId=?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        List pubList = this.getHibernateTemplate().executeFind(hcb);
        if (pubList != null && pubList.size() > 0) {
            pub = (PublishedAssessmentIfc)pubList.get(0);
        }
        return pub;
    }

    @Override
    public ArrayList getLastItemGradingDataPosition(final Long assessmentGradingId, final String agentId) {
        ArrayList<Integer> position = new ArrayList<Integer>();
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select s.sequence  from ItemGradingData i, PublishedItemData pi, PublishedSectionData s  where i.agentId = ? and i.assessmentGradingId = ?  and pi.itemId = i.publishedItemId  and pi.section.id = s.id  group by i.publishedItemId, s.sequence, pi.sequence  order by s.sequence desc , pi.sequence desc");
                    q.setString(0, agentId);
                    q.setLong(1, assessmentGradingId.longValue());
                    return q.list();
                }
            };
            List list = this.getHibernateTemplate().executeFind(hcb);
            if (list.size() == 0) {
                position.add(0);
                position.add(0);
            } else {
                Integer sequence = (Integer)list.get(0);
                int count = 1;
                for (int i = 1; i < list.size(); ++i) {
                    log.debug((Object)("i = " + i));
                    Integer nextSequence = (Integer)list.get(i);
                    if (!sequence.equals(nextSequence)) break;
                    log.debug((Object)"equal");
                    ++count;
                }
                log.debug((Object)("sequence = " + sequence));
                log.debug((Object)("count = " + count));
                position.add(sequence);
                position.add(count);
            }
            return position;
        }
        catch (Exception e) {
            e.printStackTrace();
            position.add(0);
            position.add(0);
            return position;
        }
    }

    @Override
    public List getPublishedItemIds(final Long assessmentGradingId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i.publishedItemId from  ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public HashSet getItemSet(final Long publishedAssessmentId, final Long sectionId) {
        HashSet<PublishedItemData> itemSet = new HashSet<PublishedItemData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select pia from PublishedItemData pia where pia.itemId in (select p.itemId from PublishedItemData p, AssessmentGradingData a, ItemGradingData i where a.publishedAssessmentId=? and a.forGrade=? and p.section.id=? and i.assessmentGradingId = a.assessmentGradingId and p.itemId = i.publishedItemId) ");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setLong(2, sectionId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        for (PublishedItemData publishedItemData : assessmentGradings) {
            log.debug((Object)("itemId = " + publishedItemData.getItemId()));
            itemSet.add(publishedItemData);
        }
        return itemSet;
    }

    @Override
    public Long getTypeId(final Long itemGradingId) {
        Long typeId2 = -1L;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p.typeId from PublishedItemData p, ItemGradingData i where i.itemGradingId=? and p.itemId = i.publishedItemId ");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List typeIdList = this.getHibernateTemplate().executeFind(hcb);
        for (Long typeId2 : typeIdList) {
            log.debug((Object)("typeId = " + typeId2));
        }
        return typeId2;
    }

    @Override
    public List getAllAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings;
    }

    @Override
    public HashMap getSiteSubmissionCountHash(final String siteId) {
        HashMap siteSubmissionCountHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ");
                q.setBoolean(0, true);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> numberSubmissionPerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberSubmissionPerStudentHash.put(o[1], o[2]);
                continue;
            }
            numberSubmissionPerStudentHash = new HashMap();
            numberSubmissionPerStudentHash.put(o[1], o[2]);
            siteSubmissionCountHash.put(publishedAssessmentid, numberSubmissionPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteSubmissionCountHash;
    }

    @Override
    public HashMap getSiteInProgressCountHash(final String siteId) {
        HashMap siteInProgressCountHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and (a.status=? or a.status=?) group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ");
                q.setBoolean(0, false);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                q.setInteger(3, 0);
                q.setInteger(4, 6);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> numberInProgressPerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberInProgressPerStudentHash.put(o[1], o[2]);
                continue;
            }
            numberInProgressPerStudentHash = new HashMap();
            numberInProgressPerStudentHash.put(o[1], o[2]);
            siteInProgressCountHash.put(publishedAssessmentid, numberInProgressPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteInProgressCountHash;
    }

    @Override
    public int getActualNumberRetake(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=?  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        if (iter.hasNext()) {
            int i = (Integer)iter.next();
            return i;
        }
        return 0;
    }

    @Override
    public HashMap getSiteActualNumberRetakeHash(final String siteId) {
        HashMap actualNumberRetakeHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*)  from AssessmentGradingData a, StudentGradingSummaryData s, AuthorizationData au  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate group by a.publishedAssessmentId, a.agentId");
                q.setBoolean(0, true);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> actualNumberRetakePerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                actualNumberRetakePerStudentHash.put(o[1], o[2]);
                continue;
            }
            actualNumberRetakePerStudentHash = new HashMap();
            actualNumberRetakePerStudentHash.put(o[1], o[2]);
            actualNumberRetakeHash.put(publishedAssessmentid, actualNumberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return actualNumberRetakeHash;
    }

    @Override
    public HashMap getActualNumberRetakeHash(final String agentIdString) {
        HashMap<Object, Object> actualNumberRetakeHash = new HashMap<Object, Object>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.agentId=? and a.forGrade=?  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate group by a.publishedAssessmentId");
                q.setString(0, agentIdString);
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        for (Object[] o : countList) {
            actualNumberRetakeHash.put(o[0], o[1]);
        }
        return actualNumberRetakeHash;
    }

    @Override
    public List getStudentGradingSummaryData(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s where s.publishedAssessmentId=? and s.agentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List studentGradingSummaryDataList = this.getHibernateTemplate().executeFind(hcb);
        return studentGradingSummaryDataList;
    }

    @Override
    public int getNumberRetake(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s.numberRetake from StudentGradingSummaryData s where s.publishedAssessmentId=? and s.agentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List numberRetakeList = this.getHibernateTemplate().executeFind(hcb);
        if (numberRetakeList.size() == 0) {
            return 0;
        }
        Integer numberRetake = (Integer)numberRetakeList.get(0);
        return numberRetake;
    }

    @Override
    public HashMap getNumberRetakeHash(final String agentIdString) {
        HashMap<Long, StudentGradingSummaryData> h = new HashMap<Long, StudentGradingSummaryData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s where s.agentId=? ");
                q.setString(0, agentIdString);
                return q.list();
            }
        };
        List numberRetakeList = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < numberRetakeList.size(); ++i) {
            StudentGradingSummaryData s = (StudentGradingSummaryData)numberRetakeList.get(i);
            h.put(s.getPublishedAssessmentId(), s);
        }
        return h;
    }

    @Override
    public HashMap getSiteNumberRetakeHash(final String siteId) {
        HashMap siteNumberRetakeHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and s.publishedAssessmentId = au.qualifierId order by s.publishedAssessmentId, s.agentId");
                q.setString(0, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(1, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<String, Integer> numberRetakePerStudentHash = null;
        while (iter.hasNext()) {
            StudentGradingSummaryData s = (StudentGradingSummaryData)iter.next();
            Long publishedAssessmentid = s.getPublishedAssessmentId();
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
                continue;
            }
            numberRetakePerStudentHash = new HashMap<String, Integer>();
            numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
            siteNumberRetakeHash.put(publishedAssessmentid, numberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteNumberRetakeHash;
    }

    @Override
    public void saveStudentGradingSummaryData(StudentGradingSummaryIfc studentGradingSummaryData) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)((StudentGradingSummaryData)studentGradingSummaryData));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving studentGradingSummaryData: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public int getLateSubmissionsNumberByAgentId(final Long publishedAssessmentId, final String agentIdString, final Date dueDate) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.submittedDate>?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                q.setDate(3, dueDate);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings.size();
    }

    public List getAllOrderedSubmissions(final String publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=? and a.finalScore <> 0)) order by a.agentId ASC, a.submittedDate");
                q.setLong(0, Long.parseLong(publishedId));
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getExportResponsesData(String publishedAssessmentId, boolean anonymous, String audioMessage, String fileUploadMessage, String noSubmissionMessage, boolean showPartAndTotalScoreSpreadsheetColumns, String poolString, String partString, String questionString, String textString, String rationaleString, String itemGradingCommentsString, Map useridMap) {
        ArrayList dataList = new ArrayList();
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList<ArrayList<Object>> finalList = new ArrayList<ArrayList<Object>>(2);
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        HashSet publishedAssessmentSections = pubService.getSectionSetForAssessment(Long.valueOf(publishedAssessmentId));
        Float zeroFloat = new Float(0.0);
        HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash(pubService.getPublishedAssessment(publishedAssessmentId));
        HashMap publishedItemTextHash = pubService.preparePublishedItemTextHash(pubService.getPublishedAssessment(publishedAssessmentId));
        HashMap publishedItemHash = pubService.preparePublishedItemHash(pubService.getPublishedAssessment(publishedAssessmentId));
        TreeSet publishItemSet = new TreeSet(new ItemComparator());
        publishItemSet.addAll(publishedItemHash.values());
        int numSubmission = 1;
        String numSubmissionText = noSubmissionMessage;
        String lastAgentId = "";
        String agentEid = "";
        String firstName = "";
        String lastName = "";
        HashSet useridSet = new HashSet(useridMap.keySet());
        ArrayList<Object> responseList = null;
        boolean canBeExported = false;
        boolean fistItemGradingData = true;
        List list = this.getAllOrderedSubmissions(publishedAssessmentId);
        Iterator assessmentGradingIter = list.iterator();
        while (assessmentGradingIter.hasNext()) {
            Iterator sectionsIter = publishedAssessmentSections.iterator();
            HashMap sectionItems = new HashMap();
            TreeMap<Integer, Float> sectionScores = new TreeMap<Integer, Float>();
            while (sectionsIter.hasNext()) {
                PublishedSectionData publishedSection = (PublishedSectionData)sectionsIter.next();
                ArrayList itemsArray = publishedSection.getItemArraySortedForGrading();
                Iterator itemsIter = itemsArray.iterator();
                HashMap<Long, Long> itemsForSection = new HashMap<Long, Long>();
                while (itemsIter.hasNext()) {
                    ItemDataIfc item = (ItemDataIfc)itemsIter.next();
                    itemsForSection.put(item.getItemId(), item.getItemId());
                }
                sectionItems.put(publishedSection.getSequence(), itemsForSection);
                sectionScores.put(publishedSection.getSequence(), zeroFloat);
            }
            AssessmentGradingData assessmentGradingData = (AssessmentGradingData)assessmentGradingIter.next();
            String agentId = assessmentGradingData.getAgentId();
            responseList = new ArrayList<Object>();
            canBeExported = false;
            if (anonymous) {
                canBeExported = true;
                responseList.add(assessmentGradingData.getAssessmentGradingId());
            } else if (useridMap.containsKey(assessmentGradingData.getAgentId())) {
                useridSet.remove(assessmentGradingData.getAgentId());
                canBeExported = true;
                try {
                    agentEid = UserDirectoryService.getUser((String)assessmentGradingData.getAgentId()).getEid();
                    firstName = UserDirectoryService.getUser((String)assessmentGradingData.getAgentId()).getFirstName();
                    lastName = UserDirectoryService.getUser((String)assessmentGradingData.getAgentId()).getLastName();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot get user");
                }
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                if (assessmentGradingData.getForGrade().booleanValue()) {
                    if (lastAgentId.equals(agentId)) {
                        ++numSubmission;
                    } else {
                        numSubmission = 1;
                        lastAgentId = agentId;
                    }
                } else {
                    numSubmission = 0;
                    lastAgentId = agentId;
                }
                numSubmissionText = numSubmission == 0 ? noSubmissionMessage : String.valueOf(numSubmission);
                responseList.add(numSubmissionText);
            }
            if (!canBeExported) continue;
            int sectionScoreColumnStart = responseList.size();
            if (showPartAndTotalScoreSpreadsheetColumns) {
                Float finalScore = assessmentGradingData.getFinalScore();
                if (finalScore != null) {
                    responseList.add(finalScore.doubleValue());
                } else {
                    log.debug((Object)"finalScore is NULL");
                    responseList.add(0.0);
                }
            }
            String assessmentGradingComments = "";
            if (assessmentGradingData.getComments() != null) {
                assessmentGradingComments = assessmentGradingData.getComments().replaceAll("<br\\s*/>", "");
            }
            responseList.add(assessmentGradingComments);
            Long assessmentGradingId = assessmentGradingData.getAssessmentGradingId();
            HashMap studentGradingMap = this.getStudentGradingData(assessmentGradingData.getAssessmentGradingId().toString());
            ArrayList<Object> grades = new ArrayList<Object>();
            grades.addAll(studentGradingMap.values());
            Collections.sort(grades, new QuestionComparator(publishedItemHash));
            if (grades.size() < publishItemSet.size()) {
                int index = -1;
                for (Object e : publishItemSet) {
                    PublishedItemData pid = (PublishedItemData)e;
                    if (++index != grades.size() && ((ItemGradingIfc)((List)grades.get(index)).get(0)).getPublishedItemId().longValue() == pid.getItemId().longValue()) continue;
                    ArrayList<EmptyItemGrading> newList = new ArrayList<EmptyItemGrading>();
                    newList.add(new EmptyItemGrading(pid.getSection().getSequence(), pid.getItemId(), pid.getSequence()));
                    grades.add(index, newList);
                }
            }
            int questionNumber = 0;
            for (Object e : grades) {
                List l = (List)e;
                if (l.size() > 1) {
                    Collections.sort(l, new AnswerComparator(publishedAnswerHash));
                }
                String maintext = "";
                String rationale = "";
                boolean addRationale = false;
                int count = 0;
                ItemGradingIfc grade = null;
                boolean isFinFib = false;
                float itemScore = 0.0f;
                for (Object ooo : l) {
                    String temptext;
                    Long answerid;
                    String thistext;
                    grade = (ItemGradingIfc)ooo;
                    if (grade == null || EmptyItemGrading.class.isInstance(grade)) continue;
                    if (grade != null && grade.getAutoScore() != null) {
                        itemScore += grade.getAutoScore().floatValue();
                    }
                    log.debug((Object)("<br> " + grade.getPublishedItemId() + " " + grade.getRationale() + " " + grade.getAnswerText() + " " + grade.getComments() + " " + grade.getReview()));
                    Long publishedItemId = grade.getPublishedItemId();
                    ItemDataIfc publishedItemData = (ItemDataIfc)publishedItemHash.get(publishedItemId);
                    Long typeId = publishedItemData.getTypeId();
                    questionNumber = publishedItemData.getSequence();
                    if (typeId.equals(TypeIfc.FILL_IN_BLANK) || typeId.equals(TypeIfc.FILL_IN_NUMERIC)) {
                        AnswerIfc answer;
                        log.debug((Object)"FILL_IN_BLANK, FILL_IN_NUMERIC");
                        isFinFib = true;
                        thistext = "";
                        answerid = grade.getPublishedAnswerId();
                        Long sequence = null;
                        if (answerid != null && (answer = (AnswerIfc)publishedAnswerHash.get(answerid)) != null) {
                            sequence = answer.getSequence();
                        }
                        if ((temptext = grade.getAnswerText()) == null) {
                            temptext = "No Answer";
                        }
                        thistext = sequence + ": " + temptext;
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.MATCHING)) {
                        log.debug((Object)"MATCHING");
                        thistext = "";
                        answerid = grade.getPublishedAnswerId();
                        String temptext2 = "No Answer";
                        Long sequence = null;
                        if (answerid != null) {
                            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(answerid);
                            temptext2 = answer.getText();
                            if (temptext2 == null) {
                                temptext2 = "No Answer";
                            }
                            sequence = answer.getItemText().getSequence();
                        } else {
                            ItemTextIfc itemTextIfc = (ItemTextIfc)publishedItemTextHash.get(grade.getPublishedItemTextId());
                            sequence = itemTextIfc.getSequence();
                        }
                        thistext = sequence + ": " + temptext2;
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.AUDIO_RECORDING)) {
                        log.debug((Object)"AUDIO_RECORDING");
                        maintext = audioMessage;
                    } else if (typeId.equals(TypeIfc.FILE_UPLOAD)) {
                        log.debug((Object)"FILE_UPLOAD");
                        maintext = fileUploadMessage;
                    } else if (typeId.equals(TypeIfc.ESSAY_QUESTION)) {
                        log.debug((Object)"ESSAY_QUESTION");
                        if (grade.getAnswerText() != null) {
                            maintext = grade.getAnswerText();
                        }
                    } else {
                        log.debug((Object)"other type");
                        thistext = "";
                        answerid = grade.getPublishedAnswerId();
                        if (answerid != null) {
                            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(answerid);
                            if (answer != null) {
                                temptext = answer.getText();
                                if (temptext != null) {
                                    thistext = temptext;
                                }
                            } else {
                                log.warn((Object)("Published answer for " + answerid + " is null"));
                            }
                        }
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    }
                    if (addRationale || !typeId.equals(TypeIfc.MULTIPLE_CHOICE) && !typeId.equals(TypeIfc.MULTIPLE_CORRECT) && !typeId.equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) && !typeId.equals(TypeIfc.TRUE_FALSE)) continue;
                    log.debug((Object)"MULTIPLE_CHOICE or MULTIPLE_CORRECT or MULTIPLE_CORRECT_SINGLE_SELECTION or TRUE_FALSE");
                    if (publishedItemData.getHasRationale() == null || !publishedItemData.getHasRationale().booleanValue()) continue;
                    addRationale = true;
                    rationale = grade.getRationale();
                    if (rationale != null) continue;
                    rationale = "";
                }
                Integer sectionSequenceNumber = null;
                if (grade == null || EmptyItemGrading.class.isInstance(grade)) {
                    sectionSequenceNumber = ((EmptyItemGrading)EmptyItemGrading.class.cast(grade)).getSectionSequence();
                    questionNumber = ((EmptyItemGrading)EmptyItemGrading.class.cast(grade)).getItemSequence();
                    maintext = "-";
                } else {
                    sectionSequenceNumber = this.updateSectionScore(sectionItems, sectionScores, grade.getPublishedItemId(), itemScore);
                }
                if (isFinFib && maintext.indexOf("No Answer") >= 0 && count == 1) {
                    maintext = "No Answer";
                } else if ("".equals(maintext)) {
                    maintext = "No Answer";
                }
                responseList.add(maintext);
                if (addRationale) {
                    responseList.add(rationale);
                }
                String itemGradingComments = "";
                if (grade.getComments() != null) {
                    itemGradingComments = grade.getComments().replaceAll("<br\\s*/>", "");
                }
                responseList.add(itemGradingComments);
                if (!fistItemGradingData) continue;
                String poolName = null;
                for (PublishedSectionData psd : publishedAssessmentSections) {
                    if (psd.getSequence().intValue() != sectionSequenceNumber.intValue()) continue;
                    poolName = psd.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
                }
                headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, textString, questionNumber, poolString, poolName));
                if (addRationale) {
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, rationaleString, questionNumber, poolString, poolName));
                }
                headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, itemGradingCommentsString, questionNumber, poolString, poolName));
            }
            if (showPartAndTotalScoreSpreadsheetColumns && sectionScores.size() > 1) {
                Iterator keys = sectionScores.keySet().iterator();
                while (keys.hasNext()) {
                    Double d = ((Float)sectionScores.get(keys.next())).doubleValue();
                    responseList.add(sectionScoreColumnStart++, d);
                }
            }
            dataList.add(responseList);
            if (!fistItemGradingData) continue;
            fistItemGradingData = false;
        }
        if (!anonymous && useridSet.size() != 0) {
            for (String id : useridSet) {
                try {
                    agentEid = UserDirectoryService.getUser((String)id).getEid();
                    firstName = UserDirectoryService.getUser((String)id).getFirstName();
                    lastName = UserDirectoryService.getUser((String)id).getLastName();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot get user");
                }
                responseList = new ArrayList();
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                responseList.add(noSubmissionMessage);
                dataList.add(responseList);
            }
        }
        Collections.sort(dataList, new ResponsesComparator(anonymous));
        finalList.add(dataList);
        finalList.add(headerList);
        return finalList;
    }

    private int updateSectionScore(HashMap sectionItems, TreeMap sectionScores, Long publishedItemId, float itemScore) {
        for (Map.Entry entry : sectionItems.entrySet()) {
            Object sectionSequence = entry.getKey();
            HashMap itemsForSection = (HashMap)entry.getValue();
            if (itemsForSection.get(publishedItemId) == null) continue;
            Float score = Float.valueOf(((Float)sectionScores.get(sectionSequence)).floatValue() + itemScore);
            sectionScores.put(sectionSequence, score);
            return (Integer)sectionSequence;
        }
        return 0;
    }

    @Override
    public void removeUnsubmittedAssessmentGradingData(final AssessmentGradingIfc data) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status=? order by a.submittedDate desc");
                q.setLong(0, data.getPublishedAssessmentId().longValue());
                q.setString(1, data.getAgentId());
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingIfc.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (assessmentGradings.size() != 0) {
            this.deleteAll(assessmentGradings);
        }
    }

    @Override
    public boolean getHasGradingData(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? ");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings.size() != 0;
    }

    @Override
    public ArrayList getHasGradingDataAndHasSubmission(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<Boolean> al = new ArrayList<Boolean>();
        if (assessmentGradings.size() == 0) {
            al.add(Boolean.FALSE);
            al.add(Boolean.FALSE);
        } else {
            al.add(Boolean.TRUE);
            String currentAgent = "";
            Iterator iter = assessmentGradings.iterator();
            boolean hasSubmission = false;
            while (iter.hasNext()) {
                AssessmentGradingData adata = (AssessmentGradingData)iter.next();
                if (currentAgent.equals(adata.getAgentId())) continue;
                if (adata.getForGrade().booleanValue()) {
                    al.add(Boolean.TRUE);
                    hasSubmission = true;
                    break;
                }
                currentAgent = adata.getAgentId();
            }
            if (!hasSubmission) {
                al.add(Boolean.FALSE);
            }
        }
        return al;
    }

    @Override
    public String getFilename(Long itemGradingId, String agentId, String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return this.getFilenameWOExtesion(itemGradingId, agentId, filename);
        }
        return this.getFilenameWExtesion(itemGradingId, agentId, filename, dotIndex);
    }

    private String getFilenameWOExtesion(Long itemGradingId, String agentId, String filename) {
        StringBuffer bindVar = new StringBuffer(filename);
        bindVar.append("%");
        Object[] values = new Object[]{(long)itemGradingId, agentId, bindVar.toString()};
        List list = this.getHibernateTemplate().find("select filename from MediaData m where m.itemGradingData.itemGradingId=? and m.createdBy=? and m.filename like ?", values);
        if (list.size() == 0) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        String name = "";
        while (iter.hasNext()) {
            name = ((String)iter.next()).trim();
            if (name.indexOf(".") >= 0 || !name.equals(filename) && !name.startsWith(filename + "(")) continue;
            hs.add(name);
        }
        if (hs.size() == 0) {
            return filename;
        }
        StringBuffer testName = new StringBuffer(filename);
        int i = 1;
        while (hs.contains(testName.toString())) {
            testName = new StringBuffer(filename);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
        return testName.toString();
    }

    private String getFilenameWExtesion(Long itemGradingId, String agentId, String filename, int dotIndex) {
        String filenameWithoutExtension = filename.substring(0, dotIndex);
        StringBuffer bindVar = new StringBuffer(filenameWithoutExtension);
        bindVar.append("%");
        bindVar.append(filename.substring(dotIndex));
        Object[] values = new Object[]{(long)itemGradingId, agentId, bindVar.toString()};
        List list = this.getHibernateTemplate().find("select filename from MediaData m where m.itemGradingData.itemGradingId=? and m.createdBy=? and m.filename like ?", values);
        if (list.size() == 0) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        String name = "";
        int nameLenght = 0;
        String extension = filename.substring(dotIndex);
        int extensionLength = extension.length();
        while (iter.hasNext()) {
            name = ((String)iter.next()).trim();
            if (!name.equals(filename) && !name.startsWith(filenameWithoutExtension + "(")) continue;
            nameLenght = name.length();
            hs.add(name.substring(0, nameLenght - extensionLength));
        }
        if (hs.size() == 0) {
            return filename;
        }
        StringBuffer testName = new StringBuffer(filenameWithoutExtension);
        int i = 1;
        while (true) {
            if (!hs.contains(testName.toString())) {
                testName.append(extension);
                return testName.toString();
            }
            testName = new StringBuffer(filenameWithoutExtension);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
    }

    @Override
    public List getUpdatedAssessmentList(String agentId, String siteId) {
        ArrayList finalList = new ArrayList();
        ArrayList<Object> updatedAssessmentList = new ArrayList<Object>();
        ArrayList<Object> updatedAssessmentNeedResubmitListList = new ArrayList<Object>();
        Object[] values = new Object[]{agentId, siteId, "OWN_PUBLISHED_ASSESSMENT", false, AssessmentGradingIfc.ASSESSMENT_UPDATED, AssessmentGradingIfc.ASSESSMENT_UPDATED_NEED_RESUBMIT};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, a.status from AssessmentGradingData a, AuthorizationData az  where a.agentId=? and az.agentIdString=? and az.functionId=?  and az.qualifierId=a.publishedAssessmentId and a.forGrade=? and (a.status=? or a.status=?)  order by a.status", values);
        if (list.size() == 0) {
            return updatedAssessmentList;
        }
        for (Object[] o : list) {
            if (AssessmentGradingIfc.ASSESSMENT_UPDATED_NEED_RESUBMIT.compareTo((Integer)o[1]) == 0) {
                updatedAssessmentNeedResubmitListList.add(o[0]);
                continue;
            }
            updatedAssessmentList.add(o[0]);
        }
        finalList.add(updatedAssessmentNeedResubmitListList);
        finalList.add(updatedAssessmentList);
        return finalList;
    }

    @Override
    public List getSiteNeedResubmitList(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, 4};
        List list = this.getHibernateTemplate().find("select distinct a.publishedAssessmentId from AssessmentGradingData a, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and a.status=? ", values);
        return list;
    }

    @Override
    public void autoSubmitAssessments() {
        Object[] values = new Object[]{1};
        List list = this.getHibernateTemplate().find("select new AssessmentGradingData(a.assessmentGradingId, a.publishedAssessmentId,  a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,  a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAccessControl c  where a.publishedAssessmentId = c.assessment.publishedAssessmentId  and current_timestamp() >= c.retractDate and a.status not in (4, 5) and c.autoSubmit = ?  order by a.publishedAssessmentId, a.agentId, a.forGrade desc ", values);
        Iterator iter = list.iterator();
        String lastAgentId = "";
        Long lastPublishedAssessmentId = 0L;
        HashMap sectionSetMap = new HashMap();
        HashMap gradebookMap = new HashMap();
        HashMap studentUidsToScores = new HashMap();
        ArrayList toGradebookAssessmentsList = new ArrayList();
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade assessment = null;
        GradebookService g = null;
        boolean updateGrades = false;
        HashMap toGradebookPublishedAssessmentSiteIdMap = null;
        GradebookServiceHelper gbsHelper = null;
        AssessmentGradingData adata = null;
        if (IntegrationContextFactory.getInstance() != null) {
            boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
            if (integrated) {
                g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
            }
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            toGradebookPublishedAssessmentSiteIdMap = publishedAssessmentService.getToGradebookPublishedAssessmentSiteIdMap();
            gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
            updateGrades = true;
        }
        boolean updateCurrentGrade = false;
        while (iter.hasNext()) {
            updateCurrentGrade = false;
            try {
                String currentSiteId;
                adata = (AssessmentGradingData)iter.next();
                if (!lastPublishedAssessmentId.equals(adata.getPublishedAssessmentId()) || !lastAgentId.equals(adata.getAgentId())) {
                    lastPublishedAssessmentId = adata.getPublishedAssessmentId();
                    lastAgentId = adata.getAgentId();
                    if (Boolean.FALSE.equals(adata.getForGrade())) {
                        updateCurrentGrade = true;
                        adata.setForGrade(Boolean.TRUE);
                        if (adata.getTotalAutoScore() == null) {
                            adata.setTotalAutoScore(Float.valueOf(0.0f));
                        }
                        if (adata.getFinalScore() == null) {
                            adata.setFinalScore(Float.valueOf(0.0f));
                        }
                        if (adata.getSubmittedDate() != null && assessment != null && assessment.getDueDate() != null && adata.getSubmittedDate().after(assessment.getDueDate())) {
                            adata.setIsLate(Boolean.valueOf(true));
                        }
                        adata.setIsAutoSubmitted(Boolean.TRUE);
                        adata.setStatus(Integer.valueOf(1));
                        this.completeItemGradingData(adata, sectionSetMap);
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job", (String)AutoSubmitAssessmentsJob.safeEventLength("publishedAssessmentId=" + adata.getPublishedAssessmentId() + ", assessmentGradingId=" + adata.getAssessmentGradingId()), (boolean)true));
                    }
                }
                this.getHibernateTemplate().saveOrUpdate((Object)adata);
                if (updateGrades && updateCurrentGrade && toGradebookPublishedAssessmentSiteIdMap.containsKey(adata.getPublishedAssessmentId()) && gbsHelper.gradebookExists(GradebookFacade.getGradebookUId(currentSiteId = (String)toGradebookPublishedAssessmentSiteIdMap.get(adata.getPublishedAssessmentId())), g)) {
                    int retryCount = PersistenceService.getInstance().getRetryCount();
                    while (retryCount > 0) {
                        try {
                            HashMap<String, Double> studentScore = new HashMap<String, Double>();
                            studentScore.put(adata.getAgentId(), Double.valueOf(adata.getFinalScore().floatValue()));
                            gbsHelper.updateExternalAssessmentScores(adata.getPublishedAssessmentId(), studentScore, g);
                            retryCount = 0;
                        }
                        catch (Exception e) {
                            if (adata != null) {
                                log.error((Object)("Error while updating external assessment score during auto submitting assessment grade data id: " + adata.getAssessmentGradingId()), (Throwable)e);
                            } else {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                            retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
                        }
                    }
                }
                adata = null;
            }
            catch (Exception e) {
                if (adata != null) {
                    log.error((Object)("Error while auto submitting assessment grade data id: " + adata.getAssessmentGradingId()), (Throwable)e);
                    continue;
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String makeHeader(String section, int sectionNumber, String question, String headerType, int questionNumber, String pool, String poolName) {
        StringBuffer sb = new StringBuffer(section);
        sb.append(" ");
        sb.append(sectionNumber);
        sb.append(", ");
        sb.append(question);
        sb.append(" ");
        sb.append(questionNumber);
        sb.append(", ");
        if (poolName != null) {
            sb.append(pool);
            sb.append(" ");
            sb.append(poolName);
            sb.append(", ");
        }
        sb.append(headerType);
        return sb.toString();
    }

    @Override
    public ItemGradingAttachmentIfc createItemGradingtAttachment(ItemGradingIfc itemGrading, String resourceId, String filename, String protocol) {
        ItemGradingAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = ContentHostingService.getResource((String)resourceId);
            if (cr != null) {
                AssessmentFacadeQueries assessmentFacadeQueries = new AssessmentFacadeQueries();
                ResourceProperties p = cr.getProperties();
                attach = new ItemGradingAttachment();
                attach.setItemGrading(itemGrading);
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(assessmentFacadeQueries.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(assessmentFacadeQueries.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public void removeItemGradingAttachment(Long attachmentId) {
        ItemGradingAttachment itemGradingAttachment = (ItemGradingAttachment)this.getHibernateTemplate().load(ItemGradingAttachment.class, (Serializable)attachmentId);
        ItemGradingIfc itemGrading = itemGradingAttachment.getItemGrading();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (itemGrading == null) continue;
                Set set = itemGrading.getItemGradingAttachmentSet();
                set.remove(itemGradingAttachment);
                this.getHibernateTemplate().delete((Object)itemGradingAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete assessmentAttachment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAttachments(List list) {
        this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
    }

    @Override
    public HashMap getInProgressCounts(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, 0, 6};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and (a.status=? or a.status=?) group by a.publishedAssessmentId", values);
        Iterator iter = list.iterator();
        HashMap<Object, Object> inProgressCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            inProgressCountsMap.put(o[0], o[1]);
        }
        return inProgressCountsMap;
    }

    @Override
    public HashMap getSubmittedCounts(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, true};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, count(distinct a.agentId) from AssessmentGradingData a, AuthorizationData au, PublishedAssessmentData p where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and a.publishedAssessmentId = p.publishedAssessmentId and (p.lastNeedResubmitDate is null or a.submittedDate >= p.lastNeedResubmitDate) group by a.publishedAssessmentId", values);
        Iterator iter = list.iterator();
        HashMap<Object, Object> startedCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            startedCountsMap.put(o[0], o[1]);
        }
        return startedCountsMap;
    }

    @Override
    public void completeItemGradingData(AssessmentGradingData assessmentGradingData) {
        this.completeItemGradingData(assessmentGradingData, null);
    }

    public void completeItemGradingData(AssessmentGradingData assessmentGradingData, HashMap sectionSetMap) {
        ArrayList<Long> answeredPublishedItemIdList = new ArrayList<Long>();
        List publishedItemIds = this.getPublishedItemIds(assessmentGradingData.getAssessmentGradingId());
        Iterator iter = publishedItemIds.iterator();
        Long answeredPublishedItemId = 0L;
        while (iter.hasNext()) {
            answeredPublishedItemId = (Long)iter.next();
            log.debug((Object)("answeredPublishedItemId = " + answeredPublishedItemId));
            answeredPublishedItemIdList.add(answeredPublishedItemId);
        }
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        Long publishedAssessmentId = assessmentGradingData.getPublishedAssessmentId();
        HashSet sectionSet = null;
        if (sectionSetMap == null || !sectionSetMap.containsKey(publishedAssessmentId)) {
            sectionSet = publishedAssessmentService.getSectionSetForAssessment(publishedAssessmentId);
            if (sectionSetMap != null) {
                sectionSetMap.put(publishedAssessmentId, sectionSet);
            }
        } else {
            sectionSet = (HashSet)sectionSetMap.get(publishedAssessmentId);
        }
        if (sectionSet == null) {
            return;
        }
        PublishedSectionData publishedSectionData2 = null;
        ArrayList itemArrayList = null;
        Long publishedItemId = 0L;
        PublishedItemData publishedItemData2 = null;
        for (PublishedSectionData publishedSectionData2 : sectionSet) {
            log.debug((Object)("sectionId = " + publishedSectionData2.getSectionId()));
            String authorType = publishedSectionData2.getSectionMetaDataByLabel("AUTHOR_TYPE");
            if (authorType != null && authorType.equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                log.debug((Object)"Random draw from questonpool");
                itemArrayList = publishedSectionData2.getItemArray();
                long seed = AgentFacade.getAgentString().hashCode();
                if (publishedSectionData2.getSectionMetaDataByLabel("RANDOMIZATION_TYPE") != null && publishedSectionData2.getSectionMetaDataByLabel("RANDOMIZATION_TYPE").equals("1")) {
                    seed = (assessmentGradingData.getAssessmentGradingId().toString() + "_" + publishedSectionData2.getSectionId().toString()).hashCode();
                }
                Collections.shuffle(itemArrayList, new Random(seed));
                Integer numberToBeDrawn = 0;
                if (publishedSectionData2.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    numberToBeDrawn = Integer.valueOf(publishedSectionData2.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                }
                int samplesize = numberToBeDrawn;
                for (int i = 0; i < samplesize; ++i) {
                    publishedItemData2 = (PublishedItemData)itemArrayList.get(i);
                    publishedItemId = publishedItemData2.getItemId();
                    log.debug((Object)("publishedItemId = " + publishedItemId));
                    if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                    this.saveItemGradingData(assessmentGradingData, publishedItemId);
                }
                continue;
            }
            log.debug((Object)"Not random draw from questonpool");
            itemArrayList = publishedSectionData2.getItemArray();
            for (PublishedItemData publishedItemData2 : itemArrayList) {
                publishedItemId = publishedItemData2.getItemId();
                log.debug((Object)("publishedItemId = " + publishedItemId));
                if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                this.saveItemGradingData(assessmentGradingData, publishedItemId);
            }
        }
    }

    private void saveItemGradingData(AssessmentGradingData assessmentGradingData, Long publishedItemId) {
        log.debug((Object)"Adding one ItemGradingData...");
        ItemGradingData itemGradingData = new ItemGradingData();
        itemGradingData.setAssessmentGradingId(assessmentGradingData.getAssessmentGradingId());
        itemGradingData.setAgentId(assessmentGradingData.getAgentId());
        itemGradingData.setPublishedItemId(publishedItemId);
        ItemService itemService = new ItemService();
        Long itemTextId = itemService.getItemTextId(publishedItemId);
        log.debug((Object)("itemTextId = " + itemTextId));
        if (itemTextId != -1L) {
            itemGradingData.setPublishedItemTextId(itemTextId);
            GradingService gradingService = new GradingService();
            gradingService.saveItemGrading((ItemGradingIfc)itemGradingData);
        }
    }

    @Override
    public Float getAverageSubmittedAssessmentGrading(final Long publishedAssessmentId, final String agentId) {
        Float averageScore = new Float(0.0);
        Object ag = null;
        String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by  a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by  a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentId);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (assessmentGradings.size() != 0) {
            AssessmentGradingData agd2 = null;
            Float cumulativeScore = new Float(0.0f);
            for (AssessmentGradingData agd2 : assessmentGradings) {
                cumulativeScore = Float.valueOf(cumulativeScore.floatValue() + agd2.getFinalScore().floatValue());
            }
            averageScore = Float.valueOf(cumulativeScore.floatValue() / (float)assessmentGradings.size());
            averageScore = new Float(new DecimalFormat("0.##").format(averageScore.floatValue()));
        }
        return averageScore;
    }

    @Override
    public List getHighestSubmittedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public HashMap getAverageAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    class EmptyItemGrading
    implements ItemGradingIfc {
        private Integer sectionSequence;
        private Long publishedItemId;
        private Integer itemSequence;

        EmptyItemGrading(Integer sectionSequence, Long publishedItemId, Integer itemSequence) {
            this.sectionSequence = sectionSequence;
            this.publishedItemId = publishedItemId;
            this.itemSequence = itemSequence;
        }

        public Integer getItemSequence() {
            return this.itemSequence;
        }

        public Integer getSectionSequence() {
            return this.sectionSequence;
        }

        public Long getItemGradingId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setItemGradingId(Long itemGradingId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Long getAssessmentGradingId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAssessmentGradingId(Long assessmentGradingId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Long getPublishedItemId() {
            return this.publishedItemId;
        }

        public void setPublishedItemId(Long publishedItemId) {
            this.publishedItemId = publishedItemId;
        }

        public Long getPublishedItemTextId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setPublishedItemTextId(Long publishedItemTextId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAgentId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAgentId(String agentId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setPublishedAnswerId(Long publishedAnswerId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Long getPublishedAnswerId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AnswerIfc getPublishedAnswer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setPublishedAnswer(AnswerIfc PublishedAnswer2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getRationale() {
            return null;
        }

        public void setRationale(String rationale) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAnswerText() {
            return " ";
        }

        public void setAnswerText(String answerText) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Date getSubmittedDate() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setSubmittedDate(Date submittedDate) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Float getAutoScore() {
            return Float.valueOf(0.0f);
        }

        public void setAutoScore(Float autoScore) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Float getOverrideScore() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setOverrideScore(Float overrideScore) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getComments() {
            return null;
        }

        public void setComments(String comments) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getGradedBy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setGradedBy(String gradedBy) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Date getGradedDate() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setGradedDate(Date gradedDate) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Boolean getReview() {
            return Boolean.FALSE;
        }

        public void setReview(Boolean review) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Integer getAttemptsRemaining() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttemptsRemaining(Integer attemptsRemaining) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set getItemGradingAttachmentSet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setItemGradingAttachmentSet(Set itemGradingAttachmentSet) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getItemGradingAttachmentList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class ItemComparator
    implements Comparator {
        ItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            PublishedItemData a = (PublishedItemData)o1;
            PublishedItemData b = (PublishedItemData)o2;
            if (a.getSection().getSequence() < b.getSection().getSequence()) {
                return -1;
            }
            if (a.getSection().getSequence() > b.getSection().getSequence()) {
                return 1;
            }
            return a.getSequence() - b.getSequence();
        }
    }

    class ResponsesComparator
    implements Comparator {
        boolean anonymous;

        public ResponsesComparator(boolean anony) {
            this.anonymous = anony;
        }

        public int compare(Object a, Object b) {
            String bThirdElement;
            String bSecondElement;
            String bFirstElement;
            if (this.anonymous) {
                Long bFirstElement2;
                Long aFirstElement = (Long)((ArrayList)a).get(0);
                if (aFirstElement.compareTo(bFirstElement2 = (Long)((ArrayList)b).get(0)) < 0) {
                    return -1;
                }
                if (aFirstElement.compareTo(bFirstElement2) > 0) {
                    return 1;
                }
                return 0;
            }
            String aFirstElement = (String)((ArrayList)a).get(0);
            if (aFirstElement.compareTo(bFirstElement = (String)((ArrayList)b).get(0)) < 0) {
                return -1;
            }
            if (aFirstElement.compareTo(bFirstElement) > 0) {
                return 1;
            }
            String aSecondElement = (String)((ArrayList)a).get(1);
            if (aSecondElement.compareTo(bSecondElement = (String)((ArrayList)b).get(1)) < 0) {
                return -1;
            }
            if (aSecondElement.compareTo(bSecondElement) > 0) {
                return 1;
            }
            String aThirdElement = (String)((ArrayList)a).get(2);
            if (aThirdElement.compareTo(bThirdElement = (String)((ArrayList)b).get(2)) < 0) {
                return -1;
            }
            if (aThirdElement.compareTo(bThirdElement) > 0) {
                return 1;
            }
            return 0;
        }
    }

    class QuestionComparator
    implements Comparator {
        HashMap publishedItemHash;

        public QuestionComparator(HashMap m) {
            this.publishedItemHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingIfc agrade = (ItemGradingIfc)((List)a).get(0);
            ItemGradingIfc bgrade = (ItemGradingIfc)((List)b).get(0);
            ItemDataIfc aitem = (ItemDataIfc)this.publishedItemHash.get(agrade.getPublishedItemId());
            ItemDataIfc bitem = (ItemDataIfc)this.publishedItemHash.get(bgrade.getPublishedItemId());
            Integer asectionseq = aitem.getSection().getSequence();
            Integer bsectionseq = bitem.getSection().getSequence();
            if (asectionseq < bsectionseq) {
                return -1;
            }
            if (asectionseq > bsectionseq) {
                return 1;
            }
            Integer aitemseq = aitem.getSequence();
            Integer bitemseq = bitem.getSequence();
            if (aitemseq < bitemseq) {
                return -1;
            }
            if (aitemseq > bitemseq) {
                return 1;
            }
            return 0;
        }
    }

    class AnswerComparator
    implements Comparator {
        HashMap publishedAnswerHash;

        public AnswerComparator(HashMap m) {
            this.publishedAnswerHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingIfc agrade = (ItemGradingIfc)a;
            ItemGradingIfc bgrade = (ItemGradingIfc)b;
            Long aindex = agrade.getItemGradingId();
            Long bindex = bgrade.getItemGradingId();
            Long aanswerid = agrade.getPublishedAnswerId();
            Long banswerid = bgrade.getPublishedAnswerId();
            if (aanswerid != null && banswerid != null) {
                AnswerIfc aanswer = (AnswerIfc)this.publishedAnswerHash.get(aanswerid);
                AnswerIfc banswer = (AnswerIfc)this.publishedAnswerHash.get(banswerid);
                if (aanswer == null || banswer == null) {
                    return 0;
                }
                if (aanswer == null) {
                    return -1;
                }
                aindex = aanswer.getSequence();
                if (banswer != null) {
                    bindex = banswer.getSequence();
                } else {
                    return 1;
                }
            }
            if (aindex < bindex) {
                return -1;
            }
            if (aindex > bindex) {
                return 1;
            }
            return 0;
        }
    }
}

