/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz;

import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.authz.FunctionData;
import org.sakaiproject.tool.assessment.data.ifc.authz.FunctionIfc;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;

public class FunctionFacade
implements FunctionIfc {
    private static final long serialVersionUID = 2610431044785097038L;
    private Id id;
    private String referenceName;
    private String description;
    private Type functionType;
    private FunctionIfc data;
    private long functionId;
    private String functionTypeId;
    private String displayName;

    public FunctionFacade() {
        this.data = new FunctionData();
    }

    public FunctionFacade(String referenceName, String displayName, String description, String functionTypeId) {
        this.data = new FunctionData();
        this.setReferenceName(referenceName);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setFunctionTypeId(functionTypeId);
    }

    public FunctionFacade(FunctionIfc data) {
        this.data = data;
        this.id = this.getId();
        this.referenceName = data.getDisplayName();
        this.description = data.getDescription();
        this.functionTypeId = data.getFunctionTypeId();
        this.functionType = this.getFunctionType();
        this.displayName = data.getDisplayName();
    }

    public Id getId() {
        return this.id;
    }

    public String getReferenceName() {
        return this.getDisplayName();
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
        this.setDisplayName(referenceName);
    }

    public Type getFunctionType() {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(new Long(this.data.getFunctionTypeId()));
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public void updateDescription(String description) {
        this.setDescription(description);
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public FunctionIfc getData() {
        return this.data;
    }

    public long getFunctionId() {
        return this.data.getFunctionId();
    }

    public void setFunctionId(long id) {
        this.functionId = id;
        this.data.setFunctionId(id);
    }

    public String getDisplayName() {
        return this.data.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.data.setDisplayName(displayName);
    }

    public String getFunctionTypeId() {
        return this.data.getFunctionTypeId();
    }

    public void setFunctionTypeId(String id) {
        this.functionTypeId = id;
        this.data.setFunctionTypeId(id);
    }
}

