/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.cover.SessionManager;

public class AutoSubmitAssessmentsJob
implements StatefulJob {
    private static final Log LOG = LogFactory.getLog(AutoSubmitAssessmentsJob.class);
    protected String serverName = "unknown";

    public void init() {
        LOG.debug((Object)"AutoSubmitAssessmentsJob init()  ");
    }

    public void destroy() {
        LOG.debug((Object)"AutoSubmitAssessmentsJob destroy()");
    }

    public void execute(JobExecutionContext jobInfo) throws JobExecutionException {
        this.loginToSakai("admin");
        String jobName = jobInfo.getJobDetail().getName();
        String triggerName = jobInfo.getTrigger().getName();
        Date requestedFire = jobInfo.getScheduledFireTime();
        Date actualfire = jobInfo.getFireTime();
        StringBuffer whoAmI = new StringBuffer("AutoSubmitAssessmentsJob $");
        whoAmI.append(" Job: ");
        whoAmI.append(jobName);
        whoAmI.append(" Trigger: ");
        whoAmI.append(triggerName);
        if (requestedFire != null) {
            whoAmI.append(" Fire scheduled: ");
            whoAmI.append(requestedFire.toString());
        }
        if (actualfire != null) {
            whoAmI.append(" Fire actual: ");
            whoAmI.append(actualfire.toString());
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job", (String)AutoSubmitAssessmentsJob.safeEventLength(whoAmI.toString()), (boolean)true));
        LOG.info((Object)("Start Job: " + whoAmI.toString()));
        GradingService gradingService = new GradingService();
        gradingService.autoSubmitAssessments();
        this.logoutFromSakai();
    }

    protected void loginToSakai(String whoAs) {
        this.serverName = ServerConfigurationService.getServerName();
        LOG.debug((Object)(" AutoSubmitAssessmentsJob Logging into Sakai on " + this.serverName + " as " + whoAs));
        UsageSession session = UsageSessionService.startSession((String)whoAs, (String)this.serverName, (String)"AutoSubmitAssessmentsJob");
        if (session == null) {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job.error", (String)(whoAs + " unable to log into " + this.serverName), (boolean)true));
            return;
        }
        Session sakaiSession = SessionManager.getCurrentSession();
        sakaiSession.setUserId(whoAs);
        sakaiSession.setUserEid(whoAs);
        AuthzGroupService.refreshUser((String)whoAs);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)UsageSessionService.EVENT_LOGIN, (String)(whoAs + " running " + this.serverName), (boolean)true));
    }

    protected void logoutFromSakai() {
        String serverName = ServerConfigurationService.getServerName();
        LOG.debug((Object)(" AutoSubmitAssessmentsJob Logging out of Sakai on " + serverName));
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)UsageSessionService.EVENT_LOGOUT, null, (boolean)true));
        UsageSessionService.logout();
    }

    public static final String safeEventLength(String target) {
        return target.length() > 255 ? target.substring(0, 255) : target;
    }
}

