/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.EntityTransferrerRefMigrator;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssessmentEntityProducer
implements EntityTransferrer,
EntityProducer,
EntityTransferrerRefMigrator {
    private static Log log = LogFactory.getLog(AssessmentEntityProducer.class);

    public void init() {
        log.info((Object)"init()");
        try {
            EntityManager.registerEntityProducer((EntityProducer)this, (String)"/samigo");
        }
        catch (Exception e) {
            log.warn((Object)"Error registering Samigo Entity Producer", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{"sakai.samigo"};
        return toolIds;
    }

    public void transferCopyEntities(String fromContext, String toContext, List resourceIds) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, resourceIds);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List resourceIds) {
        AssessmentService service = new AssessmentService();
        service.copyAllAssessments(fromContext, toContext);
        return null;
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        return null;
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String getLabel() {
        return "samigo";
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        return false;
    }

    public boolean willArchiveMerge() {
        return false;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids, cleanup);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List ids, boolean cleanup) {
        try {
            if (cleanup) {
                log.debug((Object)("deleting assessments from " + toContext));
                AssessmentService service = new AssessmentService();
                List assessmentList = service.getAllActiveAssessmentsbyAgent(toContext);
                log.debug((Object)("found " + assessmentList.size() + " assessments in site: " + toContext));
                for (AssessmentData oneassessment : assessmentList) {
                    log.debug((Object)("removing assessemnt id = " + oneassessment.getAssessmentId()));
                    service.removeAssessment(oneassessment.getAssessmentId().toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)"transferCopyEntities: End removing Assessment data");
        }
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids);
        return null;
    }

    public void updateEntityReferences(String toContext, Map<String, String> transversalMap) {
        if (transversalMap != null && transversalMap.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = transversalMap.entrySet();
            AssessmentService service = new AssessmentService();
            List assessmentList = service.getAllActiveAssessmentsbyAgent(toContext);
            for (AssessmentData assessment : assessmentList) {
                AssessmentFacade assessmentFacade = (AssessmentFacade)service.getAssessment(assessment.getAssessmentId());
                boolean needToUpdate = false;
                String assessmentDesc = assessmentFacade.getDescription();
                if (assessmentDesc != null && !(assessmentDesc = this.replaceAllRefs(assessmentDesc, entrySet)).equals(assessmentFacade.getDescription())) {
                    needToUpdate = true;
                    assessmentFacade.setDescription(assessmentDesc);
                }
                ArrayList sectionList = assessmentFacade.getSectionArray();
                for (int i = 0; i < sectionList.size(); ++i) {
                    SectionFacade section = (SectionFacade)sectionList.get(i);
                    String sectionDesc = section.getDescription();
                    if (sectionDesc != null && !(sectionDesc = this.replaceAllRefs(sectionDesc, entrySet)).equals(section.getDescription())) {
                        needToUpdate = true;
                        section.setDescription(sectionDesc);
                    }
                    ArrayList itemList = section.getItemArray();
                    for (int j = 0; j < itemList.size(); ++j) {
                        ArrayList itemTextList;
                        String itemDesc;
                        ItemData item = (ItemData)itemList.get(j);
                        String itemIntr = item.getInstruction();
                        if (itemIntr != null && !(itemIntr = this.replaceAllRefs(itemIntr, entrySet)).equals(item.getInstruction())) {
                            needToUpdate = true;
                            item.setInstruction(itemIntr);
                        }
                        if ((itemDesc = item.getDescription()) != null && !(itemDesc = this.replaceAllRefs(itemDesc, entrySet)).equals(item.getDescription())) {
                            needToUpdate = true;
                            item.setDescription(itemDesc);
                        }
                        if ((itemTextList = item.getItemTextArray()) == null) continue;
                        for (int k = 0; k < itemTextList.size(); ++k) {
                            ItemText itemText = (ItemText)itemTextList.get(k);
                            String text = itemText.getText();
                            if (text == null || (text = this.replaceAllRefs(text, entrySet)).equals(itemText.getText())) continue;
                            needToUpdate = true;
                            itemText.setText(text);
                        }
                    }
                }
                if (!needToUpdate) continue;
                service.saveAssessment(assessmentFacade);
            }
        }
    }

    private String replaceAllRefs(String msgBody, Set<Map.Entry<String, String>> entrySet) {
        if (msgBody != null) {
            for (Map.Entry<String, String> entry : entrySet) {
                String fromContextRef = entry.getKey();
                if (!msgBody.contains(fromContextRef)) continue;
                msgBody = msgBody.replace(fromContextRef, entry.getValue());
            }
        }
        return msgBody;
    }
}

