/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.business.entity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sakaiproject.tool.assessment.business.entity.FileNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordingData
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RecordingData.class);
    private static final long serialVersionUID = 4398684269227144959L;
    private String agentName;
    private String agentId;
    private String courseAssignmentContext;
    private String fileExtension;
    private String fileName;
    private String limit;
    private String dir;
    private String seconds;
    private String appName;
    private String imageURL;

    public RecordingData(String agent_name, String agent_id, String course_assignment_context, String lim, String sec) {
        this.agentName = agent_name;
        this.agentId = agent_id;
        this.courseAssignmentContext = course_assignment_context;
        this.courseAssignmentContext = this.cleanOutQuotes(this.courseAssignmentContext);
        this.limit = lim;
        this.seconds = sec;
        this.initDefaults();
    }

    private String cleanOutQuotes(String s) {
        StringTokenizer st = new StringTokenizer(s, "\"'");
        StringBuilder cleanSbuf = new StringBuilder();
        while (st.hasMoreTokens()) {
            cleanSbuf.append(st.nextToken());
        }
        String cleanS = cleanSbuf.toString();
        return cleanS;
    }

    private void initDefaults() {
        this.fileExtension = "au";
        this.fileName = FileNamer.make(this.agentName, this.agentId, this.courseAssignmentContext);
        if (this.limit == null) {
            this.limit = "0";
        }
        if (this.seconds == null) {
            this.seconds = "30";
        }
        this.dir = "/".equals(File.separator) ? "/tmp" : "c:\\tmp";
        this.appName = "Audio Recording";
        this.imageURL = "/samigo-app/jsp/aam/images/";
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getCourseAssignmentContext() {
        return this.courseAssignmentContext;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getDir() {
        return this.dir;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setAgentName(String s) {
        this.agentName = s;
    }

    public void setAgentId(String s) {
        this.agentId = s;
    }

    public void setCourseAssignmentContext(String s) {
        this.courseAssignmentContext = s;
    }

    public void setFileExtension(String s) {
        this.fileExtension = s;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public void setLimit(String s) {
        this.limit = s;
    }

    public void setDir(String s) {
        this.dir = s;
    }

    public void setSeconds(String s) {
        this.seconds = s;
    }

    public void setAppName(String s) {
        this.appName = s;
    }

    public void setImageURL(String s) {
        this.imageURL = s;
    }

    public Document getXMLDataModel() {
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (document == null) {
            log.error("document is null");
            return null;
        }
        Element recordingData = document.createElement("RecordingData");
        Element agentName = document.createElement("AgentName");
        Element agentId = document.createElement("AgentId");
        Element courseAssignmentContext = document.createElement("CourseAssignmentContext");
        Element fileExtension = document.createElement("FileExtension");
        Element fileName = document.createElement("FileName");
        Element limit = document.createElement("Limit");
        Element dir = document.createElement("Dir");
        Element seconds = document.createElement("Seconds");
        Element appName = document.createElement("AppName");
        Element imageURL = document.createElement("ImageURL");
        agentName.appendChild(document.createTextNode(this.getAgentName()));
        agentId.appendChild(document.createTextNode(this.getAgentId()));
        courseAssignmentContext.appendChild(document.createTextNode(this.getCourseAssignmentContext()));
        fileExtension.appendChild(document.createTextNode(this.getFileExtension()));
        fileName.appendChild(document.createTextNode(this.getFileName()));
        limit.appendChild(document.createTextNode(this.getLimit()));
        dir.appendChild(document.createTextNode(this.getDir()));
        seconds.appendChild(document.createTextNode(this.getSeconds()));
        appName.appendChild(document.createTextNode(this.getAppName()));
        imageURL.appendChild(document.createTextNode(this.getImageURL()));
        recordingData.appendChild(agentName);
        recordingData.appendChild(agentId);
        recordingData.appendChild(courseAssignmentContext);
        recordingData.appendChild(fileExtension);
        recordingData.appendChild(fileName);
        recordingData.appendChild(limit);
        recordingData.appendChild(dir);
        recordingData.appendChild(seconds);
        recordingData.appendChild(appName);
        recordingData.appendChild(imageURL);
        document.appendChild(recordingData);
        return document;
    }

    public static void unitTest() {
        RecordingData rd = new RecordingData("Ed Smiley", "esmiley", "Intro to Wombats 101", "10", "30");
        log.debug("esmiley file:" + rd.getFileName() + "." + rd.getFileExtension());
        log.debug("limit =" + rd.getLimit());
        log.debug("seconds=" + rd.getSeconds());
        rd = new RecordingData("Rachel Gollub", "rgollub", "Rachel's Intro to Wolverines and Aardvarks 221B", "10", "25");
        log.debug("rgollub file:" + rd.getFileName() + "." + rd.getFileExtension());
        log.debug("limit =" + rd.getLimit());
        log.debug("seconds=" + rd.getSeconds());
        rd = new RecordingData("Rachel Gollub", "rgollub", "Intro to Wolverines and Aardvarks 221B", "10", "25");
        log.debug("rgollub file:" + rd.getFileName() + "." + rd.getFileExtension());
        log.debug("limit =" + rd.getLimit());
        log.debug("seconds=" + rd.getSeconds());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(rd.getXMLDataModel());
        StreamResult outputTarget = new StreamResult(out);
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            log.debug("cannot serialize" + e);
        }
        rd = new RecordingData(null, null, null, null, null);
        log.debug("NULL file: " + rd.getFileName() + "." + rd.getFileExtension());
        log.debug("limit =" + rd.getLimit());
        log.debug("seconds=" + rd.getSeconds());
        rd = new RecordingData(null, null, null, null, null);
        log.debug("NULL file: " + rd.getFileName() + "." + rd.getFileExtension());
        log.debug("limit =" + rd.getLimit());
        log.debug("seconds=" + rd.getSeconds());
    }

    public static void main(String[] args) {
        RecordingData.unitTest();
    }
}

