/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.elfinder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.elfinder.FsType;
import org.sakaiproject.elfinder.ReadOnlyFsVolume;
import org.sakaiproject.elfinder.SakaiFsItem;
import org.sakaiproject.elfinder.SakaiFsService;
import org.sakaiproject.elfinder.SakaiFsVolume;
import org.sakaiproject.elfinder.ToolFsVolume;
import org.sakaiproject.elfinder.ToolFsVolumeFactory;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentToolFsVolumeFactory
implements ToolFsVolumeFactory {
    private static final Logger log = LoggerFactory.getLogger(AssessmentToolFsVolumeFactory.class);
    private PublishedAssessmentService publishedAssessmentService;
    private SakaiFsService sakaiFsService;
    private ServerConfigurationService serverConfigurationService;

    public void init() {
        this.publishedAssessmentService = new PublishedAssessmentService();
        this.sakaiFsService.registerToolVolume((ToolFsVolumeFactory)this);
    }

    public String getPrefix() {
        return FsType.ASSESSMENT.toString();
    }

    public ToolFsVolume getVolume(String siteId) {
        return new AssessmentToolFsVolume(this.sakaiFsService, siteId);
    }

    public String getToolId() {
        return "sakai.samigo";
    }

    public void setSakaiFsService(SakaiFsService sakaiFsService) {
        this.sakaiFsService = sakaiFsService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public class AssessmentToolFsVolume
    extends ReadOnlyFsVolume
    implements ToolFsVolume {
        public static final String ASSESSMENT_URL_PREFIX = "/samigo-app/servlet/Login?id=";
        private SakaiFsService service;
        private String siteId;

        public AssessmentToolFsVolume(SakaiFsService service, String siteId) {
            this.service = service;
            this.siteId = siteId;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public ToolFsVolumeFactory getToolVolumeFactory() {
            return AssessmentToolFsVolumeFactory.this;
        }

        public boolean isWriteable(SakaiFsItem item) {
            return false;
        }

        public boolean exists(SakaiFsItem newFile) {
            return false;
        }

        public SakaiFsItem fromPath(String relativePath) {
            String[] parts;
            log.debug("relativePath = {}", (Object)relativePath);
            if (StringUtils.isNotBlank((CharSequence)relativePath) && (parts = relativePath.split("/")).length == 2 && parts[0].equals(this.siteId)) {
                log.debug("parts[1]=" + parts[1]);
                log.debug("parts[0]=" + parts[0]);
                PublishedAssessmentFacade assessment = AssessmentToolFsVolumeFactory.this.publishedAssessmentService.getPublishedAssessment(parts[1]);
                return new SakaiFsItem(assessment.getPublishedAssessmentId().toString(), assessment.getTitle(), (SakaiFsVolume)this, FsType.ASSESSMENT);
            }
            return this.getRoot();
        }

        public String getDimensions(SakaiFsItem fsi) {
            return null;
        }

        public long getLastModified(SakaiFsItem fsi) {
            return 0L;
        }

        public String getMimeType(SakaiFsItem fsi) {
            return this.isFolder(fsi) ? "directory" : "sakai/assessments";
        }

        public String getName() {
            return "Tests & Quizzes";
        }

        public String getName(SakaiFsItem fsi) {
            if (this.getRoot().equals((Object)fsi)) {
                return this.getName();
            }
            if (FsType.ASSESSMENT.equals((Object)fsi.getType())) {
                return fsi.getTitle();
            }
            throw new IllegalArgumentException("Could not get title for: " + fsi.toString());
        }

        public SakaiFsItem getParent(SakaiFsItem fsi) {
            if (this.getRoot().equals((Object)fsi)) {
                return this.service.getSiteVolume(this.siteId).getRoot();
            }
            if (FsType.ASSESSMENT.equals((Object)fsi.getType())) {
                return this.getRoot();
            }
            return null;
        }

        public String getPath(SakaiFsItem fsi) throws IOException {
            if (this.getRoot().equals((Object)fsi)) {
                return "/" + AssessmentToolFsVolumeFactory.this.getPrefix() + "/" + this.siteId;
            }
            if (FsType.ASSESSMENT.equals((Object)fsi.getType())) {
                PublishedAssessmentFacade assessment = AssessmentToolFsVolumeFactory.this.publishedAssessmentService.getPublishedAssessment(fsi.getId());
                String alias = assessment.getAssessmentMetaDataByLabel("ALIAS");
                String path = "/" + AssessmentToolFsVolumeFactory.this.getPrefix() + "/" + this.siteId + "/" + alias;
                log.debug("getPath returns = {}", (Object)path);
                return path;
            }
            throw new IllegalArgumentException("Wrong type: " + fsi);
        }

        public SakaiFsItem getRoot() {
            return new SakaiFsItem("", "", (SakaiFsVolume)this, FsType.ASSESSMENT);
        }

        public long getSize(SakaiFsItem fsi) throws IOException {
            return 0L;
        }

        public String getThumbnailFileName(SakaiFsItem fsi) {
            return null;
        }

        public boolean hasChildFolder(SakaiFsItem fsi) {
            return false;
        }

        public boolean isFolder(SakaiFsItem fsi) {
            return FsType.ASSESSMENT.equals((Object)fsi.getType()) && fsi.getId().equals("");
        }

        public boolean isRoot(SakaiFsItem fsi) {
            return false;
        }

        public SakaiFsItem[] listChildren(SakaiFsItem fsi) throws PermissionException {
            ArrayList<SakaiFsItem> items = new ArrayList<SakaiFsItem>();
            if (this.getRoot().equals((Object)fsi)) {
                List<PublishedAssessmentFacade> assessments = AssessmentToolFsVolumeFactory.this.publishedAssessmentService.getBasicInfoOfAllPublishedAssessments("", "title", true, this.siteId);
                for (PublishedAssessmentFacade assessment : assessments) {
                    PublishedAssessmentFacade pAssessment = AssessmentToolFsVolumeFactory.this.publishedAssessmentService.getPublishedAssessment(assessment.getPublishedAssessmentId().toString());
                    SakaiFsItem fsItem = new SakaiFsItem(pAssessment.getPublishedAssessmentId().toString(), pAssessment.getTitle(), (SakaiFsVolume)this, FsType.ASSESSMENT);
                    log.debug("listing children {}", (Object)fsItem.getId());
                    items.add(fsItem);
                }
            } else if (FsType.ASSESSMENT.equals((Object)fsi.getType())) {
                items.add(fsi);
            }
            return items.toArray(new SakaiFsItem[0]);
        }

        public InputStream openInputStream(SakaiFsItem fsi) throws IOException {
            return null;
        }

        public String getURL(SakaiFsItem fsi) {
            String serverUrlPrefix = AssessmentToolFsVolumeFactory.this.serverConfigurationService.getServerUrl();
            if (FsType.ASSESSMENT.equals((Object)fsi.getType()) && StringUtils.isNotBlank((CharSequence)fsi.getId())) {
                PublishedAssessmentFacade assessment = AssessmentToolFsVolumeFactory.this.publishedAssessmentService.getPublishedAssessment(fsi.getId());
                String alias = assessment.getAssessmentMetaDataByLabel("ALIAS");
                return serverUrlPrefix + ASSESSMENT_URL_PREFIX + alias;
            }
            return null;
        }
    }
}

