/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.entity.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTag;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.entity.api.PublishedItemEntityProvider;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedItemEntityProviderImpl
implements PublishedItemEntityProvider,
CoreEntityProvider,
AutoRegisterEntityProvider {
    private static final Logger log = LoggerFactory.getLogger(PublishedItemEntityProviderImpl.class);
    private PublishedItemFacadeQueriesAPI publishedItemFacadeQueries;
    private PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries;
    private DeveloperHelperService developerHelperService;
    private SiteService siteService;
    private AssessmentService assessmentService = new AssessmentService();
    public static final String ENTITY_PREFIX = "sam_publisheditem";

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public boolean entityExists(String ref) {
        try {
            String itemId = this.getItemIdFromOriginalReference(ref);
            return this.publishedItemFacadeQueries.itemExists(itemId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object getEntity(EntityReference ref) {
        try {
            if (this.entityExists(ref.getOriginalReference())) {
                String itemId = this.getItemIdFromOriginalReference(ref.getOriginalReference());
                PublishedItemFacade item = this.publishedItemFacadeQueries.getItem(itemId);
                return item;
            }
            return null;
        }
        catch (Exception e) {
            log.warn("No entity found: " + ref);
            return null;
        }
    }

    private String getItemIdFromOriginalReference(String originalReference) {
        if (originalReference.contains("/sam_publisheditem/")) {
            return originalReference.substring(originalReference.indexOf("/sam_publisheditem/") + 19);
        }
        if (originalReference.contains(" publishedItemId=")) {
            return originalReference.substring(originalReference.indexOf(" publishedItemId=") + 17);
        }
        return originalReference;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        return props;
    }

    public List<String> siteIds(PublishedItemFacade item) {
        Long assessmentId = this.publishedItemFacadeQueries.getPublishedAssessmentId(item.getItemId());
        ArrayList<String> siteIds = new ArrayList<String>();
        String siteId = null;
        if (assessmentId > 0L) {
            siteId = this.publishedAssessmentFacadeQueries.getPublishedAssessmentOwner(Long.toString(assessmentId));
        }
        if (siteId != null) {
            siteIds.add(siteId);
        }
        return siteIds;
    }

    public String assessmentId(PublishedItemFacade item) {
        Long assessmentId = this.publishedItemFacadeQueries.getPublishedAssessmentId(item.getItemId());
        if (assessmentId > 0L) {
            return Long.toString(assessmentId);
        }
        return null;
    }

    public List<String> tags(PublishedItemFacade item) {
        ArrayList<String> tags = new ArrayList<String>();
        String itemId = item.getItemIdString();
        Set itemTagSet = item.getItemTagSet();
        for (PublishedItemTag tag : itemTagSet) {
            if (tags.contains(tag.getTagLabel())) continue;
            tags.add(tag.getTagLabel() + "(" + tag.getTagCollectionName() + ")");
        }
        return tags;
    }

    public String content(PublishedItemFacade item) {
        Object content = "";
        if (item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
            if (!StringUtils.isEmpty((CharSequence)item.getThemeText())) {
                content = (String)content + item.getThemeText();
            }
            if (!StringUtils.isEmpty((CharSequence)item.getLeadInText())) {
                content = (String)content + this.separator((String)content) + item.getLeadInText();
            }
        } else if (!StringUtils.isEmpty((CharSequence)item.getInstruction())) {
            content = (String)content + item.getInstruction();
        }
        if (!StringUtils.isEmpty((CharSequence)item.getDescription())) {
            content = (String)content + this.separator((String)content) + item.getDescription();
        }
        if (item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
            if (item.getIsAnswerOptionsSimple()) {
                List emiAnswerOptions = item.getEmiAnswerOptions();
                for (AnswerIfc answerIfc : emiAnswerOptions) {
                    if (StringUtils.isEmpty((CharSequence)answerIfc.getText())) continue;
                    content = (String)content + this.separator((String)content) + answerIfc.getText();
                }
            }
            if (item.getIsAnswerOptionsRich() && !StringUtils.isEmpty((CharSequence)item.getEmiAnswerOptionsRichText())) {
                content = (String)content + this.separator((String)content) + item.getEmiAnswerOptionsRichText();
            }
            List itemTextIfcs = item.getEmiQuestionAnswerCombinations();
            for (ItemTextIfc itemTextIfc : itemTextIfcs) {
                if (StringUtils.isEmpty((CharSequence)itemTextIfc.getText())) continue;
                content = (String)content + this.separator((String)content) + itemTextIfc.getText();
            }
        } else {
            ArrayList itemTextArraySorted = item.getItemTextArraySorted();
            for (ItemTextIfc itemTextIfc : itemTextArraySorted) {
                if (!item.getTypeId().equals(TypeIfc.CALCULATED_QUESTION) && !StringUtils.isEmpty((CharSequence)itemTextIfc.getText())) {
                    content = (String)content + this.separator((String)content) + itemTextIfc.getText();
                }
                if (!item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) && !item.getTypeId().equals(TypeIfc.FILL_IN_BLANK) && !item.getTypeId().equals(TypeIfc.MATCHING) && !item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC) && !item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) && !item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY) && !item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) continue;
                List answerArraySorted = itemTextIfc.getAnswerArraySorted();
                for (AnswerIfc answerIfc : answerArraySorted) {
                    if (StringUtils.isEmpty((CharSequence)answerIfc.getText()) || item.getTypeId().equals(TypeIfc.MATCHING) && !answerIfc.getIsCorrect().booleanValue()) continue;
                    content = (String)content + this.separator((String)content) + answerIfc.getText();
                }
            }
        }
        log.debug("This is the questions content: " + (String)content);
        return content;
    }

    public String separator(String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            return ". ";
        }
        return "";
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"json"};
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public PublishedItemFacadeQueriesAPI getPublishedItemFacadeQueries() {
        return this.publishedItemFacadeQueries;
    }

    public void setPublishedItemFacadeQueries(PublishedItemFacadeQueriesAPI publishedItemFacadeQueries) {
        this.publishedItemFacadeQueries = publishedItemFacadeQueries;
    }

    public PublishedAssessmentFacadeQueriesAPI getPublishedAssessmentFacadeQueries() {
        return this.publishedAssessmentFacadeQueries;
    }

    public void setPublishedAssessmentFacadeQueries(PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries) {
        this.publishedAssessmentFacadeQueries = publishedAssessmentFacadeQueries;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

