/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.grading.api.GradingService;
import org.sakaiproject.rubrics.api.RubricsService;
import org.sakaiproject.rubrics.api.model.ToolItemRubricAssociation;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentTemplateIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.util.PagingUtilQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateQueryException;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.web.client.HttpClientErrorException;

public class AssessmentFacadeQueries
extends HibernateDaoSupport
implements AssessmentFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(AssessmentFacadeQueries.class);
    public static final String TITLE = "title";

    @Override
    public IdImpl getId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(long id) {
        return new IdImpl(id);
    }

    @Override
    public Long addTemplate() {
        AssessmentTemplateData assessmentTemplate = new AssessmentTemplateData(Long.valueOf(0L), TITLE, "description", "comments", TypeD.HOMEWORK, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "1", new Date(), "1", new Date());
        AssessmentAccessControl s = new AssessmentAccessControl(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), new Date(), new Date(), new Date(), new Date(), new Date(), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "Thanks for submitting", "anonymous");
        s.setAssessmentBase((AssessmentBaseIfc)assessmentTemplate);
        assessmentTemplate.setAssessmentAccessControl((AssessmentAccessControlIfc)s);
        assessmentTemplate.addAssessmentMetaData("ASSESSMENTTEMPLATE_OBJECTIVES", " assesmentT: the objective is to ...");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessmentTemplate);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return assessmentTemplate.getAssessmentTemplateId();
    }

    @Override
    public void removeTemplate(Long assessmentId) {
        AssessmentTemplateData assessment = (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public Long addAssessment(Long assessmentTemplateId) {
        AssessmentData assessment = new AssessmentData(Long.valueOf(0L), "assessment title", "assessment description", "assessment acomments", assessmentTemplateId, TypeD.HOMEWORK, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "1", new Date(), "1", new Date());
        AssessmentAccessControl s = new AssessmentAccessControl(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), new Date(), new Date(), new Date(), new Date(), new Date(), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "Thanks for submitting", "anonymous");
        s.setAssessmentBase((AssessmentBaseIfc)assessment);
        assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)s);
        assessment.addAssessmentMetaData("ASSESSMENT_OBJECTIVES", " assesment: the objective is to ...");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return assessment.getAssessmentId();
    }

    @Override
    public AssessmentBaseData load(Long id) {
        AssessmentBaseData a = (AssessmentBaseData)this.getHibernateTemplate().load(AssessmentBaseData.class, (Serializable)id);
        if (a.getIsTemplate().equals(Boolean.TRUE)) {
            return (AssessmentTemplateData)a;
        }
        return (AssessmentData)a;
    }

    @Override
    public AssessmentTemplateData loadTemplate(Long assessmentTemplateId) {
        return (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentTemplateId);
    }

    @Override
    public AssessmentData loadAssessment(Long assessmentId) {
        return (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
    }

    @Override
    public AssessmentTemplateFacade getAssessmentTemplate(Long assessmentTemplateId) {
        AssessmentTemplateData template = (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentTemplateId);
        return new AssessmentTemplateFacade((AssessmentTemplateIfc)template);
    }

    @Override
    public List<AssessmentTemplateFacade> getAllAssessmentTemplates() {
        String agent = AgentFacade.getAgentString();
        Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.assessmentBaseId = :id or a.createdBy = :agent or a.typeId = :type order by a.title");
            q.setParameter("id", (Object)1L);
            q.setParameter("agent", (Object)agent);
            q.setParameter("type", (Object)typeId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (AssessmentTemplateData a : list) {
            AssessmentTemplateFacade f = new AssessmentTemplateFacade((AssessmentTemplateIfc)a);
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public List<AssessmentTemplateFacade> getAllActiveAssessmentTemplates() {
        String agent = AgentFacade.getAgentString();
        Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.status = :status and (a.assessmentBaseId = :id or a.createdBy = :agent or a.typeId = :type) order by a.title");
            q.setParameter("status", (Object)1);
            q.setParameter("id", (Object)1L);
            q.setParameter("agent", (Object)agent);
            q.setParameter("type", (Object)typeId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (AssessmentTemplateData a : list) {
            AssessmentTemplateFacade f = new AssessmentTemplateFacade((AssessmentTemplateIfc)a);
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public List<AssessmentTemplateFacade> getTitleOfAllActiveAssessmentTemplates() {
        String agent = AgentFacade.getAgentString();
        Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title)  from AssessmentTemplateData a where a.status = :status and  (a.assessmentBaseId = :id or a.createdBy = :agent or typeId = :type) order by a.title");
            q.setParameter("status", (Object)1);
            q.setParameter("id", (Object)1L);
            q.setParameter("agent", (Object)agent);
            q.setParameter("type", (Object)typeId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (AssessmentTemplateData a : list) {
            a.setAssessmentTemplateId(a.getAssessmentBaseId());
            AssessmentTemplateFacade f = new AssessmentTemplateFacade(a.getAssessmentBaseId(), a.getTitle());
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public AssessmentFacade getAssessment(Long assessmentId) {
        try {
            AssessmentData assessment = (AssessmentData)this.getHibernateTemplate().get(AssessmentData.class, (Serializable)assessmentId);
            if (assessment != null) {
                assessment.setSectionSet(this.getSectionSetForAssessment(assessment));
                return new AssessmentFacade((AssessmentIfc)assessment);
            }
        }
        catch (DataAccessException dae) {
            log.warn("Could not retrieve assessment: {}", (Object)assessmentId, (Object)dae);
        }
        return null;
    }

    private Set<SectionData> getSectionSetForAssessment(AssessmentData assessment) {
        List sectionList = this.getHibernateTemplate().findByNamedParam("from SectionData s where s.assessment.assessmentBaseId = :id", "id", (Object)assessment.getAssessmentBaseId());
        Hibernate.initialize((Object)sectionList);
        return new HashSet<SectionData>(sectionList);
    }

    @Override
    public void removeAssessment(Long assessmentId) {
        List count = this.getHibernateTemplate().findByNamedParam("select count(p) from PublishedAssessmentData p where p.assessmentId = :id", "id", (Object)assessmentId);
        log.debug("removeAssesment: no. of pub Assessment = {}", (Object)count.size());
        Iterator iter = count.iterator();
        int i = ((Long)iter.next()).intValue();
        AssessmentData assessment = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
        RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
        rubricsService.softDeleteRubricAssociationsByItemIdPrefix(assessmentId + ".", "sakai.samigo");
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        assessment.setStatus(AssessmentIfc.DEAD_STATUS);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating asssessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public AssessmentData cloneAssessmentFromTemplate(AssessmentTemplateData t) {
        AssessmentData assessment = new AssessmentData(t.getParentId(), "Assessment created with" + t.getTitle(), t.getDescription(), t.getComments(), t.getAssessmentTemplateId(), TypeD.HOMEWORK, t.getInstructorNotification(), t.getTesteeNotification(), t.getMultipartAllowed(), t.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        try {
            EvaluationModel evalOrig;
            AssessmentFeedback feedbackOrig;
            AssessmentAccessControl controlOrig = (AssessmentAccessControl)t.getAssessmentAccessControl();
            if (controlOrig != null) {
                AssessmentAccessControl control = (AssessmentAccessControl)controlOrig.clone();
                control.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)control);
            }
            if ((feedbackOrig = (AssessmentFeedback)t.getAssessmentFeedback()) != null) {
                AssessmentFeedback feedback = (AssessmentFeedback)feedbackOrig.clone();
                feedback.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
            }
            if ((evalOrig = (EvaluationModel)t.getEvaluationModel()) != null) {
                EvaluationModel eval = (EvaluationModel)evalOrig.clone();
                eval.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setEvaluationModel((EvaluationModelIfc)eval);
            }
            HashSet<AssessmentMetaData> h = new HashSet<AssessmentMetaData>();
            Set s = t.getAssessmentMetaDataSet();
            for (AssessmentMetaData mOrig : s) {
                if (mOrig.getLabel() == null) continue;
                AssessmentMetaData m = new AssessmentMetaData((AssessmentBaseIfc)assessment, mOrig.getLabel(), mOrig.getEntry());
                h.add(m);
            }
            assessment.setAssessmentMetaDataSet(h);
            HashSet<SectionData> sh = new HashSet<SectionData>();
            SectionData section = new SectionData(null, new Integer("1"), "Default", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
            section.setAssessment((AssessmentIfc)assessment);
            section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
            section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
            sh.add(section);
            assessment.setSectionSet(sh);
        }
        catch (CloneNotSupportedException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return assessment;
    }

    @Override
    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, Long typeId, Long templateId) throws Exception {
        return this.createAssessmentWithoutDefaultSection(title, description, typeId, templateId, null);
    }

    @Override
    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentData assessment = null;
        try {
            assessment = this.prepareAssessment(title, description, typeId, templateId, siteId);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        assessment.setSectionSet(new HashSet());
        this.getHibernateTemplate().save((Object)assessment);
        this.registerWithSite(assessment.getAssessmentId().toString(), siteId);
        return new AssessmentFacade((AssessmentIfc)assessment);
    }

    private AssessmentData prepareAssessment(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentTemplateFacade template = this.getAssessmentTemplate(templateId);
        AssessmentData assessment = this.cloneAssessmentFromTemplate((AssessmentTemplateData)template.getData());
        assessment.setTitle(title);
        assessment.setDescription(description);
        assessment.setTypeId(typeId);
        AssessmentAccessControl control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
        if (control == null) {
            control = new AssessmentAccessControl();
        }
        control.setTimedAssessment(Integer.valueOf(0));
        control.setTimeLimit(Integer.valueOf(0));
        String defaultReleaseTo = template.getAssessmentMetaDataByLabel("releaseTo");
        if ("ANONYMOUS_USERS".equals(defaultReleaseTo)) {
            control.setReleaseTo("Anonymous Users");
        } else if (siteId == null || siteId.length() == 0) {
            control.setReleaseTo(AgentFacade.getCurrentSiteName());
        } else {
            control.setReleaseTo(AgentFacade.getSiteName(siteId));
        }
        EvaluationModel evaluation = (EvaluationModel)assessment.getEvaluationModel();
        if (evaluation == null) {
            evaluation = new EvaluationModel();
        }
        GradingService g = null;
        boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
        try {
            if (integrated) {
                g = (GradingService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.grading.api.GradingService");
            }
            GradebookServiceHelper gradebookServiceHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
        }
        catch (HibernateQueryException e) {
            log.warn("Gradebook Error: " + e.getMessage());
            evaluation.setToGradeBook(EvaluationModelIfc.GRADEBOOK_NOT_AVAILABLE.toString());
            throw new Exception(e);
        }
        return assessment;
    }

    @Override
    public AssessmentFacade createAssessment(String title, String description, Long typeId, Long templateId) throws Exception {
        return this.createAssessment(title, description, typeId, templateId, null);
    }

    @Override
    public AssessmentFacade createAssessment(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentData assessment = null;
        try {
            assessment = this.prepareAssessment(title, description, typeId, templateId, siteId);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        this.registerWithSite(assessment.getAssessmentId().toString(), siteId);
        return new AssessmentFacade((AssessmentIfc)assessment);
    }

    private void registerWithSite(String qualifierIdString, String siteId) {
        if (siteId == null || siteId.length() == 0) {
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "EDIT_ASSESSMENT", qualifierIdString);
        } else {
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(siteId, "EDIT_ASSESSMENT", qualifierIdString);
        }
    }

    private void registerWithCurrentSite(String qualifierIdString) {
        this.registerWithSite(qualifierIdString, null);
    }

    @Override
    public List<AssessmentFacade> getAllAssessments(String orderBy) {
        List list = this.getHibernateTemplate().find("from AssessmentData a order by a." + orderBy, new Object[0]);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : list) {
            assessmentList.add(new AssessmentFacade((AssessmentIfc)a));
        }
        return assessmentList;
    }

    @Override
    public List<AssessmentFacade> getAllActiveAssessments(String orderBy) {
        List list = this.getHibernateTemplate().findByNamedParam("from AssessmentData a where a.status = :status order by a." + orderBy, "status", (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : list) {
            a.setSectionSet(this.getSectionSetForAssessment(a));
            AssessmentFacade f = new AssessmentFacade((AssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public List<AssessmentFacade> getBasicInfoOfAllActiveAssessments(String orderBy, boolean ascending) {
        String query = "select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)from AssessmentData a where a.status = :status order by a." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        List list = this.getHibernateTemplate().findByNamedParam(query, "status", (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : list) {
            assessmentList.add(new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate()));
        }
        return assessmentList;
    }

    @Override
    public List<AssessmentFacade> getBasicInfoOfAllActiveAssessmentsByAgent(String orderBy, String siteAgentId, boolean ascending) {
        StringBuilder sb = new StringBuilder("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.lastModifiedBy, ac.startDate, ac.dueDate, ac.releaseTo) ");
        sb.append("from AssessmentData a, AuthorizationData z, AssessmentAccessControl ac where a.status = :status and ");
        sb.append("a.assessmentBaseId=z.qualifierId and z.functionId = :fid ");
        sb.append("and z.agentIdString = :site ");
        sb.append("and ac.assessmentBase.assessmentBaseId = a.assessmentBaseId order by a.");
        sb.append(orderBy);
        Object query = sb.toString();
        query = ascending ? (String)query + " asc" : (String)query + " desc";
        Object hql = query;
        HibernateCallback hcb = arg_0 -> AssessmentFacadeQueries.lambda$getBasicInfoOfAllActiveAssessmentsByAgent$3((String)hql, siteAgentId, arg_0);
        List list = (List)this.getHibernateTemplate().execute(hcb);
        HibernateCallback hcb2 = session -> {
            Query q2 = session.createQuery("select a.assessmentBaseId, count(*) from ItemData i, SectionData s,  AssessmentData a, AuthorizationData z where a = s.assessment and s = i.section and a.assessmentBaseId = z.qualifierId and z.functionId = :fid and z.agentIdString = :site group by a.assessmentBaseId ");
            q2.setParameter("fid", (Object)"EDIT_ASSESSMENT");
            q2.setParameter("site", (Object)siteAgentId);
            return q2.list();
        };
        List questionSizeList = (List)this.getHibernateTemplate().execute(hcb2);
        HashMap<Object, Object> questionSizeMap = new HashMap<Object, Object>();
        for (Object[] o : questionSizeList) {
            questionSizeMap.put(o[0], o[1]);
        }
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : list) {
            Map<String, String> releaseToGroups = null;
            if ("Selected Groups".equals(a.getReleaseTo())) {
                Long assessmentId = a.getAssessmentBaseId();
                releaseToGroups = this.getReleaseToGroups(siteAgentId, assessmentId);
            }
            AgentFacade agent = new AgentFacade(a.getLastModifiedBy());
            String lastModifiedBy = agent.getDisplayName();
            int questionSize = 0;
            if (questionSizeMap.get(a.getAssessmentBaseId()) != null) {
                questionSize = ((Long)questionSizeMap.get(a.getAssessmentBaseId())).intValue();
            }
            AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate(), a.getStartDate(), a.getDueDate(), a.getReleaseTo(), releaseToGroups, lastModifiedBy, questionSize);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public List<AssessmentFacade> getBasicInfoOfAllActiveAssessmentsByAgent(String orderBy, String siteAgentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)  from AssessmentData a, AuthorizationData z where a.status = :status and  a.assessmentBaseId=z.qualifierId and z.functionId = :fid  and z.agentIdString = :site order by a." + orderBy);
            q.setParameter("status", (Object)1);
            q.setParameter("fid", (Object)"EDIT_ASSESSMENT");
            q.setParameter("site", (Object)siteAgentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : list) {
            assessmentList.add(new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate()));
        }
        return assessmentList;
    }

    @Override
    public AssessmentFacade getBasicInfoOfAnAssessment(Long assessmentId) {
        AssessmentData a = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
        AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
        f.setCreatedBy(a.getCreatedBy());
        return f;
    }

    @Override
    public AssessmentFacade getBasicInfoOfAnAssessmentFromSectionId(Long sectionId) {
        SectionData section = this.loadSection(sectionId);
        AssessmentData a = (AssessmentData)section.getAssessment();
        AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
        f.setCreatedBy(a.getCreatedBy());
        return f;
    }

    @Override
    public List<AssessmentFacade> getSettingsOfAllActiveAssessments(String orderBy) {
        List list = this.getHibernateTemplate().findByNamedParam("from AssessmentData a where a.status = :status order by a." + orderBy, "status", (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        Boolean loadSection = Boolean.FALSE;
        for (AssessmentData a : list) {
            assessmentList.add(new AssessmentFacade((AssessmentIfc)a, loadSection));
        }
        return assessmentList;
    }

    @Override
    public List<AssessmentFacade> getAllAssessments(int pageSize, int pageNumber, String orderBy) {
        PagingUtilQueriesAPI pagingUtilQueries = PersistenceService.getInstance().getPagingUtilQueries();
        List pageList = pagingUtilQueries.getAll(pageSize, pageNumber, "from AssessmentData a order by a." + orderBy);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (AssessmentData a : pageList) {
            assessmentList.add(new AssessmentFacade((AssessmentIfc)a));
        }
        return assessmentList;
    }

    @Override
    public int getQuestionSize(Long assessmentId) {
        HibernateCallback hcb = session -> (Number)session.createQuery("select count(i) from ItemData i, SectionData s,  AssessmentData a where a = s.assessment and s = i.section and a.assessmentBaseId = :id").setParameter("id", (Object)assessmentId).uniqueResult();
        return ((Number)this.getHibernateTemplate().execute(hcb)).intValue();
    }

    @Override
    public List getQuestionsIdList(Long assessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select i.itemId from ItemData i, SectionData s,  AssessmentData a where a = s.assessment and s = i.section and a.assessmentBaseId=?").setParameter(0, (Object)assessmentId).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public void deleteAllSecuredIP(AssessmentIfc assessment) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                Long assessmentId = assessment.getAssessmentId();
                List ip = this.getHibernateTemplate().findByNamedParam("from SecuredIPAddress s where s.assessment.assessmentBaseId = :id", "id", (Object)assessmentId);
                if (ip.size() > 0) {
                    SecuredIPAddress s = (SecuredIPAddress)ip.get(0);
                    AssessmentData a = (AssessmentData)s.getAssessment();
                    a.setSecuredIPAddressSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)ip);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting ip address: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdate(AssessmentFacade assessment) {
        AssessmentData data = (AssessmentData)assessment.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        data.setCategoryId(assessment.getCategoryId());
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save new settings: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteAllMetaData(AssessmentBaseIfc t) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                List metadatas = this.getHibernateTemplate().findByNamedParam("from AssessmentMetaData a where a.assessment.assessmentBaseId = :id", "id", (Object)t.getAssessmentBaseId());
                if (metadatas.size() > 0) {
                    AssessmentMetaDataIfc m = (AssessmentMetaDataIfc)metadatas.get(0);
                    AssessmentBaseIfc a = m.getAssessment();
                    a.setAssessmentMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)metadatas);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting metadata: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdate(AssessmentTemplateData template) {
        template.setLastModifiedBy(AgentFacade.getAgentString());
        template.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)template);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteTemplate(Long templateId) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)this.getAssessmentTemplate(templateId).getData());
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public SectionFacade addSection(Long assessmentId) {
        AssessmentData assessment = this.loadAssessment(assessmentId);
        Set<SectionData> sectionSet = this.getSectionSetForAssessment(assessment);
        assessment.setSectionSet(sectionSet);
        SectionData section = new SectionData(null, Integer.valueOf(sectionSet.size() + 1), "", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        section.setAssessment((AssessmentIfc)assessment);
        section.setAssessmentId(assessment.getAssessmentId());
        section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
        section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
        sectionSet.add(section);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return new SectionFacade((SectionDataIfc)section);
    }

    @Override
    public SectionFacade getSection(Long sectionId) {
        SectionData section = (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
        return new SectionFacade((SectionDataIfc)section);
    }

    @Override
    public void removeSection(Long sectionId) {
        SectionData section = this.loadSection(sectionId);
        if (section != null) {
            QuestionPoolService qpService = new QuestionPoolService();
            Map h = qpService.getQuestionPoolItemMap();
            this.checkForQuestionPoolItem(section, h);
            AssessmentData assessment = (AssessmentData)section.getAssessment();
            assessment.setLastModifiedBy(AgentFacade.getAgentString());
            assessment.setLastModifiedDate(new Date());
            Set itemSet = section.getItemSet();
            Iterator iter1 = itemSet.iterator();
            RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
            while (iter1.hasNext()) {
                ItemDataIfc item = (ItemDataIfc)iter1.next();
                String associationId = assessment.getAssessmentId() + "." + item.getItemId();
                rubricsService.deleteRubricAssociationsByItemIdPrefix(associationId, "sakai.samigo");
            }
            Set<SectionData> sectionSet = this.getSectionSetForAssessment(assessment);
            assessment.setSectionSet(sectionSet);
            ArrayList sections = assessment.getSectionArraySorted();
            HashSet<SectionData> set = new HashSet<SectionData>();
            int count = 1;
            for (int i = 0; i < sections.size(); ++i) {
                SectionData s = (SectionData)sections.get(i);
                if (s.getSectionId().equals(section.getSectionId())) continue;
                s.setSequence(Integer.valueOf(count++));
                set.add(s);
            }
            assessment.setSectionSet(set);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().update((Object)assessment);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem updating asssessment: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
            AssessmentService service = new AssessmentService();
            List sectionAttachmentList = service.getSectionResourceIdList((SectionDataIfc)section);
            service.deleteResources(sectionAttachmentList);
            retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().delete((Object)section);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem deletint section: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
    }

    @Override
    public SectionData loadSection(Long sectionId) {
        return (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
    }

    @Override
    public void saveOrUpdateSection(SectionFacade section) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section.getData());
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    private List loadAllItems(Long sectionId) {
        return this.getHibernateTemplate().find("from ItemData i where i.section.sectionId=" + sectionId, new Object[0]);
    }

    @Override
    public void moveAllItems(Long sourceSectionId, Long destSectionId) {
        SectionData destSection = this.loadSection(destSectionId);
        List list = this.loadAllItems(sourceSectionId);
        HashSet<ItemDataIfc> set = destSection.getItemSet();
        if (set == null) {
            set = new HashSet<ItemDataIfc>();
        }
        int itemNum = set.size();
        for (int i = 0; i < list.size(); ++i) {
            ItemDataIfc a = (ItemDataIfc)list.get(i);
            a.setSection((SectionDataIfc)destSection);
            a.setSequence(Integer.valueOf(++itemNum));
            set.add(a);
        }
        destSection.setItemSet(set);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)destSection);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void removeAllItems(Long sourceSectionId) {
        SectionData section = this.loadSection(sourceSectionId);
        AssessmentData assessment = (AssessmentData)section.getAssessment();
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        Set itemSet = section.getItemSet();
        for (ItemData item : itemSet) {
            item.setSection(null);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().update((Object)item);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem updating item: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating asssessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public List<AssessmentTemplateFacade> getBasicInfoOfAllActiveAssessmentTemplates(String orderBy) {
        String agent = AgentFacade.getAgentString();
        Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.status = 1 and (a.assessmentBaseId = :id or a.createdBy = :agent or typeId = :type) order by a." + orderBy);
            q.setParameter("id", (Object)1L);
            q.setParameter("agent", (Object)agent);
            q.setParameter("type", (Object)typeId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentTemplateFacade> assessmentList = new ArrayList<AssessmentTemplateFacade>();
        for (AssessmentTemplateData a : list) {
            assessmentList.add(new AssessmentTemplateFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate(), a.getTypeId()));
        }
        return assessmentList;
    }

    @Override
    public void checkForQuestionPoolItem(AssessmentData assessment, Map qpItemHash) {
        Set<SectionData> sectionSet = this.getSectionSetForAssessment(assessment);
        for (SectionData s : sectionSet) {
            this.checkForQuestionPoolItem(s, qpItemHash);
        }
    }

    @Override
    public void checkForQuestionPoolItem(SectionData section, Map qpItemHash) {
        Set itemSet = section.getItemSet();
        HashSet<ItemData> newItemSet = new HashSet<ItemData>();
        for (ItemData item : itemSet) {
            if (qpItemHash.get(item.getItemId()) != null) {
                item.setSection(null);
                int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)item);
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        log.warn("problem updating item: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                    }
                }
                continue;
            }
            newItemSet.add(item);
        }
        section.setItemSet(newItemSet);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public boolean assessmentTitleIsUnique(Long assessmentBaseId, String title, Boolean isTemplate) {
        return this.assessmentTitleIsUnique(assessmentBaseId, title, isTemplate, AgentFacade.getCurrentSiteId());
    }

    @Override
    public boolean assessmentTitleIsUnique(Long assessmentBaseId, String title, Boolean isTemplate, String siteId) {
        List list;
        HibernateCallback hcb;
        String titlef;
        title = title.trim();
        String agentString = AgentFacade.getAgentString();
        boolean isUnique = true;
        if (isTemplate.booleanValue()) {
            titlef = title;
            hcb = session -> {
                Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentTemplateData a, AuthorizationData z where a.title = :title and a.assessmentBaseId != :id and a.createdBy = :agent and a.status = :status");
                q.setParameter(TITLE, (Object)titlef);
                q.setParameter("id", (Object)assessmentBaseId);
                q.setParameter("agent", (Object)agentString);
                q.setParameter("status", (Object)1);
                return q.list();
            };
            list = (List)this.getHibernateTemplate().execute(hcb);
        } else {
            titlef = title;
            hcb = session -> {
                Query q = session.createQuery("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentData a, AuthorizationData z where  a.title = :title and a.assessmentBaseId != :id and z.functionId = :fid and  a.assessmentBaseId = z.qualifierId and z.agentIdString = :site and a.status = :status");
                q.setParameter(TITLE, (Object)titlef);
                q.setParameter("id", (Object)assessmentBaseId);
                q.setParameter("fid", (Object)"EDIT_ASSESSMENT");
                q.setParameter("site", (Object)siteId);
                q.setParameter("status", (Object)1);
                return q.list();
            };
            list = (List)this.getHibernateTemplate().execute(hcb);
        }
        for (AssessmentBaseData a : list) {
            if (!title.equals(a.getTitle().trim())) continue;
            isUnique = false;
            break;
        }
        return isUnique;
    }

    @Override
    public List<AssessmentData> getAssessmentByTemplate(Long templateId) {
        HibernateCallback hcb = session -> session.createQuery("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentData a where a.assessmentTemplateId = :id").setParameter("id", (Object)templateId).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List getDefaultMetaDataSet() {
        HibernateCallback hcb = session -> session.createQuery("from AssessmentMetaData m where m.assessment.assessmentBaseId = :id").setParameter("id", (Object)1L).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public long fileSizeInKB(long fileSize) {
        return fileSize / 1024L;
    }

    public String getRelativePath(String url, String protocol) {
        int index = (url = this.replaceSpace(url)).lastIndexOf(protocol);
        if (index == 0) {
            url = url.substring(protocol.length());
        }
        return url;
    }

    private String replaceSpace(String tempString) {
        String newString = "";
        char[] oneChar = new char[1];
        for (int i = 0; i < tempString.length(); ++i) {
            if (tempString.charAt(i) != ' ') {
                oneChar[0] = tempString.charAt(i);
                String concatString = new String(oneChar);
                newString = newString.concat(concatString);
                continue;
            }
            newString = newString.concat("%20");
        }
        return newString;
    }

    @Override
    public void updateAssessmentLastModifiedInfo(AssessmentFacade assessment) {
        AssessmentData data = (AssessmentData)assessment.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem update assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        Object attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = isEditPendingAssessmentFlow ? new ItemAttachment() : new PublishedItemAttachment();
                attach.setItem(item);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(ItemAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public ItemTextAttachmentIfc createItemTextAttachment(ItemTextIfc itemText, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        Object attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = isEditPendingAssessmentFlow ? new ItemTextAttachment() : new PublishedItemTextAttachment();
                attach.setItemText(itemText);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(ItemAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        SectionAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new SectionAttachment();
                attach.setSection(section);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public void removeSectionAttachment(Long sectionAttachmentId) {
        SectionAttachment sectionAttachment = (SectionAttachment)this.getHibernateTemplate().load(SectionAttachment.class, (Serializable)sectionAttachmentId);
        SectionDataIfc section = sectionAttachment.getSection();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (section == null) continue;
                Set set = section.getSectionAttachmentSet();
                set.remove(sectionAttachment);
                this.getHibernateTemplate().delete((Object)sectionAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete sectionAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        AssessmentAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new AssessmentAttachment();
                attach.setAssessment(assessment);
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public void removeAssessmentAttachment(Long assessmentAttachmentId) {
        AssessmentAttachment assessmentAttachment = (AssessmentAttachment)this.getHibernateTemplate().load(AssessmentAttachment.class, (Serializable)assessmentAttachmentId);
        AssessmentIfc assessment = assessmentAttachment.getAssessment();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessment == null) continue;
                Set set = assessment.getAssessmentAttachmentSet();
                set.remove(assessmentAttachment);
                this.getHibernateTemplate().delete((Object)assessmentAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete assessmentAttachment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public AttachmentData createEmailAttachment(String resourceId, String filename, String protocol) {
        AttachmentData attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new AttachmentData();
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public void saveOrUpdateAttachments(List<AttachmentIfc> list) {
        for (AttachmentIfc attachment : list) {
            this.getHibernateTemplate().saveOrUpdate((Object)attachment);
        }
    }

    @Override
    public List<AssessmentData> getAllActiveAssessmentsByAgent(String siteAgentId) {
        HibernateCallback hcb = session -> session.createQuery("select a from AssessmentData a,AuthorizationData z where a.status = :status and a.assessmentBaseId=z.qualifierId and z.functionId = :fid and z.agentIdString = :site").setParameter("status", (Object)1).setParameter("fid", (Object)"EDIT_ASSESSMENT").setParameter("site", (Object)siteAgentId).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAllAssessments(String fromContext, String toContext, Map<String, String> transversalMap) {
        List<AssessmentData> list = this.getAllActiveAssessmentsByAgent(fromContext);
        ArrayList<AssessmentData> newList = new ArrayList<AssessmentData>();
        HashMap<AssessmentData, CallSite> assessmentMap = new HashMap<AssessmentData, CallSite>();
        RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
        for (AssessmentData a : list) {
            log.debug("****protocol:" + ServerConfigurationService.getServerUrl());
            AssessmentData new_a = this.prepareAssessment(a, ServerConfigurationService.getServerUrl(), toContext);
            newList.add(new_a);
            assessmentMap.put(new_a, (CallSite)((Object)("sam_core/" + a.getAssessmentBaseId())));
        }
        for (AssessmentData assessmentData : newList) {
            this.getHibernateTemplate().saveOrUpdate((Object)assessmentData);
        }
        try {
            Site oSite = SiteService.getSite((String)fromContext);
            Site nSite = SiteService.getSite((String)toContext);
            AuthzQueriesFacadeAPI authzQueriesFacadeAPI = PersistenceService.getInstance().getAuthzQueriesFacade();
            int assessmentIdx = 0;
            for (AssessmentData a : newList) {
                Map<String, String> releaseToGroups = this.getReleaseToGroups(fromContext, list.get(assessmentIdx).getAssessmentBaseId());
                PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(toContext, "EDIT_ASSESSMENT", a.getAssessmentId().toString());
                HashMap assessmentMetaDataMap = a.getAssessmentMetaDataMap();
                if (!assessmentMetaDataMap.containsKey("markForReview_isInstructorEditable")) {
                    a.addAssessmentMetaData("markForReview_isInstructorEditable", "true");
                    a.getAssessmentAccessControl().setMarkForReview(Integer.valueOf(1));
                }
                if (!releaseToGroups.isEmpty()) {
                    boolean siteChanged = false;
                    Collection nGroups = nSite.getGroups();
                    Long assessmentId = a.getAssessmentBaseId();
                    HashSet<String> groupsAuthorized = new HashSet<String>();
                    for (Map.Entry<String, String> groupId : releaseToGroups.entrySet()) {
                        Group oGroup = oSite.getGroup(groupId.getKey());
                        Optional<Group> existingGroup = nGroups.stream().filter(g -> StringUtils.equals((CharSequence)g.getTitle(), (CharSequence)oGroup.getTitle())).findAny();
                        if (existingGroup.isPresent()) {
                            groupsAuthorized.add(existingGroup.get().getId());
                            siteChanged = true;
                            continue;
                        }
                        Group nGroup = nSite.addGroup();
                        nGroup.setTitle(oGroup.getTitle());
                        nGroup.setDescription(oGroup.getDescription());
                        nGroup.getProperties().addProperty("group_prop_wsetup_created", Boolean.TRUE.toString());
                        groupsAuthorized.add(nGroup.getId());
                        siteChanged = true;
                    }
                    if (siteChanged) {
                        SiteService.save((Site)nSite);
                        for (String group : groupsAuthorized) {
                            authzQueriesFacadeAPI.createAuthorization(group, "TAKE_ASSESSMENT", assessmentId.toString());
                        }
                    }
                }
                Set sectionSet = a.getSectionSet();
                for (SectionData section : sectionSet) {
                    Set itemSet = section.getItemSet();
                    for (ItemData item : itemSet) {
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + item.getItemId().toString()), (boolean)true));
                        String oldRef = (String)assessmentMap.get(a);
                        String associationId = oldRef.substring("sam_core".length() + 1) + "." + item.getOriginalItemId();
                        try {
                            if (rubricsService.getRubricAssociation("sakai.samigo", associationId).isPresent()) {
                                transversalMap.put("sam_item/" + associationId, "sam_item/" + a.getAssessmentBaseId() + "." + item.getItemId());
                            }
                        }
                        catch (HttpClientErrorException hcee) {
                            log.debug("Current user doesn't have permission to get a rubric: {}", (Object)hcee.getMessage());
                        }
                        catch (Exception e) {
                            log.error("Error while trying to duplicate Rubrics: {} ", (Object)e.getMessage());
                        }
                        Set itemMetaDataSet = item.getItemMetaDataSet();
                        for (ItemMetaData itemMetaData : itemMetaDataSet) {
                            if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                            log.debug("sectionId = " + section.getSectionId());
                            itemMetaData.setEntry(section.getSectionId().toString());
                        }
                    }
                }
                ++assessmentIdx;
            }
        }
        catch (IdUnusedException ex) {
            log.error("Cannot find a site with id {} or {}", (Object)fromContext, (Object)toContext);
        }
        catch (PermissionException ex) {
            log.error("No permission to save a site with id {} or {}", (Object)fromContext, (Object)toContext);
        }
        for (AssessmentData data : newList) {
            boolean notUnique;
            String title = data.getTitle();
            boolean bl = notUnique = !this.assessmentTitleIsUnique(data.getAssessmentBaseId(), title, false, toContext);
            if (notUnique) {
                String string = title;
                synchronized (string) {
                    log.debug("Assessment " + title + " is not unique.");
                    int count = 0;
                    while (notUnique) {
                        title = AssessmentService.renameDuplicate(title);
                        log.debug("renameDuplicate(title): " + title);
                        data.setTitle(title);
                        boolean bl2 = notUnique = !this.assessmentTitleIsUnique(data.getAssessmentBaseId(), title, false);
                        if (count++ <= 99) continue;
                    }
                }
            }
            this.getHibernateTemplate().saveOrUpdate((Object)data);
            String oldRef = (String)assessmentMap.get(data);
            if (oldRef == null || data.getAssessmentBaseId() == null) continue;
            transversalMap.put(oldRef, "sam_core/" + data.getAssessmentBaseId());
        }
    }

    @Override
    public void copyAssessment(String assessmentId, String appendCopyTitle) {
        AssessmentData assessmentData = this.loadAssessment(Long.valueOf(assessmentId));
        assessmentData.setSectionSet(this.getSectionSetForAssessment(assessmentData));
        RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
        AssessmentData newAssessmentData = this.prepareAssessment(assessmentData, ServerConfigurationService.getServerUrl(), AgentFacade.getCurrentSiteId());
        this.updateTitleForCopy(newAssessmentData, appendCopyTitle);
        this.getHibernateTemplate().saveOrUpdate((Object)newAssessmentData);
        PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "EDIT_ASSESSMENT", newAssessmentData.getAssessmentId().toString());
        Set sectionSet = newAssessmentData.getSectionSet();
        for (SectionData section : sectionSet) {
            Set itemSet = section.getItemSet();
            for (ItemData item : itemSet) {
                try {
                    String associationId = assessmentId + "." + item.getOriginalItemId();
                    Optional rubricAssociation = rubricsService.getRubricAssociation("sakai.samigo", associationId);
                    if (rubricAssociation.isPresent()) {
                        rubricsService.saveRubricAssociation("sakai.samigo", newAssessmentData.getAssessmentId() + "." + item.getItemId(), ((ToolItemRubricAssociation)rubricAssociation.get()).getFormattedAssociation());
                    }
                }
                catch (Exception e) {
                    log.error("Error while trying to duplicate Rubrics: {} ", (Object)e.getMessage());
                }
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + item.getItemId().toString()), (boolean)true));
                Set itemMetaDataSet = item.getItemMetaDataSet();
                for (ItemMetaData itemMetaData : itemMetaDataSet) {
                    if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                    log.debug("sectionId = " + section.getSectionId());
                    itemMetaData.setEntry(section.getSectionId().toString());
                }
            }
        }
        this.getHibernateTemplate().saveOrUpdate((Object)newAssessmentData);
    }

    private void updateTitleForCopy(AssessmentData assessmentData, String appendCopyTitle) {
        StringBuffer sb = new StringBuffer(assessmentData.getTitle());
        sb.append(" ");
        sb.append(appendCopyTitle);
        if (sb.length() >= 255) {
            String appendCopyText = "... " + appendCopyTitle;
            String titleCut = sb.substring(0, 255 - appendCopyText.length() - 1);
            log.debug("titleCut = " + titleCut);
            sb = new StringBuffer(titleCut);
            sb.append(appendCopyText);
        }
        String newTitle = this.getNewAssessmentTitleForCopy(sb.toString());
        assessmentData.setTitle(newTitle);
    }

    private String getNewAssessmentTitleForCopy(String title) {
        title = title.trim();
        log.debug(title);
        String currentSiteId = AgentFacade.getCurrentSiteId();
        String titlef = title + "%";
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a.title from AssessmentData a, AuthorizationData z where a.title like :title and z.functionId='EDIT_ASSESSMENT' and a.assessmentBaseId=z.qualifierId and z.agentIdString = :site");
            q.setParameter(TITLE, (Object)titlef);
            q.setParameter("site", (Object)currentSiteId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        int startIndex = title.length();
        int maxNumCopy = 0;
        if (!list.isEmpty()) {
            for (String existingTitle : list) {
                if (!existingTitle.startsWith(title)) continue;
                try {
                    int numCopy = Integer.parseInt(existingTitle.substring(startIndex));
                    if (numCopy <= maxNumCopy) continue;
                    maxNumCopy = numCopy;
                }
                catch (NumberFormatException e) {
                    log.error("existingTitle = {}, title = {}, startIndex = {}, error message: {}", new Object[]{existingTitle, title, startIndex, e.getMessage()});
                }
            }
        }
        log.debug("maxNumCopy = {}", (Object)maxNumCopy);
        int nextNumCopy = maxNumCopy + 1;
        return title + nextNumCopy;
    }

    public AssessmentData prepareAssessment(AssessmentData a, String protocol, String toContext) {
        String releaseTo;
        AssessmentData newAssessment = new AssessmentData(new Long("0"), a.getTitle(), a.getDescription(), a.getComments(), a.getAssessmentTemplateId(), TypeFacade.HOMEWORK, a.getInstructorNotification(), a.getTesteeNotification(), a.getMultipartAllowed(), a.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        Set newSectionSet = this.prepareSectionSet(newAssessment, a.getSectionSet(), protocol, toContext);
        newAssessment.setSectionSet(newSectionSet);
        AssessmentAccessControl newAccessControl = this.prepareAssessmentAccessControl(newAssessment, (AssessmentAccessControl)a.getAssessmentAccessControl());
        newAssessment.setAssessmentAccessControl((AssessmentAccessControlIfc)newAccessControl);
        EvaluationModel newEvaluationModel = this.prepareEvaluationModel(newAssessment, (EvaluationModel)a.getEvaluationModel());
        newAssessment.setEvaluationModel((EvaluationModelIfc)newEvaluationModel);
        AssessmentFeedback newFeedback = this.prepareAssessmentFeedback(newAssessment, (AssessmentFeedback)a.getAssessmentFeedback());
        newAssessment.setAssessmentFeedback((AssessmentFeedbackIfc)newFeedback);
        Set<AssessmentMetaData> newMetaDataSet = this.prepareAssessmentMetaDataSet(newAssessment, a.getAssessmentMetaDataSet());
        switch (releaseTo = newAccessControl.getReleaseTo()) {
            case "Anonymous Users": {
                String alias = AgentFacade.getAgentString() + Instant.now().toEpochMilli();
                AssessmentMetaData meta = new AssessmentMetaData((AssessmentBaseIfc)newAssessment, "ALIAS", alias);
                newMetaDataSet.add(meta);
                break;
            }
            case "Selected Groups": {
                break;
            }
            default: {
                if (toContext == null) break;
                try {
                    Site site = SiteService.getSite((String)toContext);
                    newAccessControl.setReleaseTo(site.getTitle());
                    break;
                }
                catch (IdUnusedException e) {
                    log.debug("Site not found [{}], {}", (Object)toContext, (Object)e.toString());
                }
            }
        }
        log.debug(" metadata set" + a.getAssessmentMetaDataSet());
        log.debug(" new metadata set" + newMetaDataSet);
        newAssessment.setAssessmentMetaDataSet(newMetaDataSet);
        Set newIPSet = this.prepareSecuredIPSet(newAssessment, a.getSecuredIPAddressSet());
        newAssessment.setSecuredIPAddressSet(newIPSet);
        Set<AssessmentAttachment> newAssessmentAttachmentSet = this.prepareAssessmentAttachmentSet(newAssessment, a.getAssessmentAttachmentSet(), protocol, toContext);
        newAssessment.setAssessmentAttachmentSet(newAssessmentAttachmentSet);
        return newAssessment;
    }

    public AssessmentData prepareAssessment(AssessmentData a, String protocol) {
        return this.prepareAssessment(a, protocol, null);
    }

    public AssessmentFeedback prepareAssessmentFeedback(AssessmentData p, AssessmentFeedback a) {
        if (a == null) {
            return null;
        }
        AssessmentFeedback newFeedback = new AssessmentFeedback(a.getFeedbackDelivery(), a.getFeedbackComponentOption(), a.getFeedbackAuthoring(), a.getEditComponents(), a.getShowQuestionText(), a.getShowStudentResponse(), a.getShowCorrectResponse(), a.getShowStudentScore(), a.getShowStudentQuestionScore(), a.getShowQuestionLevelFeedback(), a.getShowSelectionLevelFeedback(), a.getShowGraderComments(), a.getShowStatistics());
        newFeedback.setAssessmentBase((AssessmentBaseIfc)p);
        return newFeedback;
    }

    public AssessmentAccessControl prepareAssessmentAccessControl(AssessmentData p, AssessmentAccessControl a) {
        if (a == null) {
            return new AssessmentAccessControl();
        }
        AssessmentAccessControl newAccessControl = new AssessmentAccessControl(a.getSubmissionsAllowed(), a.getSubmissionsSaved(), a.getAssessmentFormat(), a.getBookMarkingItem(), a.getTimeLimit(), a.getTimedAssessment(), a.getRetryAllowed(), a.getLateHandling(), a.getInstructorNotification(), a.getStartDate(), a.getDueDate(), a.getScoreDate(), a.getFeedbackDate(), a.getRetractDate(), a.getAutoSubmit(), a.getItemNavigation(), a.getItemNumbering(), a.getDisplayScoreDuringAssessments(), a.getSubmissionMessage(), a.getReleaseTo());
        newAccessControl.setPassword(a.getPassword());
        newAccessControl.setFinalPageUrl(a.getFinalPageUrl());
        newAccessControl.setUnlimitedSubmissions(a.getUnlimitedSubmissions());
        newAccessControl.setAssessmentBase((AssessmentBaseIfc)p);
        newAccessControl.setMarkForReview(a.getMarkForReview());
        newAccessControl.setHonorPledge(a.getHonorPledge());
        newAccessControl.setFeedbackEndDate(a.getFeedbackEndDate());
        newAccessControl.setFeedbackScoreThreshold(a.getFeedbackScoreThreshold());
        return newAccessControl;
    }

    public EvaluationModel prepareEvaluationModel(AssessmentData p, EvaluationModel e) {
        if (e == null) {
            return null;
        }
        EvaluationModel newEvaluationModel = new EvaluationModel(e.getEvaluationComponents(), e.getScoringType(), e.getNumericModelId(), e.getFixedTotalScore(), e.getGradeAvailable(), e.getIsStudentIdPublic(), e.getAnonymousGrading(), e.getAutoScoring(), e.getToGradeBook());
        newEvaluationModel.setAssessmentBase((AssessmentBaseIfc)p);
        return newEvaluationModel;
    }

    public Set<AssessmentMetaData> prepareAssessmentMetaDataSet(AssessmentData p, Set<AssessmentMetaData> metaDataSet) {
        return metaDataSet.stream().map(m -> new AssessmentMetaData((AssessmentBaseIfc)p, m.getLabel(), m.getEntry())).collect(Collectors.toSet());
    }

    public Set prepareSecuredIPSet(AssessmentData p, Set ipSet) {
        HashSet<SecuredIPAddress> h = new HashSet<SecuredIPAddress>();
        for (SecuredIPAddress ip : ipSet) {
            SecuredIPAddress newIP = new SecuredIPAddress((AssessmentBaseIfc)p, ip.getHostname(), ip.getIpAddress());
            h.add(newIP);
        }
        return h;
    }

    public Set prepareSectionSet(AssessmentData newAssessment, Set sectionSet, String protocol, String toContext) {
        log.debug("new section size = " + sectionSet.size());
        HashSet<SectionData> h = new HashSet<SectionData>();
        for (SectionData section : sectionSet) {
            SectionData newSection = new SectionData(section.getDuration(), section.getSequence(), section.getTitle(), section.getDescription(), section.getTypeId(), section.getStatus(), section.getCreatedBy(), section.getCreatedDate(), section.getLastModifiedBy(), section.getLastModifiedDate());
            Set newSectionAttachmentSet = this.prepareSectionAttachmentSet(newSection, section.getSectionAttachmentSet(), protocol, toContext);
            newSection.setSectionAttachmentSet(newSectionAttachmentSet);
            Set newItemSet = this.prepareItemSet(newSection, section.getItemSet(), protocol, toContext);
            newSection.setItemSet(newItemSet);
            Set newMetaDataSet = this.prepareSectionMetaDataSet(newSection, section.getSectionMetaDataSet());
            newSection.setSectionMetaDataSet(newMetaDataSet);
            newSection.setAssessment((AssessmentIfc)newAssessment);
            h.add(newSection);
        }
        return h;
    }

    public Set prepareSectionSet(AssessmentData newAssessment, Set sectionSet, String protocol) {
        return this.prepareSectionSet(newAssessment, sectionSet, protocol, null);
    }

    public Set prepareSectionMetaDataSet(SectionData newSection, Set metaDataSet) {
        HashSet<SectionMetaData> h = new HashSet<SectionMetaData>();
        for (SectionMetaData sectionMetaData : metaDataSet) {
            SectionMetaData newSectionMetaData = new SectionMetaData((SectionDataIfc)newSection, sectionMetaData.getLabel(), sectionMetaData.getEntry());
            h.add(newSectionMetaData);
        }
        return h;
    }

    @Override
    public Set prepareItemSet(SectionData newSection, Set itemSet, String protocol, String toContext) {
        log.debug("new item size = " + itemSet.size());
        HashSet<ItemData> h = new HashSet<ItemData>();
        for (ItemData item : itemSet) {
            ItemData newItem = new ItemData((SectionDataIfc)newSection, item.getSequence(), item.getDuration(), item.getInstruction(), item.getDescription(), item.getTypeId(), item.getGrade(), item.getScore(), item.getScoreDisplayFlag(), item.getDiscount(), item.getMinScore(), item.getHint(), item.getHasRationale(), item.getStatus(), item.getCreatedBy(), item.getCreatedDate(), item.getLastModifiedBy(), item.getLastModifiedDate(), null, null, null, item.getTriesAllowed(), item.getPartialCreditFlag(), item.getHash(), item.getItemId());
            Set newItemTextSet = this.prepareItemTextSet(newItem, item.getItemTextSet(), protocol, toContext);
            Set newItemMetaDataSet = this.prepareItemMetaDataSet(newItem, item.getItemMetaDataSet());
            Set newItemTagSet = this.prepareItemTagSet(newItem, item.getItemTagSet());
            Set newItemFeedbackSet = this.prepareItemFeedbackSet(newItem, item.getItemFeedbackSet());
            Set newItemAttachmentSet = this.prepareItemAttachmentSet(newItem, item.getItemAttachmentSet(), protocol, toContext);
            newItem.setItemTextSet(newItemTextSet);
            newItem.setItemMetaDataSet(newItemMetaDataSet);
            newItem.setItemTagSet(newItemTagSet);
            newItem.setItemFeedbackSet(newItemFeedbackSet);
            newItem.setItemAttachmentSet(newItemAttachmentSet);
            newItem.setAnswerOptionsRichCount(item.getAnswerOptionsRichCount());
            newItem.setAnswerOptionsSimpleOrRich(item.getAnswerOptionsSimpleOrRich());
            newItem.setIsExtraCredit(item.getIsExtraCredit());
            h.add(newItem);
        }
        return h;
    }

    public Set prepareItemSet(SectionData newSection, Set itemSet, String protocol) {
        return this.prepareItemSet(newSection, itemSet, protocol, null);
    }

    @Override
    public Set prepareItemTextSet(ItemData newItem, Set itemTextSet, String protocol, String toContext) {
        log.debug("new item text size = " + itemTextSet.size());
        HashSet<ItemText> h = new HashSet<ItemText>();
        for (ItemText itemText : itemTextSet) {
            log.debug("item text id =" + itemText.getId());
            ItemText newItemText = new ItemText(newItem, itemText.getSequence(), itemText.getText(), null);
            Set newAnswerSet = this.prepareAnswerSet(newItemText, itemText.getAnswerSet());
            newItemText.setAnswerSet(newAnswerSet);
            Set itemTextAttachmentSet = this.prepareItemTextAttachmentSet(newItemText, itemText.getItemTextAttachmentSet(), protocol, toContext);
            newItemText.setItemTextAttachmentSet(itemTextAttachmentSet);
            newItemText.setRequiredOptionsCount(itemText.getRequiredOptionsCount());
            h.add(newItemText);
        }
        return h;
    }

    @Override
    public Set prepareItemMetaDataSet(ItemData newItem, Set itemMetaDataSet) {
        HashSet<ItemMetaData> h = new HashSet<ItemMetaData>();
        for (ItemMetaData itemMetaData : itemMetaDataSet) {
            ItemMetaData newItemMetaData = new ItemMetaData((ItemDataIfc)newItem, itemMetaData.getLabel(), itemMetaData.getEntry());
            h.add(newItemMetaData);
        }
        return h;
    }

    @Override
    public Set prepareItemTagSet(ItemData newItem, Set itemTagSet) {
        HashSet<ItemTag> h = new HashSet<ItemTag>();
        for (ItemTag itemTag : itemTagSet) {
            ItemTag newItemTag = new ItemTag((ItemDataIfc)newItem, itemTag.getTagId(), itemTag.getTagLabel(), itemTag.getTagCollectionId(), itemTag.getTagCollectionName());
            h.add(newItemTag);
        }
        return h;
    }

    @Override
    public Set prepareItemFeedbackSet(ItemData newItem, Set itemFeedbackSet) {
        HashSet<ItemFeedback> h = new HashSet<ItemFeedback>();
        for (ItemFeedback itemFeedback : itemFeedbackSet) {
            ItemFeedback newItemFeedback = new ItemFeedback(newItem, itemFeedback.getTypeId(), itemFeedback.getText());
            h.add(newItemFeedback);
        }
        return h;
    }

    @Override
    public Set prepareItemAttachmentSet(ItemData newItem, Set itemAttachmentSet, String protocol, String toContext) {
        HashSet<ItemAttachment> h = new HashSet<ItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename(), toContext);
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                ItemAttachment newItemAttachment = new ItemAttachment(null, (ItemDataIfc)newItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), itemAttachment.getCreatedBy(), itemAttachment.getCreatedDate(), itemAttachment.getLastModifiedBy(), itemAttachment.getLastModifiedDate());
                h.add(newItemAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set prepareItemTextAttachmentSet(ItemText newItemText, Set itemTextAttachmentSet, String protocol, String toContext) {
        HashSet<ItemTextAttachment> h = new HashSet<ItemTextAttachment>();
        for (ItemTextAttachment itemTextAttachment : itemTextAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemTextAttachment.getResourceId(), itemTextAttachment.getFilename(), toContext);
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                ItemTextAttachment newItemTextAttachment = new ItemTextAttachment(null, (ItemTextIfc)newItemText, cr_copy.getId(), itemTextAttachment.getFilename(), itemTextAttachment.getMimeType(), itemTextAttachment.getFileSize(), itemTextAttachment.getDescription(), url, itemTextAttachment.getIsLink(), itemTextAttachment.getStatus(), itemTextAttachment.getCreatedBy(), itemTextAttachment.getCreatedDate(), itemTextAttachment.getLastModifiedBy(), itemTextAttachment.getLastModifiedDate());
                h.add(newItemTextAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set prepareItemAttachmentSet(ItemData newItem, Set itemAttachmentSet, String protocol) {
        return this.prepareItemAttachmentSet(newItem, itemAttachmentSet, protocol, null);
    }

    public Set prepareSectionAttachmentSet(SectionData newSection, Set sectionAttachmentSet, String protocol, String toContext) {
        HashSet<SectionAttachment> h = new HashSet<SectionAttachment>();
        for (SectionAttachment sectionAttachment : sectionAttachmentSet) {
            AssessmentService service = new AssessmentService();
            ContentResource cr_copy = service.createCopyOfContentResource(sectionAttachment.getResourceId(), sectionAttachment.getFilename(), toContext);
            String url = this.getRelativePath(cr_copy.getUrl(), protocol);
            SectionAttachment newSectionAttachment = new SectionAttachment(null, (SectionDataIfc)newSection, cr_copy.getId(), sectionAttachment.getFilename(), sectionAttachment.getMimeType(), sectionAttachment.getFileSize(), sectionAttachment.getDescription(), url, sectionAttachment.getIsLink(), sectionAttachment.getStatus(), sectionAttachment.getCreatedBy(), sectionAttachment.getCreatedDate(), sectionAttachment.getLastModifiedBy(), sectionAttachment.getLastModifiedDate());
            h.add(newSectionAttachment);
        }
        return h;
    }

    public Set<AssessmentAttachment> prepareSectionAttachmentSet(SectionData newSection, Set sectionAttachmentSet, String protocol) {
        return this.prepareSectionAttachmentSet(newSection, sectionAttachmentSet, protocol, null);
    }

    public Set<AssessmentAttachment> prepareAssessmentAttachmentSet(AssessmentData newAssessment, Set<AssessmentAttachment> assessmentAttachmentSet, String protocol, String toContext) {
        HashSet<AssessmentAttachment> h = new HashSet<AssessmentAttachment>();
        Iterator<AssessmentAttachment> iterator = assessmentAttachmentSet.iterator();
        while (iterator.hasNext()) {
            AssessmentService service = new AssessmentService();
            AssessmentAttachment assessmentAttachment = iterator.next();
            ContentResource cr_copy = service.createCopyOfContentResource(assessmentAttachment.getResourceId(), assessmentAttachment.getFilename(), toContext);
            if (cr_copy == null) continue;
            String url = this.getRelativePath(cr_copy.getUrl(), protocol);
            AssessmentAttachment newAssessmentAttachment = new AssessmentAttachment(null, (AssessmentIfc)newAssessment, cr_copy.getId(), assessmentAttachment.getFilename(), assessmentAttachment.getMimeType(), assessmentAttachment.getFileSize(), assessmentAttachment.getDescription(), url, assessmentAttachment.getIsLink(), assessmentAttachment.getStatus(), assessmentAttachment.getCreatedBy(), assessmentAttachment.getCreatedDate(), assessmentAttachment.getLastModifiedBy(), assessmentAttachment.getLastModifiedDate());
            h.add(newAssessmentAttachment);
        }
        return h;
    }

    public Set prepareAssessmentAttachmentSet(AssessmentData newAssessment, Set assessmentAttachmentSet, String protocol) {
        return this.prepareAssessmentAttachmentSet(newAssessment, assessmentAttachmentSet, protocol, null);
    }

    public Set prepareAnswerSet(ItemText newItemText, Set answerSet) {
        log.debug("new answer size = " + answerSet.size());
        HashSet<Answer> h = new HashSet<Answer>();
        for (Answer answer : answerSet) {
            Answer newAnswer = new Answer((ItemTextIfc)newItemText, answer.getText(), answer.getSequence(), answer.getLabel(), answer.getIsCorrect(), answer.getGrade(), answer.getScore(), answer.getPartialCredit(), answer.getDiscount(), null);
            Set newAnswerFeedbackSet = this.prepareAnswerFeedbackSet(newAnswer, answer.getAnswerFeedbackSet());
            newAnswer.setAnswerFeedbackSet(newAnswerFeedbackSet);
            h.add(newAnswer);
        }
        return h;
    }

    public Set prepareAnswerFeedbackSet(Answer newAnswer, Set answerFeedbackSet) {
        HashSet<AnswerFeedback> h = new HashSet<AnswerFeedback>();
        for (AnswerFeedback answerFeedback : answerFeedbackSet) {
            AnswerFeedback newAnswerFeedback = new AnswerFeedback((AnswerIfc)newAnswer, answerFeedback.getTypeId(), answerFeedback.getText());
            h.add(newAnswerFeedback);
        }
        return h;
    }

    @Override
    public String getAssessmentSiteId(String assessmentId) {
        List l = this.getHibernateTemplate().findByNamedParam("select a from AuthorizationData a where a.functionId = :fid and a.qualifierId = :id", new String[]{"fid", "id"}, new Object[]{"EDIT_ASSESSMENT", assessmentId});
        if (!l.isEmpty()) {
            AuthorizationData a = (AuthorizationData)l.get(0);
            return a.getAgentIdString();
        }
        return null;
    }

    @Override
    public String getAssessmentCreatedBy(String assessmentId) {
        List l = this.getHibernateTemplate().findByNamedParam("select a from AssessmentData a where a.assessmentBaseId = :id", "id", (Object)Long.parseLong(assessmentId));
        if (!l.isEmpty()) {
            AssessmentData a = (AssessmentData)l.get(0);
            return a.getCreatedBy();
        }
        return null;
    }

    @Override
    public Set copyItemAttachmentSet(ItemData newItem, Set itemAttachmentSet) {
        HashSet<ItemAttachment> h = new HashSet<ItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), ServerConfigurationService.getServerUrl());
                ItemAttachment newItemAttachment = new ItemAttachment(null, (ItemDataIfc)newItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
                h.add(newItemAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    private Map<String, String> getReleaseToGroups(String siteId, Long assessmentId) {
        HashMap<String, String> releaseToGroups = new HashMap<String, String>();
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        List<AuthorizationData> authorizations = authz.getAuthorizationByFunctionAndQualifier("TAKE_ASSESSMENT", assessmentId.toString());
        if (authorizations != null && !authorizations.isEmpty()) {
            Map<String, String> allGroupsInSite = this.getAllGroupsForSite(siteId);
            authorizations.stream().filter(a -> allGroupsInSite.containsKey(a.getAgentIdString())).forEach(a -> releaseToGroups.put(a.getAgentIdString(), (String)allGroupsInSite.get(a.getAgentIdString())));
        }
        return releaseToGroups;
    }

    private Map<String, String> getAllGroupsForSite(String siteId) {
        HashMap<String, String> groupInfo = new HashMap<String, String>();
        try {
            Site site = SiteService.getSite((String)siteId);
            Collection groups = site.getGroups();
            if (groups != null) {
                groups.forEach(g -> groupInfo.put(g.getId(), g.getTitle()));
            }
        }
        catch (Exception e) {
            log.warn("Site [{}] not found while attempting to get its groups, {}", (Object)siteId, (Object)e.toString());
        }
        return groupInfo;
    }

    @Override
    public List<AssessmentData> getDeletedAssessments(String siteAgentId) {
        HibernateCallback hcb = session -> session.createQuery("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentData a, AuthorizationData z where a.assessmentBaseId=z.qualifierId and z.functionId=:functionId and z.agentIdString=:siteId and a.status=:inactiveStatus ").setParameter("functionId", (Object)"EDIT_ASSESSMENT").setParameter("siteId", (Object)siteAgentId).setParameter("inactiveStatus", (Object)AssessmentIfc.DEAD_STATUS).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public void restoreAssessment(Long assessmentId) {
        AssessmentData assessment = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        assessment.setStatus(AssessmentIfc.ACTIVE_STATUS);
        RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
        rubricsService.restoreRubricAssociationsByItemIdPrefix(assessmentId + ".", "sakai.samigo");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating asssessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    private static /* synthetic */ List lambda$getBasicInfoOfAllActiveAssessmentsByAgent$3(String hql, String siteAgentId, Session session) throws HibernateException {
        Query q = session.createQuery(hql);
        q.setParameter("status", (Object)1);
        q.setParameter("fid", (Object)"EDIT_ASSESSMENT");
        q.setParameter("site", (Object)siteAgentId);
        return q.list();
    }
}

