/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;
import org.sakaiproject.antivirus.api.VirusFoundException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.GradingAttachmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.dao.grading.StudentGradingSummaryData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.StudentGradingSummaryIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueries;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AutoSubmitFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceHelper;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class AssessmentGradingFacadeQueries
extends HibernateDaoSupport
implements AssessmentGradingFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(AssessmentGradingFacadeQueries.class);
    private ContentHostingService contentHostingService;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private PersistenceHelper persistenceHelper;

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setPersistenceHelper(PersistenceHelper persistenceHelper) {
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    public List<AssessmentGradingData> getTotalScores(Long publishedId, String which, boolean getSubmittedOnly) {
        if (publishedId == null) {
            return Collections.emptyList();
        }
        try {
            HibernateCallback hcb = session -> {
                Criteria q = session.createCriteria(AssessmentGradingData.class).add((Criterion)Restrictions.eq((String)"publishedAssessmentId", (Object)publishedId)).add((Criterion)Restrictions.gt((String)"status", (Object)AssessmentGradingData.REMOVED)).addOrder(Order.asc((String)"agentId").nulls(NullPrecedence.LAST)).addOrder(Order.desc((String)"finalScore").nulls(NullPrecedence.LAST)).addOrder(Order.desc((String)"submittedDate").nulls(NullPrecedence.LAST));
                if (getSubmittedOnly) {
                    q.add((Criterion)Restrictions.eq((String)"forGrade", (Object)true));
                } else {
                    q.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"forGrade", (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"forGrade", (Object)false), (Criterion)Restrictions.eq((String)"status", (Object)AssessmentGradingData.NO_SUBMISSION))));
                }
                return q.list();
            };
            List list = (List)this.getHibernateTemplate().execute(hcb);
            Map<Long, List<AssessmentGradingAttachment>> attachmentMap = this.getAssessmentGradingAttachmentMap(publishedId);
            for (AssessmentGradingData data : list) {
                if (attachmentMap.get(data.getAssessmentGradingId()) != null) {
                    data.setAssessmentGradingAttachmentList(attachmentMap.get(data.getAssessmentGradingId()));
                    continue;
                }
                data.setAssessmentGradingAttachmentList(new ArrayList());
            }
            if (which.equals(EvaluationModelIfc.LAST_SCORE.toString())) {
                HibernateCallback hcb2 = session -> {
                    Criteria q = session.createCriteria(AssessmentGradingData.class).add((Criterion)Restrictions.eq((String)"publishedAssessmentId", (Object)publishedId)).add((Criterion)Restrictions.gt((String)"status", (Object)AssessmentGradingData.REMOVED)).addOrder(Order.asc((String)"agentId").nulls(NullPrecedence.LAST)).addOrder(Order.desc((String)"submittedDate").nulls(NullPrecedence.LAST));
                    if (getSubmittedOnly) {
                        q.add((Criterion)Restrictions.eq((String)"forGrade", (Object)true));
                    } else {
                        q.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"forGrade", (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"forGrade", (Object)false), (Criterion)Restrictions.eq((String)"status", (Object)AssessmentGradingData.NO_SUBMISSION))));
                    }
                    return q.list();
                };
                list = (List)this.getHibernateTemplate().execute(hcb2);
            }
            if (which.equals(EvaluationModelIfc.ALL_SCORE.toString()) || which.equals(EvaluationModelIfc.AVERAGE_SCORE.toString())) {
                return list;
            }
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            AssessmentGradingData first = (AssessmentGradingData)list.get(0);
            if (first != null) {
                first.setPublishedAssessmentId(Long.valueOf(publishedId));
            }
            return new ArrayList<AssessmentGradingData>(list.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<AssessmentGradingData> getAllSubmissions(String publishedId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.forGrade = :forgrade and a.status > :status");
            q.setParameter("id", (Object)Long.parseLong(publishedId));
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<AssessmentGradingData> getAllAssessmentGradingData(Long publishedId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.status <> :status and a.status <> :removed order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedId);
            q.setParameter("status", (Object)AssessmentGradingData.NO_SUBMISSION);
            q.setParameter("removed", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        list.forEach(agd -> agd.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId())));
        return list;
    }

    @Override
    public Map<Long, List<ItemGradingData>> getItemScores(Long publishedId, Long itemId, String which) {
        List<AssessmentGradingData> scores = this.getTotalScores(publishedId, which, true);
        return this.getItemScores(itemId, scores, false);
    }

    @Override
    public Map<Long, List<ItemGradingData>> getItemScores(Long publishedId, Long itemId, String which, boolean loadItemGradingAttachment) {
        List<AssessmentGradingData> scores = this.getTotalScores(publishedId, which, true);
        return this.getItemScores(itemId, scores, loadItemGradingAttachment);
    }

    @Override
    public Map<Long, List<ItemGradingData>> getItemScores(Long itemId, List<AssessmentGradingData> scores, boolean loadItemGradingAttachment) {
        try {
            HashMap<Long, List<ItemGradingData>> map = new HashMap<Long, List<ItemGradingData>>();
            HibernateCallback hcb = session -> {
                Criteria criteria = session.createCriteria(ItemGradingData.class);
                Disjunction disjunction = Expression.disjunction();
                List gradingIdList = scores.stream().map(AssessmentGradingData::getAssessmentGradingId).collect(Collectors.toList());
                for (int i = 0; i < gradingIdList.size(); i += 50) {
                    List tempList;
                    if (i + 50 > gradingIdList.size()) {
                        tempList = gradingIdList.subList(i, gradingIdList.size());
                        disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                        continue;
                    }
                    tempList = gradingIdList.subList(i, i + 50);
                    disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                }
                if (itemId.equals(0L)) {
                    criteria.add((Criterion)disjunction);
                } else {
                    SimpleExpression pubCriterion = Expression.eq((String)"publishedItemId", (Object)itemId);
                    criteria.add((Criterion)Expression.and((Criterion)pubCriterion, (Criterion)disjunction));
                }
                criteria.addOrder(Order.asc((String)"agentId").nulls(NullPrecedence.LAST));
                criteria.addOrder(Order.desc((String)"submittedDate").nulls(NullPrecedence.LAST));
                return criteria.list();
            };
            List temp = (List)this.getHibernateTemplate().execute(hcb);
            Map<Object, Object> attachmentMap = new HashMap();
            if (loadItemGradingAttachment) {
                attachmentMap = this.getItemGradingAttachmentMap(itemId);
            }
            for (ItemGradingData data : temp) {
                List<ItemGradingData> thisone;
                if (loadItemGradingAttachment) {
                    if (attachmentMap.get(data.getItemGradingId()) != null) {
                        data.setItemGradingAttachmentSet((Set)attachmentMap.get(data.getItemGradingId()));
                    } else {
                        data.setItemGradingAttachmentSet(new HashSet());
                    }
                }
                if ((thisone = map.get(data.getPublishedItemId())) == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            map.forEach((k, v) -> Collections.sort(v, new Comparator<ItemGradingData>(){

                @Override
                public int compare(ItemGradingData itg1, ItemGradingData itg2) {
                    return new NullComparator().compare((Object)itg1.getPublishedAnswerId(), (Object)itg2.getPublishedAnswerId());
                }
            }));
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap<Long, List<ItemGradingData>>();
        }
    }

    @Override
    public Map<Long, List<ItemGradingData>> getLastItemGradingData(Long publishedId, String agentId) {
        try {
            HibernateCallback hcb = session -> {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status <> :status and a.status <> :removed order by a.submittedDate DESC");
                q.setParameter("id", (Object)publishedId);
                q.setParameter("agent", (Object)agentId);
                q.setParameter("forgrade", (Object)false);
                q.setParameter("status", (Object)AssessmentGradingData.NO_SUBMISSION);
                q.setParameter("removed", (Object)AssessmentGradingData.REMOVED);
                return q.list();
            };
            List scores = (List)this.getHibernateTemplate().execute(hcb);
            if (scores.isEmpty()) {
                return new HashMap<Long, List<ItemGradingData>>();
            }
            HashMap<Long, List<ItemGradingData>> map = new HashMap<Long, List<ItemGradingData>>();
            AssessmentGradingData gdata = (AssessmentGradingData)scores.get(0);
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            if (gdata.getForGrade().booleanValue()) {
                return new HashMap<Long, List<ItemGradingData>>();
            }
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                List<ItemGradingData> thisone = map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap<Long, List<ItemGradingData>>();
        }
    }

    @Override
    public HashMap getStudentGradingData(String assessmentGradingId) {
        return this.getStudentGradingData(assessmentGradingId, true);
    }

    public HashMap getStudentGradingData(String assessmentGradingId, boolean loadGradingAttachment) {
        try {
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            AssessmentGradingData gdata = this.load(new Long(assessmentGradingId), loadGradingAttachment);
            log.debug("****#6, gdata=" + gdata);
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    @Override
    public Map<Long, List<ItemGradingData>> getSubmitData(Long publishedId, String agentId, Integer scoringoption, Long assessmentGradingId) {
        try {
            HibernateCallback hcb = session -> {
                log.debug("scoringoption = " + scoringoption);
                if (EvaluationModelIfc.LAST_SCORE.equals(scoringoption)) {
                    Query q;
                    if (assessmentGradingId == null) {
                        q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by a.submittedDate DESC");
                        q.setParameter("id", (Object)publishedId);
                        q.setParameter("agent", (Object)agentId);
                        q.setParameter("forgrade", (Object)true);
                        q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                    } else {
                        q = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId = :id");
                        q.setParameter("id", (Object)assessmentGradingId);
                    }
                    return q.list();
                }
                Query q1 = null;
                if (assessmentGradingId == null) {
                    q1 = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by a.finalScore DESC, a.submittedDate DESC");
                    q1.setParameter("id", (Object)publishedId);
                    q1.setParameter("agent", (Object)agentId);
                    q1.setParameter("forgrade", (Object)true);
                    q1.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                } else {
                    q1 = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId = :id");
                    q1.setParameter("id", (Object)assessmentGradingId);
                }
                return q1.list();
            };
            List scores = (List)this.getHibernateTemplate().execute(hcb);
            HashMap<Long, List<ItemGradingData>> map = new HashMap<Long, List<ItemGradingData>>();
            if (scores.isEmpty()) {
                return new HashMap<Long, List<ItemGradingData>>();
            }
            AssessmentGradingData gdata = (AssessmentGradingData)scores.get(0);
            Map<Long, Set<ItemGradingAttachment>> attachmentMap = this.getItemGradingAttachmentMapByAssessmentGradingId(gdata.getAssessmentGradingId());
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                if (attachmentMap.get(data.getItemGradingId()) != null) {
                    data.setItemGradingAttachmentSet(attachmentMap.get(data.getItemGradingId()));
                } else {
                    data.setItemGradingAttachmentSet(new HashSet());
                }
                List<ItemGradingData> thisone = map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap<Long, List<ItemGradingData>>();
        }
    }

    @Override
    public Long add(AssessmentGradingData a) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)a);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem adding assessmentGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        return a.getAssessmentGradingId();
    }

    @Override
    public int getSubmissionSizeOfPublishedAssessment(Long publishedAssessmentId) {
        Number size = (Number)this.getHibernateTemplate().execute(session -> session.createCriteria(AssessmentGradingData.class).add((Criterion)Restrictions.eq((String)"publishedAssessmentId", (Object)publishedAssessmentId)).add((Criterion)Restrictions.eq((String)"forGrade", (Object)true)).setProjection(Projections.rowCount()).uniqueResult());
        return size.intValue();
    }

    @Override
    public Long saveMedia(byte[] media, String mimeType) {
        MediaData mediaData = new MediaData(media, mimeType);
        mediaData.setFileSize(Long.valueOf(media.length));
        return this.saveMedia(mediaData);
    }

    protected SecurityAdvisor pushAdvisor() {
        SecurityAdvisor samigoAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.securityService.pushAdvisor(samigoAdvisor);
        return samigoAdvisor;
    }

    protected void popAdvisor(SecurityAdvisor sa) {
        if (sa == null) {
            throw new IllegalArgumentException("popAdvisor was called with a null SecurityAdvisor");
        }
        this.securityService.popAdvisor(sa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkMediaCollection(String id) {
        SecurityAdvisor resourceAdvisor = this.pushAdvisor();
        try {
            this.contentHostingService.checkCollection(id);
        }
        catch (IdUnusedException | PermissionException | TypeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.popAdvisor(resourceAdvisor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureMediaCollection(String id) {
        SecurityAdvisor resourceAdvisor = this.pushAdvisor();
        try {
            ContentCollection contentCollection = this.contentHostingService.getCollection(id);
        }
        catch (IdUnusedException ie) {
            log.debug("Creating collection: " + id);
            String name = id;
            if (name.endsWith("/")) {
                name = id.substring(0, id.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            try {
                ContentCollectionEdit edit = this.contentHostingService.addCollection(id);
                ResourcePropertiesEdit props = edit.getPropertiesEdit();
                props.addProperty("DAV:displayname", name);
                this.contentHostingService.commitCollection(edit);
            }
            catch (IdInvalidException | IdUsedException | InconsistentException | PermissionException collex) {
                log.warn("[Samigo Media Attachments] Exception while creating collection (" + id + "): " + collex.toString());
                boolean bl = false;
                return bl;
            }
        }
        catch (PermissionException | TypeException e) {
            log.warn("[Samigo Media Attachments] General exception while ensuring collection: " + e.toString());
        }
        finally {
            this.popAdvisor(resourceAdvisor);
        }
        return true;
    }

    protected boolean ensureMediaPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("[Samigo Media Attachments] Relative media paths are not acceptable. (" + path + ")");
        }
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash != 0 && this.checkMediaCollection(path.substring(0, lastSlash + 1))) {
            return true;
        }
        int slash = 1;
        while (slash != lastSlash) {
            if (this.ensureMediaCollection(path.substring(0, (slash = path.indexOf("/", slash + 1)) + 1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String saveMediaToContent(MediaData mediaData) {
        String mediaPath = this.getMediaPath(mediaData);
        if (mediaData.getMedia() != null && this.ensureMediaPath(mediaPath)) {
            log.debug("=====> Saving media: " + mediaPath);
            SecurityAdvisor resourceAdvisor = this.pushAdvisor();
            boolean newResource = true;
            try {
                this.contentHostingService.checkResource(mediaPath);
                newResource = false;
            }
            catch (IdUnusedException | PermissionException | TypeException throwable) {
                // empty catch block
            }
            try {
                ContentResource chsMedia;
                if (newResource) {
                    ContentResourceEdit edit = this.contentHostingService.addResource(mediaPath);
                    edit.setContentType(mediaData.getMimeType());
                    edit.setContent(mediaData.getMedia());
                    ResourcePropertiesEdit props = edit.getPropertiesEdit();
                    props.addProperty("DAV:displayname", mediaData.getFilename());
                    this.contentHostingService.commitResource(edit);
                    chsMedia = this.contentHostingService.getResource(mediaPath);
                } else {
                    chsMedia = this.contentHostingService.updateResource(mediaPath, mediaData.getMimeType(), mediaData.getMedia());
                }
                mediaData.setContentResource(chsMedia);
                String string = mediaPath;
                return string;
            }
            catch (VirusFoundException | IdInvalidException | IdUnusedException | IdUsedException | InUseException | InconsistentException | OverQuotaException | PermissionException | ServerOverloadException | TypeException e) {
                log.warn("Exception while saving media to content: " + e.toString());
            }
            finally {
                this.popAdvisor(resourceAdvisor);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentResource getMediaContentResource(MediaData mediaData) {
        if (mediaData.getContentResource() != null) {
            return mediaData.getContentResource();
        }
        String id = this.getMediaPath(mediaData);
        log.debug("=====> Reading media: " + id);
        if (id != null) {
            SecurityAdvisor resourceAdvisor = this.pushAdvisor();
            try {
                ContentResource res;
                ContentResource contentResource = res = this.contentHostingService.getResource(id);
                return contentResource;
            }
            catch (IdUnusedException ie) {
                log.info("Nonexistent resource when trying to load media (id: " + mediaData.getMediaId() + "): " + id);
            }
            catch (PermissionException | TypeException e) {
                log.debug("Exception while reading media from content (" + mediaData.getMediaId() + "):" + e.toString());
            }
            finally {
                this.popAdvisor(resourceAdvisor);
            }
        }
        return null;
    }

    protected String getMediaPath(MediaData mediaData) {
        String mediaBase = "/private/samigo/";
        String mediaPath = null;
        ItemGradingData itemGrading = mediaData.getItemGradingData();
        if (itemGrading != null) {
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            PublishedAssessmentIfc assessment = this.getPublishedAssessmentByAssessmentGradingId(itemGrading.getAssessmentGradingId());
            String assessmentId = assessment.getPublishedAssessmentId().toString();
            String siteId = publishedAssessmentService.getPublishedAssessmentSiteId(assessmentId);
            String userId = itemGrading.getAgentId();
            String questionId = itemGrading.getPublishedItemId().toString();
            if (questionId != null && assessmentId != null) {
                mediaPath = mediaBase + siteId + "/" + assessmentId + "/" + userId + "/" + questionId + "_" + mediaData.getFilename();
            }
        }
        return mediaPath;
    }

    @Override
    public Long saveMedia(MediaData mediaData) {
        log.debug("****" + mediaData.getFilename() + " saving media...size=" + mediaData.getFileSize() + " " + new Date());
        int retryCount = this.persistenceHelper.getRetryCount();
        this.getMediaPath(mediaData);
        while (retryCount > 0) {
            try {
                this.saveMediaToContent(mediaData);
                this.getHibernateTemplate().saveOrUpdate((Object)mediaData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving media: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        log.debug("****" + mediaData.getFilename() + " saved media." + new Date());
        return mediaData.getMediaId();
    }

    @Override
    public void removeMediaById(Long mediaId) {
        this.removeMediaById(mediaId, null);
    }

    @Override
    public void removeMediaById(Long mediaId, Long itemGradingId) {
        File mediaFile;
        String mediaLocation = null;
        String mediaFilename = null;
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                MediaData mediaData = this.getMedia(mediaId);
                mediaLocation = mediaData.getLocation();
                mediaFilename = mediaData.getFilename();
                this.getHibernateTemplate().delete((Object)mediaData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("Problem deleting media with Id {}", (Object)mediaId);
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        if (mediaLocation != null && (mediaFile = new File(mediaLocation)).delete()) {
            log.warn("problem removing file. mediaLocation = {}", (Object)mediaLocation);
        }
        if (itemGradingId != null) {
            ItemGradingData itemGradingData = this.getItemGrading(itemGradingId);
            itemGradingData.setAutoScore(Double.valueOf(0.0));
            this.saveItemGrading(itemGradingData);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.attachment.delete", (String)("itemGradingId=" + itemGradingData.getItemGradingId() + ", " + mediaFilename), null, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
        }
    }

    @Override
    public MediaData getMedia(Long mediaId) {
        MediaData mediaData = (MediaData)this.getHibernateTemplate().load(MediaData.class, (Serializable)mediaId);
        if (mediaData.getLocation() == null) {
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
        }
        return mediaData;
    }

    @Override
    public List<MediaData> getMediaArray(Long itemGradingId) {
        log.debug("*** itemGradingId =" + itemGradingId);
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from MediaData m where m.itemGradingData.itemGradingId = :id");
            q.setParameter("id", (Object)itemGradingId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        for (MediaData mediaData : list) {
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public List<MediaData> getMediaArray2(Long itemGradingId) {
        log.debug("*** itemGradingId =" + itemGradingId);
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new MediaData(m.mediaId, m.filename, m.fileSize, m.duration, m.createdDate)  from MediaData m where m.itemGradingData.itemGradingId = :id");
            q.setParameter("id", (Object)itemGradingId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        for (MediaData mediaData : list) {
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public Map<Long, List<ItemGradingData>> getMediaItemGradingHash(Long assessmentGradingId) {
        log.debug("*** assessmentGradingId = {}", (Object)assessmentGradingId);
        HashMap<Long, List<ItemGradingData>> map = new HashMap<Long, List<ItemGradingData>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select i from MediaData m, ItemGradingData i where m.itemGradingData.itemGradingId = i.itemGradingId and i.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        for (ItemGradingData itemGradingData : list) {
            ArrayList<ItemGradingData> al = new ArrayList<ItemGradingData>();
            al.add(itemGradingData);
            map.put(itemGradingData.getPublishedItemId(), al);
        }
        log.debug("*** no. of media = {}", (Object)map.size());
        return map;
    }

    public ArrayList getMediaArray(ItemGradingData item) {
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        List list = this.getHibernateTemplate().findByNamedParam("from MediaData m where m.itemGradingData = :id", "id", (Object)item);
        for (int i = 0; i < list.size(); ++i) {
            MediaData mediaData = (MediaData)list.get(i);
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public List<MediaData> getMediaArray(Long publishedId, Long publishedItemId, String which) {
        try {
            Map<Long, List<ItemGradingData>> itemScores = this.getItemScores(publishedId, publishedItemId, which);
            List<ItemGradingData> list = itemScores.get(publishedItemId);
            log.debug("list size list.size() = " + list.size());
            HibernateCallback hcb = session -> {
                Criteria criteria = session.createCriteria(MediaData.class);
                Disjunction disjunction = Expression.disjunction();
                List itemGradingIdList = list.stream().map(ItemGradingData::getItemGradingId).collect(Collectors.toList());
                for (int i = 0; i < itemGradingIdList.size(); i += 50) {
                    List tempList;
                    if (i + 50 > itemGradingIdList.size()) {
                        tempList = itemGradingIdList.subList(i, itemGradingIdList.size());
                        disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                        continue;
                    }
                    tempList = itemGradingIdList.subList(i, i + 50);
                    disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                }
                criteria.add((Criterion)disjunction);
                return criteria.list();
            };
            ArrayList<MediaData> a = new ArrayList<MediaData>();
            List hbmList = (List)this.getHibernateTemplate().execute(hcb);
            for (MediaData mediaData : hbmList) {
                mediaData.setContentResource(this.getMediaContentResource(mediaData));
                a.add(mediaData);
            }
            return a;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new ArrayList<MediaData>();
        }
    }

    @Override
    public List<Long> getMediaConversionBatch() {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("SELECT id FROM MediaData WHERE dbMedia IS NOT NULL AND location IS NULL");
            q.setMaxResults(10);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean markMediaForConversion(List<Long> mediaIds) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("UPDATE MediaData SET location = 'CONVERTING' WHERE id in (:ids)");
            q.setParameterList("ids", (Collection)mediaIds);
            return q.executeUpdate();
        };
        return ((Integer)this.getHibernateTemplate().execute(hcb)).equals(mediaIds.size());
    }

    @Override
    public List<Long> getMediaWithDataAndLocation() {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("SELECT id FROM MediaData WHERE dbMedia IS NOT NULL AND location IS NOT NULL");
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<Long> getMediaInConversion() {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("SELECT id FROM MediaData WHERE location = 'CONVERTING'");
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public ItemGradingData getLastItemGradingDataByAgent(Long publishedItemId, String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingData i where i.publishedItemId = :id and i.agentId = :agent");
            q.setParameter("id", (Object)publishedItemId);
            q.setParameter("agent", (Object)agentId);
            return q.list();
        };
        List itemGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public ItemGradingData getItemGradingData(Long itemGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingData i where i.itemGradingId = :id");
            q.setParameter("id", (Object)itemGradingId);
            return q.list();
        };
        List itemGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public ItemGradingData getItemGradingData(Long assessmentGradingId, Long publishedItemId) {
        log.debug("****assessmentGradingId={}", (Object)assessmentGradingId);
        log.debug("****publishedItemId={}", (Object)publishedItemId);
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId = :gradingid and i.publishedItemId = :itemid");
            q.setParameter("gradingid", (Object)assessmentGradingId);
            q.setParameter("itemid", (Object)publishedItemId);
            return q.list();
        };
        List itemGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public AssessmentGradingData load(Long id) {
        return this.load(id, true);
    }

    @Override
    public AssessmentGradingData load(Long id, boolean loadGradingAttachment) {
        AssessmentGradingData gdata = (AssessmentGradingData)this.getHibernateTemplate().load(AssessmentGradingData.class, (Serializable)id);
        HashSet<ItemGradingData> itemGradingSet = new HashSet<ItemGradingData>();
        Map<Long, ItemGradingData> itemGradingMap = this.getItemGradingMap(gdata.getAssessmentGradingId());
        if (itemGradingMap.keySet().size() > 0) {
            Collection<ItemGradingData> itemGradingCollection = itemGradingMap.values();
            if (loadGradingAttachment) {
                Map<Long, Set<ItemGradingAttachment>> attachmentMap = this.getItemGradingAttachmentMap(itemGradingMap.keySet());
                for (ItemGradingData itemGradingData : itemGradingCollection) {
                    if (attachmentMap.get(itemGradingData.getItemGradingId()) != null) {
                        itemGradingData.setItemGradingAttachmentSet(attachmentMap.get(itemGradingData.getItemGradingId()));
                    } else {
                        itemGradingData.setItemGradingAttachmentSet(new HashSet());
                    }
                    itemGradingSet.add(itemGradingData);
                }
            } else {
                itemGradingSet.addAll(itemGradingCollection);
            }
        }
        gdata.setItemGradingSet(itemGradingSet);
        return gdata;
    }

    @Override
    public ItemGradingData getItemGrading(Long id) {
        return (ItemGradingData)this.getHibernateTemplate().load(ItemGradingData.class, (Serializable)id);
    }

    @Override
    public AssessmentGradingData getLastSavedAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status not in (:status1, :status2) order by a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)false);
            q.setParameter("status1", (Object)AssessmentGradingData.NO_SUBMISSION);
            q.setParameter("status2", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getLastSubmittedAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString, Long assessmentGradingId) {
        AssessmentGradingData ag;
        block5: {
            List assessmentGradings;
            block4: {
                ag = null;
                HibernateCallback hcb = session -> {
                    Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by a.submittedDate desc");
                    q.setParameter("id", (Object)publishedAssessmentId);
                    q.setParameter("agent", (Object)agentIdString);
                    q.setParameter("forgrade", (Object)true);
                    q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                    return q.list();
                };
                assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
                if (assessmentGradingId != null) break block4;
                if (assessmentGradings.size() <= 0) break block5;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block5;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        if (ag != null) {
            Map<Long, List<AssessmentGradingAttachment>> map = this.getAssessmentGradingAttachmentMap(publishedAssessmentId);
            List<AssessmentGradingAttachment> attachments = map.get(ag.getAssessmentGradingId());
            if (attachments != null) {
                ag.setAssessmentGradingAttachmentList(attachments);
            } else {
                ag.setAssessmentGradingAttachmentList(new ArrayList());
            }
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getLastAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.status > :status order by a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public void saveItemGrading(ItemGradingData item) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving itemGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public boolean saveOrUpdateAssessmentGrading(AssessmentGradingData assessment) {
        int retryCount = this.persistenceHelper.getRetryCount();
        boolean success = false;
        while (retryCount > 0) {
            try {
                if (assessment.getAssessmentGradingId() != null) {
                    this.getHibernateTemplate().merge((Object)assessment);
                } else {
                    this.getHibernateTemplate().save((Object)assessment);
                }
                retryCount = 0;
                success = true;
            }
            catch (Exception e) {
                log.warn("problem inserting/updating assessmentGrading: {}", (Object)e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        return success;
    }

    @Override
    public List<Long> getAssessmentGradingIds(Long publishedItemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select g.assessmentGradingId from ItemGradingData g where g.publishedItemId = :id");
            q.setParameter("id", (Object)publishedItemId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public AssessmentGradingData getHighestAssessmentGrading(Long publishedAssessmentId, String agentId) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and  a.agentId = :agent and a.status > :status order by a.finalScore desc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getHighestSubmittedAssessmentGrading(Long publishedAssessmentId, String agentId, Long assessmentGradingId) {
        AssessmentGradingData ag;
        block4: {
            List assessmentGradings;
            block3: {
                ag = null;
                HibernateCallback hcb = session -> {
                    Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and  a.forGrade = :forgrade and a.status > :status order by a.finalScore desc, a.submittedDate desc");
                    q.setParameter("id", (Object)publishedAssessmentId);
                    q.setParameter("agent", (Object)agentId);
                    q.setParameter("forgrade", (Object)true);
                    q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                    return q.list();
                };
                assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
                if (assessmentGradingId != null) break block3;
                if (assessmentGradings.size() <= 0) break block4;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block4;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        List<Object> attachments = new ArrayList();
        if (ag != null) {
            Map<Long, List<AssessmentGradingAttachment>> map = this.getAssessmentGradingAttachmentMap(publishedAssessmentId);
            if (map != null && map.containsKey(ag.getAssessmentGradingId())) {
                attachments = map.get(ag.getAssessmentGradingId());
            }
            ag.setAssessmentGradingAttachmentList(attachments);
        }
        return ag;
    }

    @Override
    public List getLastAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.status > :status order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public List getLastSubmittedAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a from AssessmentGradingData a left join fetch a.assessmentGradingAttachmentSet where a.publishedAssessmentId = :id and a.forGrade = :forgrade and a.status > :status order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public List getLastSubmittedOrGradedAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createCriteria(AssessmentGradingData.class).add((Criterion)Restrictions.eq((String)"publishedAssessmentId", (Object)publishedAssessmentId)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"forGrade", (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"forGrade", (Object)false), (Criterion)Restrictions.eq((String)"status", (Object)AssessmentGradingData.NO_SUBMISSION)))).addOrder(Order.asc((String)"agentId").nulls(NullPrecedence.LAST)).addOrder(Order.desc((String)"submittedDate").nulls(NullPrecedence.LAST)).list();
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public List<AssessmentGradingData> getHighestAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.status > :status order by a.agentId asc, a.finalScore desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public List<AssessmentGradingData> getHighestSubmittedOrGradedAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createCriteria(AssessmentGradingData.class).add((Criterion)Restrictions.eq((String)"publishedAssessmentId", (Object)publishedAssessmentId)).add((Criterion)Restrictions.gt((String)"status", (Object)AssessmentGradingData.REMOVED)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"forGrade", (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"forGrade", (Object)false), (Criterion)Restrictions.eq((String)"status", (Object)AssessmentGradingData.NO_SUBMISSION)))).addOrder(Order.asc((String)"agentId").nulls(NullPrecedence.LAST)).addOrder(Order.desc((String)"finalScore").nulls(NullPrecedence.LAST)).list();
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public Map<Long, List<Long>> getLastAssessmentGradingByPublishedItem(Long publishedAssessmentId) {
        HashMap<Long, List<Long>> h = new HashMap<Long, List<Long>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId = :id and a.status > :status  order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore());
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                List o = (List)h.get(itemId);
                if (o != null) {
                    o.add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    @Override
    public Map<Long, List<Long>> getHighestAssessmentGradingByPublishedItem(Long publishedAssessmentId) {
        HashMap<Long, List<Long>> h = new HashMap<Long, List<Long>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a,  PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId = :id and a.status > :status  order by a.agentId asc, a.finalScore desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        String currentAgent = "";
        Double finalScore = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore());
            if (i == 0) {
                currentAgent = g.getAgentId();
                finalScore = g.getFinalScore();
            }
            if (currentAgent.equals(g.getAgentId()) && (finalScore == null && g.getFinalScore() == null || finalScore != null && finalScore.equals(g.getFinalScore()))) {
                List o = (List)h.get(itemId);
                if (o != null) {
                    o.add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            finalScore = g.getFinalScore();
        }
        return h;
    }

    @Override
    public Set<ItemGradingData> getItemGradingSet(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        List itemGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new HashSet<ItemGradingData>(itemGradings);
    }

    public Map<Long, ItemGradingData> getItemGradingMap(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        List itemGradingList = (List)this.getHibernateTemplate().execute(hcb);
        return itemGradingList.stream().collect(Collectors.toMap(ItemGradingData::getItemGradingId, p -> p));
    }

    @Override
    public Map<Long, AssessmentGradingData> getAssessmentGradingByItemGradingId(Long publishedAssessmentId) {
        Map<Long, AssessmentGradingData> submissionDataMap = this.getAllSubmissions(publishedAssessmentId.toString()).stream().filter(Objects::nonNull).collect(Collectors.toMap(AssessmentGradingData::getAssessmentGradingId, a -> a));
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new ItemGradingData(i.itemGradingId, a.assessmentGradingId)  from ItemGradingData i, AssessmentGradingData a  where i.assessmentGradingId = a.assessmentGradingId  and a.publishedAssessmentId = :id  and a.forGrade = :forgrade and a.status > :status ");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List l = (List)this.getHibernateTemplate().execute(hcb);
        return l.stream().filter(i -> Objects.nonNull(submissionDataMap.get(i.getAssessmentGradingId()))).collect(Collectors.toMap(ItemGradingData::getItemGradingId, g -> (AssessmentGradingData)submissionDataMap.get(g.getAssessmentGradingId())));
    }

    @Override
    public void deleteAll(Collection c) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                c.stream().filter(Objects::nonNull).map(arg_0 -> ((HibernateTemplate)this.getHibernateTemplate()).merge(arg_0)).forEach(arg_0 -> ((HibernateTemplate)this.getHibernateTemplate()).delete(arg_0));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem inserting assessmentGrading: {}", (Object)e.toString());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAll(Collection<ItemGradingData> c) {
        int retryCount = this.persistenceHelper.getRetryCount();
        c.removeAll(Collections.singleton(null));
        while (retryCount > 0) {
            try {
                for (ItemGradingData itemGradingData : c) {
                    this.getHibernateTemplate().merge((Object)itemGradingData);
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem inserting assessmentGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByAssessmentGradingId(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select p from PublishedAssessmentData p, AssessmentGradingData a where a.publishedAssessmentId = p.publishedAssessmentId and a.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        List pubList = (List)this.getHibernateTemplate().execute(hcb);
        if (pubList != null && !pubList.isEmpty()) {
            return (PublishedAssessmentIfc)pubList.get(0);
        }
        return null;
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByPublishedItemId(Long publishedItemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select p from PublishedAssessmentData p, PublishedItemData i where p.publishedAssessmentId = i.section.assessment.publishedAssessmentId and i.itemId = :id");
            q.setParameter("id", (Object)publishedItemId);
            return q.list();
        };
        List pubList = (List)this.getHibernateTemplate().execute(hcb);
        if (pubList != null && !pubList.isEmpty()) {
            return (PublishedAssessmentIfc)pubList.get(0);
        }
        return null;
    }

    @Override
    public List<Integer> getLastItemGradingDataPosition(Long assessmentGradingId, String agentId) {
        ArrayList<Integer> position = new ArrayList<Integer>();
        try {
            HibernateCallback hcb = session -> {
                Query q = session.createQuery("select s.sequence  from ItemGradingData i, PublishedItemData pi, PublishedSectionData s  where i.agentId = :agent and i.assessmentGradingId = :id  and pi.itemId = i.publishedItemId  and pi.section.id = s.id  group by i.publishedItemId, s.sequence, pi.sequence  order by s.sequence desc , pi.sequence desc");
                q.setParameter("agent", (Object)agentId);
                q.setParameter("id", (Object)assessmentGradingId);
                return q.list();
            };
            List list = (List)this.getHibernateTemplate().execute(hcb);
            if (list.isEmpty()) {
                position.add(0);
                position.add(0);
            } else {
                Integer sequence = (Integer)list.get(0);
                int count = 1;
                for (int i = 1; i < list.size(); ++i) {
                    log.debug("i = {}", (Object)i);
                    Integer nextSequence = (Integer)list.get(i);
                    if (!sequence.equals(nextSequence)) break;
                    log.debug("equal");
                    ++count;
                }
                log.debug("sequence = " + sequence);
                log.debug("count = " + count);
                position.add(sequence);
                position.add(count);
            }
            return position;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            position.add(0);
            position.add(0);
            return position;
        }
    }

    @Override
    public List<Long> getPublishedItemIds(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select i.publishedItemId from ItemGradingData i where i.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<Long> getItemGradingIds(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select i.itemGradingId from ItemGradingData i where i.assessmentGradingId = :id");
            q.setParameter("id", (Object)assessmentGradingId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public Set<PublishedItemData> getItemSet(Long publishedAssessmentId, Long sectionId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select distinct p.itemId from PublishedItemData p, AssessmentGradingData a, ItemGradingData i where a.publishedAssessmentId = :id and a.forGrade = :forgrade and p.section.id = :sectionid and i.assessmentGradingId = a.assessmentGradingId and p.itemId = i.publishedItemId and a.status > :status ");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("sectionid", (Object)sectionId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List itemIds = (List)this.getHibernateTemplate().execute(hcb);
        if (itemIds.isEmpty()) {
            return new HashSet<PublishedItemData>();
        }
        HibernateCallback hcb2 = session -> {
            Criteria criteria = session.createCriteria(PublishedItemData.class);
            if (itemIds.size() > 1000) {
                HashSet<Long> ids = new HashSet<Long>();
                Disjunction disjunction = Restrictions.disjunction();
                for (Long id : itemIds) {
                    if (ids.size() < 1000) {
                        ids.add(id);
                        continue;
                    }
                    criteria.add((Criterion)disjunction.add(Restrictions.in((String)"itemId", ids)));
                    ids.clear();
                }
            } else {
                criteria.add(Restrictions.in((String)"itemId", (Collection)itemIds));
            }
            return criteria.list();
        };
        List publishedItems = (List)this.getHibernateTemplate().execute(hcb2);
        return new HashSet<PublishedItemData>(publishedItems);
    }

    @Override
    public Long getTypeId(Long itemGradingId) {
        Long typeId = -1L;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select p.typeId from PublishedItemData p, ItemGradingData i where i.itemGradingId = :id and p.itemId = i.publishedItemId ");
            q.setParameter("id", (Object)itemGradingId);
            return q.list();
        };
        List typeIds = (List)this.getHibernateTemplate().execute(hcb);
        if (typeIds != null) {
            Iterator iterator = typeIds.iterator();
            while (iterator.hasNext()) {
                Long id;
                typeId = id = (Long)iterator.next();
                log.debug("typeId = {}", (Object)typeId);
            }
        }
        return typeId;
    }

    @Override
    public List<AssessmentGradingData> getAllAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<ItemGradingData> getAllItemGradingDataForItemInGrading(Long assesmentGradingId, Long publishedItemId) {
        if (assesmentGradingId == null) {
            throw new IllegalArgumentException("assesmentGradingId cant' be null");
        }
        if (publishedItemId == null) {
            throw new IllegalArgumentException("publishedItemId cant' be null");
        }
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(ItemGradingData.class).add((Criterion)Restrictions.eq((String)"assessmentGradingId", (Object)assesmentGradingId)).add((Criterion)Restrictions.eq((String)"publishedItemId", (Object)publishedItemId)).list());
    }

    @Override
    public Map<Long, Map<String, Integer>> getSiteSubmissionCountHash(String siteId) {
        HashMap<Long, Map<String, Integer>> siteSubmissionCountHash = new HashMap<Long, Map<String, Integer>>();
        HibernateCallback hcb = session -> session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade = :forgrade and au.functionId = :fid and au.agentIdString = :agent and a.publishedAssessmentId = au.qualifierId and a.status > :status group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ").setParameter("forgrade", (Object)true).setParameter("fid", (Object)"OWN_PUBLISHED_ASSESSMENT").setParameter("agent", (Object)siteId).setParameter("status", (Object)AssessmentGradingData.REMOVED).setCacheable(true).list();
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<String, Integer> numberSubmissionPerStudentHash = new HashMap<String, Integer>();
        Long lastPublishedAssessmentId = -1L;
        for (Object[] o : countList) {
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberSubmissionPerStudentHash.put((String)o[1], ((Long)o[2]).intValue());
                continue;
            }
            numberSubmissionPerStudentHash = new HashMap();
            numberSubmissionPerStudentHash.put((String)o[1], ((Long)o[2]).intValue());
            siteSubmissionCountHash.put(publishedAssessmentid, numberSubmissionPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteSubmissionCountHash;
    }

    @Override
    public Map<Long, Map<String, Long>> getSiteInProgressCountHash(String siteId) {
        HashMap<Long, Map<String, Long>> siteInProgressCountHash = new HashMap<Long, Map<String, Long>>();
        HibernateCallback hcb = session -> session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade = :forgrade and au.functionId = :fid and au.agentIdString = :agent and a.publishedAssessmentId = au.qualifierId and (a.status = :status1 or a.status = :status2) group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ").setParameter("forgrade", (Object)false).setParameter("fid", (Object)"OWN_PUBLISHED_ASSESSMENT").setParameter("agent", (Object)siteId).setParameter("status1", (Object)AssessmentGradingData.IN_PROGRESS).setParameter("status2", (Object)AssessmentGradingData.ASSESSMENT_UPDATED).setCacheable(true).list();
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<String, Long> numberInProgressPerStudentHash = new HashMap<String, Long>();
        Long lastPublishedAssessmentId = -1L;
        for (Object[] o : countList) {
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberInProgressPerStudentHash.put((String)o[1], (Long)o[2]);
                continue;
            }
            numberInProgressPerStudentHash = new HashMap();
            numberInProgressPerStudentHash.put((String)o[1], (Long)o[2]);
            siteInProgressCountHash.put(publishedAssessmentid, numberInProgressPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteInProgressCountHash;
    }

    @Override
    public int getActualNumberRetake(Long publishedAssessmentId, String agentIdString) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate and a.status > :status");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        if (countList != null && !countList.isEmpty()) {
            return Math.toIntExact((Long)countList.get(0));
        }
        return 0;
    }

    @Override
    public Map<Long, Map<String, Long>> getSiteActualNumberRetakeHash(String siteId) {
        HashMap<Long, Map<String, Long>> actualNumberRetakeHash = new HashMap<Long, Map<String, Long>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*)  from AssessmentGradingData a, StudentGradingSummaryData s, AuthorizationData au, PublishedAssessmentData p  where a.forGrade = :forgrade and au.functionId = :fid and au.agentIdString = :agent and a.publishedAssessmentId = au.qualifierId and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate and a.publishedAssessmentId = p.publishedAssessmentId and p.status != 2 and a.status > :astatus group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId");
            q.setParameter("forgrade", (Object)true);
            q.setParameter("fid", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("astatus", (Object)AssessmentGradingData.REMOVED);
            q.setParameter("agent", (Object)siteId);
            return q.list();
        };
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<String, Long> actualNumberRetakePerStudentHash = new HashMap<String, Long>();
        Long lastPublishedAssessmentId = -1L;
        for (Object[] o : countList) {
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                actualNumberRetakePerStudentHash.put((String)o[1], (Long)o[2]);
                continue;
            }
            actualNumberRetakePerStudentHash = new HashMap();
            actualNumberRetakePerStudentHash.put((String)o[1], (Long)o[2]);
            actualNumberRetakeHash.put(publishedAssessmentid, actualNumberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return actualNumberRetakeHash;
    }

    @Override
    public Map<Long, Integer> getActualNumberRetakeHash(String agentIdString) {
        HashMap<Long, Integer> actualNumberRetakeHash = new HashMap<Long, Integer>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.agentId = :agent and a.forGrade = :forgrade  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate and a.status > :status group by a.publishedAssessmentId");
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        for (Object[] o : countList) {
            Long l = (Long)o[1];
            actualNumberRetakeHash.put((Long)o[0], l.intValue());
        }
        return actualNumberRetakeHash;
    }

    @Override
    public List<StudentGradingSummaryData> getStudentGradingSummaryData(Long publishedAssessmentId, String agentIdString) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s from StudentGradingSummaryData s where s.publishedAssessmentId = :id and s.agentId = :agent");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public int getNumberRetake(Long publishedAssessmentId, String agentIdString) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s.numberRetake from StudentGradingSummaryData s where s.publishedAssessmentId = :id and s.agentId = :agent");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            return q.list();
        };
        List numberRetakeList = (List)this.getHibernateTemplate().execute(hcb);
        if (!numberRetakeList.isEmpty()) {
            return (Integer)numberRetakeList.get(0);
        }
        return 0;
    }

    @Override
    public Map<Long, StudentGradingSummaryData> getNumberRetakeHash(String agentIdString) {
        HashMap h = new HashMap();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s from StudentGradingSummaryData s where s.agentId = :agent");
            q.setParameter("agent", (Object)agentIdString);
            return q.list();
        };
        List numberRetakeList = (List)this.getHibernateTemplate().execute(hcb);
        return numberRetakeList.stream().collect(Collectors.toMap(StudentGradingSummaryData::getPublishedAssessmentId, Function.identity(), (oldValue, newValue) -> newValue));
    }

    @Override
    public Map<Long, Map<String, Integer>> getSiteNumberRetakeHash(String siteId) {
        HashMap<Long, Map<String, Integer>> siteNumberRetakeHash = new HashMap<Long, Map<String, Integer>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s from StudentGradingSummaryData s, AuthorizationData au where au.functionId = :fid and au.agentIdString = :agent and s.publishedAssessmentId = au.qualifierId order by s.publishedAssessmentId, s.agentId");
            q.setParameter("fid", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("agent", (Object)siteId);
            return q.list();
        };
        List countList = (List)this.getHibernateTemplate().execute(hcb);
        Long lastPublishedAssessmentId = -1L;
        HashMap<String, Integer> numberRetakePerStudentHash = null;
        for (StudentGradingSummaryData s : countList) {
            Long publishedAssessmentid = s.getPublishedAssessmentId();
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
                continue;
            }
            numberRetakePerStudentHash = new HashMap<String, Integer>();
            numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
            siteNumberRetakeHash.put(publishedAssessmentid, numberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteNumberRetakeHash;
    }

    @Override
    public void saveStudentGradingSummaryData(StudentGradingSummaryIfc studentGradingSummaryData) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)studentGradingSummaryData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving studentGradingSummaryData: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public int getLateSubmissionsNumberByAgentId(Long publishedAssessmentId, String agentIdString, Date dueDate) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.submittedDate > :submitted and a.status > :status");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("submitted", (Object)dueDate);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return assessmentGradings.size();
    }

    public List<AssessmentGradingData> getAllOrderedSubmissions(String publishedId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and (a.forGrade = :forgrade1 or (a.forGrade = :forgrade2 and a.status = :status and a.finalScore <> 0)) order by a.agentId ASC, a.submittedDate");
            q.setParameter("id", (Object)Long.parseLong(publishedId));
            q.setParameter("forgrade1", (Object)true);
            q.setParameter("forgrade2", (Object)false);
            q.setParameter("status", (Object)AssessmentGradingData.NO_SUBMISSION);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List getExportResponsesData(String publishedAssessmentId, boolean anonymous, String audioMessage, String fileUploadMessage, String noSubmissionMessage, boolean showPartAndTotalScoreSpreadsheetColumns, String poolString, String partString, String questionString, String textString, String rationaleString, String itemGradingCommentsString, Map useridMap, String responseCommentString) {
        ArrayList<Object> responseList;
        ArrayList dataList = new ArrayList();
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList<ArrayList<Object>> finalList = new ArrayList<ArrayList<Object>>(2);
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        Set<PublishedSectionData> publishedAssessmentSections = pubService.getSectionSetForAssessment(Long.valueOf(publishedAssessmentId));
        Double zeroDouble = 0.0;
        Map<Long, AnswerIfc> publishedAnswerHash = pubService.preparePublishedAnswerHash(pubService.getPublishedAssessment(publishedAssessmentId));
        Map<Long, ItemTextIfc> publishedItemTextHash = pubService.preparePublishedItemTextHash(pubService.getPublishedAssessment(publishedAssessmentId));
        Map<Long, ItemDataIfc> publishedItemHash = pubService.preparePublishedItemHash(pubService.getPublishedAssessment(publishedAssessmentId));
        TreeSet<ItemDataIfc> publishItemSet = new TreeSet<ItemDataIfc>(new ItemComparator());
        publishItemSet.addAll(publishedItemHash.values());
        int numSubmission = 1;
        String lastAgentId = "";
        String agentEid = "";
        String firstName = "";
        String lastName = "";
        HashSet useridSet = new HashSet(useridMap.keySet());
        boolean fistItemGradingData = true;
        List<AssessmentGradingData> list = this.getAllOrderedSubmissions(publishedAssessmentId);
        Iterator<AssessmentGradingData> assessmentGradingIter = list.iterator();
        while (assessmentGradingIter.hasNext()) {
            Iterator<PublishedSectionData> sectionsIter = publishedAssessmentSections.iterator();
            HashMap sectionItems = new HashMap();
            TreeMap<Integer, Double> sectionScores = new TreeMap<Integer, Double>();
            while (sectionsIter.hasNext()) {
                PublishedSectionData publishedSection = sectionsIter.next();
                ArrayList itemsArray = publishedSection.getItemArraySortedForGrading();
                Iterator itemsIter = itemsArray.iterator();
                HashMap<Long, Long> itemsForSection = new HashMap<Long, Long>();
                while (itemsIter.hasNext()) {
                    ItemDataIfc item = (ItemDataIfc)itemsIter.next();
                    itemsForSection.put(item.getItemId(), item.getItemId());
                }
                sectionItems.put(publishedSection.getSequence(), itemsForSection);
                sectionScores.put(publishedSection.getSequence(), zeroDouble);
            }
            AssessmentGradingData assessmentGradingData = assessmentGradingIter.next();
            String agentId = assessmentGradingData.getAgentId();
            responseList = new ArrayList<Object>();
            boolean canBeExported = false;
            if (anonymous) {
                canBeExported = true;
                responseList.add(assessmentGradingData.getAssessmentGradingId());
            } else if (useridMap.containsKey(assessmentGradingData.getAgentId())) {
                useridSet.remove(assessmentGradingData.getAgentId());
                canBeExported = true;
                try {
                    agentEid = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getEid();
                    firstName = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getFirstName();
                    lastName = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getLastName();
                }
                catch (Exception e) {
                    log.error("Cannot get user");
                }
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                if (assessmentGradingData.getForGrade().booleanValue()) {
                    if (lastAgentId.equals(agentId)) {
                        ++numSubmission;
                    } else {
                        numSubmission = 1;
                        lastAgentId = agentId;
                    }
                } else {
                    numSubmission = 0;
                    lastAgentId = agentId;
                }
                String numSubmissionText = numSubmission == 0 ? noSubmissionMessage : String.valueOf(numSubmission);
                responseList.add(numSubmissionText);
            }
            if (!canBeExported) continue;
            Date attempt = assessmentGradingData.getAttemptDate();
            Date submitted = assessmentGradingData.getSubmittedDate();
            responseList.add(attempt == null ? "" : attempt);
            responseList.add(submitted == null ? "" : submitted);
            int sectionScoreColumnStart = responseList.size();
            if (showPartAndTotalScoreSpreadsheetColumns) {
                Double finalScore = assessmentGradingData.getFinalScore();
                if (finalScore != null) {
                    responseList.add(finalScore);
                } else {
                    log.debug("finalScore is NULL");
                    responseList.add(0.0);
                }
            }
            String assessmentGradingComments = "";
            if (assessmentGradingData.getComments() != null) {
                assessmentGradingComments = assessmentGradingData.getComments().replaceAll("<br\\s*/>", "");
            }
            responseList.add(assessmentGradingComments);
            Long assessmentGradingId = assessmentGradingData.getAssessmentGradingId();
            HashMap studentGradingMap = this.getStudentGradingData(assessmentGradingData.getAssessmentGradingId().toString(), false);
            ArrayList<Object> grades = new ArrayList<Object>();
            grades.addAll(studentGradingMap.values());
            Collections.sort(grades, new QuestionComparator(publishedItemHash));
            if (grades.size() < publishItemSet.size()) {
                int index = -1;
                for (Object e : publishItemSet) {
                    PublishedItemData pid = (PublishedItemData)e;
                    if (++index != grades.size() && ((ItemGradingData)((List)grades.get(index)).get(0)).getPublishedItemId().longValue() == pid.getItemId().longValue()) continue;
                    ArrayList<EmptyItemGrading> newList = new ArrayList<EmptyItemGrading>();
                    newList.add(new EmptyItemGrading(pid.getSection().getSequence(), pid.getItemId(), pid.getSequence()));
                    grades.add(index, newList);
                }
            }
            int questionNumber = 0;
            for (Object e : grades) {
                void var67_72;
                Integer sectionSequenceNumber;
                List l = (List)e;
                if (l.size() > 1) {
                    Collections.sort(l, new AnswerComparator(publishedAnswerHash));
                }
                Object maintext = "";
                String rationale = "";
                String responseComment = "";
                boolean addRationale = false;
                boolean addResponseComment = false;
                boolean matrixChoices = false;
                TreeMap<Long, String> responsesMap = new TreeMap<Long, String>();
                int count = 0;
                ItemGradingData grade = null;
                boolean isFinFib = false;
                double itemScore = 0.0;
                TreeMap<Long, Object> emiAnswerText = new TreeMap<Long, Object>();
                for (Object e2 : l) {
                    PublishedItemData pid;
                    ItemTextIfc itemTextIfc;
                    AnswerIfc answer;
                    Long sequence;
                    String temptext;
                    Object thistext;
                    Long answerid;
                    grade = (ItemGradingData)e2;
                    if (grade == null || EmptyItemGrading.class.isInstance(grade)) continue;
                    if (grade.getAutoScore() != null) {
                        itemScore += grade.getAutoScore().doubleValue();
                    }
                    log.debug("<br> " + grade.getPublishedItemId() + " " + grade.getRationale() + " " + grade.getAnswerText() + " " + grade.getComments() + " " + grade.getReview());
                    Long publishedItemId = grade.getPublishedItemId();
                    ItemDataIfc publishedItemData = publishedItemHash.get(publishedItemId);
                    Long typeId = publishedItemData.getTypeId();
                    questionNumber = publishedItemData.getSequence();
                    if (typeId.equals(TypeIfc.FILL_IN_BLANK) || typeId.equals(TypeIfc.FILL_IN_NUMERIC) || typeId.equals(TypeIfc.CALCULATED_QUESTION)) {
                        String temptext2;
                        AnswerIfc answer2;
                        log.debug("FILL_IN_BLANK, FILL_IN_NUMERIC");
                        isFinFib = true;
                        answerid = grade.getPublishedAnswerId();
                        Long sequence2 = null;
                        if (answerid != null && (answer2 = publishedAnswerHash.get(answerid)) != null) {
                            sequence2 = answer2.getSequence();
                        }
                        if ((temptext2 = grade.getAnswerText()) == null) {
                            temptext2 = "No Answer";
                        }
                        thistext = sequence2 + ": " + temptext2;
                        maintext = count == 0 ? thistext : (String)maintext + "|" + (String)thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.MATCHING)) {
                        log.debug("MATCHING");
                        answerid = grade.getPublishedAnswerId();
                        temptext = "No Answer";
                        sequence = null;
                        if (answerid != null) {
                            answer = publishedAnswerHash.get(answerid);
                            if (answer != null) {
                                temptext = answer.getText();
                                if (temptext == null) {
                                    temptext = "No Answer";
                                }
                                sequence = answer.getItemText().getSequence();
                            } else if (answerid == -1L) {
                                temptext = "None of the Above";
                                ItemTextIfc itemTextIfc2 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                                sequence = itemTextIfc2.getSequence();
                            }
                        } else {
                            itemTextIfc = publishedItemTextHash.get(grade.getPublishedItemTextId());
                            sequence = itemTextIfc.getSequence();
                        }
                        thistext = sequence + ": " + temptext;
                        maintext = count == 0 ? thistext : (String)maintext + "|" + (String)thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.IMAGEMAP_QUESTION)) {
                        log.debug("IMAGEMAP_QUESTION");
                        ItemTextIfc itemTextIfc3 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                        Long sequence3 = itemTextIfc3.getSequence();
                        temptext = "No OK";
                        if (grade.getIsCorrect() != null) {
                            temptext = grade.getIsCorrect() != false ? "OK" : "No OK";
                        }
                        String thistext2 = sequence3 + ": " + temptext;
                        maintext = count == 0 ? thistext2 : (String)maintext + "|" + thistext2;
                        ++count;
                    } else if (typeId.equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
                        log.debug("EXTENDED_MATCHING_ITEMS");
                        answerid = grade.getPublishedAnswerId();
                        temptext = "No Answer";
                        sequence = null;
                        if (answerid != null && (answer = publishedAnswerHash.get(answerid)) != null) {
                            temptext = answer.getLabel();
                            if (temptext == null) {
                                temptext = "No Answer";
                            }
                            sequence = answer.getItemText().getSequence();
                        }
                        if (sequence == null && (itemTextIfc = publishedItemTextHash.get(grade.getPublishedItemTextId())) != null) {
                            sequence = itemTextIfc.getSequence();
                        }
                        if (sequence != null) {
                            thistext = (String)emiAnswerText.get(sequence);
                            thistext = thistext == null ? temptext : (String)thistext + temptext;
                            emiAnswerText.put(sequence, thistext);
                        } else {
                            sequence = new Long(99L);
                            emiAnswerText.put(sequence, "Item Removed");
                        }
                    } else if (typeId.equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
                        String temptext2;
                        Long sequence2;
                        log.debug("MATRIX_CHOICES_SURVEY");
                        matrixChoices = true;
                        Long answerid2 = grade.getPublishedAnswerId();
                        if (answerid2 != null) {
                            AnswerIfc answer2 = publishedAnswerHash.get(answerid2);
                            String temptext3 = answer2.getText();
                            if (temptext3 == null) {
                                temptext3 = "No Answer";
                            }
                            sequence2 = answer2.getItemText().getSequence();
                        } else {
                            ItemTextIfc itemTextIfc4 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                            sequence2 = itemTextIfc4.getSequence();
                            log.debug("Answerid null for " + grade.getPublishedItemId() + ". Adding " + sequence2);
                            temptext2 = "No Answer";
                        }
                        responsesMap.put(sequence2, temptext2);
                    } else if (typeId.equals(TypeIfc.AUDIO_RECORDING)) {
                        log.debug("AUDIO_RECORDING");
                        maintext = audioMessage;
                    } else if (typeId.equals(TypeIfc.FILE_UPLOAD)) {
                        log.debug("FILE_UPLOAD");
                        maintext = fileUploadMessage;
                    } else if (typeId.equals(TypeIfc.ESSAY_QUESTION)) {
                        log.debug("ESSAY_QUESTION");
                        if (grade.getAnswerText() != null) {
                            maintext = grade.getAnswerText();
                        }
                    } else {
                        log.debug("other type");
                        thistext = "";
                        answerid = grade.getPublishedAnswerId();
                        if (answerid != null) {
                            AnswerIfc answer3 = publishedAnswerHash.get(answerid);
                            if (answer3 != null) {
                                String temptext3 = answer3.getText();
                                if (temptext3 != null) {
                                    thistext = temptext3;
                                }
                            } else {
                                log.warn("Published answer for " + answerid + " is null");
                            }
                        }
                        maintext = count == 0 ? thistext : (String)maintext + "|" + (String)thistext;
                        ++count;
                    }
                    if (!addRationale && (typeId.equals(TypeIfc.MULTIPLE_CHOICE) || typeId.equals(TypeIfc.MULTIPLE_CORRECT) || typeId.equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || typeId.equals(TypeIfc.TRUE_FALSE))) {
                        log.debug("MULTIPLE_CHOICE or MULTIPLE_CORRECT or MULTIPLE_CORRECT_SINGLE_SELECTION or TRUE_FALSE");
                        if (publishedItemData.getHasRationale() != null && publishedItemData.getHasRationale().booleanValue()) {
                            addRationale = true;
                            rationale = grade.getRationale();
                            if (rationale == null) {
                                rationale = "";
                            }
                        }
                    }
                    if (!matrixChoices || !(pid = (PublishedItemData)publishedItemData).getAddCommentFlag()) continue;
                    addResponseComment = true;
                    if (!responseComment.equals("") || grade.getAnswerText() == null) continue;
                    responseComment = grade.getAnswerText();
                }
                if (!emiAnswerText.isEmpty()) {
                    if (maintext == null) {
                        maintext = "";
                    }
                    for (Map.Entry entry : emiAnswerText.entrySet()) {
                        maintext = (String)maintext + "|" + ((Long)entry.getKey()).toString() + ":" + (String)entry.getValue();
                    }
                    if (((String)maintext).startsWith("|")) {
                        maintext = ((String)maintext).substring(1);
                    }
                }
                if (grade == null || EmptyItemGrading.class.isInstance(grade)) {
                    sectionSequenceNumber = ((EmptyItemGrading)((Object)EmptyItemGrading.class.cast(grade))).getSectionSequence();
                    questionNumber = ((EmptyItemGrading)((Object)EmptyItemGrading.class.cast(grade))).getItemSequence();
                    maintext = "-";
                } else {
                    sectionSequenceNumber = this.updateSectionScore(sectionItems, sectionScores, grade.getPublishedItemId(), itemScore);
                }
                if (isFinFib && ((String)maintext).contains("No Answer") && count == 1) {
                    maintext = "No Answer";
                } else if ("".equals(maintext)) {
                    maintext = "No Answer";
                }
                if (!matrixChoices) {
                    responseList.add(maintext);
                } else {
                    ItemDataIfc itemDataIfc = publishedItemHash.get(grade.getPublishedItemId());
                    List correspondingItemTextArray = itemDataIfc.getItemTextArray();
                    log.debug("publishedItem is " + itemDataIfc.getText() + " and number of rows " + correspondingItemTextArray.size());
                    if (responsesMap.size() < correspondingItemTextArray.size()) {
                        for (ItemTextIfc itemTextIfc : correspondingItemTextArray) {
                            if (responsesMap.containsKey(itemTextIfc.getSequence())) continue;
                            log.debug("responsesMap does not contain answer to " + itemTextIfc.getText());
                            responsesMap.put(itemTextIfc.getSequence(), "No Answer");
                        }
                    }
                    for (Map.Entry e3 : responsesMap.entrySet()) {
                        log.debug("Adding to response list " + e3.getKey() + " and " + e3.getValue());
                        responseList.add(e3.getValue());
                    }
                }
                if (addResponseComment) {
                    responseList.add(responseComment);
                }
                String string = "";
                if (grade.getComments() != null) {
                    String string2 = grade.getComments().replaceAll("<br\\s*/>", "");
                }
                responseList.add(var67_72);
                if (addRationale) {
                    responseList.add(rationale);
                }
                if (!fistItemGradingData) continue;
                String poolName = null;
                for (PublishedSectionData psd : publishedAssessmentSections) {
                    if (psd.getSequence().intValue() != sectionSequenceNumber.intValue()) continue;
                    poolName = psd.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
                }
                if (!matrixChoices) {
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, textString, questionNumber, poolString, poolName));
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, itemGradingCommentsString, questionNumber, poolString, poolName));
                    if (!addRationale) continue;
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, rationaleString, questionNumber, poolString, poolName));
                    continue;
                }
                int numberRows = responsesMap.size();
                for (int i = 0; i < numberRows; ++i) {
                    headerList.add(this.makeHeaderMatrix(partString, sectionSequenceNumber, questionString, textString, questionNumber, i + 1, poolString, poolName));
                }
                if (addResponseComment) {
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, responseCommentString, questionNumber, poolString, poolName));
                }
                headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, itemGradingCommentsString, questionNumber, poolString, poolName));
            }
            if (showPartAndTotalScoreSpreadsheetColumns && sectionScores.size() > 1) {
                Iterator keys = sectionScores.keySet().iterator();
                while (keys.hasNext()) {
                    Double d = (Double)sectionScores.get(keys.next());
                    responseList.add(sectionScoreColumnStart++, d);
                }
            }
            dataList.add(responseList);
            if (!fistItemGradingData) continue;
            fistItemGradingData = false;
        }
        if (!anonymous && !useridSet.isEmpty()) {
            for (String id : useridSet) {
                try {
                    agentEid = this.userDirectoryService.getUser(id).getEid();
                    firstName = this.userDirectoryService.getUser(id).getFirstName();
                    lastName = this.userDirectoryService.getUser(id).getLastName();
                }
                catch (Exception e) {
                    log.error("Cannot get user");
                }
                responseList = new ArrayList();
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                responseList.add(noSubmissionMessage);
                dataList.add(responseList);
            }
        }
        Collections.sort(dataList, new ResponsesComparator(anonymous));
        finalList.add(dataList);
        finalList.add(headerList);
        return finalList;
    }

    private int updateSectionScore(Map sectionItems, Map sectionScores, Long publishedItemId, double itemScore) {
        for (Map.Entry entry : sectionItems.entrySet()) {
            Object sectionSequence = entry.getKey();
            Map itemsForSection = (Map)entry.getValue();
            if (itemsForSection.get(publishedItemId) == null) continue;
            Double score = (Double)sectionScores.get(sectionSequence) + itemScore;
            sectionScores.put(sectionSequence, score);
            return (Integer)sectionSequence;
        }
        return 0;
    }

    @Override
    public void removeUnsubmittedAssessmentGradingData(AssessmentGradingData data) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status = :status order by a.submittedDate desc");
            q.setParameter("id", (Object)data.getPublishedAssessmentId());
            q.setParameter("agent", (Object)data.getAgentId());
            q.setParameter("forgrade", (Object)false);
            q.setParameter("status", (Object)AssessmentGradingData.NO_SUBMISSION);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (!assessmentGradings.isEmpty()) {
            this.deleteAll(assessmentGradings);
        }
    }

    @Override
    public void removeAssessmentGradingData(AssessmentGradingData data) {
        data.setStatus(AssessmentGradingData.REMOVED);
        data.setForGrade(Boolean.valueOf(false));
        this.saveOrUpdateAssessmentGrading(data);
    }

    @Override
    public boolean getHasGradingData(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.status > :status");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return !assessmentGradings.isEmpty();
    }

    @Override
    public List<Boolean> getHasGradingDataAndHasSubmission(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.status > :status order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<Boolean> al = new ArrayList<Boolean>();
        if (assessmentGradings.size() == 0) {
            al.add(Boolean.FALSE);
            al.add(Boolean.FALSE);
        } else {
            al.add(Boolean.TRUE);
            String currentAgent = "";
            boolean hasSubmission = false;
            for (AssessmentGradingData adata : assessmentGradings) {
                if (currentAgent.equals(adata.getAgentId())) continue;
                if (adata.getForGrade().booleanValue()) {
                    al.add(Boolean.TRUE);
                    hasSubmission = true;
                    break;
                }
                currentAgent = adata.getAgentId();
            }
            if (!hasSubmission) {
                al.add(Boolean.FALSE);
            }
        }
        return al;
    }

    @Override
    public String getFilename(Long itemGradingId, String agentId, String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return this.getFilenameWOExtesion(itemGradingId, agentId, filename);
        }
        return this.getFilenameWExtesion(itemGradingId, agentId, filename, dotIndex);
    }

    private String getFilenameWOExtesion(Long itemGradingId, String agentId, String filename) {
        StringBuilder bindVar = new StringBuilder(filename);
        bindVar.append("%");
        Object[] values = new Object[]{itemGradingId, agentId, bindVar.toString()};
        List list = this.getHibernateTemplate().findByNamedParam("select filename from MediaData m where m.itemGradingData.itemGradingId = :id and m.createdBy = :agent and m.filename like :file", new String[]{"id", "agent", "file"}, new Object[]{itemGradingId, agentId, bindVar.toString()});
        if (list.isEmpty()) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name = ((String)iter.next()).trim();
            if (name.contains(".") || !name.equals(filename) && !name.startsWith(filename + "(")) continue;
            hs.add(name);
        }
        if (hs.isEmpty()) {
            return filename;
        }
        StringBuilder testName = new StringBuilder(filename);
        int i = 1;
        while (hs.contains(testName.toString())) {
            testName = new StringBuilder(filename);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
        return testName.toString();
    }

    private String getFilenameWExtesion(Long itemGradingId, String agentId, String filename, int dotIndex) {
        String filenameWithoutExtension = filename.substring(0, dotIndex);
        StringBuilder bindVar = new StringBuilder(filenameWithoutExtension);
        bindVar.append("%");
        bindVar.append(filename.substring(dotIndex));
        List list = this.getHibernateTemplate().findByNamedParam("select filename from MediaData m where m.itemGradingData.itemGradingId = :id and m.createdBy = :agent and m.filename like :file", new String[]{"id", "agent", "file"}, new Object[]{itemGradingId, agentId, bindVar.toString()});
        if (list.isEmpty()) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        String extension = filename.substring(dotIndex);
        int extensionLength = extension.length();
        while (iter.hasNext()) {
            String name = ((String)iter.next()).trim();
            if (!name.equals(filename) && !name.startsWith(filenameWithoutExtension + "(")) continue;
            int nameLenght = name.length();
            hs.add(name.substring(0, nameLenght - extensionLength));
        }
        if (hs.isEmpty()) {
            return filename;
        }
        StringBuffer testName = new StringBuffer(filenameWithoutExtension);
        int i = 1;
        while (true) {
            if (!hs.contains(testName.toString())) {
                testName.append(extension);
                return testName.toString();
            }
            testName = new StringBuffer(filenameWithoutExtension);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
    }

    @Override
    public List getUpdatedAssessmentList(String agentId, String siteId) {
        ArrayList finalList = new ArrayList();
        ArrayList<Object> updatedAssessmentList = new ArrayList<Object>();
        ArrayList<Object> updatedAssessmentNeedResubmitListList = new ArrayList<Object>();
        List list = this.getHibernateTemplate().findByNamedParam("select a.publishedAssessmentId, a.status from AssessmentGradingData a, AuthorizationData az  where a.agentId = :agent and az.agentIdString = :site and az.functionId = :fid  and az.qualifierId=a.publishedAssessmentId and a.forGrade = :forgrade and (a.status = :status1 or a.status = :status2)  order by a.status", new String[]{"agent", "site", "fid", "forgrade", "status1", "status2"}, new Object[]{agentId, siteId, "OWN_PUBLISHED_ASSESSMENT", false, AssessmentGradingData.ASSESSMENT_UPDATED, AssessmentGradingData.ASSESSMENT_UPDATED_NEED_RESUBMIT});
        if (list.isEmpty()) {
            return updatedAssessmentList;
        }
        for (Object[] o : list) {
            if (AssessmentGradingData.ASSESSMENT_UPDATED_NEED_RESUBMIT.compareTo((Integer)o[1]) == 0) {
                updatedAssessmentNeedResubmitListList.add(o[0]);
                continue;
            }
            updatedAssessmentList.add(o[0]);
        }
        finalList.add(updatedAssessmentNeedResubmitListList);
        finalList.add(updatedAssessmentList);
        return finalList;
    }

    @Override
    public List getSiteNeedResubmitList(String siteId) {
        List list = this.getHibernateTemplate().findByNamedParam("select distinct a.publishedAssessmentId from AssessmentGradingData a, AuthorizationData au where au.functionId = :fid and au.agentIdString = :site and a.publishedAssessmentId = au.qualifierId and a.forGrade = :forgrade and a.status = :status", new String[]{"fid", "site", "forgrade", "status"}, new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, AssessmentGradingData.ASSESSMENT_UPDATED_NEED_RESUBMIT});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int autoSubmitAssessments() {
        Date currentTime = new Date();
        Session session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        Query query = session.createQuery("select new AssessmentGradingData(a.assessmentGradingId, a.publishedAssessmentId,  a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,  a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAccessControl c  where a.publishedAssessmentId = c.assessment.publishedAssessmentId  and ((c.lateHandling = 1 and c.retractDate <= :currentTime) or (c.lateHandling = 2 and c.dueDate <= :currentTime)) and a.status not in (:status) and (a.hasAutoSubmissionRun = 0 or a.hasAutoSubmissionRun is null) and c.autoSubmit = 1  and a.attemptDate is not null  order by a.publishedAssessmentId, a.agentId, a.forGrade desc, a.assessmentGradingId");
        query.setTimestamp("currentTime", currentTime);
        query.setParameterList("status", Arrays.asList(AssessmentGradingData.REMOVED, AssessmentGradingData.NO_SUBMISSION));
        query.setTimeout(300);
        List list = query.list();
        Iterator iter = list.iterator();
        String lastAgentId = "";
        Long lastPublishedAssessmentId = 0L;
        PublishedAssessmentFacade assessment = null;
        AssessmentGradingData adata = null;
        HashMap<Long, Set<PublishedSectionData>> sectionSetMap = new HashMap<Long, Set<PublishedSectionData>>();
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        boolean updateGrades = IntegrationContextFactory.getInstance() != null;
        AutoSubmitFacadeQueriesAPI autoSubmitFacade = PersistenceService.getInstance().getAutoSubmitFacadeQueries();
        int failures = 0;
        while (iter.hasNext()) {
            try {
                boolean success;
                adata = (AssessmentGradingData)iter.next();
                if (!lastPublishedAssessmentId.equals(adata.getPublishedAssessmentId())) {
                    assessment = publishedAssessmentService.getPublishedAssessmentQuick(adata.getPublishedAssessmentId().toString());
                }
                if (!(success = autoSubmitFacade.processAttempt(adata, updateGrades, this, assessment, currentTime, lastAgentId, lastPublishedAssessmentId, sectionSetMap))) {
                    ++failures;
                }
                lastPublishedAssessmentId = adata.getPublishedAssessmentId();
                lastAgentId = adata.getAgentId();
            }
            catch (Exception e) {
                ++failures;
                if (adata != null) {
                    log.error("Error while auto submitting assessment grade data id: " + adata.getAssessmentGradingId(), (Throwable)e);
                    continue;
                }
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                adata = null;
            }
        }
        return failures;
    }

    private String makeHeader(String section, int sectionNumber, String question, String headerType, int questionNumber, String pool, String poolName) {
        StringBuilder sb = new StringBuilder(section);
        sb.append(" ");
        sb.append(sectionNumber);
        sb.append(", ");
        sb.append(question);
        sb.append(" ");
        sb.append(questionNumber);
        sb.append(", ");
        if (poolName != null) {
            sb.append(pool);
            sb.append(" ");
            sb.append(poolName);
            sb.append(", ");
        }
        sb.append(headerType);
        return sb.toString();
    }

    private String makeHeaderMatrix(String section, int sectionNumber, String question, String headerType, int questionNumber, int questionRow, String pool, String poolName) {
        StringBuilder sb = new StringBuilder(section);
        sb.append(" ");
        sb.append(sectionNumber);
        sb.append(", ");
        sb.append(question);
        sb.append(" ");
        sb.append(questionNumber);
        sb.append(": ");
        sb.append(questionRow);
        sb.append(", ");
        if (poolName != null) {
            sb.append(pool);
            sb.append(" ");
            sb.append(poolName);
            sb.append(", ");
        }
        sb.append(headerType);
        return sb.toString();
    }

    @Override
    public ItemGradingAttachment createItemGradingtAttachment(ItemGradingData itemGrading, String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = this.createGradingtAttachment(resourceId, filename, protocol);
        ItemGradingAttachment itemAttach = new ItemGradingAttachment(attach, itemGrading);
        itemAttach.setItemGrading(itemGrading);
        return itemAttach;
    }

    @Override
    public AssessmentGradingAttachment createAssessmentGradingtAttachment(AssessmentGradingData assessmentGrading, String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = this.createGradingtAttachment(resourceId, filename, protocol);
        AssessmentGradingAttachment assessAttach = new AssessmentGradingAttachment(attach, assessmentGrading);
        assessAttach.setAssessmentGrading(assessmentGrading);
        return assessAttach;
    }

    private GradingAttachmentData createGradingtAttachment(String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = this.contentHostingService.getResource(resourceId);
            if (cr != null) {
                AssessmentFacadeQueries assessmentFacadeQueries = new AssessmentFacadeQueries();
                ResourceProperties p = cr.getProperties();
                attach = new GradingAttachmentData();
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(assessmentFacadeQueries.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(assessmentFacadeQueries.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public void removeItemGradingAttachment(Long attachmentId) {
        ItemGradingAttachment itemGradingAttachment = (ItemGradingAttachment)this.getHibernateTemplate().load(ItemGradingAttachment.class, (Serializable)attachmentId);
        ItemGradingData itemGrading = itemGradingAttachment.getItemGrading();
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                if (itemGrading == null) continue;
                Set set = itemGrading.getItemGradingAttachmentSet();
                set.remove(itemGradingAttachment);
                this.getHibernateTemplate().delete((Object)itemGradingAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete assessmentAttachment: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void removeAssessmentGradingAttachment(Long attachmentId) {
        AssessmentGradingAttachment assessmentGradingAttachment = (AssessmentGradingAttachment)this.getHibernateTemplate().load(AssessmentGradingAttachment.class, (Serializable)attachmentId);
        AssessmentGradingData assessmentGrading = assessmentGradingAttachment.getAssessmentGrading();
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessmentGrading == null) continue;
                Set set = assessmentGrading.getAssessmentGradingAttachmentSet();
                set.remove(assessmentGradingAttachment);
                this.getHibernateTemplate().delete((Object)assessmentGradingAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete assessmentAttachment: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAttachments(List<AttachmentIfc> list) {
        for (AttachmentIfc attachment : list) {
            this.getHibernateTemplate().saveOrUpdate((Object)attachment);
        }
    }

    @Override
    public HashMap getInProgressCounts(String siteId) {
        List list = this.getHibernateTemplate().findByNamedParam("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, AuthorizationData au where au.functionId = :fid and au.agentIdString = :site and a.publishedAssessmentId = au.qualifierId and a.forGrade = :forgrade and (a.status = :status1 or a.status = :status2) group by a.publishedAssessmentId", new String[]{"fid", "site", "forgrade", "status1", "status2"}, new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, AssessmentGradingData.IN_PROGRESS, AssessmentGradingData.ASSESSMENT_UPDATED});
        Iterator iter = list.iterator();
        HashMap<Object, Object> inProgressCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            inProgressCountsMap.put(o[0], o[1]);
        }
        return inProgressCountsMap;
    }

    @Override
    public HashMap getSubmittedCounts(String siteId) {
        List list = this.getHibernateTemplate().findByNamedParam("select a.publishedAssessmentId, count(distinct a.agentId) from AssessmentGradingData a, AuthorizationData au, PublishedAssessmentData p where au.functionId = :fid and au.agentIdString = :site and a.publishedAssessmentId = au.qualifierId and a.forGrade = :forgrade and a.status > :status and a.publishedAssessmentId = p.publishedAssessmentId and (p.lastNeedResubmitDate is null or a.submittedDate >= p.lastNeedResubmitDate) group by a.publishedAssessmentId", new String[]{"fid", "site", "forgrade", "status"}, new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, true, AssessmentGradingData.REMOVED});
        Iterator iter = list.iterator();
        HashMap<Object, Object> startedCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            startedCountsMap.put(o[0], o[1]);
        }
        return startedCountsMap;
    }

    @Override
    public void completeItemGradingData(AssessmentGradingData assessmentGradingData) {
        this.completeItemGradingData(assessmentGradingData, null);
    }

    @Override
    public void completeItemGradingData(AssessmentGradingData assessmentGradingData, Map<Long, Set<PublishedSectionData>> sectionSetMap) {
        Set<PublishedSectionData> sectionSet;
        List<Long> publishedItemIds;
        List<Long> answeredPublishedItemIdList = publishedItemIds = this.getPublishedItemIds(assessmentGradingData.getAssessmentGradingId());
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        Long publishedAssessmentId = assessmentGradingData.getPublishedAssessmentId();
        if (sectionSetMap == null || !sectionSetMap.containsKey(publishedAssessmentId)) {
            sectionSet = publishedAssessmentService.getSectionSetForAssessment(publishedAssessmentId);
            if (sectionSetMap != null) {
                sectionSetMap.put(publishedAssessmentId, sectionSet);
            }
        } else {
            sectionSet = sectionSetMap.get(publishedAssessmentId);
        }
        if (sectionSet == null) {
            return;
        }
        for (PublishedSectionData publishedSectionData : sectionSet) {
            Long publishedItemId;
            ArrayList itemArrayList;
            log.debug("sectionId = " + publishedSectionData.getSectionId());
            String authorType = publishedSectionData.getSectionMetaDataByLabel("AUTHOR_TYPE");
            if (authorType != null && authorType.equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                log.debug("Random draw from questonpool");
                itemArrayList = publishedSectionData.getItemArray();
                long seed = AgentFacade.getAgentString().hashCode();
                String sectionRandomizationSeed = publishedSectionData.getSectionMetaDataByLabel("RANDOMIZATION_SEED");
                if (StringUtils.isNotBlank((CharSequence)sectionRandomizationSeed)) {
                    seed += Long.parseLong(sectionRandomizationSeed);
                }
                if (publishedSectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE") != null && publishedSectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE").equals("1")) {
                    seed = (assessmentGradingData.getAssessmentGradingId().toString() + "_" + publishedSectionData.getSectionId().toString()).hashCode();
                }
                Collections.shuffle(itemArrayList, new Random(seed));
                Integer numberToBeDrawn = 0;
                if (publishedSectionData.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    numberToBeDrawn = Integer.valueOf(publishedSectionData.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                }
                int samplesize = numberToBeDrawn;
                for (int i = 0; i < samplesize; ++i) {
                    PublishedItemData publishedItemData = (PublishedItemData)itemArrayList.get(i);
                    publishedItemId = publishedItemData.getItemId();
                    log.debug("publishedItemId = " + publishedItemId);
                    if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                    this.saveItemGradingData(assessmentGradingData, publishedItemId);
                }
                continue;
            }
            log.debug("Not random draw from questonpool");
            itemArrayList = publishedSectionData.getItemArray();
            for (PublishedItemData pid : itemArrayList) {
                publishedItemId = pid.getItemId();
                log.debug("publishedItemId = " + publishedItemId);
                if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                this.saveItemGradingData(assessmentGradingData, publishedItemId);
            }
        }
    }

    private void saveItemGradingData(AssessmentGradingData assessmentGradingData, Long publishedItemId) {
        log.debug("Adding one ItemGradingData...");
        ItemGradingData itemGradingData = new ItemGradingData();
        itemGradingData.setAssessmentGradingId(assessmentGradingData.getAssessmentGradingId());
        itemGradingData.setAgentId(assessmentGradingData.getAgentId());
        itemGradingData.setPublishedItemId(publishedItemId);
        ItemService itemService = new ItemService();
        Long itemTextId = itemService.getItemTextId(publishedItemId);
        log.debug("itemTextId = {}", (Object)itemTextId);
        if (itemTextId != -1L) {
            itemGradingData.setPublishedItemTextId(itemTextId);
            this.saveItemGrading(itemGradingData);
        }
    }

    @Override
    public Double getAverageSubmittedAssessmentGrading(Long publishedAssessmentId, String agentId) {
        Double averageScore = 0.0;
        Object ag = null;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by  a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentId);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        if (!assessmentGradings.isEmpty()) {
            Double cumulativeScore = new Double(0.0);
            for (AssessmentGradingData agd : assessmentGradings) {
                cumulativeScore = cumulativeScore + agd.getFinalScore();
            }
            averageScore = cumulativeScore / (double)assessmentGradings.size();
            DecimalFormat df = new DecimalFormat("0.##");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            averageScore = new Double(df.format(averageScore));
        }
        return averageScore;
    }

    @Override
    public List<AssessmentGradingData> getHighestSubmittedAssessmentGradingList(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.forGrade = :forgrade and a.status > :status order by a.agentId asc, a.finalScore desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("forgrade", (Object)true);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        return new ArrayList<AssessmentGradingData>(assessmentGradings.stream().collect(Collectors.toMap(AssessmentGradingData::getAgentId, p -> p, (p, q) -> p)).values());
    }

    @Override
    public Map<Long, List<Long>> getAverageAssessmentGradingByPublishedItem(Long publishedAssessmentId) {
        HashMap<Long, List<Long>> h = new HashMap<Long, List<Long>>();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId = :id and a.status > :status order by a.agentId asc, a.submittedDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                List o = (List)h.get(itemId);
                if (o != null) {
                    o.add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    private Map<Long, Set<ItemGradingAttachment>> getItemGradingAttachmentMap(Set itemGradingIds) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemGradingAttachment a where a.itemGrading.itemGradingId in (:itemGradingIds)");
            q.setParameterList("itemGradingIds", (Collection)itemGradingIds);
            return q.list();
        };
        HashSet<ItemGradingAttachment> itemGradingAttachmentList = new HashSet<ItemGradingAttachment>((Collection)this.getHibernateTemplate().execute(hcb));
        return this.processItemGradingAttachment(itemGradingAttachmentList);
    }

    private Map<Long, Set<ItemGradingAttachment>> getItemGradingAttachmentMap(Long publishedItemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a from ItemGradingAttachment a where a.itemGrading.publishedItemId = :publishedItemId ");
            q.setParameter("publishedItemId", (Object)publishedItemId);
            return q.list();
        };
        HashSet<ItemGradingAttachment> itemGradingAttachmentSet = new HashSet<ItemGradingAttachment>((Collection)this.getHibernateTemplate().execute(hcb));
        return this.processItemGradingAttachment(itemGradingAttachmentSet);
    }

    public Map<Long, List<AssessmentGradingAttachment>> getAssessmentGradingAttachmentMap(Long pubAssessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a from AssessmentGradingAttachment a where a.assessmentGrading.publishedAssessmentId = :pubAssessmentId ");
            q.setParameter("pubAssessmentId", (Object)pubAssessmentId);
            return q.list();
        };
        List assessmentGradingAttachmentList = (List)this.getHibernateTemplate().execute(hcb);
        return this.processAssessmentGradingAttachment(assessmentGradingAttachmentList);
    }

    public Map<Long, Set<ItemGradingAttachment>> getItemGradingAttachmentMapByAssessmentGradingId(Long assessmentGradingId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select a from ItemGradingAttachment a, ItemGradingData i where a.itemGrading.itemGradingId = i.itemGradingId and i.assessmentGradingId = :assessmentGradingId");
            q.setParameter("assessmentGradingId", (Object)assessmentGradingId);
            return q.list();
        };
        HashSet<ItemGradingAttachment> itemGradingAttachmentList = new HashSet<ItemGradingAttachment>((Collection)this.getHibernateTemplate().execute(hcb));
        return this.processItemGradingAttachment(itemGradingAttachmentList);
    }

    private Map<Long, Set<ItemGradingAttachment>> processItemGradingAttachment(Set<ItemGradingAttachment> itemGradingAttachmentSet) {
        HashMap<Long, Set<ItemGradingAttachment>> itemGradingAttachmentMap = new HashMap<Long, Set<ItemGradingAttachment>>();
        for (ItemGradingAttachment attachment : itemGradingAttachmentSet) {
            Long itemGrdingId = attachment.getItemGrading().getItemGradingId();
            Set attachmentSet = itemGradingAttachmentMap.containsKey(itemGrdingId) ? (Set)itemGradingAttachmentMap.get(itemGrdingId) : new HashSet();
            attachmentSet.add(attachment);
            itemGradingAttachmentMap.put(itemGrdingId, attachmentSet);
        }
        return itemGradingAttachmentMap;
    }

    private Map<Long, List<AssessmentGradingAttachment>> processAssessmentGradingAttachment(List<AssessmentGradingAttachment> assessmentGradingAttachmentList) {
        HashMap<Long, List<AssessmentGradingAttachment>> assessmentGradingAttachmentMap = new HashMap<Long, List<AssessmentGradingAttachment>>();
        for (int i = 0; i < assessmentGradingAttachmentList.size(); ++i) {
            AssessmentGradingAttachment attachment = assessmentGradingAttachmentList.get(i);
            Long assessGradingId = attachment.getAssessmentGrading().getAssessmentGradingId();
            List<Object> attachmentList = new ArrayList<AssessmentGradingAttachment>();
            if (assessmentGradingAttachmentMap.containsKey(assessGradingId)) {
                attachmentList = (List)assessmentGradingAttachmentMap.get(assessGradingId);
            }
            attachmentList.add(attachment);
            assessmentGradingAttachmentMap.put(assessGradingId, attachmentList);
        }
        return assessmentGradingAttachmentMap;
    }

    @Override
    public List<AssessmentGradingData> getUnSubmittedAssessmentGradingDataList(Long publishedAssessmentId, String agentIdString) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status order by a.attemptDate desc");
            q.setParameter("id", (Object)publishedAssessmentId);
            q.setParameter("agent", (Object)agentIdString);
            q.setParameter("forgrade", (Object)false);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private static class EmptyItemGrading
    extends ItemGradingData {
        private static final long serialVersionUID = 1444166131103415747L;
        private Integer sectionSequence;
        private Long publishedItemId;
        private Integer itemSequence;

        EmptyItemGrading(Integer sectionSequence, Long publishedItemId, Integer itemSequence) {
            this.sectionSequence = sectionSequence;
            this.publishedItemId = publishedItemId;
            this.itemSequence = itemSequence;
        }

        public Integer getItemSequence() {
            return this.itemSequence;
        }

        public Integer getSectionSequence() {
            return this.sectionSequence;
        }
    }

    private static class ItemComparator
    implements Comparator {
        private ItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            PublishedItemData a = (PublishedItemData)o1;
            PublishedItemData b = (PublishedItemData)o2;
            if (a.getSection().getSequence() < b.getSection().getSequence()) {
                return -1;
            }
            if (a.getSection().getSequence() > b.getSection().getSequence()) {
                return 1;
            }
            return a.getSequence() - b.getSequence();
        }
    }

    private static class ResponsesComparator
    implements Comparator {
        private static final Logger log = LoggerFactory.getLogger(ResponsesComparator.class);
        boolean anonymous;

        public ResponsesComparator(boolean anony) {
            this.anonymous = anony;
        }

        public int compare(Object a, Object b) {
            RuleBasedCollator collator_ini = (RuleBasedCollator)Collator.getInstance();
            try {
                String bThirdElement;
                String bSecondElement;
                String bFirstElement;
                RuleBasedCollator collator = new RuleBasedCollator(collator_ini.getRules().replaceAll("<'_'", "<' '<'_'"));
                if (this.anonymous) {
                    Long bFirstElement2;
                    Long aFirstElement = (Long)((ArrayList)a).get(0);
                    if (aFirstElement.compareTo(bFirstElement2 = (Long)((ArrayList)b).get(0)) < 0) {
                        return -1;
                    }
                    if (aFirstElement.compareTo(bFirstElement2) > 0) {
                        return 1;
                    }
                    return 0;
                }
                String aFirstElement = (String)((ArrayList)a).get(0);
                if (collator.compare(aFirstElement, bFirstElement = (String)((ArrayList)b).get(0)) < 0) {
                    return -1;
                }
                if (collator.compare(aFirstElement, bFirstElement) > 0) {
                    return 1;
                }
                String aSecondElement = (String)((ArrayList)a).get(1);
                if (collator.compare(aSecondElement, bSecondElement = (String)((ArrayList)b).get(1)) < 0) {
                    return -1;
                }
                if (collator.compare(aSecondElement, bSecondElement) > 0) {
                    return 1;
                }
                String aThirdElement = (String)((ArrayList)a).get(2);
                if (collator.compare(aThirdElement, bThirdElement = (String)((ArrayList)b).get(2)) < 0) {
                    return -1;
                }
                if (collator.compare(aThirdElement, bThirdElement) > 0) {
                    return 1;
                }
                return 0;
            }
            catch (ParseException e) {
                log.error("ERROR compare: ", (Throwable)e);
                return Collator.getInstance().compare(a, b);
            }
        }
    }

    private static class QuestionComparator
    implements Comparator {
        Map publishedItemHash;

        public QuestionComparator(Map m) {
            this.publishedItemHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingData agrade = (ItemGradingData)((List)a).get(0);
            ItemGradingData bgrade = (ItemGradingData)((List)b).get(0);
            ItemDataIfc aitem = (ItemDataIfc)this.publishedItemHash.get(agrade.getPublishedItemId());
            ItemDataIfc bitem = (ItemDataIfc)this.publishedItemHash.get(bgrade.getPublishedItemId());
            Integer asectionseq = aitem.getSection().getSequence();
            Integer bsectionseq = bitem.getSection().getSequence();
            if (asectionseq < bsectionseq) {
                return -1;
            }
            if (asectionseq > bsectionseq) {
                return 1;
            }
            Integer aitemseq = aitem.getSequence();
            Integer bitemseq = bitem.getSequence();
            if (aitemseq < bitemseq) {
                return -1;
            }
            if (aitemseq > bitemseq) {
                return 1;
            }
            return 0;
        }
    }

    private static class AnswerComparator
    implements Comparator {
        Map publishedAnswerHash;

        public AnswerComparator(Map m) {
            this.publishedAnswerHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingData agrade = (ItemGradingData)a;
            ItemGradingData bgrade = (ItemGradingData)b;
            Long aindex = agrade.getItemGradingId();
            Long bindex = bgrade.getItemGradingId();
            Long aanswerid = agrade.getPublishedAnswerId();
            Long banswerid = bgrade.getPublishedAnswerId();
            if (aanswerid != null && banswerid != null) {
                AnswerIfc aanswer = (AnswerIfc)this.publishedAnswerHash.get(aanswerid);
                AnswerIfc banswer = (AnswerIfc)this.publishedAnswerHash.get(banswerid);
                if (aanswer == null || banswer == null) {
                    return aanswer == null ? -1 : 1;
                }
                if (aanswer.getItem() != null && TypeIfc.EXTENDED_MATCHING_ITEMS.equals(aanswer.getItem().getTypeId()) && banswer.getItem() != null && TypeIfc.EXTENDED_MATCHING_ITEMS.equals(banswer.getItem().getTypeId())) {
                    Long bTextSeq;
                    Long aTextSeq = aanswer.getItemText().getSequence();
                    if (!aTextSeq.equals(bTextSeq = banswer.getItemText().getSequence())) {
                        return aTextSeq.compareTo(bTextSeq);
                    }
                    return aanswer.getLabel().compareToIgnoreCase(banswer.getLabel());
                }
                aindex = aanswer.getSequence();
                bindex = banswer.getSequence();
            }
            if (aindex < bindex) {
                return -1;
            }
            if (aindex > bindex) {
                return 1;
            }
            return 0;
        }
    }
}

