/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AutoSubmitFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.util.ExtendedTimeDeliveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class AutoSubmitFacadeQueries
extends HibernateDaoSupport
implements AutoSubmitFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(AutoSubmitFacadeQueries.class);

    @Override
    public boolean processAttempt(AssessmentGradingData adata, boolean updateGrades, AssessmentGradingFacadeQueriesAPI agfq, PublishedAssessmentFacade assessment, Date currentTime, String lastAgentId, Long lastPublishedAssessmentId, Map<Long, Set<PublishedSectionData>> sectionSetMap) {
        boolean success;
        boolean autoSubmitCurrent = false;
        adata.setHasAutoSubmissionRun(Boolean.TRUE);
        if (Boolean.FALSE.equals(adata.getForGrade()) && assessment.getStatus() != AssessmentBaseIfc.DEAD_STATUS) {
            Date dueDate = assessment.getAssessmentAccessControl().getDueDate();
            Date retractDate = assessment.getAssessmentAccessControl().getRetractDate();
            Integer lateHandling = assessment.getAssessmentAccessControl().getLateHandling();
            boolean acceptLate = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.toString().equals(lateHandling);
            ExtendedTimeDeliveryService assessmentExtended = new ExtendedTimeDeliveryService(assessment, adata.getAgentId());
            if (assessmentExtended.hasExtendedTime()) {
                Date date = dueDate = assessmentExtended.getDueDate() != null ? assessmentExtended.getDueDate() : dueDate;
                if (assessmentExtended.getRetractDate() != null) {
                    retractDate = assessmentExtended.getRetractDate();
                    acceptLate = true;
                }
            }
            if (acceptLate && retractDate != null && (currentTime.before(retractDate) || adata.getAttemptDate().after(retractDate))) {
                return true;
            }
            if ((!acceptLate || retractDate == null) && dueDate != null && currentTime.before(dueDate)) {
                return true;
            }
            if (adata.getAttemptDate() != null && adata.getSubmittedDate() == null) {
                adata.setStatus(AssessmentGradingData.NO_SUBMISSION);
            } else {
                adata.setForGrade(Boolean.TRUE);
                if (adata.getTotalAutoScore() == null) {
                    adata.setTotalAutoScore(Double.valueOf(0.0));
                }
                if (adata.getFinalScore() == null) {
                    adata.setFinalScore(Double.valueOf(0.0));
                }
                if (adata.getAttemptDate() != null && dueDate != null && adata.getAttemptDate().after(dueDate)) {
                    adata.setIsLate(Boolean.valueOf(true));
                } else if (adata.getSubmittedDate() != null && dueDate != null && adata.getSubmittedDate().after(dueDate)) {
                    adata.setIsLate(Boolean.valueOf(true));
                }
                autoSubmitCurrent = true;
                adata.setIsAutoSubmitted(Boolean.TRUE);
                if (lastPublishedAssessmentId.equals(adata.getPublishedAssessmentId()) && lastAgentId.equals(adata.getAgentId())) {
                    adata.setStatus(AssessmentGradingData.AUTOSUBMIT_UPDATED);
                } else {
                    adata.setStatus(AssessmentGradingData.SUBMITTED);
                }
                agfq.completeItemGradingData(adata, sectionSetMap);
            }
        }
        if (!(success = agfq.saveOrUpdateAssessmentGrading(adata))) {
            log.error("Unable to persist assessement grading data for id {}", (Object)adata.getAssessmentGradingId());
            return false;
        }
        if (autoSubmitCurrent) {
            GradingService gs = new GradingService();
            if (updateGrades) {
                gs.notifyGradebookByScoringType(adata, assessment);
            }
            gs.updateAutosubmitEventLog(adata);
        }
        return true;
    }
}

