/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;
import org.sakaiproject.tool.assessment.data.dao.assessment.ExtendedTime;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.ExtendedTimeQueriesAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class ExtendedTimeQueries
extends HibernateDaoSupport
implements ExtendedTimeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(ExtendedTimeQueries.class);

    public void init() {
        log.info("init()");
    }

    @Override
    public List<ExtendedTime> getEntriesForAss(AssessmentBaseIfc ass) {
        log.debug("getEntriesForAss " + ass.getAssessmentBaseId());
        try {
            HibernateCallback hcb = s -> {
                Query q = s.getNamedQuery("getEntriesForAss");
                q.setParameter("assessmentId", (Object)ass, (Type)new ManyToOneType(TypeConfiguration::new, "org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData"));
                return q.list();
            };
            return (List)this.getHibernateTemplate().execute(hcb);
        }
        catch (DataAccessException e) {
            log.error("Failed to get Extended TimeEntries for Assessment: " + ass.getAssessmentBaseId(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ExtendedTime> getEntriesForPub(PublishedAssessmentIfc pub) {
        log.debug("getEntriesForPub " + pub.getPublishedAssessmentId());
        try {
            HibernateCallback hcb = s -> {
                Query q = s.getNamedQuery("getEntriesForPub");
                q.setParameter("publishedId", (Object)pub, (Type)new ManyToOneType(TypeConfiguration::new, "org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData"));
                return q.list();
            };
            return (List)this.getHibernateTemplate().execute(hcb);
        }
        catch (DataAccessException e) {
            log.error("Failed to get Extended Time Entries for Published Assessment: " + pub.getPublishedAssessmentId(), (Throwable)e);
            return null;
        }
    }

    @Override
    public ExtendedTime getEntryForPubAndUser(PublishedAssessmentIfc pub, String userId) {
        log.debug("getEntryForPubAndUser, pub: '" + pub.getPublishedAssessmentId() + "' User: " + userId);
        return this.getPubAndX("getEntriesForPubNUser", pub, "userId", userId);
    }

    @Override
    public ExtendedTime getEntryForPubAndGroup(PublishedAssessmentIfc pub, String groupId) {
        log.debug("getEntryForPubAndGroup, pub: '" + pub.getPublishedAssessmentId() + "' group: " + groupId);
        return this.getPubAndX("getEntriesForPubNGroup", pub, "groupId", groupId);
    }

    @Override
    public boolean updateEntry(ExtendedTime e) {
        log.debug("updating entry assessment: '" + e.getAssessmentId() + "' pubId: '" + e.getPubAssessmentId() + "' user: '" + e.getUser() + "' group: " + e.getGroup());
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)e);
            return true;
        }
        catch (DataAccessException de) {
            log.error("Error updating extended time entry", (Throwable)de);
            return false;
        }
    }

    @Override
    public void updateEntries(List<ExtendedTime> entries) {
        entries.forEach(this::updateEntry);
    }

    @Override
    public boolean deleteEntry(ExtendedTime e) {
        log.debug("Removing ExtendedTime entry id: " + e.getId());
        try {
            this.getHibernateTemplate().delete(this.getHibernateTemplate().merge((Object)e));
            return true;
        }
        catch (DataAccessException de) {
            log.error("Failed to delete extendedTime entry, id: " + e.getId() + ".", (Throwable)de);
            return false;
        }
    }

    private ExtendedTime getPubAndX(String query, PublishedAssessmentIfc pub, String secondParam, String secondParamValue) {
        try {
            HibernateCallback hcb = s -> {
                Query q = s.getNamedQuery(query);
                q.setParameter("publishedId", (Object)pub, (Type)new ManyToOneType(TypeConfiguration::new, "org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData"));
                q.setParameter(secondParam, (Object)secondParamValue, (Type)new StringType());
                return q.uniqueResult();
            };
            return (ExtendedTime)this.getHibernateTemplate().execute(hcb);
        }
        catch (DataAccessException e) {
            log.error("Failed to get extended time for pub: " + pub.getPublishedAssessmentId() + " and user/group: " + secondParamValue, (Throwable)e);
            return null;
        }
    }

    @Override
    public ExtendedTime getEntry(String entryId) {
        log.debug("getEntry " + entryId);
        try {
            HibernateCallback hcb = s -> {
                Query q = s.getNamedQuery("getEntry");
                q.setParameter("entryId", (Object)Long.valueOf(entryId));
                return q.uniqueResult();
            };
            return (ExtendedTime)this.getHibernateTemplate().execute(hcb);
        }
        catch (DataAccessException e) {
            log.error("Failed to get Extended Time Entries for Published Assessment: " + entryId, (Throwable)e);
            return null;
        }
    }
}

