/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.Iterator;
import java.util.List;
import org.hibernate.query.Query;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoices;
import org.sakaiproject.tool.assessment.facade.FavoriteColChoicesFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class FavoriteColChoicesFacadeQueries
extends HibernateDaoSupport
implements FavoriteColChoicesFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(FavoriteColChoicesFacadeQueries.class);

    @Override
    public void saveOrUpdate(FavoriteColChoices choices) {
        Iterator iter;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from FavoriteColChoices as a where a.favoriteName = :name");
            q.setParameter("name", (Object)choices.getFavoriteName());
            return q.list();
        };
        List favoriteList = (List)this.getHibernateTemplate().execute(hcb);
        if (favoriteList != null && (iter = favoriteList.iterator()).hasNext()) {
            FavoriteColChoices fChoice = (FavoriteColChoices)iter.next();
            this.getHibernateTemplate().delete((Object)fChoice);
        }
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)choices);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving favoriteColChoices: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public List<FavoriteColChoices> getFavoriteColChoicesByAgent(String siteAgentId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from FavoriteColChoices as a where a.ownerStringId = :site");
            q.setParameter("site", (Object)siteAgentId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }
}

