/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.query.Query;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.ItemHashUtil;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class ItemFacadeQueries
extends HibernateDaoSupport
implements ItemFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(ItemFacadeQueries.class);
    private ItemHashUtil itemHashUtil;
    private static final Map<String, String> BACKFILL_HASHES_HQL = new HashMap<String, String>(){
        {
            this.put("total.item.count.hql", "select count(*) from ItemData");
            this.put("total.hash.backfillable.item.count.hql", "select count(*) from ItemData as item where item.hash is null");
            this.put("all.backfillable.item.ids.hql", "select item.id from ItemData as item where item.hash is null");
            this.put("items.by.id.hql", "select item from ItemData as item where item.id in ({ID_PARAMS})");
        }
    };

    @Override
    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    @Override
    public List list() {
        return this.getHibernateTemplate().find("from ItemData", new Object[0]);
    }

    @Override
    public void show(Long itemId) {
        this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
    }

    @Override
    public ItemFacade getItem(Long itemId, String agent) {
        return this.getItem(itemId);
    }

    @Override
    public void deleteItem(Long itemId, String agent) {
        ItemData item = (ItemData)this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId);
        if (item != null) {
            AssessmentService service = new AssessmentService();
            List itemAttachmentList = service.getItemResourceIdList((ItemDataIfc)item);
            service.deleteResources(itemAttachmentList);
            SectionDataIfc section = item.getSection();
            if (section != null) {
                section.getItemSet().remove(item);
            }
            this.getHibernateTemplate().delete((Object)item);
        }
    }

    @Override
    public void deleteItemContent(Long itemId, String agent) {
        ItemData item = (ItemData)this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId);
        if (item != null) {
            item.getItemTextSet().clear();
            item.getItemMetaDataSet().clear();
            item.getItemFeedbackSet().clear();
            this.getHibernateTemplate().merge((Object)item);
        }
    }

    @Override
    public void deleteItemMetaData(Long itemId, String label) {
        ItemData item = (ItemData)this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId);
        List itemmetadatalist = this.getHibernateTemplate().findByNamedParam("from ItemMetaData imd where imd.item.itemId = :id and imd.label = :label", new String[]{"id", "label"}, new Object[]{itemId, label});
        item.getItemMetaDataSet().removeAll(itemmetadatalist);
        this.getHibernateTemplate().merge((Object)item);
    }

    @Override
    public void addItemMetaData(Long itemId, String label, String value) {
        ItemData item = (ItemData)this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId);
        if (item != null) {
            log.debug("**Id = {}, **score = {}, **grade = {}, **CorrectFeedback is lazy = {}, **Objective not lazy = {}", new Object[]{item.getItemId(), item.getScore(), item.getGrade(), item.getCorrectItemFeedback(), item.getItemMetaDataByLabel("ITEM_OBJECTIVE")});
            item.getItemMetaDataSet().add(new ItemMetaData((ItemDataIfc)item, label, value));
            this.getHibernateTemplate().merge((Object)item);
        }
    }

    @Override
    public ItemFacade saveItem(ItemFacade item) throws DataFacadeException {
        List<ItemFacade> list = new ArrayList<ItemFacade>(1);
        list.add(item);
        list = this.saveItems(list);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public void removeItemAttachment(Long itemAttachmentId) {
        ItemAttachment itemAttachment = (ItemAttachment)this.getHibernateTemplate().load(ItemAttachment.class, (Serializable)itemAttachmentId);
        ItemDataIfc item = itemAttachment.getItem();
        if (item != null) {
            item.getItemAttachmentSet().remove(itemAttachment);
            this.getHibernateTemplate().merge((Object)item);
        }
    }

    @Override
    public List<ItemFacade> saveItems(List<ItemFacade> items) throws DataFacadeException {
        log.debug("Persist items: {}", items);
        try {
            for (ItemFacade item : items) {
                ItemDataIfc itemData = item.getData();
                itemData.setLastModifiedDate(new Date());
                itemData.setLastModifiedBy(AgentFacade.getAgentString());
                itemData.setHash(this.itemHashUtil.hashItem(itemData));
                itemData = (ItemDataIfc)this.getHibernateTemplate().merge((Object)itemData);
                item.setData(itemData);
                item.setItemId(itemData.getItemId());
                if (itemData.getSection() == null) continue;
                AssessmentIfc assessment = itemData.getSection().getAssessment();
                assessment.setLastModifiedBy(AgentFacade.getAgentString());
                assessment.setLastModifiedDate(new Date());
                this.getHibernateTemplate().merge((Object)assessment);
            }
            return items;
        }
        catch (Exception e) {
            log.warn("Could not save items, {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public BackfillItemHashResult backfillItemHashes(int batchSize) {
        return this.itemHashUtil.backfillItemHashes(batchSize, BACKFILL_HASHES_HQL, ItemData.class, i -> {
            String hash = this.itemHashUtil.hashItemUnchecked((ItemDataIfc)i);
            i.setHash(hash);
            return i;
        }, this.getHibernateTemplate());
    }

    @Override
    public ItemFacade getItem(Long itemId) {
        ItemData item = null;
        try {
            item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        }
        catch (DataAccessException e) {
            log.warn("unable to retrieve item " + itemId + " due to:", (Throwable)e);
            return null;
        }
        return new ItemFacade((ItemDataIfc)item);
    }

    @Override
    public Boolean itemExists(Long itemId) {
        try {
            if (this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId) == null) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, ItemFacade> getItemsByHash(String hash) {
        List list1 = this.getHibernateTemplate().findByNamedParam("from ItemData where hash = :hash", "hash", (Object)hash);
        HashMap<String, ItemFacade> itemFacadeMap = new HashMap<String, ItemFacade>();
        for (int i = 0; i < list1.size(); ++i) {
            ItemData a = (ItemData)list1.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)a);
            itemFacadeMap.put(f.getItemIdString(), f);
        }
        return itemFacadeMap;
    }

    @Override
    public Map<String, ItemFacade> getItemsByKeyword(String keyword) {
        ItemFacade f;
        ItemData a;
        int i;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, ItemText itext where itext.item=ab and itext.text like :text");
            q.setParameter("text", (Object)keyword);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        HibernateCallback hcb2 = session -> {
            Query q = session.createQuery("select distinct ab from ItemData ab, Answer answer where answer.item=ab and answer.text like :text");
            q.setParameter("text", (Object)keyword);
            return q.list();
        };
        List list2 = (List)this.getHibernateTemplate().execute(hcb2);
        HibernateCallback hcb3 = session -> {
            Query q = session.createQuery("select ab from ItemData ab, ItemMetaData md where md.item=ab and md.entry like :keyword and md.label = :label");
            q.setParameter("keyword", (Object)keyword);
            q.setParameter("label", (Object)"KEYWORD");
            return q.list();
        };
        List list3 = (List)this.getHibernateTemplate().execute(hcb3);
        HibernateCallback hcb4 = session -> {
            Query q = session.createQuery("select ab from ItemData ab where ab.instruction like :keyword");
            q.setParameter("keyword", (Object)keyword);
            return q.list();
        };
        List list4 = (List)this.getHibernateTemplate().execute(hcb4);
        HashMap<String, ItemFacade> itemfacadeMap = new HashMap<String, ItemFacade>();
        for (i = 0; i < list1.size(); ++i) {
            a = (ItemData)list1.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list2.size(); ++i) {
            a = (ItemData)list2.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list3.size(); ++i) {
            a = (ItemData)list3.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list4.size(); ++i) {
            a = (ItemData)list4.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        log.debug("Search for keyword, found: " + itemfacadeMap.size());
        return itemfacadeMap;
    }

    @Override
    public Long getItemTextId(Long publishedItemId) {
        List list = (List)this.getHibernateTemplate().execute(session -> session.createQuery("select i.id from PublishedItemText i where i.item.itemId = :id").setParameter("id", (Object)publishedItemId).list());
        log.debug("list.size() = {}", (Object)list.size());
        Long itemTextId = -1L;
        if (!list.isEmpty()) {
            itemTextId = (Long)list.get(0);
        }
        log.debug("itemTextId {}", (Object)itemTextId);
        return itemTextId;
    }

    @Override
    public void updateItemTagBindingsHavingTag(TagServiceHelper.TagView tagView) {
        this.getHibernateTemplate().execute(session -> session.createQuery("update ItemTag it set it.tagLabel = :tagLabel, it.tagCollectionId = :tagCollectionId, it.tagCollectionName = :tagCollectionName where it.tagId = :tagId").setParameter("tagLabel", (Object)tagView.tagLabel).setParameter("tagCollectionId", (Object)tagView.tagCollectionId).setParameter("tagCollectionName", (Object)tagView.tagCollectionName).setParameter("tagId", (Object)tagView.tagId).executeUpdate());
    }

    @Override
    public void deleteItemTagBindingsHavingTagId(String tagId) {
        this.getHibernateTemplate().execute(session -> session.createQuery("delete ItemTag it where it.tagId = :tagId").setParameter("tagId", (Object)tagId).executeUpdate());
    }

    @Override
    public void updateItemTagBindingsHavingTagCollection(TagServiceHelper.TagCollectionView tagCollectionView) {
        this.getHibernateTemplate().execute(session -> session.createQuery("update ItemTag it set it.tagCollectionName = :tagCollectionName where it.tagCollectionId = :tagCollectionId").setParameter("tagCollectionName", (Object)tagCollectionView.tagCollectionName).setParameter("tagCollectionId", (Object)tagCollectionView.tagCollectionId).executeUpdate());
    }

    @Override
    public void deleteItemTagBindingsHavingTagCollectionId(String tagCollectionId) {
        this.getHibernateTemplate().execute(session -> session.createQuery("delete ItemTag it where it.tagCollectionId = :tagCollectionId").setParameter("tagCollectionId", (Object)tagCollectionId).executeUpdate());
    }

    @Override
    public List<Long> getItemsIdsByHash(String hash) {
        List list1 = (List)this.getHibernateTemplate().execute(session -> session.createQuery("select ab.itemId from ItemData ab where ab.hash = :hash ").setParameter("hash", (Object)hash).list());
        return list1;
    }

    @Override
    public Long getAssessmentId(Long itemId) {
        List list1 = (List)this.getHibernateTemplate().execute(session -> session.createQuery("select s.assessment.assessmentBaseId from SectionData s, ItemData i where s.id = i.section AND i.itemId = :itemId").setParameter("itemId", (Object)itemId).list());
        if (list1.isEmpty()) {
            return -1L;
        }
        return ((Number)list1.get(0)).longValue();
    }

    public void setItemHashUtil(ItemHashUtil itemHashUtil) {
        this.itemHashUtil = itemHashUtil;
    }
}

