/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.type.BooleanType;
import org.hibernate.type.Type;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.grading.api.GradingService;
import org.sakaiproject.rubrics.api.RubricsService;
import org.sakaiproject.samigo.api.SamigoReferenceReckoner;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswer;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedEvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.util.PagingUtilQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.PublishingTargetHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class PublishedAssessmentFacadeQueries
extends HibernateDaoSupport
implements PublishedAssessmentFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(PublishedAssessmentFacadeQueries.class);
    private SiteService siteService;
    private ToolManager toolManager;
    private UserDirectoryService userDirectoryService;
    public static final String STARTDATE = "assessmentAccessControl.startDate";
    public static final String DUEDATE = "assessmentAccessControl.dueDate";
    public static final String RETRACTDATE = "assessmentAccessControl.retractDate";
    public static final String RELEASETO = "assessmentAccessControl.releaseTo";
    public static final String PUB_RELEASETO = "releaseTo";
    public static final String PUB_STARTDATE = "startDate";
    public static final String PUB_DUEDATE = "dueDate";
    public static final String TITLE = "title";
    public static final String GRADE = "finalScore";
    public static final String DUE = "dueDate";
    public static final String RAW = "totalAutoScore";
    public static final String TIME = "timeElapsed";
    public static final String SUBMITTED = "submittedDate";
    public static final String SITECONTENTPATH = "/access/content/group/";

    @Override
    public IdImpl getId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(long id) {
        return new IdImpl(id);
    }

    @Override
    public PublishedAssessmentData preparePublishedAssessment(AssessmentData a) {
        String protocol = ServerConfigurationService.getServerUrl();
        PublishedAssessmentData publishedAssessment = new PublishedAssessmentData(a.getTitle(), a.getDescription(), a.getComments(), TypeFacade.HOMEWORK, a.getInstructorNotification(), a.getTesteeNotification(), a.getMultipartAllowed(), a.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        publishedAssessment.setAssessmentId(a.getAssessmentBaseId());
        Set publishedSectionSet = this.preparePublishedSectionSet(publishedAssessment, a.getSectionSet(), protocol);
        publishedAssessment.setSectionSet(publishedSectionSet);
        PublishedAccessControl publishedAccessControl = this.preparePublishedAccessControl(publishedAssessment, (AssessmentAccessControl)a.getAssessmentAccessControl());
        publishedAssessment.setAssessmentAccessControl((AssessmentAccessControlIfc)publishedAccessControl);
        PublishedEvaluationModel publishedEvaluationModel = this.preparePublishedEvaluationModel(publishedAssessment, (EvaluationModel)a.getEvaluationModel());
        publishedAssessment.setEvaluationModel((EvaluationModelIfc)publishedEvaluationModel);
        PublishedFeedback publishedFeedback = this.preparePublishedFeedback(publishedAssessment, (AssessmentFeedback)a.getAssessmentFeedback());
        publishedAssessment.setAssessmentFeedback((AssessmentFeedbackIfc)publishedFeedback);
        Set publishedMetaDataSet = this.preparePublishedMetaDataSet(publishedAssessment, a.getAssessmentMetaDataSet());
        log.debug("******* metadata set" + a.getAssessmentMetaDataSet());
        log.debug("******* published metadata set" + publishedMetaDataSet);
        publishedAssessment.setAssessmentMetaDataSet(publishedMetaDataSet);
        Set publishedIPSet = this.preparePublishedSecuredIPSet(publishedAssessment, a.getSecuredIPAddressSet());
        publishedAssessment.setSecuredIPAddressSet(publishedIPSet);
        Set publishedAssessmentAttachmentSet = this.preparePublishedAssessmentAttachmentSet(publishedAssessment, a.getAssessmentAttachmentSet(), protocol);
        publishedAssessment.setAssessmentAttachmentSet(publishedAssessmentAttachmentSet);
        publishedAssessment.setCategoryId(a.getCategoryId());
        return publishedAssessment;
    }

    @Override
    public PublishedFeedback preparePublishedFeedback(PublishedAssessmentData p, AssessmentFeedback a) {
        if (a == null) {
            return null;
        }
        PublishedFeedback publishedFeedback = new PublishedFeedback(a.getFeedbackDelivery(), a.getFeedbackComponentOption(), a.getFeedbackAuthoring(), a.getEditComponents(), a.getShowQuestionText(), a.getShowStudentResponse(), a.getShowCorrectResponse(), a.getShowStudentScore(), a.getShowStudentQuestionScore(), a.getShowQuestionLevelFeedback(), a.getShowSelectionLevelFeedback(), a.getShowGraderComments(), a.getShowStatistics());
        publishedFeedback.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedFeedback;
    }

    @Override
    public PublishedAccessControl preparePublishedAccessControl(PublishedAssessmentData p, AssessmentAccessControl a) {
        if (a == null) {
            return new PublishedAccessControl();
        }
        PublishedAccessControl publishedAccessControl = new PublishedAccessControl(a.getSubmissionsAllowed(), a.getSubmissionsSaved(), a.getAssessmentFormat(), a.getBookMarkingItem(), a.getTimeLimit(), a.getTimedAssessment(), a.getRetryAllowed(), a.getLateHandling(), a.getInstructorNotification(), a.getStartDate(), a.getDueDate(), a.getScoreDate(), a.getFeedbackDate());
        publishedAccessControl.setRetractDate(a.getRetractDate());
        publishedAccessControl.setAutoSubmit(a.getAutoSubmit());
        publishedAccessControl.setItemNavigation(a.getItemNavigation());
        publishedAccessControl.setItemNumbering(a.getItemNumbering());
        publishedAccessControl.setDisplayScoreDuringAssessments(a.getDisplayScoreDuringAssessments());
        publishedAccessControl.setSubmissionMessage(a.getSubmissionMessage());
        publishedAccessControl.setReleaseTo(a.getReleaseTo());
        publishedAccessControl.setPassword(a.getPassword());
        publishedAccessControl.setFinalPageUrl(a.getFinalPageUrl());
        publishedAccessControl.setUnlimitedSubmissions(a.getUnlimitedSubmissions());
        publishedAccessControl.setMarkForReview(a.getMarkForReview());
        publishedAccessControl.setHonorPledge(a.getHonorPledge());
        publishedAccessControl.setFeedbackEndDate(a.getFeedbackEndDate());
        publishedAccessControl.setFeedbackScoreThreshold(a.getFeedbackScoreThreshold());
        publishedAccessControl.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedAccessControl;
    }

    @Override
    public PublishedEvaluationModel preparePublishedEvaluationModel(PublishedAssessmentData p, EvaluationModel e) {
        if (e == null) {
            return null;
        }
        PublishedEvaluationModel publishedEvaluationModel = new PublishedEvaluationModel(e.getEvaluationComponents(), e.getScoringType(), e.getNumericModelId(), e.getFixedTotalScore(), e.getGradeAvailable(), e.getIsStudentIdPublic(), e.getAnonymousGrading(), e.getAutoScoring(), e.getToGradeBook());
        publishedEvaluationModel.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedEvaluationModel;
    }

    @Override
    public Set preparePublishedMetaDataSet(PublishedAssessmentData p, Set metaDataSet) {
        HashSet<PublishedMetaData> h = new HashSet<PublishedMetaData>();
        for (AssessmentMetaData metaData : metaDataSet) {
            PublishedMetaData publishedMetaData = new PublishedMetaData((AssessmentBaseIfc)p, metaData.getLabel(), metaData.getEntry());
            h.add(publishedMetaData);
        }
        return h;
    }

    @Override
    public Set preparePublishedSecuredIPSet(PublishedAssessmentData p, Set ipSet) {
        HashSet<PublishedSecuredIPAddress> h = new HashSet<PublishedSecuredIPAddress>();
        for (SecuredIPAddress ip : ipSet) {
            PublishedSecuredIPAddress publishedIP = new PublishedSecuredIPAddress((AssessmentBaseIfc)p, ip.getHostname(), ip.getIpAddress());
            h.add(publishedIP);
        }
        return h;
    }

    @Override
    public Set preparePublishedSectionSet(PublishedAssessmentData publishedAssessment, Set sectionSet, String protocol) {
        log.debug("**published section size = {}", (Object)sectionSet.size());
        HashSet<PublishedSectionData> h = new HashSet<PublishedSectionData>();
        for (SectionData section : sectionSet) {
            PublishedSectionData publishedSection = new PublishedSectionData(section.getDuration(), section.getSequence(), section.getTitle(), section.getDescription(), section.getTypeId(), section.getStatus(), section.getCreatedBy(), section.getCreatedDate(), section.getLastModifiedBy(), section.getLastModifiedDate());
            Set publishedSectionAttachmentSet = this.preparePublishedSectionAttachmentSet(publishedSection, section.getSectionAttachmentSet(), protocol);
            publishedSection.setSectionAttachmentSet(publishedSectionAttachmentSet);
            Set publishedItemSet = this.preparePublishedItemSet(publishedSection, section.getItemSet(), protocol);
            publishedSection.setItemSet(publishedItemSet);
            Set publishedMetaDataSet = this.preparePublishedSectionMetaDataSet(publishedSection, section.getSectionMetaDataSet());
            publishedSection.setSectionMetaDataSet(publishedMetaDataSet);
            publishedSection.setAssessment((AssessmentIfc)publishedAssessment);
            h.add(publishedSection);
        }
        return h;
    }

    @Override
    public Set preparePublishedSectionMetaDataSet(PublishedSectionData publishedSection, Set metaDataSet) {
        HashSet<PublishedSectionMetaData> h = new HashSet<PublishedSectionMetaData>();
        for (SectionMetaData sectionMetaData : metaDataSet) {
            PublishedSectionMetaData publishedSectionMetaData = new PublishedSectionMetaData((SectionDataIfc)publishedSection, sectionMetaData.getLabel(), sectionMetaData.getEntry());
            h.add(publishedSectionMetaData);
        }
        h.add(new PublishedSectionMetaData((SectionDataIfc)publishedSection, "RANDOMIZATION_SEED", String.valueOf(UUID.randomUUID().hashCode())));
        return h;
    }

    @Override
    public Set preparePublishedItemSet(PublishedSectionData publishedSection, Set itemSet, String protocol) {
        log.debug("**published item size = {}", (Object)itemSet.size());
        HashSet<PublishedItemData> h = new HashSet<PublishedItemData>();
        for (ItemData item : itemSet) {
            PublishedItemData publishedItem = new PublishedItemData((SectionDataIfc)publishedSection, item.getSequence(), item.getDuration(), item.getInstruction(), item.getDescription(), item.getTypeId(), item.getGrade(), item.getScore(), item.getScoreDisplayFlag(), item.getDiscount(), item.getMinScore(), item.getHint(), item.getHasRationale(), item.getStatus(), item.getCreatedBy(), item.getCreatedDate(), item.getLastModifiedBy(), item.getLastModifiedDate(), null, null, null, item.getTriesAllowed(), item.getPartialCreditFlag(), item.getHash(), item.getHash(), item.getItemId());
            Set publishedItemTextSet = this.preparePublishedItemTextSet(publishedItem, item.getItemTextSet(), protocol);
            Set publishedItemMetaDataSet = this.preparePublishedItemMetaDataSet(publishedItem, item.getItemMetaDataSet());
            Set publishedItemTagSet = this.preparePublishedItemTagSet(publishedItem, item.getItemTagSet());
            Set publishedItemFeedbackSet = this.preparePublishedItemFeedbackSet(publishedItem, item.getItemFeedbackSet());
            Set publishedItemAttachmentSet = this.preparePublishedItemAttachmentSet(publishedItem, item.getItemAttachmentSet(), protocol);
            publishedItem.setItemTextSet(publishedItemTextSet);
            publishedItem.setItemMetaDataSet(publishedItemMetaDataSet);
            publishedItem.setItemTagSet(publishedItemTagSet);
            publishedItem.setItemFeedbackSet(publishedItemFeedbackSet);
            publishedItem.setItemAttachmentSet(publishedItemAttachmentSet);
            publishedItem.setAnswerOptionsRichCount(item.getAnswerOptionsRichCount());
            publishedItem.setAnswerOptionsSimpleOrRich(item.getAnswerOptionsSimpleOrRich());
            publishedItem.setIsExtraCredit(item.getIsExtraCredit());
            h.add(publishedItem);
        }
        return h;
    }

    @Override
    public Set preparePublishedItemTextSet(PublishedItemData publishedItem, Set itemTextSet, String protocol) {
        log.debug("**published item text size = {}", (Object)itemTextSet.size());
        HashSet<PublishedItemText> h = new HashSet<PublishedItemText>();
        for (ItemText itemText : itemTextSet) {
            log.debug("**item text id = {}", (Object)itemText.getId());
            PublishedItemText publishedItemText = new PublishedItemText(publishedItem, itemText.getSequence(), itemText.getText(), null);
            Set publishedAnswerSet = this.preparePublishedAnswerSet(publishedItemText, itemText.getAnswerSet());
            publishedItemText.setAnswerSet(publishedAnswerSet);
            Set publishedItemTextAttachmentSet = this.preparePublishedItemTextAttachmentSet(publishedItemText, itemText.getItemTextAttachmentSet(), protocol);
            publishedItemText.setItemTextAttachmentSet(publishedItemTextAttachmentSet);
            publishedItemText.setRequiredOptionsCount(itemText.getRequiredOptionsCount());
            h.add(publishedItemText);
        }
        return h;
    }

    @Override
    public Set preparePublishedItemMetaDataSet(PublishedItemData publishedItem, Set itemMetaDataSet) {
        HashSet<PublishedItemMetaData> h = new HashSet<PublishedItemMetaData>();
        for (ItemMetaData itemMetaData : itemMetaDataSet) {
            PublishedItemMetaData publishedItemMetaData = new PublishedItemMetaData((ItemDataIfc)publishedItem, itemMetaData.getLabel(), itemMetaData.getEntry());
            h.add(publishedItemMetaData);
        }
        return h;
    }

    @Override
    public Set preparePublishedItemFeedbackSet(PublishedItemData publishedItem, Set itemFeedbackSet) {
        HashSet<PublishedItemFeedback> h = new HashSet<PublishedItemFeedback>();
        for (ItemFeedback itemFeedback : itemFeedbackSet) {
            PublishedItemFeedback publishedItemFeedback = new PublishedItemFeedback(publishedItem, itemFeedback.getTypeId(), itemFeedback.getText());
            h.add(publishedItemFeedback);
        }
        return h;
    }

    public Set preparePublishedItemAttachmentSet(PublishedItemData publishedItem, Set itemAttachmentSet, String protocol) {
        HashSet<PublishedItemAttachment> h = new HashSet<PublishedItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedItemAttachment publishedItemAttachment = new PublishedItemAttachment(null, (ItemDataIfc)publishedItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), itemAttachment.getCreatedBy(), itemAttachment.getCreatedDate(), itemAttachment.getLastModifiedBy(), itemAttachment.getLastModifiedDate());
                h.add(publishedItemAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set preparePublishedItemTagSet(PublishedItemData publishedItem, Set itemTagSet) {
        HashSet<PublishedItemTag> h = new HashSet<PublishedItemTag>();
        for (ItemTag itemTag : itemTagSet) {
            PublishedItemTag publishedItemTag = new PublishedItemTag((ItemDataIfc)publishedItem, itemTag.getTagId(), itemTag.getTagLabel(), itemTag.getTagCollectionId(), itemTag.getTagCollectionName());
            h.add(publishedItemTag);
        }
        return h;
    }

    public Set preparePublishedItemTextAttachmentSet(PublishedItemText publishedItemText, Set itemTextAttachmentSet, String protocol) {
        HashSet<PublishedItemTextAttachment> h = new HashSet<PublishedItemTextAttachment>();
        for (ItemTextAttachment itemTextAttachment : itemTextAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemTextAttachment.getResourceId(), itemTextAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedItemTextAttachment publishedItemTextAttachment = new PublishedItemTextAttachment(null, (ItemTextIfc)publishedItemText, cr_copy.getId(), itemTextAttachment.getFilename(), itemTextAttachment.getMimeType(), itemTextAttachment.getFileSize(), itemTextAttachment.getDescription(), url, itemTextAttachment.getIsLink(), itemTextAttachment.getStatus(), itemTextAttachment.getCreatedBy(), itemTextAttachment.getCreatedDate(), itemTextAttachment.getLastModifiedBy(), itemTextAttachment.getLastModifiedDate());
                h.add(publishedItemTextAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    public String getRelativePath(String url, String protocol) {
        String location = url = this.replaceSpace(url);
        int index = url.lastIndexOf(protocol);
        if (index == 0) {
            location = url.substring(protocol.length());
        }
        return location;
    }

    public Set preparePublishedSectionAttachmentSet(PublishedSectionData publishedSection, Set sectionAttachmentSet, String protocol) {
        HashSet<PublishedSectionAttachment> h = new HashSet<PublishedSectionAttachment>();
        for (SectionAttachment sectionAttachment : sectionAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(sectionAttachment.getResourceId(), sectionAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedSectionAttachment publishedSectionAttachment = new PublishedSectionAttachment(null, (SectionDataIfc)publishedSection, cr_copy.getId(), sectionAttachment.getFilename(), sectionAttachment.getMimeType(), sectionAttachment.getFileSize(), sectionAttachment.getDescription(), url, sectionAttachment.getIsLink(), sectionAttachment.getStatus(), sectionAttachment.getCreatedBy(), sectionAttachment.getCreatedDate(), sectionAttachment.getLastModifiedBy(), sectionAttachment.getLastModifiedDate());
                h.add(publishedSectionAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set preparePublishedAssessmentAttachmentSet(PublishedAssessmentData publishedAssessment, Set assessmentAttachmentSet, String protocol) {
        HashSet<PublishedAssessmentAttachment> h = new HashSet<PublishedAssessmentAttachment>();
        for (AssessmentAttachment assessmentAttachment : assessmentAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(assessmentAttachment.getResourceId(), assessmentAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedAssessmentAttachment publishedAssessmentAttachment = new PublishedAssessmentAttachment(null, (AssessmentIfc)publishedAssessment, cr_copy.getId(), assessmentAttachment.getFilename(), assessmentAttachment.getMimeType(), assessmentAttachment.getFileSize(), assessmentAttachment.getDescription(), url, assessmentAttachment.getIsLink(), assessmentAttachment.getStatus(), assessmentAttachment.getCreatedBy(), assessmentAttachment.getCreatedDate(), assessmentAttachment.getLastModifiedBy(), assessmentAttachment.getLastModifiedDate());
                h.add(publishedAssessmentAttachment);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return h;
    }

    @Override
    public Set preparePublishedAnswerSet(PublishedItemText publishedItemText, Set answerSet) {
        log.debug("**published answer size = {}", (Object)answerSet.size());
        HashSet<PublishedAnswer> h = new HashSet<PublishedAnswer>();
        for (Answer answer : answerSet) {
            PublishedAnswer publishedAnswer = new PublishedAnswer((ItemTextIfc)publishedItemText, answer.getText(), answer.getSequence(), answer.getLabel(), answer.getIsCorrect(), answer.getGrade(), answer.getScore(), answer.getPartialCredit(), answer.getDiscount(), null);
            Set publishedAnswerFeedbackSet = this.preparePublishedAnswerFeedbackSet(publishedAnswer, answer.getAnswerFeedbackSet());
            publishedAnswer.setAnswerFeedbackSet(publishedAnswerFeedbackSet);
            h.add(publishedAnswer);
        }
        return h;
    }

    @Override
    public Set preparePublishedAnswerFeedbackSet(PublishedAnswer publishedAnswer, Set answerFeedbackSet) {
        HashSet<PublishedAnswerFeedback> h = new HashSet<PublishedAnswerFeedback>();
        for (AnswerFeedback answerFeedback : answerFeedbackSet) {
            PublishedAnswerFeedback publishedAnswerFeedback = new PublishedAnswerFeedback((AnswerIfc)publishedAnswer, answerFeedback.getTypeId(), answerFeedback.getText());
            h.add(publishedAnswerFeedback);
        }
        return h;
    }

    @Override
    public boolean isPublishedAssessmentIdValid(Long publishedAssessmentId) {
        List list = this.getHibernateTemplate().findByNamedParam("from PublishedAssessmentData where publishedAssessmentId = :id", "id", (Object)publishedAssessmentId);
        if (!list.isEmpty()) {
            PublishedAssessmentData f = (PublishedAssessmentData)list.get(0);
            return f.getPublishedAssessmentId() > 0L;
        }
        return false;
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessment(Long assessmentId) {
        return this.getPublishedAssessment(assessmentId, true);
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessmentQuick(Long assessmentId) {
        PublishedAssessmentData a = this.loadPublishedAssessment(assessmentId);
        PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a, false);
        f.setStartDate(a.getStartDate());
        f.setDueDate(a.getDueDate());
        f.setRetractDate(a.getRetractDate());
        f.setTimeLimit(a.getTimeLimit());
        return f;
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessment(Long assessmentId, boolean withGroupsInfo) {
        PublishedAssessmentData a = this.loadPublishedAssessment(assessmentId);
        a.setSectionSet(this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
        Map<Object, Object> releaseToGroups = new HashMap();
        if (withGroupsInfo) {
            String siteId = this.getPublishedAssessmentSiteId(assessmentId.toString());
            Map groupsForSite = this.getGroupsForSite(siteId);
            releaseToGroups = this.getReleaseToGroups(groupsForSite, assessmentId);
        }
        PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a, releaseToGroups);
        return f;
    }

    @Override
    public Long getPublishedAssessmentId(Long assessmentId) {
        List list = this.getHibernateTemplate().findByNamedParam("from PublishedAssessmentData as p where p.assessmentId = :id order by p.createdDate desc", "id", (Object)assessmentId);
        Long publishedId = 0L;
        if (!list.isEmpty()) {
            PublishedAssessmentData f = (PublishedAssessmentData)list.get(0);
            publishedId = f.getPublishedAssessmentId();
        }
        return publishedId;
    }

    @Override
    public PublishedAssessmentFacade publishAssessment(AssessmentFacade assessment) throws Exception {
        PublishedAssessmentData publishedAssessment = this.preparePublishedAssessment((AssessmentData)assessment.getData());
        this.saveOrUpdate((PublishedAssessmentIfc)publishedAssessment);
        Set sectionSet = publishedAssessment.getSectionSet();
        for (PublishedSectionData section : sectionSet) {
            Set itemSet = section.getItemSet();
            for (PublishedItemData item : itemSet) {
                this.replaceEmbeddedSiteIdsForItem(item);
                Set itemMetaDataSet = item.getItemMetaDataSet();
                for (PublishedItemMetaData itemMetaData : itemMetaDataSet) {
                    if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                    log.debug("sectionId = " + section.getSectionId());
                    itemMetaData.setEntry(section.getSectionId().toString());
                }
            }
        }
        PublishedAssessmentFacade publishedAssessmentFacade = new PublishedAssessmentFacade((PublishedAssessmentIfc)publishedAssessment);
        if (publishedAssessment.getEvaluationModel() != null) {
            String toGradebook = publishedAssessment.getEvaluationModel().getToGradeBook();
            boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
            GradingService g = null;
            if (integrated) {
                g = (GradingService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.grading.api.GradingService");
            }
            GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
            if (toGradebook != null && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
                try {
                    Site site = this.siteService.getSite(this.toolManager.getCurrentPlacement().getContext());
                    String ref = SamigoReferenceReckoner.reckoner().site(site.getId()).subtype("p").id(publishedAssessmentFacade.getPublishedAssessmentId().toString()).reckon().getReference();
                    publishedAssessment.setReference(ref);
                    gbsHelper.addToGradebook(publishedAssessment, publishedAssessment.getCategoryId(), g);
                }
                catch (Exception e) {
                    log.error("Removing published assessment: " + e);
                    this.delete((PublishedAssessmentIfc)publishedAssessment);
                    throw e;
                }
            }
        }
        this.createAuthorization(publishedAssessment);
        return publishedAssessmentFacade;
    }

    @Override
    public PublishedAssessmentFacade publishPreviewAssessment(AssessmentFacade assessment) {
        PublishedAssessmentData publishedAssessment = this.preparePublishedAssessment((AssessmentData)assessment.getData());
        publishedAssessment.setStatus(PublishedAssessmentIfc.DEAD_STATUS);
        try {
            this.saveOrUpdate((PublishedAssessmentIfc)publishedAssessment);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        this.createAuthorization(publishedAssessment);
        return new PublishedAssessmentFacade((PublishedAssessmentIfc)publishedAssessment);
    }

    @Override
    public void createAuthorization(PublishedAssessmentData p) {
        if (p.getAssessmentAccessControl().getReleaseTo() != null && p.getAssessmentAccessControl().getReleaseTo().equals("Selected Groups")) {
            this.createAuthorizationForSelectedGroups(p);
            return;
        }
        String qualifierIdString = p.getPublishedAssessmentId().toString();
        Vector<String> v = new Vector<String>();
        PublishingTargetHelper ptHelper = IntegrationContextFactory.getInstance().getPublishingTargetHelper();
        HashMap targets = ptHelper.getTargets();
        HashMap<String, String> trimedTargets = new HashMap<String, String>();
        for (Map.Entry entry : targets.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            trimedTargets.put(key.trim(), value);
        }
        AssessmentAccessControlIfc control = p.getAssessmentAccessControl();
        String releaseTo = control.getReleaseTo();
        if (releaseTo != null) {
            String[] targetSelected = new String[]{releaseTo};
            for (int i = 0; i < targetSelected.length; ++i) {
                String agentKey = targetSelected[i].trim();
                if (trimedTargets.get(agentKey) == null) continue;
                v.add((String)trimedTargets.get(agentKey));
            }
        }
        PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "OWN_PUBLISHED_ASSESSMENT", qualifierIdString);
        for (int i = 0; i < v.size(); ++i) {
            String agentId = (String)v.get(i);
            log.debug("** agentId=" + agentId);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "TAKE_PUBLISHED_ASSESSMENT", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "VIEW_PUBLISHED_ASSESSMENT_FEEDBACK", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "GRADE_PUBLISHED_ASSESSMENT", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "VIEW_PUBLISHED_ASSESSMENT", qualifierIdString);
        }
    }

    public void createAuthorizationForSelectedGroups(PublishedAssessmentData publishedAssessment) {
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        String qualifierIdString = publishedAssessment.getPublishedAssessmentId().toString();
        authz.createAuthorization(AgentFacade.getCurrentSiteId(), "OWN_PUBLISHED_ASSESSMENT", qualifierIdString);
        authz.createAuthorization(AgentFacade.getCurrentSiteId(), "VIEW_PUBLISHED_ASSESSMENT", qualifierIdString);
        List<AuthorizationData> authorizationsToCopy = authz.getAuthorizationByFunctionAndQualifier("TAKE_ASSESSMENT", publishedAssessment.getAssessmentId().toString());
        if (authorizationsToCopy != null && authorizationsToCopy.size() > 0) {
            for (AuthorizationData adToCopy : authorizationsToCopy) {
                authz.createAuthorization(adToCopy.getAgentIdString(), "TAKE_PUBLISHED_ASSESSMENT", publishedAssessment.getPublishedAssessmentId().toString());
            }
        }
    }

    @Override
    public AssessmentData loadAssessment(Long assessmentId) {
        return (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
    }

    @Override
    public PublishedAssessmentData loadPublishedAssessment(Long assessmentId) {
        PublishedAssessmentData ret = null;
        try {
            ret = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)assessmentId);
        }
        catch (DataAccessException e) {
            log.warn("Error accessing Published Assesment: " + assessmentId + " storage returned: " + e);
        }
        return ret;
    }

    @Override
    public List<PublishedAssessmentFacade> getAllTakeableAssessments(String orderBy, boolean ascending, Integer status) {
        String query = "from PublishedAssessmentData as p where p.status = :status order by p." + orderBy;
        query = query + (ascending ? " asc" : " desc");
        log.debug("Order by " + orderBy);
        String hql = query;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery(hql);
            q.setParameter("status", (Object)status);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (PublishedAssessmentData a : list) {
            log.debug("Title: " + a.getTitle());
            assessmentList.add(new PublishedAssessmentFacade((PublishedAssessmentIfc)a));
        }
        return assessmentList;
    }

    @Override
    public Integer getNumberOfSubmissions(String publishedAssessmentId, String agentId) {
        HibernateCallback hcb = session -> session.createQuery("select count(a) from AssessmentGradingData a where a.publishedAssessmentId = :id and a.agentId = :agent and a.forGrade = :forgrade and a.status > :status").setParameter("id", (Object)Long.parseLong(publishedAssessmentId)).setParameter("agent", (Object)agentId).setParameter("forgrade", (Object)true).setParameter("status", (Object)AssessmentGradingData.REMOVED).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public List<AssessmentGradingData> getNumberOfSubmissionsOfAllAssessmentsByAgent(String agentId) {
        HibernateCallback hcb = session -> session.createQuery("select new AssessmentGradingData(a.publishedAssessmentId, count(a)) from AssessmentGradingData as a where a.agentId = :agent and a.forGrade= :forgrade and a.status > :status group by a.publishedAssessmentId").setParameter("agent", (Object)agentId).setParameter("forgrade", (Object)true, (Type)BooleanType.INSTANCE).setParameter("status", (Object)AssessmentGradingData.REMOVED).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<AssessmentGradingData> getNumberOfSubmissionsOfAllAssessmentsByAgent(String agentId, String siteId) {
        List<String> groupIds = this.getSiteGroupIdsForSubmittingAgent(agentId, siteId);
        if (groupIds.size() > 0) {
            HibernateCallback hcb = session -> {
                Query q = session.createQuery("select new AssessmentGradingData( a.publishedAssessmentId, count(distinct a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade and a.status > :status and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId");
                q.setParameter("agentId", (Object)agentId);
                q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
                q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                q.setParameter("siteId", (Object)siteId);
                q.setParameterList("groupIds", (Collection)groupIds);
                q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            };
            return (List)this.getHibernateTemplate().execute(hcb);
        }
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade and a.status > :status  and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId");
            q.setParameter("agentId", (Object)agentId);
            q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            q.setParameter("siteId", (Object)siteId);
            q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<PublishedAssessmentFacade> getAllPublishedAssessments(String sortString) {
        String orderBy = this.getOrderBy(sortString);
        List list = this.getHibernateTemplate().find("from PublishedAssessmentData p order by p." + orderBy, new Object[0]);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (PublishedAssessmentData a : list) {
            a.setSectionSet(this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public List<PublishedAssessmentFacade> getAllPublishedAssessments(String sortString, Integer status) {
        String orderBy = this.getOrderBy(sortString);
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from PublishedAssessmentData as p where p.status = :status order by p." + orderBy);
            q.setParameter("status", (Object)status);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (PublishedAssessmentData a : list) {
            a.setSectionSet(this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public List<PublishedAssessmentFacade> getAllPublishedAssessments(int pageSize, int pageNumber, String sortString, Integer status) {
        String orderBy = this.getOrderBy(sortString);
        String queryString = "from PublishedAssessmentData p order by p." + orderBy;
        if (!status.equals(PublishedAssessmentFacade.ANY_STATUS)) {
            queryString = "from PublishedAssessmentData p where p.status = :status order by p." + orderBy;
        }
        PagingUtilQueriesAPI pagingUtilQueries = PersistenceService.getInstance().getPagingUtilQueries();
        List pageList = pagingUtilQueries.getAll(pageSize, pageNumber, queryString, status);
        log.debug("**** pageList=" + pageList);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (PublishedAssessmentData a : pageList) {
            a.setSectionSet(this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            log.debug("****  published assessment=" + a.getTitle());
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            log.debug("**** published assessment title=" + f.getTitle());
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public void removeAssessment(Long assessmentId, String action) {
        PublishedAssessmentData assessment = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)assessmentId);
        if (action == null || action.equals("preview")) {
            this.delete((PublishedAssessmentIfc)assessment);
            PersistenceService.getInstance().getAuthzQueriesFacade().removeAuthorizationByQualifier(assessment.getPublishedAssessmentId().toString(), true);
        } else {
            assessment.setLastModifiedBy(AgentFacade.getAgentString());
            assessment.setLastModifiedDate(new Date());
            assessment.setStatus(PublishedAssessmentIfc.DEAD_STATUS);
            try {
                this.saveOrUpdate((PublishedAssessmentIfc)assessment);
                RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
                rubricsService.softDeleteRubricAssociationsByItemIdPrefix("pub." + assessmentId + ".", "sakai.samigo");
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
    }

    private String getOrderBy(String sortString) {
        String startDate = STARTDATE.substring(STARTDATE.lastIndexOf(".") + 1);
        String dueDate = DUEDATE.substring(DUEDATE.lastIndexOf(".") + 1);
        String releaseTo = RELEASETO.substring(RELEASETO.lastIndexOf(".") + 1);
        if (sortString.equals(startDate)) {
            return STARTDATE;
        }
        if (sortString.equals(dueDate)) {
            return DUEDATE;
        }
        if (sortString.equals(releaseTo)) {
            return RELEASETO;
        }
        return TITLE;
    }

    @Override
    public void deleteAllSecuredIP(PublishedAssessmentIfc assessment) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                Long assessmentId = assessment.getPublishedAssessmentId();
                List ip = this.getHibernateTemplate().findByNamedParam("from PublishedSecuredIPAddress s where s.assessment.publishedAssessmentId = :id", "id", (Object)assessmentId);
                if (ip.size() > 0) {
                    PublishedSecuredIPAddress s = (PublishedSecuredIPAddress)ip.get(0);
                    PublishedAssessmentData a = (PublishedAssessmentData)s.getAssessment();
                    a.setSecuredIPAddressSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)ip);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting ip address: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdate(PublishedAssessmentIfc assessment) throws Exception {
        PublishedAssessmentData data = assessment instanceof PublishedAssessmentFacade ? (PublishedAssessmentData)((PublishedAssessmentFacade)assessment).getData() : (PublishedAssessmentData)assessment;
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update assessment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                if (retryCount != 0) continue;
                throw e;
            }
        }
    }

    @Override
    public List<PublishedAssessmentFacade> getBasicInfoOfAllActivePublishedAssessments(String sortString, String siteAgentId, boolean ascending) {
        Date currentDate = new Date();
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.lastModifiedDate, p.lastModifiedBy)  from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId = p.publishedAssessmentId and p.status=:status and  p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId  order by p." + orderBy;
        String hql = query = query + (ascending ? " asc" : " desc");
        HibernateCallback hcb = session -> {
            Query q = session.createQuery(hql);
            q.setParameter("status", (Object)1);
            q.setParameter("functionId", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("siteId", (Object)siteAgentId);
            return q.list();
        };
        List l = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentData> list = new ArrayList<PublishedAssessmentData>();
        for (PublishedAssessmentData p : l) {
            if (p.getDueDate() != null && !p.getDueDate().after(currentDate) || p.getRetractDate() != null && !p.getRetractDate().after(currentDate)) continue;
            list.add(p);
        }
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        Map groupsForSite = null;
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (PublishedAssessmentData p : list) {
            Map<String, String> releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroups(groupsForSite, assessmentId);
            }
            agent = new AgentFacade(p.getLastModifiedBy());
            lastModifiedBy = agent.getDisplayName();
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy);
            pubList.add(f);
        }
        return pubList;
    }

    @Override
    public List getBasicInfoOfAllInActivePublishedAssessments(String sortString, String siteAgentId, boolean ascending) {
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title, c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.status, p.lastModifiedDate, p.lastModifiedBy) from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and ((p.status=:activeStatus and (c.dueDate<=:today or c.retractDate<=:today)) or p.status=:editStatus) and p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId  order by p." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        String hql = query;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery(hql);
            q.setParameter("activeStatus", (Object)1);
            q.setTimestamp("today", new Date());
            q.setParameter("editStatus", (Object)3);
            q.setParameter("functionId", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("siteId", (Object)siteAgentId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        Map groupsForSite = null;
        String lastModifiedBy = "";
        for (int i = 0; i < list.size(); ++i) {
            AgentFacade agent;
            PublishedAssessmentData p = (PublishedAssessmentData)list.get(i);
            Map<String, String> releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroups(groupsForSite, assessmentId);
            }
            if ((agent = new AgentFacade(p.getLastModifiedBy())) != null) {
                lastModifiedBy = agent.getDisplayName();
            }
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getStatus(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy);
            pubList.add(f);
        }
        return pubList;
    }

    @Override
    public Set<PublishedSectionData> getSectionSetForAssessment(PublishedAssessmentIfc assessment) {
        List sectionList = this.getHibernateTemplate().findByNamedParam("from PublishedSectionData s where s.assessment.publishedAssessmentId = :id", "id", (Object)assessment.getPublishedAssessmentId());
        Hibernate.initialize((Object)sectionList);
        return new HashSet<PublishedSectionData>(sectionList);
    }

    @Override
    public PublishedAssessmentFacade getSettingsOfPublishedAssessment(Long assessmentId) {
        PublishedAssessmentData a = this.loadPublishedAssessment(assessmentId);
        Boolean loadSection = Boolean.FALSE;
        PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a, loadSection);
        return f;
    }

    @Override
    public PublishedItemData loadPublishedItem(Long itemId) {
        return (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
    }

    @Override
    public PublishedItemText loadPublishedItemText(Long itemTextId) {
        return (PublishedItemText)this.getHibernateTemplate().load(PublishedItemText.class, (Serializable)itemTextId);
    }

    @Override
    public List<PublishedAssessmentFacade> getBasicInfoOfAllPublishedAssessments(String orderBy, boolean ascending, String siteId) {
        List<String> groupIds = this.getSiteGroupIdsForCurrentUser(siteId);
        Object query = "";
        query = groupIds.size() > 0 ? "select distinct new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed, em.scoringType, p.status, p.lastModifiedDate, c.timeLimit, c.feedbackEndDate, c.feedbackScoreThreshold)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f, AuthorizationData as az, PublishedEvaluationModel as em where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId = em.assessment.publishedAssessmentId  and (p.status=:activeStatus or p.status=:editStatus) and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by " : "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed, em.scoringType, p.status, p.lastModifiedDate, c.timeLimit, c.feedbackEndDate, c.feedbackScoreThreshold)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f, AuthorizationData as az, PublishedEvaluationModel as em where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId = em.assessment.publishedAssessmentId  and (p.status=:activeStatus or p.status=:editStatus) and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by ";
        query = !ascending ? (orderBy.equals("dueDate") ? (String)query + " c." + orderBy + " desc" : (String)query + " p." + orderBy + " desc") : (orderBy.equals("dueDate") ? (String)query + " c." + orderBy + " asc" : (String)query + " p." + orderBy + " asc");
        Object hql = query;
        HibernateCallback hcb = arg_0 -> PublishedAssessmentFacadeQueries.lambda$getBasicInfoOfAllPublishedAssessments$8((String)hql, siteId, groupIds, arg_0);
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        for (PublishedAssessmentData p : list) {
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getRetractDate(), p.getFeedbackDate(), p.getFeedbackDelivery(), p.getFeedbackComponentOption(), p.getFeedbackAuthoring(), p.getLateHandling(), p.getUnlimitedSubmissions(), p.getSubmissionsAllowed(), p.getScoringType(), p.getStatus(), p.getLastModifiedDate(), p.getTimeLimit(), p.getFeedbackEndDate(), p.getFeedbackScoreThreshold());
            pubList.add(f);
        }
        return pubList;
    }

    @Override
    public List<PublishedAssessmentFacade> getBasicInfoOfAllPublishedAssessments2(String sortString, boolean ascending, String siteAgentId) {
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.status, p.lastModifiedDate, p.lastModifiedBy, c.lateHandling, c.unlimitedSubmissions, c.submissionsAllowed)  from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId = p.publishedAssessmentId  and p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId and (p.status=:activeStatus or p.status=:editStatus)  order by p." + orderBy;
        String hql = query = query + (ascending ? " asc" : " desc");
        HibernateCallback hcb = session -> {
            Query q = session.createQuery(hql);
            q.setParameter("functionId", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("siteId", (Object)siteAgentId);
            q.setParameter("activeStatus", (Object)1);
            q.setParameter("editStatus", (Object)3);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        Map groupsForSite = null;
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (PublishedAssessmentData p : list) {
            Map<String, String> releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroups(groupsForSite, assessmentId);
            }
            if ((agent = new AgentFacade(p.getLastModifiedBy())) != null) {
                lastModifiedBy = agent.getDisplayName();
            }
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getRetractDate(), p.getStatus(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy, p.getLateHandling(), p.getUnlimitedSubmissions(), p.getSubmissionsAllowed());
            pubList.add(f);
        }
        return pubList;
    }

    @Override
    public List<AssessmentGradingData> getBasicInfoOfLastSubmittedAssessments(String agentId, String orderBy, boolean ascending) {
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p where a.publishedAssessmentId = p.publishedAssessmentId  and a.forGrade = :forgrade and a.agentId = :agent and a.status > :status order by p.publishedAssessmentId DESC, a.submittedDate DESC";
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p where a.publishedAssessmentId = p.publishedAssessmentId  and a.forGrade = :forgrade and a.agentId = :agent and a.status > :status order by p.publishedAssessmentId DESC, a.submittedDate DESC");
            q.setParameter("forgrade", (Object)true, (Type)BooleanType.INSTANCE);
            q.setParameter("agent", (Object)agentId);
            q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<AssessmentGradingData> assessmentList = new ArrayList<AssessmentGradingData>();
        Long current = 0L;
        for (AssessmentGradingData a : list) {
            if (a.getPublishedAssessmentId().equals(current)) continue;
            current = a.getPublishedAssessmentId();
            AssessmentGradingData f = a;
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public Map<Long, Integer> getTotalSubmissionPerAssessment(String agentId) {
        List<AssessmentGradingData> l = this.getNumberOfSubmissionsOfAllAssessmentsByAgent(agentId);
        HashMap<Long, Integer> h = new HashMap<Long, Integer>();
        for (AssessmentGradingData d : l) {
            h.put(d.getPublishedAssessmentId(), d.getTotalSubmitted());
            log.debug("pId={} submitted={}", (Object)d.getPublishedAssessmentId(), (Object)d.getTotalSubmitted());
        }
        return h;
    }

    @Override
    public Map<Long, Integer> getTotalSubmissionPerAssessment(String agentId, String siteId) {
        List<AssessmentGradingData> l = this.getNumberOfSubmissionsOfAllAssessmentsByAgent(agentId, siteId);
        HashMap<Long, Integer> h = new HashMap<Long, Integer>();
        for (AssessmentGradingData d : l) {
            h.put(d.getPublishedAssessmentId(), d.getTotalSubmitted());
            log.debug("pId={} submitted={}", (Object)d.getPublishedAssessmentId(), (Object)d.getTotalSubmitted());
        }
        return h;
    }

    @Override
    public Integer getTotalSubmissionForEachAssessment(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select count(a) from AssessmentGradingData a where a.forGrade = :forgrade and a.publishedAssessmentId = :id and a.status > :status").setParameter("forgrade", (Object)true, (Type)BooleanType.INSTANCE).setParameter("id", (Object)publishedAssessmentId).setParameter("status", (Object)AssessmentGradingData.REMOVED).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        return ((Number)l.get(0)).intValue();
    }

    @Override
    public Integer getTotalSubmission(String agentId, Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select count(a) from AssessmentGradingData a where a.forGrade = :forgrade and a.agentId = :agent and a.publishedAssessmentId = :id and a.status > :status").setParameter("forgrade", (Object)true, (Type)BooleanType.INSTANCE).setParameter("agent", (Object)agentId).setParameter("id", (Object)publishedAssessmentId).setParameter("status", (Object)AssessmentGradingData.REMOVED).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        return ((Number)l.get(0)).intValue();
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessmentIdByAlias(String alias) {
        return this.getPublishedAssessmentIdByMetaLabel("ALIAS", alias);
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessmentIdByMetaLabel(String label, String entry) {
        HibernateCallback hcb = session -> session.createQuery("select p from PublishedAssessmentData p, PublishedMetaData m where p=m.assessment and m.label = :label and m.entry = :entry").setParameter("label", (Object)label).setParameter("entry", (Object)entry).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        switch (list.size()) {
            case 0: {
                log.warn("No matching assessment where ALIAS = {}", (Object)entry);
                break;
            }
            case 1: {
                PublishedAssessmentData data = (PublishedAssessmentData)list.get(0);
                data.setSectionSet(this.getSectionSetForAssessment((PublishedAssessmentIfc)data));
                PublishedAssessmentFacade assessment = new PublishedAssessmentFacade((PublishedAssessmentIfc)data);
                assessment.setFeedbackComponentOption(data.getAssessmentFeedback().getFeedbackComponentOption());
                return assessment;
            }
            default: {
                log.warn("More than 1 assessment found with the same ALIAS = {}, this should be unique.", (Object)entry);
            }
        }
        return null;
    }

    @Override
    public void saveOrUpdateMetaData(PublishedMetaData meta) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)meta);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update meta data: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public Map<Long, PublishedFeedback> getFeedbackHash(String siteId) {
        ArrayList<String> listAgentId = new ArrayList<String>();
        listAgentId.add(siteId);
        try {
            Site site = this.siteService.getSite(siteId);
            Collection groups = site.getGroups();
            if (groups != null && groups.size() > 0) {
                for (Group group : groups) {
                    listAgentId.add(group.getId());
                }
            }
        }
        catch (IdUnusedException site) {
            // empty catch block
        }
        String query = "select new PublishedFeedback( p.assessment.publishedAssessmentId, p.feedbackDelivery,p.feedbackComponentOption,  p.feedbackAuthoring, p.editComponents, p.showQuestionText, p.showStudentResponse, p.showCorrectResponse, p.showStudentScore, p.showStudentQuestionScore, p.showQuestionLevelFeedback, p.showSelectionLevelFeedback, p.showGraderComments, p.showStatistics) from PublishedFeedback p, AuthorizationData az where az.qualifierId = p.assessment.publishedAssessmentId  and (az.agentIdString in (:agentIdString))  and az.functionId=:functionId ";
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new PublishedFeedback( p.assessment.publishedAssessmentId, p.feedbackDelivery,p.feedbackComponentOption,  p.feedbackAuthoring, p.editComponents, p.showQuestionText, p.showStudentResponse, p.showCorrectResponse, p.showStudentScore, p.showStudentQuestionScore, p.showQuestionLevelFeedback, p.showSelectionLevelFeedback, p.showGraderComments, p.showStatistics) from PublishedFeedback p, AuthorizationData az where az.qualifierId = p.assessment.publishedAssessmentId  and (az.agentIdString in (:agentIdString))  and az.functionId=:functionId ");
            q.setParameterList("agentIdString", (Collection)listAgentId);
            q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
            return q.list();
        };
        List l = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<Long, PublishedFeedback> h = new HashMap<Long, PublishedFeedback>();
        for (PublishedFeedback f : l) {
            h.put(f.getAssessmentId(), f);
        }
        return h;
    }

    @Override
    public Map<Long, PublishedAssessmentFacade> getAllAssessmentsReleasedToAuthenticatedUsers() {
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate)  from PublishedAssessmentData p, PublishedAccessControl c   where c.assessment = p and c.releaseTo like '%Authenticated Users%'";
        List l = this.getHibernateTemplate().find(query, new Object[0]);
        HashMap<Long, PublishedAssessmentFacade> h = new HashMap<Long, PublishedAssessmentFacade>();
        for (PublishedAssessmentData p : l) {
            h.put(p.getPublishedAssessmentId(), new PublishedAssessmentFacade((PublishedAssessmentIfc)p));
        }
        return h;
    }

    @Override
    public String getPublishedAssessmentOwner(String publishedAssessmentId) {
        List l = this.getHibernateTemplate().findByNamedParam("select a from AuthorizationData a where a.functionId = :fid and a.qualifierId = :id", new String[]{"fid", "id"}, new Object[]{"OWN_PUBLISHED_ASSESSMENT", publishedAssessmentId});
        if (!l.isEmpty()) {
            AuthorizationData a = (AuthorizationData)l.get(0);
            return a.getAgentIdString();
        }
        return null;
    }

    @Override
    public boolean publishedAssessmentTitleIsUnique(Long assessmentBaseId, String title) {
        String currentSiteId = AgentFacade.getCurrentSiteId();
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select new PublishedAssessmentData(a.publishedAssessmentId, a.title, a.lastModifiedDate) from PublishedAssessmentData a, AuthorizationData z where a.title = :title and a.publishedAssessmentId != :id and a.status != :status and z.functionId = :fid and a.publishedAssessmentId = z.qualifierId and z.agentIdString = :site");
            q.setParameter(TITLE, (Object)title);
            q.setParameter("id", (Object)assessmentBaseId);
            q.setParameter("status", (Object)2);
            q.setParameter("fid", (Object)"OWN_PUBLISHED_ASSESSMENT");
            q.setParameter("site", (Object)currentSiteId);
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return list.isEmpty();
    }

    @Override
    public boolean hasRandomPart(Long publishedAssessmentId) {
        String key = "AUTHOR_TYPE";
        String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        HibernateCallback hcb = session -> session.createQuery("select s from PublishedSectionData s, PublishedSectionMetaData m where s = m.section and s.assessment.publishedAssessmentId = :id and m.label = :key and m.entry = :value").setParameter("id", (Object)publishedAssessmentId).setParameter("key", (Object)"AUTHOR_TYPE").setParameter("value", (Object)value).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        return !l.isEmpty();
    }

    @Override
    public List<Long> getContainRandomPartAssessmentIds(Collection assessmentIds) {
        if (assessmentIds == null || assessmentIds.size() < 1) {
            return new ArrayList<Long>();
        }
        String key = "AUTHOR_TYPE";
        String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        HibernateCallback hcb = session -> session.createQuery("select s.assessment.publishedAssessmentId from PublishedSectionData s, PublishedSectionMetaData m where s.assessment.publishedAssessmentId in (:ids) and s = m.section and m.label = :label and m.entry = :entry group by s.assessment.publishedAssessmentId").setParameter("label", (Object)"AUTHOR_TYPE").setParameter("entry", (Object)value).setParameterList("ids", assessmentIds).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public PublishedItemData getFirstPublishedItem(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select i from PublishedAssessmentData p, PublishedSectionData s,  PublishedItemData i where p.publishedAssessmentId = :id and p.publishedAssessmentId = s.assessment.publishedAssessmentId and s = i.section").setParameter("id", (Object)publishedAssessmentId).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        HibernateCallback hcb2 = session -> session.createQuery("select s from PublishedAssessmentData p, PublishedSectionData s  where p.publishedAssessmentId = :id and p.publishedAssessmentId = s.assessment.publishedAssessmentId").setParameter("id", (Object)publishedAssessmentId).list();
        List sec = (List)this.getHibernateTemplate().execute(hcb2);
        PublishedItemData returnItem = null;
        if (sec.size() > 0 && l.size() > 0) {
            sec.sort(new SecComparator());
            for (PublishedSectionData thisSec : sec) {
                ArrayList<PublishedItemData> itemList = new ArrayList<PublishedItemData>();
                for (PublishedItemData aL : l) {
                    PublishedItemData compItem = aL;
                    if (!compItem.getSection().getSectionId().equals(thisSec.getSectionId())) continue;
                    itemList.add(compItem);
                }
                if (itemList.size() <= 0) continue;
                itemList.sort(new ItemComparator());
                returnItem = (PublishedItemData)itemList.get(0);
                break;
            }
        }
        return returnItem;
    }

    @Override
    public List<Long> getPublishedItemIds(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select i.itemId from PublishedItemData i, PublishedSectionData s, PublishedAssessmentData p where p.publishedAssessmentId = :id and p = s.assessment and i.section = s").setParameter("id", (Object)publishedAssessmentId).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public Set<PublishedItemData> getPublishedItemSet(Long publishedAssessmentId, Long sectionId) {
        HibernateCallback hcb = session -> session.createQuery("select i from PublishedItemData i, PublishedSectionData s, PublishedAssessmentData p where p.publishedAssessmentId = :id and i.section.id = :section and p = s.assessment and i.section = s").setParameter("id", (Object)publishedAssessmentId).setParameter("section", (Object)sectionId).list();
        List assessmentGradings = (List)this.getHibernateTemplate().execute(hcb);
        HashSet<PublishedItemData> itemSet = new HashSet<PublishedItemData>();
        for (PublishedItemData publishedItemData : assessmentGradings) {
            log.debug("itemId = {}", (Object)publishedItemData.getItemId());
            itemSet.add(publishedItemData);
        }
        return itemSet;
    }

    @Override
    public Long getItemType(Long publishedItemId) {
        HibernateCallback hcb = session -> session.createQuery("select p.typeId from PublishedItemData p where p.itemId = :id").setParameter("id", (Object)publishedItemId).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        if (!list.isEmpty()) {
            return (Long)list.get(0);
        }
        return null;
    }

    @Override
    public void delete(PublishedAssessmentIfc assessment) {
        PublishedAssessmentData data = assessment instanceof PublishedAssessmentFacade ? (PublishedAssessmentData)((PublishedAssessmentFacade)assessment).getData() : (PublishedAssessmentData)assessment;
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem removing publishedAssessment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public Set<PublishedSectionData> getSectionSetForAssessment(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("from PublishedSectionData s where s.assessment.publishedAssessmentId = :id").setParameter("id", (Object)publishedAssessmentId).list();
        List sectionList = (List)this.getHibernateTemplate().execute(hcb);
        return new HashSet<PublishedSectionData>(sectionList);
    }

    private String replaceSpace(String tempString) {
        String newString = "";
        char[] oneChar = new char[1];
        for (int i = 0; i < tempString.length(); ++i) {
            if (tempString.charAt(i) != ' ') {
                oneChar[0] = tempString.charAt(i);
                String concatString = new String(oneChar);
                newString = newString.concat(concatString);
                continue;
            }
            newString = newString.concat("%20");
        }
        return newString;
    }

    @Override
    public boolean isRandomDrawPart(Long publishedAssessmentId, Long sectionId) {
        String key = "AUTHOR_TYPE";
        String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        HibernateCallback hcb = session -> session.createQuery("select s from PublishedSectionData s, PublishedSectionMetaData m  where s = m.section and s.assessment.publishedAssessmentId = :id and s.id = :section and m.label = :key and m.entry = :value").setParameter("id", (Object)publishedAssessmentId).setParameter("section", (Object)sectionId).setParameter("key", (Object)"AUTHOR_TYPE").setParameter("value", (Object)value).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        return !l.isEmpty();
    }

    @Override
    public List<AssessmentGradingData> getBasicInfoOfLastOrHighestOrAverageSubmittedAssessmentsByScoringOption(String agentId, String siteId, boolean allAssessments) {
        Integer scoringOption;
        List highest_list;
        HibernateCallback hcb_highest;
        List last_list;
        HibernateCallback hcb_last;
        String hql;
        List<String> groupIds = this.getSiteGroupIdsForSubmittingAgent(agentId, siteId);
        String order_last = " order by p.publishedAssessmentId DESC, a.submittedDate DESC";
        String order_highest = " order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC";
        if (groupIds.size() > 0) {
            hql = "select distinct new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, '', a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus) ";
            hcb_last = session -> {
                Query q = session.createQuery("select distinct new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, '', a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus)  order by p.publishedAssessmentId DESC, a.submittedDate DESC");
                q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
                q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                q.setParameter("agentId", (Object)agentId);
                q.setParameter("siteId", (Object)siteId);
                q.setParameterList("groupIds", (Collection)groupIds);
                q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
                q.setParameter("activeStatus", (Object)1);
                q.setParameter("editStatus", (Object)3);
                return q.list();
            };
            last_list = (List)this.getHibernateTemplate().execute(hcb_last);
            hcb_highest = session -> {
                Query q = session.createQuery("select distinct new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, '', a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus)  order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC");
                q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
                q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                q.setParameter("agentId", (Object)agentId);
                q.setParameter("siteId", (Object)siteId);
                q.setParameterList("groupIds", (Collection)groupIds);
                q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
                q.setParameter("activeStatus", (Object)1);
                q.setParameter("editStatus", (Object)3);
                return q.list();
            };
            highest_list = (List)this.getHibernateTemplate().execute(hcb_highest);
        } else {
            hql = "select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC";
            hcb_last = session -> {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC order by p.publishedAssessmentId DESC, a.submittedDate DESC");
                q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
                q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                q.setParameter("agentId", (Object)agentId);
                q.setParameter("siteId", (Object)siteId);
                q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            };
            last_list = (List)this.getHibernateTemplate().execute(hcb_last);
            hcb_highest = session -> {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.status > :status and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC");
                q.setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE);
                q.setParameter("status", (Object)AssessmentGradingData.REMOVED);
                q.setParameter("agentId", (Object)agentId);
                q.setParameter("siteId", (Object)siteId);
                q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            };
            highest_list = (List)this.getHibernateTemplate().execute(hcb_highest);
        }
        String query = "select e.assessment.publishedAssessmentId, e.scoringType, ac.submissionsAllowed  from PublishedEvaluationModel e, PublishedAccessControl ac, AuthorizationData az where e.assessment.publishedAssessmentId = ac.assessment.publishedAssessmentId and az.qualifierId = ac.assessment.publishedAssessmentId and az.agentIdString in (:agentIdString) and az.functionId=:functionId";
        groupIds.add(siteId);
        HibernateCallback eval_model = session -> {
            Query q = session.createQuery("select e.assessment.publishedAssessmentId, e.scoringType, ac.submissionsAllowed  from PublishedEvaluationModel e, PublishedAccessControl ac, AuthorizationData az where e.assessment.publishedAssessmentId = ac.assessment.publishedAssessmentId and az.qualifierId = ac.assessment.publishedAssessmentId and az.agentIdString in (:agentIdString) and az.functionId=:functionId");
            q.setParameterList("agentIdString", (Collection)groupIds);
            q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
            return q.list();
        };
        List l = (List)this.getHibernateTemplate().execute(eval_model);
        HashMap<Long, Integer> scoringTypeMap = new HashMap<Long, Integer>();
        for (Object[] o : l) {
            scoringTypeMap.put((Long)o[0], (Integer)o[1]);
        }
        ArrayList<AssessmentGradingData> assessmentList = new ArrayList<AssessmentGradingData>();
        Long currentid = new Long("0");
        for (AssessmentGradingData a : last_list) {
            scoringOption = scoringTypeMap.get(a.getPublishedAssessmentId()) != null ? (Integer)scoringTypeMap.get(a.getPublishedAssessmentId()) : EvaluationModelIfc.LAST_SCORE;
            if (!EvaluationModelIfc.LAST_SCORE.equals(scoringOption) || a.getPublishedAssessmentId().equals(currentid) && !allAssessments) continue;
            if (!a.getPublishedAssessmentId().equals(currentid)) {
                a.setIsRecorded(true);
            }
            assessmentList.add(a);
            currentid = a.getPublishedAssessmentId();
        }
        currentid = 0L;
        for (AssessmentGradingData a : highest_list) {
            scoringOption = scoringTypeMap.get(a.getPublishedAssessmentId()) != null ? (Integer)scoringTypeMap.get(a.getPublishedAssessmentId()) : EvaluationModelIfc.LAST_SCORE;
            if (EvaluationModelIfc.HIGHEST_SCORE.equals(scoringOption) && (!a.getPublishedAssessmentId().equals(currentid) || allAssessments)) {
                if (!a.getPublishedAssessmentId().equals(currentid)) {
                    a.setIsRecorded(true);
                }
                assessmentList.add(a);
                currentid = a.getPublishedAssessmentId();
            }
            if (!EvaluationModelIfc.AVERAGE_SCORE.equals(scoringOption)) continue;
            assessmentList.add(a);
        }
        return assessmentList;
    }

    @Override
    public PublishedAssessmentData getBasicInfoOfPublishedAssessment(Long publishedId) {
        HibernateCallback hcb = session -> session.createQuery("select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed, c.feedbackEndDate, c.feedbackScoreThreshold)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId = :id").setParameter("id", (Object)publishedId).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        if (!list.isEmpty()) {
            return (PublishedAssessmentData)list.get(0);
        }
        return null;
    }

    @Override
    public String getPublishedAssessmentSiteId(String publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select a from AuthorizationData a where a.functionId = :fid and a.qualifierId = :id").setParameter("fid", (Object)"TAKE_PUBLISHED_ASSESSMENT").setParameter("id", (Object)publishedAssessmentId).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        PublishedAssessmentData publishedAssessment = this.loadPublishedAssessment(Long.valueOf(publishedAssessmentId));
        boolean releaseToGroups = "Selected Groups".equals(publishedAssessment.getAssessmentAccessControl().getReleaseTo());
        Iterator iterator = l.iterator();
        if (iterator.hasNext()) {
            String agentId;
            AuthorizationData a = (AuthorizationData)iterator.next();
            if (releaseToGroups && this.siteService.findGroup(agentId = a.getAgentIdString()) != null && this.siteService.findGroup(agentId).getContainingSite() != null) {
                return this.siteService.findGroup(a.getAgentIdString()).getContainingSite().getId();
            }
            return a.getAgentIdString();
        }
        return "";
    }

    @Override
    public Integer getPublishedItemCount(Long publishedAssessmentId) {
        return this.getPublishedItemCountForNonRandomSections(publishedAssessmentId) + this.getPublishedItemCountForRandomSections(publishedAssessmentId);
    }

    public Integer getPublishedItemCountForRandomSections(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select m.entry from PublishedSectionData s, PublishedAssessmentData p, PublishedSectionMetaData m where p.publishedAssessmentId=:publishedAssessmentId and m.label=:metaDataLabel and p = s.assessment and m.section = s").setParameter("publishedAssessmentId", (Object)publishedAssessmentId).setParameter("metaDataLabel", (Object)"NUM_QUESTIONS_DRAWN").list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        int sum = 0;
        for (String entry : list) {
            if (entry == null) continue;
            sum += Integer.valueOf(entry).intValue();
        }
        return sum;
    }

    public Integer getPublishedItemCountForNonRandomSections(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select count(i) from PublishedItemData i, PublishedSectionData s, PublishedAssessmentData p, PublishedSectionMetaData m where p.publishedAssessmentId=:publishedAssessmentId and m.label=:metaDataLabel and p = s.assessment and i.section = s and m.section = s and m.entry=:metaDataEntry ").setParameter("publishedAssessmentId", (Object)publishedAssessmentId).setParameter("metaDataLabel", (Object)"AUTHOR_TYPE").setParameter("metaDataEntry", (Object)SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString()).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public Integer getPublishedSectionCount(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select count(s) from PublishedSectionData s, PublishedAssessmentData p where p.publishedAssessmentId = :id and p = s.assessment").setParameter("id", (Object)publishedAssessmentId).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public PublishedAttachmentData getPublishedAttachmentData(Long attachmentId) {
        HibernateCallback hcb = session -> session.createQuery("select a from PublishedAttachmentData a where a.attachmentId = :id").setParameter("id", (Object)attachmentId).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        if (!l.isEmpty()) {
            return (PublishedAttachmentData)l.get(0);
        }
        return null;
    }

    @Override
    public void updateAssessmentLastModifiedInfo(PublishedAssessmentFacade publishedAssessmentFacade) {
        PublishedAssessmentIfc data = publishedAssessmentFacade.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem update assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateSection(SectionFacade section) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section.getData());
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public PublishedSectionFacade addSection(Long publishedAssessmentId) {
        PublishedAssessmentData assessment = this.loadPublishedAssessment(publishedAssessmentId);
        Set<PublishedSectionData> sectionSet = this.getSectionSetForAssessment(publishedAssessmentId);
        assessment.setSectionSet(sectionSet);
        PublishedSectionData section = new PublishedSectionData(null, Integer.valueOf(sectionSet.size() + 1), "", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        section.setAssessment((AssessmentIfc)assessment);
        section.setAssessmentId(assessment.getAssessmentId());
        section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
        section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
        sectionSet.add(section);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update assessment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return new PublishedSectionFacade((SectionDataIfc)section);
    }

    @Override
    public PublishedSectionFacade getSection(Long sectionId) {
        PublishedSectionData publishedSection = (PublishedSectionData)this.getHibernateTemplate().load(PublishedSectionData.class, (Serializable)sectionId);
        return new PublishedSectionFacade((SectionDataIfc)publishedSection);
    }

    @Override
    public AssessmentAccessControlIfc loadPublishedAccessControl(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select c from PublishedAssessmentData as p, PublishedAccessControl as c where c.assessment.publishedAssessmentId=p.publishedAssessmentId and p.publishedAssessmentId = :id").setParameter("id", (Object)publishedAssessmentId).list();
        List list = (List)this.getHibernateTemplate().execute(hcb);
        if (!list.isEmpty()) {
            return (AssessmentAccessControlIfc)list.get(0);
        }
        return null;
    }

    @Override
    public void saveOrUpdatePublishedAccessControl(AssessmentAccessControlIfc publishedAccessControl) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)publishedAccessControl);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update publishedAccessControl data: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    private List<String> getSiteGroupIdsForSubmittingAgent(String agentId, String siteId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("none");
        if (siteId == null) {
            return groupIds;
        }
        Collection siteGroups = null;
        try {
            Site s = this.siteService.getSite(siteId);
            if (s != null) {
                siteGroups = s.getGroupsWithMember(agentId);
            }
        }
        catch (IdUnusedException ex) {
            log.debug("No site found for siteid: " + siteId + "agentid: " + agentId);
        }
        if (siteGroups != null) {
            for (Group group : siteGroups) {
                groupIds.add(group.getId());
            }
        }
        return groupIds;
    }

    private List<String> getSiteGroupIdsForCurrentUser(String siteId) {
        String currentUserId = this.userDirectoryService.getCurrentUser().getId();
        return this.getSiteGroupIdsForSubmittingAgent(currentUserId, siteId);
    }

    private Map<String, String> getReleaseToGroups(Map groupsForSite, Long assessmentId) {
        HashMap<String, String> releaseToGroups = new HashMap<String, String>();
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        List<AuthorizationData> authorizations = authz.getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", assessmentId.toString());
        if (authorizations != null && authorizations.size() > 0) {
            for (AuthorizationData ad : authorizations) {
                String group;
                if (!groupsForSite.containsKey(ad.getAgentIdString()) || (group = groupsForSite.get(ad.getAgentIdString()).toString()) == null) continue;
                releaseToGroups.put(ad.getAgentIdString(), group);
            }
            releaseToGroups.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        }
        return releaseToGroups;
    }

    private Map getGroupsForSite(String siteId) {
        TreeMap<String, String> sortedGroups = new TreeMap<String, String>();
        try {
            Site site = this.siteService.getSite(siteId);
            Collection groups = site.getGroups();
            if (groups != null && groups.size() > 0) {
                for (Group group : groups) {
                    sortedGroups.put(group.getId(), group.getTitle());
                }
            }
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return sortedGroups;
    }

    @Override
    public Map getGroupsForSite() {
        String siteId = this.toolManager.getCurrentPlacement().getContext();
        return this.getGroupsForSite(siteId);
    }

    @Override
    public List<String> getReleaseToGroupIdsForPublishedAssessment(String publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select agentIdString from AuthorizationData az where az.functionId=:functionId and az.qualifierId=:publishedAssessmentId").setParameter("publishedAssessmentId", (Object)publishedAssessmentId).setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT").list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public Integer getPublishedAssessmentStatus(Long publishedAssessmentId) {
        HibernateCallback hcb = session -> session.createQuery("select p.status from PublishedAssessmentData p where p.publishedAssessmentId = :id").setParameter("id", (Object)publishedAssessmentId).list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        if (!l.isEmpty()) {
            return (Integer)l.get(0);
        }
        return AssessmentBaseIfc.DEAD_STATUS;
    }

    @Override
    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        PublishedAssessmentAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new PublishedAssessmentAttachment();
                attach.setAssessment(assessment);
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage());
        }
        return attach;
    }

    private long fileSizeInKB(long fileSize) {
        return fileSize / 1024L;
    }

    @Override
    public void removeAssessmentAttachment(Long assessmentAttachmentId) {
        PublishedAssessmentAttachment assessmentAttachment = (PublishedAssessmentAttachment)this.getHibernateTemplate().load(PublishedAssessmentAttachment.class, (Serializable)assessmentAttachmentId);
        AssessmentIfc assessment = assessmentAttachment.getAssessment();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessment == null) continue;
                Set set = assessment.getAssessmentAttachmentSet();
                set.remove(assessmentAttachment);
                this.getHibernateTemplate().delete((Object)assessmentAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete publishedAssessmentAttachment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        PublishedSectionAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new PublishedSectionAttachment();
                attach.setSection(section);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage());
        }
        return attach;
    }

    @Override
    public void removeSectionAttachment(Long sectionAttachmentId) {
        PublishedSectionAttachment sectionAttachment = (PublishedSectionAttachment)this.getHibernateTemplate().load(PublishedSectionAttachment.class, (Serializable)sectionAttachmentId);
        SectionDataIfc section = sectionAttachment.getSection();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (section == null) continue;
                Set set = section.getSectionAttachmentSet();
                set.remove(sectionAttachment);
                this.getHibernateTemplate().delete((Object)sectionAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete sectionAttachment: {}", (Object)e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAttachments(List<AttachmentIfc> list) {
        for (AttachmentIfc attachment : list) {
            this.getHibernateTemplate().saveOrUpdate((Object)attachment);
        }
    }

    @Override
    public PublishedAssessmentFacade getPublishedAssessmentInfoForRemove(Long publishedAssessmentId) {
        PublishedAssessmentData a = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)publishedAssessmentId);
        PublishedAssessmentFacade f = new PublishedAssessmentFacade(a.getAssessmentId(), a.getTitle(), a.getCreatedBy());
        return f;
    }

    @Override
    public Map<Long, String> getToGradebookPublishedAssessmentSiteIdMap() {
        HibernateCallback hcb = session -> session.createQuery("select em.assessment.publishedAssessmentId, a.agentIdString from PublishedEvaluationModel em, AuthorizationData a where a.functionId = 'OWN_PUBLISHED_ASSESSMENT' and em.assessment.publishedAssessmentId = a.qualifierId and em.toGradeBook = '1'").list();
        List l = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (Object[] o : l) {
            map.put((Long)o[0], (String)o[1]);
        }
        return map;
    }

    @Override
    public List<AssessmentGradingData> getAllAssessmentsGradingDataByAgentAndSiteId(String agentId, String siteId) {
        HibernateCallback hcb = session -> session.createQuery("select a  from AssessmentGradingData as a, AuthorizationData as az where a.agentId=:agentId and a.forGrade=:forGrade and a.status > :status and az.agentIdString=:siteId and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId").setParameter("agentId", (Object)agentId).setParameter("forGrade", (Object)true, (Type)BooleanType.INSTANCE).setParameter("status", (Object)AssessmentGradingData.REMOVED).setParameter("siteId", (Object)siteId).setParameter("functionId", (Object)"OWN_PUBLISHED_ASSESSMENT").list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private void replaceEmbeddedSiteIdsForItem(PublishedItemData item) {
        String toContext = AgentFacade.getCurrentSiteId();
        this.replaceEmbeddedSiteIdsForItemText(item.getItemTextSet(), toContext);
        String itemHint = item.getHint();
        if (itemHint != null) {
            item.setHint(this.replaceSiteIdsForString(itemHint, toContext));
        }
        this.replaceEmbeddedSiteIdsForFeedback(item.getItemFeedbackSet(), toContext);
    }

    private void replaceEmbeddedSiteIdsForItemText(Set itemTextSet, String toContext) {
        for (PublishedItemText itemText : itemTextSet) {
            String itemTextString = itemText.getText();
            if (itemTextString != null) {
                itemText.setText(this.replaceSiteIdsForString(itemTextString, toContext));
            }
            this.replaceEmbeddedSiteIdsForAnswers(itemText.getAnswerSet(), toContext);
        }
    }

    private void replaceEmbeddedSiteIdsForAnswers(Set answerSet, String toContext) {
        for (PublishedAnswer answer : answerSet) {
            String answerText = answer.getText();
            if (answerText != null) {
                answer.setText(this.replaceSiteIdsForString(answerText, toContext));
            }
            this.replaceEmbeddedSiteIdsForAnswerFeedback(answer.getAnswerFeedbackSet(), toContext);
        }
    }

    private void replaceEmbeddedSiteIdsForAnswerFeedback(Set answerFeedbackSet, String toContext) {
        for (PublishedAnswerFeedback answerFeedback : answerFeedbackSet) {
            String answerFeedbackText = answerFeedback.getText();
            if (answerFeedbackText == null) continue;
            answerFeedback.setText(this.replaceSiteIdsForString(answerFeedbackText, toContext));
        }
    }

    private void replaceEmbeddedSiteIdsForFeedback(Set feedbackSet, String toContext) {
        for (PublishedItemFeedback feedback : feedbackSet) {
            String feedbackString = feedback.getText();
            if (feedbackString == null) continue;
            feedback.setText(this.replaceSiteIdsForString(feedbackString, toContext));
        }
    }

    private String replaceSiteIdsForString(String assessmentStringData, String toContext) {
        boolean doReplaceSiteIds = ServerConfigurationService.getBoolean((String)"samigo.publish.update.siteids", (boolean)true);
        if (!doReplaceSiteIds) {
            return assessmentStringData;
        }
        String updatedAssessmentStringData = null;
        if (assessmentStringData != null) {
            String sakaiSiteResourcePath = ServerConfigurationService.getServerUrl() + SITECONTENTPATH;
            int beginIndex = assessmentStringData.indexOf(sakaiSiteResourcePath);
            if (beginIndex > 0) {
                while (beginIndex > 0) {
                    int siteIdIndex = beginIndex + sakaiSiteResourcePath.length();
                    int endSiteIdIndex = assessmentStringData.indexOf(47, siteIdIndex);
                    String fromContext = assessmentStringData.substring(siteIdIndex, endSiteIdIndex);
                    updatedAssessmentStringData = assessmentStringData.replaceAll(fromContext, toContext);
                    beginIndex = assessmentStringData.indexOf(sakaiSiteResourcePath, endSiteIdIndex);
                }
            } else {
                updatedAssessmentStringData = assessmentStringData;
            }
        }
        return updatedAssessmentStringData;
    }

    @Override
    public List getQuestionsIdList(Long publishedAssessmentId) {
        return (List)this.getHibernateTemplate().execute(session -> session.createQuery("select i.itemId from PublishedItemData i, PublishedSectionData s,  PublishedAssessmentData a where a = s.assessment and s = i.section and a.publishedAssessmentId=:publishedAssessmentId").setParameter("publishedAssessmentId", (Object)publishedAssessmentId).list());
    }

    @Override
    public List<PublishedAssessmentData> getPublishedDeletedAssessments(String siteAgentId) {
        HibernateCallback hcb = session -> session.createQuery("select new PublishedAssessmentData(p.publishedAssessmentId, p.title, p.lastModifiedDate) from PublishedAssessmentData p, AuthorizationData z where p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId and z.agentIdString=:siteId and p.status=:inactiveStatus ").setParameter("functionId", (Object)"OWN_PUBLISHED_ASSESSMENT").setParameter("siteId", (Object)siteAgentId).setParameter("inactiveStatus", (Object)AssessmentIfc.DEAD_STATUS).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public void restorePublishedAssessment(Long publishedAssessmentId) {
        PublishedAssessmentData assessment = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)publishedAssessmentId);
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        assessment.setStatus(AssessmentIfc.ACTIVE_STATUS);
        RubricsService rubricsService = (RubricsService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.rubrics.api.RubricsService");
        rubricsService.restoreRubricAssociationsByItemIdPrefix("pub." + publishedAssessmentId + ".", "sakai.samigo");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem updating asssessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    private static /* synthetic */ List lambda$getBasicInfoOfAllPublishedAssessments$8(String hql, String siteId, List groupIds, Session session) throws HibernateException {
        Query q = session.createQuery(hql);
        q.setParameter("activeStatus", (Object)1);
        q.setParameter("editStatus", (Object)3);
        q.setParameter("siteId", (Object)siteId);
        if (groupIds.size() > 0) {
            q.setParameterList("groupIds", (Collection)groupIds);
        }
        q.setParameter("functionId", (Object)"TAKE_PUBLISHED_ASSESSMENT");
        return q.list();
    }

    class ItemComparator
    implements Comparator {
        ItemComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((PublishedItemData)arg0).getSequence().compareTo(((PublishedItemData)arg1).getSequence());
        }
    }

    class SecComparator
    implements Comparator {
        SecComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((PublishedSectionData)arg0).getSequence().compareTo(((PublishedSectionData)arg1).getSequence());
        }
    }
}

