/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.osid.assessment.AssessmentException;
import org.osid.shared.Id;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueries;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.osid.assessment.impl.ItemImpl;

public class PublishedItemFacade
extends ItemFacade
implements Serializable,
ItemDataIfc,
Comparable<ItemDataIfc> {
    private static final long serialVersionUID = -1711478342512505707L;
    private PublishedSectionFacade section;

    public PublishedItemFacade() {
        this.data = new PublishedItemData();
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public PublishedItemFacade(ItemDataIfc data) {
        this.data = data;
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.description = this.getDescription();
        this.itemType = this.getItemType();
        this.itemTextSet = this.getItemTextSet();
        this.itemMetaDataSet = this.getItemMetaDataSet();
        this.itemTagSet = this.getItemTagSet();
        this.itemFeedbackSet = this.getItemFeedbackSet();
        this.hasRationale = data.getHasRationale();
        this.itemAttachmentSet = this.getItemAttachmentSet();
        this.answerOptionsRichCount = this.getAnswerOptionsRichCount();
        this.answerOptionsSimpleOrRich = this.getAnswerOptionsSimpleOrRich();
    }

    @Override
    Id getId() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        PublishedItemFacadeQueries publishedItemFacadeQueries = new PublishedItemFacadeQueries();
        return publishedItemFacadeQueries.getItemId(this.data.getItemId());
    }

    @Override
    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
        this.data.setItemIdString(itemIdString);
    }

    @Override
    public SectionDataIfc getSection() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        if (this.data.getSection() != null) {
            return new PublishedSectionFacade(this.data.getSection());
        }
        return null;
    }

    @Override
    public void setSection(SectionDataIfc section) {
        this.section = (PublishedSectionFacade)section;
        if (this.section != null) {
            this.data.setSection(this.section.getData());
        } else {
            this.data.setSection(null);
        }
    }

    @Override
    public void addItemText(String text, Set answerSet) {
        if (this.data.getItemTextSet() == null) {
            this.data.setItemTextSet(new HashSet());
        }
        Long sequence = this.data.getItemTextSet().size() + 1;
        PublishedItemText itemText = new PublishedItemText((PublishedItemData)this.data, sequence, text, answerSet);
        this.data.getItemTextSet().add(itemText);
        this.itemTextSet = this.data.getItemTextSet();
    }

    @Override
    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet());
        }
        this.data.getItemMetaDataSet().add(new PublishedItemMetaData((ItemDataIfc)((PublishedItemData)this.data), label, entry));
        this.itemMetaDataSet = this.data.getItemMetaDataSet();
    }

    @Override
    public void addItemTag(String tagId, String tagLabel, String tagCollectionId, String tagCollectionName) {
        if (this.getItemTagSet() == null) {
            this.setItemTagSet(new HashSet());
        }
        this.getItemTagSet().add(new PublishedItemTag(this.data, tagId, tagLabel, tagCollectionId, tagCollectionName));
        this.itemTagSet = this.getItemTagSet();
    }

    @Override
    public void addItemFeedback(String feedbackTypeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet());
        }
        this.data.getItemFeedbackSet().add(new PublishedItemFeedback((PublishedItemData)this.data, feedbackTypeId, text));
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
    }

    @Override
    public String getTagListToJsonString() {
        return this.data.getTagListToJsonString();
    }
}

