/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.sakaiproject.tool.assessment.data.dao.grading.SecureDeliveryData;
import org.sakaiproject.tool.assessment.facade.SecureDeliveryFacadeQueriesAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class SecureDeliveryFacadeQueries
extends HibernateDaoSupport
implements SecureDeliveryFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(SecureDeliveryFacadeQueries.class);

    @Override
    public List<SecureDeliveryData> getUrlsForAssessment(Long assessmentId) {
        HibernateCallback hcb = session -> {
            Query q = session.getNamedQuery("getEntriesForAssessment");
            q.setParameter("publishedId", (Object)assessmentId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<SecureDeliveryData> getUrlsForAssessmentAndUser(Long assessmentId, String agentId) {
        HibernateCallback hcb = session -> {
            Query q = session.getNamedQuery("getEntriesForAssessmentAndUser");
            q.setParameter("publishedId", (Object)assessmentId);
            q.setParameter("agentId", (Object)agentId);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public void saveUrlsForAssessmentAndUser(Long assessmentId, String agentId, String instructorUrl, String studentUrl) {
        SecureDeliveryData sd = new SecureDeliveryData();
        sd.setPublishedAssessmentId(assessmentId);
        sd.setAgentId(agentId);
        sd.setInstructorUrl(instructorUrl);
        sd.setStudentUrl(studentUrl);
        sd.setCreatedDate(new Date());
        this.getHibernateTemplate().save((Object)sd);
    }
}

