/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz.integrated;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.Query;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class AuthzQueriesFacade
extends HibernateDaoSupport
implements AuthzQueriesFacadeAPI {
    private static final Logger log = LoggerFactory.getLogger(AuthzQueriesFacade.class);
    private static final String HQL_QUERY_CHECK_AUTHZ = "select from org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as data where data.agentIdString = :agentId and data.functionId = :functionId and data.qualifierId = :qualifierId";
    private static final String HQL_QUERY_BY_AGENT_FUNC = "select from org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as item where item.agentIdString = :agentId and item.functionId = :functionId";
    private static final String HQL_QUERY_ASSESS_BY_AGENT_FUNC = "select asset from org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData as asset, org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData as authz where asset.assessmentBaseId=authz.qualifierId and authz.agentIdString = :agentId and authz.functionId = :functionId";
    private AuthzGroupService authzGroupService;

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    @Override
    public boolean hasPrivilege(String functionName, String siteId) {
        return SecurityService.unlock((String)functionName, (String)("/site/" + siteId));
    }

    @Override
    public boolean hasPrivilege(String functionName) {
        String context = ToolManager.getCurrentPlacement().getContext();
        boolean privilege = SecurityService.unlock((String)functionName, (String)("/site/" + context));
        return privilege;
    }

    @Override
    public boolean isAuthorized(String agentId, String functionId, String qualifierId) {
        HibernateCallback hcb = session -> session.createQuery("select a from AuthorizationData a where a.functionId = :fid and a.qualifierId = :id").setParameter("fid", (Object)functionId).setParameter("id", (Object)qualifierId).list();
        List authorizationList = (List)this.getHibernateTemplate().execute(hcb);
        String currentSiteId = null;
        if (ToolManager.getCurrentPlacement() != null) {
            currentSiteId = ToolManager.getCurrentPlacement().getContext();
        }
        if (currentSiteId == null) {
            return false;
        }
        String currentAgentId = UserDirectoryService.getCurrentUser().getId();
        for (int i = 0; i < authorizationList.size(); ++i) {
            AuthorizationData a = (AuthorizationData)authorizationList.get(i);
            String siteId = a.getAgentIdString();
            if ("AUTHENTICATED_USERS".equals(siteId) && currentAgentId != null) {
                return true;
            }
            if ("ANONYMOUS_USERS".equals(siteId)) {
                return true;
            }
            if (!currentSiteId.equals(siteId)) continue;
            return true;
        }
        return false;
    }

    public boolean checkAuthorization(String agentId, String functionId, String qualifierId) {
        if (functionId == null || qualifierId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        String queryAgentId = ToolManager.getCurrentPlacement().getContext();
        HibernateCallback hcb = session -> {
            Query query = session.createQuery(HQL_QUERY_CHECK_AUTHZ);
            if (agentId == null) {
                query.setParameter("agentId", (Object)queryAgentId);
            } else {
                query.setParameter("agentId", (Object)agentId);
            }
            query.setParameter("functionId", (Object)functionId);
            query.setParameter("qualifierId", (Object)qualifierId);
            return query.uniqueResult();
        };
        Object result = this.getHibernateTemplate().execute(hcb);
        return result != null;
    }

    @Override
    public AuthorizationData createAuthorization(String agentId, String functionId, String qualifierId) {
        if (agentId == null || functionId == null || qualifierId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        AuthorizationData ad = new AuthorizationData();
        Calendar cal = Calendar.getInstance();
        Date lastModifiedDate = cal.getTime();
        ad.setAgentIdString(agentId);
        ad.setFunctionId(functionId);
        ad.setQualifierId(qualifierId);
        ad.setLastModifiedBy(UserDirectoryService.getCurrentUser().getId());
        ad.setLastModifiedDate(lastModifiedDate);
        this.getHibernateTemplate().save((Object)ad);
        return ad;
    }

    public List<AuthorizationData> getAssessments(String agentId, String functionId) {
        if (agentId == null || functionId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = session -> {
            Query query = session.createQuery(HQL_QUERY_BY_AGENT_FUNC);
            query.setParameter("agentId", (Object)agentId);
            query.setParameter("functionId", (Object)functionId);
            return query.list();
        };
        ArrayList returnList = (ArrayList)this.getHibernateTemplate().execute(hcb);
        if (returnList == null) {
            returnList = new ArrayList();
        }
        return returnList;
    }

    public List<AssessmentBaseData> getAssessmentsByAgentAndFunction(String agentId, String functionId) {
        if (agentId == null || functionId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = session -> {
            Query query = session.createQuery(HQL_QUERY_ASSESS_BY_AGENT_FUNC);
            query.setParameter("agentId", (Object)agentId);
            query.setParameter("functionId", (Object)functionId);
            return query.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public void removeAuthorizationByQualifier(String qualifierId, boolean isPublishedAssessment) {
        String query = "select a from AuthorizationData a where a.qualifierId=" + qualifierId;
        String clause = "";
        clause = isPublishedAssessment ? " and (a.functionId='OWN_PUBLISHED_ASSESSMENT' or a.functionId='TAKE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT_FEEDBACK' or a.functionId='GRADE_PUBLISHED_ASSESSMENT' or a.functionId='VIEW_PUBLISHED_ASSESSMENT')" : " and a.functionId='EDIT_ASSESSMENT'";
        List l = this.getHibernateTemplate().find(query + clause, new Object[0]);
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    @Override
    public void removeAuthorizationByQualifierAndFunction(String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId = :id and a.functionId = :fid";
        List l = this.getHibernateTemplate().findByNamedParam(query, new String[]{"id", "fid"}, (Object[])new String[]{qualifierId, functionId});
        this.getHibernateTemplate().deleteAll((Collection)l);
    }

    @Override
    public void removeAuthorizationByAgentQualifierAndFunction(String agentId, String qualifierId, String functionId) {
        String query = "select a from AuthorizationData a where a.qualifierId = :id and a.agentIdString = :agent and a.functionId = :fid";
        List l = this.getHibernateTemplate().findByNamedParam(query, new String[]{"id", "agent", "fid"}, (Object[])new String[]{qualifierId, agentId, functionId});
        if (l != null && l.size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)l);
        }
    }

    @Override
    public HashMap getAuthorizationToViewAssessments(String agentId) {
        HashMap<String, AuthorizationData> h = new HashMap<String, AuthorizationData>();
        List l = this.getAuthorizationByAgentAndFunction(agentId, "VIEW_PUBLISHED_ASSESSMENT");
        for (int i = 0; i < l.size(); ++i) {
            AuthorizationData a = (AuthorizationData)l.get(i);
            h.put(a.getQualifierId(), a);
        }
        return h;
    }

    @Override
    public List getAuthorizationByAgentAndFunction(String agentId, String functionId) {
        String query = "select a from AuthorizationData a where a.agentIdString = :agent and a.functionId = :fid";
        return this.getHibernateTemplate().findByNamedParam(query, new String[]{"agent", "fid"}, (Object[])new String[]{agentId, functionId});
    }

    @Override
    public List<AuthorizationData> getAuthorizationByFunctionAndQualifier(String functionId, String qualifierId) {
        HibernateCallback hcb = session -> session.createQuery("select a from AuthorizationData a where a.functionId = :fid and a.qualifierId = :id").setParameter("fid", (Object)functionId).setParameter("id", (Object)qualifierId).list();
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean checkMembership(String siteId) {
        boolean isMember = false;
        try {
            String realmName = "/site/" + siteId;
            AuthzGroup siteAuthzGroup = this.authzGroupService.getAuthzGroup(realmName);
            if (siteAuthzGroup.getUserRole(AgentFacade.getAgentString()) != null) {
                isMember = true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return isMember;
    }
}

