/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.Map;
import org.apache.commons.math3.util.Precision;
import org.apache.commons.text.StringEscapeUtils;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.grading.api.AssessmentNotFoundException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookServiceHelperImpl
implements GradebookServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(GradebookServiceHelperImpl.class);

    private Site getCurrentSite(String id) {
        Site site = null;
        try {
            site = SiteService.getSite((String)id);
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage());
        }
        return site;
    }

    @Override
    public void removeExternalAssessment(String gradebookUId, String publishedAssessmentId, org.sakaiproject.grading.api.GradingService g) throws Exception {
        g.removeExternalAssignment(gradebookUId, publishedAssessmentId);
    }

    @Override
    public boolean isAssignmentDefined(String assessmentTitle, org.sakaiproject.grading.api.GradingService g) {
        String gradebookUId = GradebookFacade.getGradebookUId();
        return g.isAssignmentDefined(gradebookUId, assessmentTitle);
    }

    @Override
    public String getAppName() {
        return "sakai.samigo";
    }

    @Override
    public boolean addToGradebook(PublishedAssessmentData publishedAssessment, Long categoryId, org.sakaiproject.grading.api.GradingService g) throws Exception {
        boolean added = false;
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        String title = StringEscapeUtils.unescapeHtml4((String)publishedAssessment.getTitle());
        if (!g.isAssignmentDefined(gradebookUId, title)) {
            g.addExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, title, publishedAssessment.getTotalScore(), publishedAssessment.getAssessmentAccessControl().getDueDate(), this.getAppName(), null, Boolean.valueOf(false), categoryId, publishedAssessment.getReference());
            added = true;
        }
        return added;
    }

    @Override
    public boolean updateGradebook(PublishedAssessmentIfc publishedAssessment, org.sakaiproject.grading.api.GradingService g) throws Exception {
        log.debug("updateGradebook start");
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        log.debug("before g.isAssignmentDefined()");
        g.updateExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, null, publishedAssessment.getTitle(), publishedAssessment.getTotalScore().doubleValue(), publishedAssessment.getAssessmentAccessControl().getDueDate());
        return true;
    }

    @Override
    public void updateExternalAssessmentScore(AssessmentGradingData ag, org.sakaiproject.grading.api.GradingService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        GradingService gradingService = new GradingService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(ag.getPublishedAssessmentId());
        if (gradebookUId == null) {
            return;
        }
        String points = null;
        if (ag.getFinalScore() != null) {
            double fScore = Precision.round((double)ag.getFinalScore(), (int)2);
            Double score = fScore;
            points = score.toString();
            log.info("rounded:  " + ag.getFinalScore() + " to: " + score.toString());
        }
        g.updateExternalAssessmentScore(gradebookUId, ag.getPublishedAssessmentId().toString(), ag.getAgentId(), points);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }

    @Override
    public void updateExternalAssessmentScores(Long publishedAssessmentId, Map<String, Double> studentUidsToScores, org.sakaiproject.grading.api.GradingService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(publishedAssessmentId);
        if (gradebookUId == null) {
            return;
        }
        g.updateExternalAssessmentScores(gradebookUId, publishedAssessmentId.toString(), studentUidsToScores);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }

    @Override
    public void updateExternalAssessmentComment(Long publishedAssessmentId, String studentUid, String comment, org.sakaiproject.grading.api.GradingService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(publishedAssessmentId);
        if (gradebookUId == null) {
            return;
        }
        g.updateExternalAssessmentComment(gradebookUId, publishedAssessmentId.toString(), studentUid, comment);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentComment.");
        }
    }

    @Override
    public Long getExternalAssessmentCategoryId(String gradebookUId, String publishedAssessmentId, org.sakaiproject.grading.api.GradingService g) {
        try {
            return g.getExternalAssessmentCategoryId(gradebookUId, publishedAssessmentId);
        }
        catch (AssessmentNotFoundException e) {
            log.info("No category defined for publishedAssessmentId={} in gradebookUid={}", (Object)publishedAssessmentId, (Object)gradebookUId);
            return null;
        }
    }
}

