/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.section.api.SectionAwareness;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.integration.helper.ifc.SectionAwareServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.integrated.AbstractSectionsImpl;
import org.sakaiproject.tool.assessment.integration.helper.integrated.FacadeUtils;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionAwareServiceHelperImpl
extends AbstractSectionsImpl
implements SectionAwareServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(SectionAwareServiceHelperImpl.class);
    private SiteService siteService;

    @Override
    public boolean isUserAbleToGrade(String siteid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(siteid, userUid, Role.INSTRUCTOR) || this.getSectionAwareness().isSiteMemberInRole(siteid, userUid, Role.TA) || SecurityService.unlock((String)"assessment.gradeAssessment.any", (String)("/site/" + siteid));
    }

    @Override
    public boolean isUserAbleToGradeAll(String siteid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(siteid, userUid, Role.INSTRUCTOR) || SecurityService.unlock((String)"assessment.gradeAssessment.any", (String)("/site/" + siteid));
    }

    @Override
    public boolean isUserAbleToGradeSection(String sectionUid, String userUid) {
        return this.getSectionAwareness().isSectionMemberInRole(sectionUid, userUid, Role.TA);
    }

    @Override
    public boolean isUserAbleToEdit(String siteid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(siteid, userUid, Role.INSTRUCTOR) || SecurityService.unlock((String)"assessment.gradeAssessment.any", (String)("/site/" + siteid));
    }

    @Override
    public boolean isUserGradable(String siteid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(siteid, userUid, Role.STUDENT);
    }

    @Override
    public List<EnrollmentRecord> getAvailableEnrollments(String siteid, String userUid) {
        ArrayList enrollments;
        if ("-1".equals(userUid) || this.isUserAbleToGradeAll(siteid, userUid)) {
            enrollments = this.getSectionAwareness().getSiteMembersInRole(siteid, Role.STUDENT);
        } else {
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            List<CourseSection> sections = this.getAvailableSections(siteid, userUid);
            for (CourseSection section : sections) {
                List sectionEnrollments = this.getSectionEnrollmentsTrusted(section.getUuid(), userUid);
                for (EnrollmentRecord enr : sectionEnrollments) {
                    enrollmentMap.put(enr.getUser().getUserUid(), enr);
                }
            }
            enrollments = new ArrayList(enrollmentMap.values());
        }
        return enrollments;
    }

    @Override
    public List getGroupReleaseEnrollments(String siteid, String userUid, String publishedAssessmentId) {
        List<EnrollmentRecord> availEnrollments = this.getAvailableEnrollments(siteid, userUid);
        ArrayList<EnrollmentRecord> enrollments = new ArrayList<EnrollmentRecord>();
        HashSet membersInReleaseGroups = new HashSet(0);
        try {
            List releaseGroupIds = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getReleaseToGroupIdsForPublishedAssessment(publishedAssessmentId);
            HashSet releaseGroupIdsSet = new HashSet(releaseGroupIds);
            Site site = SiteService.getInstance().getSite(siteid);
            membersInReleaseGroups = new HashSet(site.getMembersInGroups(releaseGroupIdsSet));
        }
        catch (IdUnusedException ex) {
            log.warn("Unable to find a site with id (" + siteid + ") in order to get the enrollments, will return 0 enrollments");
        }
        for (EnrollmentRecord enr : availEnrollments) {
            if (!membersInReleaseGroups.contains(enr.getUser().getUserUid())) continue;
            enrollments.add(enr);
        }
        return enrollments;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    private boolean isUserInReleaseGroup(String userId, String siteId, String publishedAssessmentId) {
        Collection siteGroups = null;
        try {
            siteGroups = SiteService.getSite((String)siteId).getGroupsWithMember(userId);
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        List releaseGroupIds = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getReleaseToGroupIdsForPublishedAssessment(publishedAssessmentId);
        if (siteGroups == null) {
            return false;
        }
        for (Group group : siteGroups) {
            Iterator releaseGroupIdsIter = releaseGroupIds.iterator();
            while (releaseGroupIdsIter.hasNext()) {
                if (!group.getId().equals((String)releaseGroupIdsIter.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<CourseSection> getAvailableSections(String siteid, String userUid) {
        ArrayList<CourseSection> availableSections = new ArrayList<CourseSection>();
        SectionAwareness sectionAwareness = this.getSectionAwareness();
        if (sectionAwareness != null) {
            List sections = sectionAwareness.getSections(siteid);
            for (CourseSection section : sections) {
                if (!this.isUserAbleToGradeAll(siteid, userUid) && !this.isUserAbleToGradeSection(section.getUuid(), userUid)) continue;
                availableSections.add(section);
            }
        }
        return availableSections;
    }

    @Override
    public List getSectionEnrollmentsTrusted(String sectionUid) {
        return this.getSectionEnrollmentsTrusted(sectionUid, null);
    }

    private List getSectionEnrollmentsTrusted(String sectionUid, String userUid) {
        return this.getSectionAwareness().getSectionMembersInRole(sectionUid, Role.STUDENT);
    }

    @Override
    public List getSectionEnrollments(String siteid, String sectionUid, String userUid) {
        ArrayList enrollments;
        if (this.isUserAbleToGradeAll(siteid, userUid) || this.isUserAbleToGradeSection(sectionUid, userUid)) {
            enrollments = this.getSectionEnrollmentsTrusted(sectionUid, userUid);
        } else {
            enrollments = new ArrayList();
            log.warn("getSectionEnrollments for sectionUid=" + sectionUid + " called by unauthorized userUid=" + userUid);
        }
        return enrollments;
    }

    @Override
    public List findMatchingEnrollments(String siteid, String searchString, String optionalSectionUid, String userUid) {
        ArrayList<EnrollmentRecord> enrollments;
        ArrayList<EnrollmentRecord> allEnrollmentsFilteredBySearch = this.getSectionAwareness().findSiteMembersInRole(siteid, Role.STUDENT, searchString);
        if (allEnrollmentsFilteredBySearch.isEmpty() || optionalSectionUid == null && this.isUserAbleToGradeAll(siteid, userUid)) {
            enrollments = allEnrollmentsFilteredBySearch;
        } else {
            enrollments = optionalSectionUid == null ? this.getAvailableEnrollments(siteid, userUid) : this.getSectionEnrollments(siteid, optionalSectionUid, userUid);
            Set availableStudentUids = FacadeUtils.getStudentUids(enrollments);
            enrollments = new ArrayList<EnrollmentRecord>();
            for (EnrollmentRecord enr : allEnrollmentsFilteredBySearch) {
                if (!availableStudentUids.contains(enr.getUser().getUserUid())) continue;
                enrollments.add(enr);
            }
        }
        return enrollments;
    }

    @Override
    public boolean isSectionMemberInRoleStudent(String sectionId, String studentId) {
        return this.getSectionAwareness().isSectionMemberInRole(sectionId, studentId, Role.STUDENT);
    }
}

