/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.api.UsageSessionService;
import org.sakaiproject.samigo.api.SamigoETSProvider;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSubmitAssessmentsJob
implements StatefulJob {
    private static final Logger log = LoggerFactory.getLogger(AutoSubmitAssessmentsJob.class);
    private AuthzGroupService authzGroupService;
    private EventTrackingService eventTrackingService;
    private SamigoETSProvider samigoETSProvider;
    private ServerConfigurationService serverConfigurationService;
    private SessionManager sessionManager;
    private UsageSessionService usageSessionService;

    public void execute(JobExecutionContext jobInfo) throws JobExecutionException {
        this.loginToSakai("admin");
        String jobName = jobInfo.getJobDetail().getKey().getName();
        String triggerName = jobInfo.getTrigger().getKey().getName();
        Date requestedFire = jobInfo.getScheduledFireTime();
        Date actualfire = jobInfo.getFireTime();
        StringBuffer whoAmI = new StringBuffer("AutoSubmitAssessmentsJob $");
        whoAmI.append(" Job: ");
        whoAmI.append(jobName);
        whoAmI.append(" Trigger: ");
        whoAmI.append(triggerName);
        if (requestedFire != null) {
            whoAmI.append(" Fire scheduled: ");
            whoAmI.append(requestedFire.toString());
        }
        if (actualfire != null) {
            whoAmI.append(" Fire actual: ");
            whoAmI.append(actualfire.toString());
        }
        this.eventTrackingService.post(this.eventTrackingService.newEvent("sam.auto-submit.job", AutoSubmitAssessmentsJob.safeEventLength(whoAmI.toString()), true));
        log.info("Start Job: {}", (Object)whoAmI);
        GradingService gradingService = new GradingService();
        int failures = gradingService.autoSubmitAssessments();
        if (failures > 0) {
            this.samigoETSProvider.notifyAutoSubmitFailures(failures);
        }
        log.info("End Job: {} ({} failures)", (Object)whoAmI, (Object)failures);
        this.logoutFromSakai();
    }

    protected void loginToSakai(String whoAs) {
        String serverName = this.serverConfigurationService.getServerName();
        log.debug("AutoSubmitAssessmentsJob Logging into Sakai on {} as {}", (Object)serverName, (Object)whoAs);
        UsageSession session = this.usageSessionService.startSession(whoAs, serverName, "AutoSubmitAssessmentsJob");
        if (session == null) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("sam.auto-submit.job.error", whoAs + " unable to log into " + serverName, true));
            return;
        }
        Session sakaiSession = this.sessionManager.getCurrentSession();
        sakaiSession.setUserId(whoAs);
        sakaiSession.setUserEid(whoAs);
        this.authzGroupService.refreshUser(whoAs);
        this.eventTrackingService.post(this.eventTrackingService.newEvent("user.login", whoAs + " running " + serverName, true));
    }

    protected void logoutFromSakai() {
        log.debug("Logging out of Sakai on {}", (Object)this.serverConfigurationService.getServerName());
        this.eventTrackingService.post(this.eventTrackingService.newEvent("user.logout", null, true));
        this.usageSessionService.logout();
    }

    public static final String safeEventLength(String target) {
        return StringUtils.abbreviate((String)target, (int)255);
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setSamigoETSProvider(SamigoETSProvider samigoETSProvider) {
        this.samigoETSProvider = samigoETSProvider;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setUsageSessionService(UsageSessionService usageSessionService) {
        this.usageSessionService = usageSessionService;
    }
}

