/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import osid.shared.Id;

public class QuestionPoolService {
    private static final Logger log = LoggerFactory.getLogger(QuestionPoolService.class);

    public List<QuestionPoolData> getAllPools() {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllPools();
    }

    public QuestionPoolIteratorFacade getAllPools(String agentId) {
        QuestionPoolIteratorFacade results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllPools(agentId);
        return results;
    }

    public QuestionPoolIteratorFacade getAllPoolsWithAccess(String agentId) {
        QuestionPoolIteratorFacade results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllPoolsWithAccess(agentId);
        return results;
    }

    public List getBasicInfoOfAllPools(String agentId) {
        List<QuestionPoolFacade> results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getBasicInfoOfAllPools(agentId);
        return results;
    }

    public QuestionPoolFacade getPool(Long poolId, String agentId) {
        QuestionPoolFacade pool = null;
        try {
            pool = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPool(poolId, agentId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return pool;
    }

    public List getPoolIdsByItem(Long itemId) {
        List idList = null;
        try {
            idList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPoolIdsByItem(itemId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return idList;
    }

    public boolean hasItem(Long itemId, Long poolId) {
        List poollist = null;
        boolean found = false;
        try {
            poollist = this.getPoolIdsByItem(itemId);
            found = poollist != null ? poollist.contains(poolId) : false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return found;
    }

    public List<Long> getPoolIdsByAgent(String agentId) {
        List<Long> idList = null;
        try {
            idList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPoolIdsByAgent(agentId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return idList;
    }

    public List getSubPools(Long poolId) {
        List poolList = null;
        try {
            poolList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getSubPools(poolId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return poolList;
    }

    public long getSubPoolSize(Long poolId) {
        long poolSize;
        try {
            poolSize = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getSubPoolSize(poolId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return poolSize;
    }

    public boolean hasSubPools(Long poolId) {
        boolean result = false;
        try {
            result = PersistenceService.getInstance().getQuestionPoolFacadeQueries().hasSubPools(poolId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public List getAllItems(Long poolId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllItemFacades(poolId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public ArrayList getAllItemsIds(Long poolId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllItemsIds(poolId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public void addItemToPool(Long itemId, Long poolId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().addItemToPool(new QuestionPoolItemData(poolId, itemId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void moveItemToPool(Long itemId, Long sourceId, Long destId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().moveItemToPool(itemId, sourceId, destId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isDescendantOf(Long poolA, Long poolB, String agentId) {
        try {
            Long tempPoolId = poolA;
            while (tempPoolId != null && tempPoolId.toString().compareTo("0") > 0) {
                QuestionPoolFacade tempPool = this.getPool(tempPoolId, agentId);
                if (tempPool.getParentPoolId().toString().compareTo(poolB.toString()) == 0) {
                    return true;
                }
                tempPoolId = tempPool.getParentPoolId();
            }
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void movePool(String agentId, Long sourceId, Long destId) {
        try {
            if (!this.isDescendantOf(destId, sourceId, agentId)) {
                if (!sourceId.equals(destId)) {
                    PersistenceService.getInstance().getQuestionPoolFacadeQueries().movePool(agentId, sourceId, destId);
                } else {
                    log.warn("Illegal Move: Can not move a pool to itself.");
                }
            } else {
                log.warn("Illegal Move: Can not move a pool to its descendant.");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void deletePool(Long poolId, String agentId, Tree tree) {
        try {
            QuestionPoolFacade qp = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPool(poolId, agentId);
            if (!qp.getOwnerId().equals(agentId)) {
                throw new Exception("You are not allowed to delete pool if you are not the owner");
            }
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().deletePool(poolId, agentId, tree);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeQuestionFromPool(Long questionId, Long poolId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().removeItemFromPool(questionId, poolId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            if (!this.isDescendantOf(destId, sourceId, agentId)) {
                PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyPool(tree, agentId, sourceId, destId, prependString1, prependString2);
            } else {
                log.warn("Illegal Copy: Can not copy a pool to its descendant!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void copyQuestion(Id questionId, Id destId) {
    }

    public void copyQuestion(Id questionId, Id destId, boolean duplicateCopy) {
    }

    public String exportQuestion(Id questionId) {
        try {
            return "";
        }
        catch (Exception e) {
            log.error("Exception in exportQuestion", (Throwable)e);
            return null;
        }
    }

    public QuestionPoolFacade savePool(QuestionPoolFacade pool) {
        try {
            return PersistenceService.getInstance().getQuestionPoolFacadeQueries().savePool(pool);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return pool;
        }
    }

    public Map getQuestionPoolItemMap() {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().getQuestionPoolItemMap();
    }

    public boolean poolIsUnique(String questionPoolId, String title, String parentPoolId, String agentId) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().poolIsUnique(new Long(questionPoolId), title, new Long(parentPoolId), agentId);
    }

    public Long copyItemFacade(ItemDataIfc itemData) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyItemFacade(itemData);
    }

    public ItemFacade copyItemFacade2(ItemDataIfc itemData) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyItemFacade2(itemData);
    }

    public int getCountItems(Long poolId) {
        Integer result = 0;
        try {
            result = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getCountItemFacades(poolId);
        }
        catch (Exception e) {
            log.error("getCountItems", (Throwable)e);
        }
        return result;
    }

    public Map<Long, Integer> getCountItemsForUser(String agentId) {
        HashMap<Long, Integer> result = new HashMap();
        try {
            result = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getCountItemFacadesForUser(agentId);
        }
        catch (Exception e) {
            log.error("getCountItemsForUser", (Throwable)e);
        }
        return result;
    }

    public void addQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().addQuestionPoolAccess(tree, user, questionPoolId, accessTypeId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().removeQuestionPoolAccess(tree, user, questionPoolId, accessTypeId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<AgentFacade> getAgentsWithAccess(Long questionPoolId) {
        List<AgentFacade> agents = null;
        try {
            agents = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAgentsWithAccess(questionPoolId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return agents;
    }

    public List<AgentFacade> getAgentsWithoutAccess(Long questionPoolId, String realmId) {
        ArrayList<AgentFacade> agents = new ArrayList<AgentFacade>();
        try {
            List<AgentFacade> agentsWithAccess = this.getAgentsWithAccess(questionPoolId);
            ArrayList<CallSite> azGroups = new ArrayList<CallSite>();
            azGroups.add((CallSite)((Object)("/site/" + realmId)));
            Set users = ((AuthzGroupService)ComponentManager.get(AuthzGroupService.class)).getUsersIsAllowed("assessment.questionpool.create", azGroups);
            for (String userId : users) {
                AgentFacade agent = new AgentFacade(userId);
                agents.add(agent);
            }
            agents.removeAll(agentsWithAccess);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return agents;
    }

    public void transferPoolsOwnership(String ownerId, List<Long> poolIds) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().transferPoolsOwnership(ownerId, poolIds);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

