/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.samigo.api.SamigoReferenceReckoner;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.shared.api.qti.QTIServiceAPI;
import org.sakaiproject.util.cover.LinkMigrationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AssessmentEntityProducer
implements EntityTransferrer,
EntityProducer {
    private static final Logger log = LoggerFactory.getLogger(AssessmentEntityProducer.class);
    private static final int QTI_VERSION = 1;
    private static final String ARCHIVED_ELEMENT = "assessment";
    public static final String REFERENCE_ROOT = "/samigo";
    private QTIServiceAPI qtiService;
    protected EntityManager entityManager;
    protected ServerConfigurationService serverConfigService;
    protected SiteService siteService;
    protected PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries;

    public void init() {
        log.info("init()");
        try {
            this.entityManager.registerEntityProducer((EntityProducer)this, REFERENCE_ROOT);
        }
        catch (Exception e) {
            log.warn("Error registering Samigo Entity Producer", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void setQtiService(QTIServiceAPI qtiService) {
        this.qtiService = qtiService;
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{"sakai.samigo"};
        return toolIds;
    }

    public Map<String, String> transferCopyEntities(String fromContext, String toContext, List<String> resourceIds, List<String> transferOptions) {
        AssessmentService service = new AssessmentService();
        HashMap<String, String> transversalMap = new HashMap<String, String>();
        service.copyAllAssessments(fromContext, toContext, transversalMap);
        transversalMap.put("/content/attachment/" + fromContext + "/", "/content/attachment/" + toContext + "/");
        return transversalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        StringBuilder results = new StringBuilder();
        results.append("archiving ").append(this.getLabel()).append("\n");
        String qtiPath = archivePath + File.separator + "qti";
        File qtiDir = new File(qtiPath);
        if (!qtiDir.isDirectory() && !qtiDir.mkdir()) {
            log.error("Could not create directory " + qtiPath);
            results.append("Could not create " + qtiPath + "\n");
            return results.toString();
        }
        Element element = doc.createElement(this.getClass().getName());
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        AssessmentService assessmentService = new AssessmentService();
        List assessmentList = assessmentService.getAllActiveAssessmentsbyAgent(siteId);
        for (AssessmentData data : assessmentList) {
            Element assessmentXml = doc.createElement(ARCHIVED_ELEMENT);
            String id = data.getAssessmentId().toString();
            assessmentXml.setAttribute("id", id);
            OutputStreamWriter writer = null;
            try {
                File assessmentFile = new File(qtiPath + File.separator + ARCHIVED_ELEMENT + id + ".xml");
                writer = new FileWriter(assessmentFile);
                writer.write(this.qtiService.getExportedAssessmentAsString(id, 1));
            }
            catch (IOException e) {
                results.append(e.getMessage() + "\n");
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable t) {
                        log.error(t.getMessage(), t);
                    }
                }
            }
            element.appendChild(assessmentXml);
        }
        stack.pop();
        return results.toString();
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        Long id;
        PublishedAssessmentFacade paf;
        if (StringUtils.isNotBlank((CharSequence)ref.getId()) && (paf = this.publishedAssessmentFacadeQueries.getPublishedAssessment(id = Long.valueOf(Long.parseLong(ref.getId())))) != null) {
            String alias = paf.getAssessmentMetaDataByLabel("ALIAS");
            return this.serverConfigService.getServerUrl() + "/samigo-app/servlet/Login?id=" + alias;
        }
        return null;
    }

    public Optional<String> getEntityUrl(Reference ref, Entity.UrlType urlType) {
        SamigoReferenceReckoner.SamigoReference samigoRef = SamigoReferenceReckoner.reckoner().reference(ref.getReference()).reckon();
        try {
            Long id = Long.parseLong(samigoRef.getId());
            Site site = this.siteService.getSite(samigoRef.getSite());
            ToolConfiguration tc = site.getToolForCommonId("sakai.samigo");
            if (tc != null) {
                return Optional.of("/portal/site/" + samigoRef.getSite() + "/tool/" + tc.getId() + "/jsf/evaluation/totalScores?publishedId=" + id);
            }
        }
        catch (NumberFormatException nfe) {
            log.error("{} is not a valid Samigo id", (Object)samigoRef.getId());
        }
        catch (IdUnusedException idue) {
            log.error("No site for id {}", (Object)samigoRef.getSite());
        }
        return Optional.empty();
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String getLabel() {
        return "samigo";
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        if (log.isDebugEnabled()) {
            log.debug("merging " + this.getLabel());
        }
        StringBuilder results = new StringBuilder();
        String qtiPath = new File(archivePath).getParent() + File.separator + "qti" + File.separator;
        NodeList assessments = root.getElementsByTagName(ARCHIVED_ELEMENT);
        DocumentBuilder dbuilder = null;
        try {
            dbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            return this.getLabel() + " Error: " + t.getMessage();
        }
        for (int i = 0; i < assessments.getLength(); ++i) {
            Element element = (Element)assessments.item(i);
            String id = element.getAttribute("id");
            String path = qtiPath + ARCHIVED_ELEMENT + id + ".xml";
            try {
                AssessmentIfc assessment = this.qtiService.createImportedAssessment(path, 1, siteId);
                results.append(this.getLabel() + " imported assessment '" + assessment.getTitle() + "'\n");
                continue;
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                results.append(this.getLabel() + " error with assessment " + id + ": " + t.getMessage() + "\n");
            }
        }
        return results.toString();
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        if (StringUtils.startsWith((CharSequence)reference, (CharSequence)REFERENCE_ROOT)) {
            String[] parts = StringUtils.splitPreserveAllTokens((String)reference, (String)"/");
            if (parts.length >= 3) {
                ref.set("sakai:samigo", ARCHIVED_ELEMENT, parts[3], parts[2], parts[2]);
            }
            return true;
        }
        return false;
    }

    public boolean willArchiveMerge() {
        return true;
    }

    public Map<String, String> transferCopyEntities(String fromContext, String toContext, List<String> ids, List<String> options, boolean cleanup) {
        try {
            if (cleanup) {
                if (log.isDebugEnabled()) {
                    log.debug("deleting assessments from " + toContext);
                }
                AssessmentService service = new AssessmentService();
                List assessmentList = service.getAllActiveAssessmentsbyAgent(toContext);
                log.debug("found " + assessmentList.size() + " assessments in site: " + toContext);
                for (AssessmentData oneassessment : assessmentList) {
                    log.debug("removing assessemnt id = " + oneassessment.getAssessmentId());
                    service.removeAssessment(oneassessment.getAssessmentId().toString());
                }
            }
        }
        catch (Exception e) {
            log.error("transferCopyEntities: End removing Assessment data", (Throwable)e);
        }
        return this.transferCopyEntities(fromContext, toContext, ids, null);
    }

    public void updateEntityReferences(String toContext, Map<String, String> transversalMap) {
        if (transversalMap != null && transversalMap.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = transversalMap.entrySet();
            AssessmentService service = new AssessmentService();
            List assessmentList = service.getAllActiveAssessmentsbyAgent(toContext);
            for (AssessmentData assessment : assessmentList) {
                AssessmentFacade assessmentFacade = (AssessmentFacade)service.getAssessment(assessment.getAssessmentId());
                boolean needToUpdate = false;
                String assessmentDesc = assessmentFacade.getDescription();
                if (assessmentDesc != null && !(assessmentDesc = LinkMigrationHelper.migrateAllLinks(entrySet, (String)assessmentDesc)).equals(assessmentFacade.getDescription())) {
                    needToUpdate = true;
                    assessmentFacade.setDescription(assessmentDesc);
                }
                ArrayList sectionList = assessmentFacade.getSectionArray();
                for (int i = 0; i < sectionList.size(); ++i) {
                    SectionFacade section = (SectionFacade)sectionList.get(i);
                    String sectionDesc = section.getDescription();
                    if (sectionDesc != null && !(sectionDesc = LinkMigrationHelper.migrateAllLinks(entrySet, (String)sectionDesc)).equals(section.getDescription())) {
                        needToUpdate = true;
                        section.setDescription(sectionDesc);
                    }
                    ArrayList itemList = section.getItemArray();
                    for (int j = 0; j < itemList.size(); ++j) {
                        List itemTextList;
                        String itemDesc;
                        ItemData item = (ItemData)itemList.get(j);
                        String itemIntr = item.getInstruction();
                        if (itemIntr != null && !(itemIntr = LinkMigrationHelper.migrateAllLinks(entrySet, (String)itemIntr)).equals(item.getInstruction())) {
                            needToUpdate = true;
                            item.setInstruction(itemIntr);
                        }
                        if ((itemDesc = item.getDescription()) != null && !(itemDesc = LinkMigrationHelper.migrateAllLinks(entrySet, (String)itemDesc)).equals(item.getDescription())) {
                            needToUpdate = true;
                            item.setDescription(itemDesc);
                        }
                        if ((itemTextList = item.getItemTextArray()) == null) continue;
                        for (int k = 0; k < itemTextList.size(); ++k) {
                            List answerSetList;
                            ItemText itemText = (ItemText)itemTextList.get(k);
                            String text = itemText.getText();
                            if (text != null) {
                                text = service.copyContentHostingAttachments(text, toContext);
                                if (!(text = LinkMigrationHelper.migrateAllLinks(entrySet, (String)text)).equals(itemText.getText())) {
                                    needToUpdate = true;
                                    itemText.setText(text);
                                } else {
                                    log.info("Migration - now update");
                                }
                            }
                            if ((answerSetList = itemText.getAnswerArray()) == null) continue;
                            for (int l = 0; l < answerSetList.size(); ++l) {
                                Answer answer = (Answer)answerSetList.get(l);
                                String answerText = answer.getText();
                                if (answerText == null) continue;
                                answerText = service.copyContentHostingAttachments(answerText, toContext);
                                if ((answerText = LinkMigrationHelper.migrateAllLinks(entrySet, (String)answerText)).equals(answer.getText())) continue;
                                needToUpdate = true;
                                answer.setText(answerText);
                            }
                        }
                    }
                }
                if (!needToUpdate) continue;
                service.saveAssessment(assessmentFacade);
            }
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public ServerConfigurationService getServerConfigService() {
        return this.serverConfigService;
    }

    public void setServerConfigService(ServerConfigurationService serverConfigService) {
        this.serverConfigService = serverConfigService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public PublishedAssessmentFacadeQueriesAPI getPublishedAssessmentFacadeQueries() {
        return this.publishedAssessmentFacadeQueries;
    }

    public void setPublishedAssessmentFacadeQueries(PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries) {
        this.publishedAssessmentFacadeQueries = publishedAssessmentFacadeQueries;
    }
}

