/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.cover.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentService {
    private static final Logger log = LoggerFactory.getLogger(AssessmentService.class);
    public static final int UPDATE_SUCCESS = 0;
    public static final int UPDATE_ERROR_DRAW_SIZE_TOO_LARGE = 1;
    private SecurityService securityService = (SecurityService)ComponentManager.get(SecurityService.class);
    private static final String VERSION_START = "  - ";
    public static final String INVALID_CHARS_IN_RESOURCE_ID = "^/\\{}[]()%*?#&=\n\r\t\b\f";
    protected static final String MAP_TO_A = "\u0089\u008a\u0088\u008c\u0080?\u0087\u0087";
    protected static final String MAP_TO_B = "\u00a7\u00a7";
    protected static final String MAP_TO_C = "\u0082?\u00a2\u00a2";
    protected static final String MAP_TO_E = "\u008e?\u0091?\u0083\u00be\u00ae\u00ae";
    protected static final String MAP_TO_I = "\u0095\u0094\u0093\u0092\u0092";
    protected static final String MAP_TO_L = "\u00a3\u00a3";
    protected static final String MAP_TO_N = "\u0096\u0084\u0084";
    protected static final String MAP_TO_O = "\u0099\u009a\u0098\u0085\u0097\u0097";
    protected static final String MAP_TO_U = "\u009f\u009e?\u0086\u009c\u009c";
    protected static final String MAP_TO_Y = "\u00d8\u00b4??";
    protected static final String MAP_TO_X = "???\u00a4\u00a9\u00bb\u00a8\u00b1?\u00ab\u00b5\u00a6\u00c0?";
    protected static final String ESCAPE_CHARS_IN_RESOURCE_ID = ";'\"";

    public AssessmentTemplateFacade getAssessmentTemplate(String assessmentTemplateId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentTemplate(new Long(assessmentTemplateId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade getAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessment(Long.valueOf(assessmentId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentIfc getAssessment(Long assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessment(assessmentId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade getBasicInfoOfAnAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAnAssessment(new Long(assessmentId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade getBasicInfoOfAnAssessmentFromSectionId(Long sectionId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAnAssessmentFromSectionId(sectionId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AssessmentTemplateFacade> getAllAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessmentTemplates();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AssessmentTemplateFacade> getAllActiveAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessmentTemplates();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AssessmentTemplateFacade> getTitleOfAllActiveAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getTitleOfAllActiveAssessmentTemplates();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AssessmentFacade> getAllAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(orderBy);
    }

    public List<AssessmentFacade> getAllActiveAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessments(orderBy);
    }

    public List<AssessmentFacade> getSettingsOfAllActiveAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getSettingsOfAllActiveAssessments(orderBy);
    }

    public List<AssessmentFacade> getBasicInfoOfAllActiveAssessments(String orderBy, boolean ascending) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentsByAgent(orderBy, siteAgentId, ascending);
    }

    public List<AssessmentFacade> getBasicInfoOfAllActiveAssessments(String orderBy) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentsByAgent(orderBy, siteAgentId);
    }

    public List<AssessmentFacade> getAllAssessments(int pageSize, int pageNumber, String orderBy) {
        try {
            if (pageSize > 0 && pageNumber > 0) {
                return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(pageSize, pageNumber, orderBy);
            }
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(orderBy);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade createAssessment(String title, String description, String typeId, String templateId) throws Exception {
        return this.createAssessment(title, description, typeId, templateId, null);
    }

    public AssessmentFacade createAssessment(String title, String description, String typeId, String templateId, String siteId) throws Exception {
        AssessmentFacade assessment = null;
        try {
            Object assessmentTemplate = null;
            Long templateIdLong = AssessmentTemplateFacade.DEFAULTTEMPLATE;
            if (StringUtils.isNotBlank((CharSequence)templateId)) {
                templateIdLong = new Long(templateId);
            }
            Long typeIdLong = TypeFacade.HOMEWORK;
            if (StringUtils.isNotBlank((CharSequence)typeId)) {
                typeIdLong = new Long(typeId);
            }
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            log.debug("**** AssessmentFacadeQueries=" + queries);
            assessment = queries.createAssessment(title, description, typeIdLong, templateIdLong, siteId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return assessment;
    }

    public int getQuestionSize(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getQuestionSize(new Long(assessmentId));
    }

    public List getQuestionsIdList(long assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getQuestionsIdList(assessmentId);
    }

    public void update(AssessmentFacade assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(assessment);
    }

    public void save(AssessmentTemplateData template) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(template);
    }

    public void deleteAllSecuredIP(AssessmentIfc assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteAllSecuredIP(assessment);
    }

    public void saveAssessment(AssessmentFacade assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(assessment);
    }

    public void deleteAssessmentTemplate(Long assessmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteTemplate(assessmentId);
    }

    public void removeAssessment(String assessmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAssessment(new Long(assessmentId));
    }

    public SectionFacade addSection(String assessmentId) {
        SectionFacade section = null;
        try {
            Long assessmentIdLong = new Long(assessmentId);
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            section = queries.addSection(assessmentIdLong);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return section;
    }

    public void removeSection(String sectionId) {
        try {
            Long sectionIdLong = new Long(sectionId);
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            queries.removeSection(sectionIdLong);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public SectionFacade getSection(String sectionId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getSection(new Long(sectionId));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveOrUpdateSection(SectionFacade section) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdateSection(section);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void moveAllItems(String sourceSectionId, String destSectionId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().moveAllItems(new Long(sourceSectionId), new Long(destSectionId));
    }

    public void removeAllItems(String sourceSectionId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAllItems(new Long(sourceSectionId));
    }

    public boolean verifyItemsDrawSize(SectionFacade section) {
        if (section != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && StringUtils.equals((CharSequence)section.getSectionMetaDataByLabel("AUTHOR_TYPE"), (CharSequence)SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            QuestionPoolService qpService = new QuestionPoolService();
            List itemlist = qpService.getAllItems(Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW")));
            return this.verifyItemsDrawSize(itemlist.size(), section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
        }
        return true;
    }

    private boolean verifyItemsDrawSize(int itemcount, String numberDrawn) {
        try {
            int numberDrawnInt = Integer.parseInt(numberDrawn);
            if (numberDrawnInt <= 0 || numberDrawnInt > itemcount) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public int updateRandomPoolQuestions(SectionFacade section) {
        return this.updateRandomPoolQuestions(section, false);
    }

    public int updateRandomPoolQuestions(SectionFacade section, boolean publishing) {
        if (section != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && StringUtils.equals((CharSequence)section.getSectionMetaDataByLabel("AUTHOR_TYPE"), (CharSequence)SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            QuestionPoolService qpService = new QuestionPoolService();
            List itemlist = qpService.getAllItems(Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW")));
            if (this.verifyItemsDrawSize(itemlist.size(), section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"))) {
                String requestedDiscount;
                String requestedScore;
                this.removeAllItems(section.getSectionId().toString());
                ItemService itemService = new ItemService();
                String agentId = AgentFacade.getAgentString();
                Iterator itemIter = section.getItemSet().iterator();
                while (itemIter.hasNext()) {
                    ItemDataIfc item = (ItemDataIfc)itemIter.next();
                    List poolIds = qpService.getPoolIdsByItem(item.getItemId());
                    if (!poolIds.isEmpty()) continue;
                    Long deleteId = item.getItemId();
                    itemService.deleteItem(deleteId, agentId);
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.item.delete", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/removed itemId=" + deleteId), (boolean)true));
                    itemIter.remove();
                }
                section = this.getSection(section.getSectionId().toString());
                boolean hasRandomPartScore = false;
                Double score = null;
                String string = requestedScore = section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION") != null ? section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION") : "";
                if (StringUtils.isNotBlank((CharSequence)requestedScore)) {
                    hasRandomPartScore = true;
                    score = new Double(requestedScore);
                }
                boolean hasRandomPartDiscount = false;
                Double discount = null;
                String string2 = requestedDiscount = section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION") != null ? section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION") : "";
                if (StringUtils.isNotBlank((CharSequence)requestedDiscount)) {
                    hasRandomPartDiscount = true;
                    discount = new Double(requestedDiscount);
                }
                int i = 0;
                for (ItemFacade item : itemlist) {
                    ItemDataIfc data;
                    Set itemTextSet;
                    item = qpService.copyItemFacade2(item);
                    item.setSection(section);
                    item.setSequence(i + 1);
                    if (hasRandomPartScore) {
                        item.setScore(score);
                    }
                    long itemTypeId = item.getTypeId();
                    String mcmsPartialCredit = item.getItemMetaDataByLabel("MCMS_PARTIAL_CREDIT");
                    if (hasRandomPartDiscount && (itemTypeId == TypeFacade.MULTIPLE_CHOICE || itemTypeId == TypeFacade.TRUE_FALSE || itemTypeId == TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION || itemTypeId == TypeFacade.MULTIPLE_CORRECT && "false".equals(mcmsPartialCredit))) {
                        item.setDiscount(discount);
                    }
                    if ((itemTextSet = (data = item.getData()).getItemTextSet()) != null) {
                        for (ItemTextIfc itemText : itemTextSet) {
                            Set answerSet;
                            if (publishing) {
                                itemText.setText(this.copyContentHostingAttachments(itemText.getText(), AgentFacade.getCurrentSiteId()));
                            }
                            if ((answerSet = itemText.getAnswerSet()) == null) continue;
                            for (AnswerIfc answer : answerSet) {
                                if (publishing) {
                                    answer.setText(this.copyContentHostingAttachments(answer.getText(), AgentFacade.getCurrentSiteId()));
                                }
                                if (hasRandomPartScore) {
                                    answer.setScore(score);
                                }
                                if (!hasRandomPartDiscount || itemTypeId != TypeFacade.MULTIPLE_CHOICE && itemTypeId != TypeFacade.TRUE_FALSE && itemTypeId != TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION && (itemTypeId != TypeFacade.MULTIPLE_CORRECT || !"false".equals(mcmsPartialCredit))) continue;
                                answer.setDiscount(discount);
                            }
                        }
                    }
                    section.addItem(item);
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved  itemId=" + item.getItemId().toString()), (boolean)true));
                    ++i;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                section.addSectionMetaData("QUESTIONS_RANDOM_DRAW_DATE", df.format(new Date()));
                this.saveOrUpdateSection(section);
            } else {
                return 1;
            }
        }
        return 0;
    }

    public int updateAllRandomPoolQuestions(AssessmentFacade assessment) {
        return this.updateAllRandomPoolQuestions(assessment, false);
    }

    public int updateAllRandomPoolQuestions(AssessmentFacade assessment, boolean publishing) {
        for (SectionFacade section : assessment.getSectionArray()) {
            if (this.verifyItemsDrawSize(section)) continue;
            return 1;
        }
        for (SectionFacade section : assessment.getSectionArray()) {
            this.updateRandomPoolQuestions(section, publishing);
        }
        return 0;
    }

    public List<AssessmentTemplateFacade> getBasicInfoOfAllActiveAssessmentTemplates(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentTemplates(orderBy);
    }

    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, String typeId, String templateId) throws Exception {
        return this.createAssessmentWithoutDefaultSection(title, description, typeId, templateId, null);
    }

    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, String typeId, String templateId, String siteId) throws Exception {
        AssessmentFacade assessment = null;
        try {
            Object assessmentTemplate = null;
            Long templateIdLong = AssessmentTemplateFacade.DEFAULTTEMPLATE;
            if (StringUtils.isNotBlank((CharSequence)templateId)) {
                templateIdLong = new Long(templateId);
            }
            Long typeIdLong = TypeFacade.HOMEWORK;
            if (StringUtils.isNotBlank((CharSequence)typeId)) {
                typeIdLong = new Long(typeId);
            }
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            assessment = queries.createAssessmentWithoutDefaultSection(title, description, typeIdLong, templateIdLong, siteId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return assessment;
    }

    public boolean assessmentTitleIsUnique(String assessmentBaseId, String title, boolean isTemplate) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().assessmentTitleIsUnique(new Long(assessmentBaseId), title, isTemplate);
    }

    public List getAssessmentByTemplate(String templateId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentByTemplate(new Long(templateId));
    }

    public List getDefaultMetaDataSet() {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getDefaultMetaDataSet();
    }

    public void deleteAllMetaData(AssessmentBaseIfc assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteAllMetaData(assessment);
    }

    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol) {
        return this.createItemAttachment(item, resourceId, filename, protocol, true);
    }

    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        ItemAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createItemAttachment(item, resourceId, filename, protocol, isEditPendingAssessmentFlow);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public ItemTextAttachmentIfc createItemTextAttachment(ItemTextIfc itemText, String resourceId, String filename, String protocol) {
        return this.createItemTextAttachment(itemText, resourceId, filename, protocol, true);
    }

    public ItemTextAttachmentIfc createItemTextAttachment(ItemTextIfc itemText, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        ItemTextAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createItemTextAttachment(itemText, resourceId, filename, protocol, isEditPendingAssessmentFlow);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public void updateAssessmentLastModifiedInfo(AssessmentIfc assessment) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().updateAssessmentLastModifiedInfo((AssessmentFacade)assessment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        SectionAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createSectionAttachment(section, resourceId, filename, protocol);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public void removeSectionAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeSectionAttachment(new Long(attachmentId));
    }

    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        AssessmentAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createAssessmentAttachment(assessment, resourceId, filename, protocol);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public void removeAssessmentAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAssessmentAttachment(new Long(attachmentId));
    }

    public AttachmentData createEmailAttachment(String resourceId, String filename, String protocol) {
        AttachmentData attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createEmailAttachment(resourceId, filename, protocol);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public List getAssessmentResourceIdList(AssessmentIfc pub) {
        List resourceIdList = new ArrayList();
        List list = pub.getAssessmentAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        Set sectionSet = pub.getSectionSet();
        for (SectionDataIfc section : sectionSet) {
            List sectionAttachments = this.getSectionResourceIdList(section);
            if (sectionAttachments == null) continue;
            resourceIdList.addAll(sectionAttachments);
        }
        log.debug("*** resource size=" + resourceIdList.size());
        return resourceIdList;
    }

    public List getSectionResourceIdList(SectionDataIfc section) {
        List resourceIdList = new ArrayList();
        List list = section.getSectionAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        Set itemSet = section.getItemSet();
        for (ItemDataIfc item : itemSet) {
            List itemAttachments = this.getItemResourceIdList(item);
            if (itemAttachments == null) continue;
            resourceIdList.addAll(itemAttachments);
        }
        return resourceIdList;
    }

    public List getItemResourceIdList(ItemDataIfc item) {
        List resourceIdList = new ArrayList();
        List list = item.getItemAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        return resourceIdList;
    }

    private List getResourceIdList(List list) {
        ArrayList<String> resourceIdList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            AttachmentIfc attach = (AttachmentIfc)list.get(i);
            resourceIdList.add(attach.getResourceId());
        }
        return resourceIdList;
    }

    public void deleteResources(List resourceIdList) {
        if (resourceIdList == null) {
            return;
        }
        for (int i = 0; i < resourceIdList.size(); ++i) {
            String resourceId = (String)resourceIdList.get(i);
            if (!(resourceId = resourceId.trim()).toLowerCase().startsWith("/attachment")) continue;
            try {
                log.debug("removing=" + resourceId);
                AssessmentService.getContentHostingService().removeResource(resourceId);
                continue;
            }
            catch (PermissionException e) {
                log.warn("cannot remove resourceId=" + resourceId + ":" + e.getMessage());
                log.warn("PermissionException from ContentHostingService:" + e.getMessage());
                continue;
            }
            catch (IdUnusedException e) {
                log.warn("cannot remove resourceId=" + resourceId + ":" + e.getMessage());
                log.warn("IdUnusedException from ContentHostingService:" + e.getMessage());
                continue;
            }
            catch (TypeException e) {
                log.warn("cannot remove resourceId=" + resourceId + ":" + e.getMessage());
                log.warn("TypeException from ContentHostingService:" + e.getMessage());
                continue;
            }
            catch (InUseException e) {
                log.warn("cannot remove resourceId=" + resourceId + ":" + e.getMessage());
                log.warn("InUseException from ContentHostingService:" + e.getMessage());
            }
        }
    }

    public void saveOrUpdateAttachments(List list) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdateAttachments(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentResource createCopyOfContentResource(String resourceId, String filename, String toContext) {
        filename = filename.replaceAll("http://", "http:__");
        ContentResource cr_copy = null;
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String arg0, String arg1, String arg2) {
                if ("content.read".equals(arg1)) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
                return SecurityAdvisor.SecurityAdvice.PASS;
            }
        };
        try {
            this.securityService.pushAdvisor(securityAdvisor);
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            String escapedName = AssessmentService.escapeResourceName(filename);
            cr_copy = StringUtils.isNotBlank((CharSequence)toContext) ? AssessmentService.getContentHostingService().addAttachmentResource(escapedName, toContext, ToolManager.getTool((String)"sakai.samigo").getTitle(), cr.getContentType(), cr.streamContent(), cr.getProperties()) : AssessmentService.getContentHostingService().addAttachmentResource(escapedName, ToolManager.getCurrentPlacement().getContext(), ToolManager.getTool((String)"sakai.samigo").getTitle(), cr.getContentType(), cr.streamContent(), cr.getProperties());
        }
        catch (Exception e) {
            log.warn("Could not copy resource " + resourceId + ", " + e.getMessage());
        }
        finally {
            this.securityService.popAdvisor(securityAdvisor);
        }
        return cr_copy;
    }

    public ContentResource createCopyOfContentResource(String resourceId, String filename) {
        return this.createCopyOfContentResource(resourceId, filename, null);
    }

    public static String escapeResourceName(String id) {
        if (id == null) {
            return "";
        }
        id = id.trim();
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (MAP_TO_A.indexOf(c) >= 0) {
                    buf.append('a');
                    continue;
                }
                if (MAP_TO_E.indexOf(c) >= 0) {
                    buf.append('e');
                    continue;
                }
                if (MAP_TO_I.indexOf(c) >= 0) {
                    buf.append('i');
                    continue;
                }
                if (MAP_TO_O.indexOf(c) >= 0) {
                    buf.append('o');
                    continue;
                }
                if (MAP_TO_U.indexOf(c) >= 0) {
                    buf.append('u');
                    continue;
                }
                if (MAP_TO_Y.indexOf(c) >= 0) {
                    buf.append('y');
                    continue;
                }
                if (MAP_TO_N.indexOf(c) >= 0) {
                    buf.append('n');
                    continue;
                }
                if (MAP_TO_B.indexOf(c) >= 0) {
                    buf.append('b');
                    continue;
                }
                if (MAP_TO_C.indexOf(c) >= 0) {
                    buf.append('c');
                    continue;
                }
                if (MAP_TO_L.indexOf(c) >= 0) {
                    buf.append('l');
                    continue;
                }
                if (MAP_TO_X.indexOf(c) >= 0) {
                    buf.append('x');
                    continue;
                }
                if (c < ' ') {
                    buf.append('_');
                    continue;
                }
                if (INVALID_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0 || ESCAPE_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0) {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            log.warn("escapeResourceName: ", (Throwable)e);
            return id;
        }
    }

    public void copyAllAssessments(String fromContext, String toContext, Map<String, String> transversalMap) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().copyAllAssessments(fromContext, toContext, transversalMap);
            List<PublishedAssessmentFacade> publist = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments("dueDate", true, fromContext);
            for (PublishedAssessmentFacade facade : publist) {
                PublishedAssessmentData data = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().loadPublishedAssessment(facade.getPublishedAssessmentId());
                if (data == null) continue;
                String oldRef = "sam_pub/" + data.getPublishedAssessmentId();
                String oldCore = "sam_core/" + data.getAssessmentId();
                String newCore = transversalMap.get(oldCore);
                if (oldRef == null || newCore == null) continue;
                transversalMap.put(oldRef, newCore);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void copyAssessment(String assessmentId, String appendCopyTitle) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().copyAssessment(assessmentId, appendCopyTitle);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List getAllActiveAssessmentsbyAgent(String fromContext) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessmentsByAgent(fromContext);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getAssessmentSiteId(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentSiteId(assessmentId);
    }

    public String getAssessmentCreatedBy(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentCreatedBy(assessmentId);
    }

    public Set copyItemAttachmentSet(ItemData newItem, Set itemAttachmentSet) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().copyItemAttachmentSet(newItem, itemAttachmentSet);
    }

    public static ContentHostingService getContentHostingService() {
        return (ContentHostingService)ComponentManager.get((String)ContentHostingService.class.getName());
    }

    public List getFavoriteColChoicesbyAgent(String fromContext) {
        try {
            return PersistenceService.getInstance().getFavoriteColChoicesFacadeQueries().getFavoriteColChoicesByAgent(fromContext);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copyContentHostingAttachments(String text, String toContext) {
        if (text != null) {
            ContentResource cr = null;
            String[] sources = StringUtils.splitByWholeSeparator((String)text, (String)"src=\"");
            HashSet<String> attachments = new HashSet<String>();
            for (String source : sources) {
                String theHref = StringUtils.substringBefore((String)source, (String)"\"");
                if (!StringUtils.contains((CharSequence)theHref, (CharSequence)"/access/content/")) continue;
                attachments.add(theHref);
            }
            if (attachments.size() > 0) {
                log.info("Found " + attachments.size() + " attachments buried in question or answer text");
                SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

                    public SecurityAdvisor.SecurityAdvice isAllowed(String arg0, String arg1, String arg2) {
                        if ("content.read".equals(arg1)) {
                            return SecurityAdvisor.SecurityAdvice.ALLOWED;
                        }
                        return SecurityAdvisor.SecurityAdvice.PASS;
                    }
                };
                try {
                    this.securityService.pushAdvisor(securityAdvisor);
                    for (String attachment : attachments) {
                        String resourceIdOrig = "/" + StringUtils.substringAfter((String)attachment, (String)"/access/content/");
                        String resourceId = URLDecoder.decode(resourceIdOrig);
                        String filename = StringUtils.substringAfterLast((String)attachment, (String)"/");
                        try {
                            cr = AssessmentService.getContentHostingService().getResource(resourceId);
                        }
                        catch (IdUnusedException e) {
                            log.warn("Could not find resource (" + resourceId + ") that was embedded in a question or answer");
                        }
                        catch (TypeException e) {
                            log.warn("TypeException for resource (" + resourceId + ") that was embedded in a question or answer", (Throwable)e);
                        }
                        catch (PermissionException e) {
                            log.warn("No permission for resource (" + resourceId + ") that was embedded in a question or answer");
                        }
                        if (cr == null || !StringUtils.isNotEmpty((CharSequence)filename)) continue;
                        ContentResource crCopy = this.createCopyOfContentResource(cr.getId(), filename, toContext);
                        text = StringUtils.replace((String)text, (String)resourceIdOrig, (String)StringUtils.substringAfter((String)crCopy.getReference(), (String)"/content"));
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                finally {
                    this.securityService.popAdvisor(securityAdvisor);
                }
            }
        }
        return text;
    }

    public String exportAssessmentToMarkupText(AssessmentFacade assessment, Map<String, String> bundle) {
        StringBuilder markupText = new StringBuilder();
        int nQuestion = 1;
        for (Object sectionObj : assessment.getSectionArray()) {
            SectionFacade section = (SectionFacade)sectionObj;
            List items = null;
            boolean hasRandomPartScore = false;
            Double score = null;
            boolean hasRandomPartDiscount = false;
            Double discount = null;
            if (StringUtils.equals((CharSequence)section.getSectionMetaDataByLabel("AUTHOR_TYPE"), (CharSequence)SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString())) {
                items = section.getItemArray();
            } else {
                String requestedDiscount;
                String requestedScore = StringUtils.trimToEmpty((String)section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION"));
                if (StringUtils.isNotEmpty((CharSequence)requestedScore)) {
                    hasRandomPartScore = true;
                    try {
                        score = new Double(requestedScore);
                    }
                    catch (NumberFormatException e) {
                        log.error("NumberFormatException converting to Double: " + requestedScore);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(requestedDiscount = StringUtils.trimToEmpty((String)section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION"))))) {
                    hasRandomPartDiscount = true;
                    try {
                        discount = new Double(requestedDiscount);
                    }
                    catch (NumberFormatException e) {
                        log.error("NumberFormatException converting to Double: " + requestedDiscount);
                    }
                }
                QuestionPoolService qpService = new QuestionPoolService();
                try {
                    Long sectionId = Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"));
                    items = qpService.getAllItems(sectionId);
                }
                catch (NumberFormatException e) {
                    log.error("NumberFormatException converting to Long: " + section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"));
                }
            }
            for (ItemDataIfc item : items) {
                if (!this.isQuestionTypeExportable2MarkupText(item.getTypeId())) continue;
                markupText.append(nQuestion).append(". ");
                if (hasRandomPartScore) {
                    markupText.append("(").append(score).append(" ").append(bundle.get("points")).append(")");
                } else {
                    markupText.append("(").append(item.getScore()).append(" ").append(bundle.get("points")).append(")");
                }
                if (hasRandomPartDiscount && discount != null && discount > 0.0) {
                    markupText.append(" (").append(discount).append(" ").append(bundle.get("discount")).append(")");
                } else if (!hasRandomPartDiscount && item.getDiscount() != null && item.getDiscount() > 0.0) {
                    markupText.append(" (").append(item.getDiscount()).append(" ").append(bundle.get("discount")).append(")");
                }
                for (ItemTextIfc itemText : item.getItemTextArray()) {
                    markupText.append("\n");
                    if ((long)TypeIfc.FILL_IN_BLANK.intValue() == item.getTypeId() || (long)TypeIfc.FILL_IN_NUMERIC.intValue() == item.getTypeId()) {
                        markupText.append(itemText.getText().replaceAll("\\{\\}", ""));
                    } else {
                        markupText.append(itemText.getText());
                    }
                    if ((long)TypeIfc.ESSAY_QUESTION.intValue() == item.getTypeId()) continue;
                    for (AnswerIfc answer : itemText.getAnswerArray()) {
                        markupText.append("\n");
                        if (answer.getIsCorrect().booleanValue()) {
                            markupText.append("*");
                        }
                        if ((long)TypeIfc.MULTIPLE_CHOICE.intValue() == item.getTypeId() || (long)TypeIfc.MULTIPLE_CORRECT.intValue() == item.getTypeId()) {
                            markupText.append(answer.getLabel()).append(". ");
                        }
                        if ((long)TypeIfc.FILL_IN_NUMERIC.intValue() == item.getTypeId()) {
                            markupText.append("{").append(answer.getText()).append("}");
                            continue;
                        }
                        if ((long)TypeIfc.TRUE_FALSE.intValue() == item.getTypeId()) {
                            String boolText = bundle.get("false");
                            if (Boolean.parseBoolean(answer.getText())) {
                                boolText = bundle.get("true");
                            }
                            markupText.append(boolText);
                            continue;
                        }
                        markupText.append(answer.getText());
                    }
                }
                String randomized = item.getItemMetaDataByLabel("RANDOMIZE");
                if (randomized != null && Boolean.valueOf(randomized).booleanValue()) {
                    markupText.append("\n");
                    markupText.append(bundle.get("randomize"));
                }
                if (item.getHasRationale() != null && item.getHasRationale().booleanValue()) {
                    markupText.append("\n");
                    markupText.append(bundle.get("rationale"));
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getCorrectItemFeedback())) {
                    markupText.append("\n");
                    markupText.append("#FBOK:").append(item.getCorrectItemFeedback());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getInCorrectItemFeedback())) {
                    markupText.append("\n");
                    markupText.append("#FBNOK:").append(item.getInCorrectItemFeedback());
                }
                markupText.append("\n");
                ++nQuestion;
            }
        }
        return markupText.toString();
    }

    public boolean isExportable(AssessmentFacade assessment) {
        boolean exportToMarkupText = false;
        for (Object sectionObj : assessment.getSectionArray()) {
            SectionFacade section = (SectionFacade)sectionObj;
            List items = null;
            if (section != null) {
                if (section.getSectionMetaDataByLabel("AUTHOR_TYPE") == null || StringUtils.equals((CharSequence)section.getSectionMetaDataByLabel("AUTHOR_TYPE"), (CharSequence)SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString())) {
                    items = section.getItemArray();
                } else if (StringUtils.equals((CharSequence)section.getSectionMetaDataByLabel("AUTHOR_TYPE"), (CharSequence)SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                    QuestionPoolService qpService = new QuestionPoolService();
                    try {
                        Long qpId = Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"));
                        items = qpService.getAllItems(qpId);
                    }
                    catch (NumberFormatException e) {
                        log.error("NumberFormatException converting to Long: " + section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"));
                    }
                }
            }
            if (items == null) {
                log.info("Items for assessment {} section {} is null in isExportable", (Object)assessment.getAssessmentId(), (Object)section.getSectionId());
            } else {
                for (ItemDataIfc item : items) {
                    if (!this.isQuestionTypeExportable2MarkupText(item.getTypeId())) continue;
                    exportToMarkupText = true;
                    break;
                }
            }
            if (!exportToMarkupText) continue;
            break;
        }
        return exportToMarkupText;
    }

    public boolean isQuestionTypeExportable2MarkupText(Long itemTypeId) {
        boolean exportable = false;
        exportable = exportable || TypeIfc.MULTIPLE_CHOICE.intValue() == itemTypeId.intValue();
        exportable = exportable || TypeIfc.MULTIPLE_CORRECT.intValue() == itemTypeId.intValue();
        exportable = exportable || TypeIfc.FILL_IN_BLANK.intValue() == itemTypeId.intValue();
        exportable = exportable || TypeIfc.FILL_IN_NUMERIC.intValue() == itemTypeId.intValue();
        exportable = exportable || TypeIfc.TRUE_FALSE.intValue() == itemTypeId.intValue();
        exportable = exportable || TypeIfc.ESSAY_QUESTION.intValue() == itemTypeId.intValue();
        return exportable;
    }

    public static String copyStringAttachment(String stringWithAttachment) {
        AssessmentService assessmentService = new AssessmentService();
        if (AgentFacade.getCurrentSiteId() != null) {
            return assessmentService.copyContentHostingAttachments(stringWithAttachment, AgentFacade.getCurrentSiteId());
        }
        return stringWithAttachment;
    }

    public List<AssessmentData> getDeletedAssessments(String siteId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getDeletedAssessments(siteId);
    }

    public void restoreAssessment(Long assessmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().restoreAssessment(assessmentId);
    }

    public static String renameDuplicate(String title) {
        if (title == null) {
            title = "";
        }
        Object rename = "";
        int index = title.lastIndexOf(VERSION_START);
        if (index > -1) {
            String mainPart = "";
            Object versionPart = title.substring(index);
            if (index > 0) {
                mainPart = title.substring(0, index);
            }
            int nIndex = index + VERSION_START.length();
            String version = title.substring(nIndex);
            int versionNumber = 0;
            try {
                versionNumber = Integer.parseInt(version);
                if (versionNumber < 2) {
                    versionNumber = 2;
                }
                versionPart = VERSION_START + (versionNumber + 1);
                rename = mainPart + (String)versionPart;
            }
            catch (NumberFormatException ex) {
                rename = title + "  - 2";
            }
        } else {
            rename = title + "  - 2";
        }
        return rename;
    }
}

