/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Mac;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SecureDeliveryModuleIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriUtils;

@Configuration
public class SecureDeliveryProctorio
implements SecureDeliveryModuleIfc {
    private static final Logger log = LoggerFactory.getLogger(SecureDeliveryProctorio.class);
    private static final String ENCODING = StandardCharsets.US_ASCII.toString();
    private static final String SITE_PROPERTY = "proctorio";
    private static final String SESSION_PROPERTY = "x-proctorio";
    private static final String DEFAULT_OPTIONS = "recordvideo,linksonly";
    private static final String[] VALID_OPTIONS = new String[]{"recordvideo", "recordaudio", "recordscreen", "recordwebtraffic", "recordroomstart", "verifyvideo", "verifyaudio", "verifydesktop", "verifyidauto", "verifyidlive", "verifysignature", "fullscreenlenient", "fullscreenmoderate", "fullscreensevere", "clipboard", "notabs", "linksonly", "closetabs", "onescreen", "print", "downloads", "cache", "rightclick", "noreentry", "agentreentry", "calculatorbasic", "calculatorsci", "whiteboard"};
    private static String proctorioKey;
    private static String proctorioSecret;
    private static String proctorioUrl;
    private static String proctorioEnabled;
    private UserDirectoryService userDirectoryService = (UserDirectoryService)ComponentManager.get(UserDirectoryService.class);
    private ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);
    private SiteService siteService = (SiteService)ComponentManager.get(SiteService.class);
    private SessionManager sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);

    public boolean initialize() {
        proctorioKey = this.serverConfigurationService.getString("proctorio.key", null);
        proctorioSecret = this.serverConfigurationService.getString("proctorio.secret", null);
        proctorioUrl = this.serverConfigurationService.getString("proctorio.url", null);
        proctorioEnabled = this.serverConfigurationService.getString("proctorio.enabled", "always");
        log.debug("Proctorio init: key={}", (Object)proctorioKey);
        return proctorioKey != null && proctorioSecret != null && proctorioUrl != null;
    }

    public boolean isEnabled() {
        if (!StringUtils.equals((CharSequence)proctorioEnabled, (CharSequence)"always")) {
            String siteId = AgentFacade.getCurrentSiteId();
            return this.isSiteProctorioEnabled(siteId);
        }
        return true;
    }

    public boolean isEnabled(Long assessmentId) {
        if (!StringUtils.equals((CharSequence)proctorioEnabled, (CharSequence)"always")) {
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            PublishedAssessmentFacade pub = pubService.getPublishedAssessment(assessmentId.toString());
            String siteId = pub.getOwnerSiteId();
            return this.isSiteProctorioEnabled(siteId);
        }
        return true;
    }

    private boolean isSiteProctorioEnabled(String siteId) {
        try {
            Site site = this.siteService.getSite(siteId);
            String proctorioOptions = site.getProperties().getProperty(SITE_PROPERTY);
            return StringUtils.isNotBlank((CharSequence)proctorioOptions);
        }
        catch (IdUnusedException e) {
            log.warn("Proctorio could not find siteId={}", (Object)siteId);
            return false;
        }
    }

    public String getModuleName(Locale locale) {
        return "Proctorio";
    }

    public String getTitleDecoration(Locale locale) {
        return " (Proctorio required)\t";
    }

    public SecureDeliveryServiceAPI.PhaseStatus validatePhase(SecureDeliveryServiceAPI.Phase phase, PublishedAssessmentIfc assessment, HttpServletRequest request) {
        log.debug("validatePhase: {}", (Object)phase);
        switch (phase) {
            case ASSESSMENT_START: {
                return SecureDeliveryServiceAPI.PhaseStatus.SUCCESS;
            }
        }
        return SecureDeliveryServiceAPI.PhaseStatus.SUCCESS;
    }

    public String getInitialHTMLFragment(HttpServletRequest request, Locale locale) {
        return "";
    }

    public String getHTMLFragment(PublishedAssessmentIfc assessment, HttpServletRequest request, SecureDeliveryServiceAPI.Phase phase, SecureDeliveryServiceAPI.PhaseStatus status, Locale locale) {
        switch (phase) {
            case ASSESSMENT_START: {
                String currentAgentId = this.userDirectoryService.getCurrentUser().getId();
                Optional<String> alternativeDeliveryUrl = this.getAlternativeDeliveryUrl(assessment.getPublishedAssessmentId(), currentAgentId);
                if (alternativeDeliveryUrl.isPresent()) {
                    String url = alternativeDeliveryUrl.get();
                    log.debug("Proctorio: phase={}, agentId={}, url={}", new Object[]{phase, currentAgentId, url});
                    return "<script> window.addEventListener(\"message\", function(event) {\n    if(event.origin === \"https://getproctorio.com\") {\n        // event.data.active should be true if Proctorio is running\n        console.log(\"Proctorio is running: \" + event.data.active)\n    } else {\n        fetch('/samigo-app/jsf/delivery/stopTimerProgress.faces').then(data => { window.location.href='" + url + "' }); \n    }\n}); if (window.top.location.origin != 'https://getproctorio.com') fetch('/samigo-app/jsf/delivery/stopTimerProgress.faces').then(data => {window.top.location.replace('" + url + "')}); \ntry { window.top.postMessage([10, \"proctorio_status\"], \"https://getproctorio.com\"); }  catch(e) { jQuery('#takeAssessmentForm input.active').prop('disabled', true); fetch('/samigo-app/jsf/delivery/stopTimerProgress.faces').then(data => { window.location.href='" + url + "'; }); } </script>";
                }
            }
            case ASSESSMENT_FINISH: 
            case ASSESSMENT_REVIEW: {
                return "";
            }
        }
        return "<strong>Proctorio HTML</strong>";
    }

    public boolean validateContext(Object context) {
        return true;
    }

    public String encryptPassword(String password) {
        return "";
    }

    public String decryptPassword(String password) {
        return "";
    }

    public Optional<String> getAlternativeDeliveryUrl(Long assessmentId, String uid) {
        String[] urls = this.getProctorioUrls(assessmentId, uid);
        if (urls == null) {
            return Optional.empty();
        }
        return Optional.of(urls[0]);
    }

    public Optional<String> getInstructorReviewUrl(Long assessmentId, String studentId) {
        String[] urls = this.getProctorioUrls(assessmentId, studentId);
        if (urls == null) {
            return Optional.empty();
        }
        return Optional.of(urls[1]);
    }

    private String[] getProctorioUrls(Long assessmentId, String studentUid) {
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        PublishedAssessmentFacade assessment = pubService.getPublishedAssessment(assessmentId.toString());
        User user = null;
        try {
            user = this.userDirectoryService.getUser(studentUid);
        }
        catch (UserNotDefinedException e) {
            log.warn("ProctorIO secure delivery could not find user ({})", (Object)studentUid);
            return null;
        }
        String siteId = assessment.getOwnerSiteId();
        String proctorioOptions = null;
        try {
            Site site = this.siteService.getSite(siteId);
            proctorioOptions = site.getProperties().getProperty(SITE_PROPERTY);
        }
        catch (IdUnusedException site) {
            // empty catch block
        }
        if (StringUtils.isBlank(proctorioOptions)) {
            proctorioOptions = this.serverConfigurationService.getString("proctorio.options", DEFAULT_OPTIONS);
        }
        String assessmentPath = this.serverConfigurationService.getServerUrl() + "/samigo-app/servlet/Login?id=" + assessment.getAssessmentMetaDataByLabel("ALIAS");
        try {
            String[] urls = this.buildURL(user.getId(), user.getDisplayName(), assessmentId, assessmentPath, proctorioOptions);
            if (urls != null && urls.length == 2) {
                return urls;
            }
        }
        catch (IOException e) {
            log.warn("ProctorIO could not build the URL", (Throwable)e);
        }
        return null;
    }

    private static String toNormalizedString(Map<String, String> collection, List<String> excludedNames) {
        StringBuilder normalizedString = new StringBuilder();
        for (String key : collection.keySet()) {
            if (excludedNames != null && excludedNames.contains(key)) continue;
            String value = collection.getOrDefault(key, "");
            String encodedKey = null;
            String encodedValue = null;
            String decodedKey = UriUtils.decode((String)key, (String)ENCODING);
            encodedKey = UriUtils.encode((String)decodedKey, (String)ENCODING);
            String decodedValue = UriUtils.decode((String)value, (String)ENCODING);
            encodedValue = UriUtils.encode((String)decodedValue, (String)ENCODING);
            normalizedString.append("&").append(encodedKey != null ? encodedKey : key).append("=").append(encodedValue != null ? encodedValue : value);
        }
        return normalizedString.substring(1);
    }

    private String[] buildURL(String uid, String fullname, Long assessmentId, String launchUrl, String options) throws ClientProtocolException, IOException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("launch_url", launchUrl);
        parameters.put("user_id", uid);
        parameters.put("oauth_consumer_key", proctorioKey);
        parameters.put("exam_start", "(.)*\\/samigo-app\\/servlet\\/Login.*");
        parameters.put("exam_take", "(.*)\\/samigo-app\\/jsf\\/delivery.*");
        parameters.put("exam_end", "(.*)confirmSubmit.*");
        parameters.put("exam_settings", this.validateOptions(options));
        parameters.put("fullname", fullname);
        parameters.put("exam_tag", "" + assessmentId);
        parameters.put("oauth_signature_method", "HMAC-SHA1");
        parameters.put("oauth_version", "1.0");
        parameters.put("oauth_timestamp", "" + System.currentTimeMillis() / 1000L);
        parameters.put("oauth_nonce", "" + (int)(Math.random() * 1.0E8));
        String signature_base_string = "POST&" + UriUtils.encode((String)proctorioUrl, (String)ENCODING) + "&" + UriUtils.encode((String)SecureDeliveryProctorio.toNormalizedString(parameters, null), (String)ENCODING);
        log.debug("Proctorio signature_base_string: {}", (Object)signature_base_string);
        Mac mac = HmacUtils.getHmacSha1((byte[])proctorioSecret.getBytes());
        HmacUtils.updateHmac((Mac)mac, (String)signature_base_string);
        byte[] hmac = mac.doFinal();
        String oauthSignature = Base64.getEncoder().encodeToString(hmac);
        parameters.put("oauth_signature", oauthSignature);
        StringBuilder parameterBuilder = new StringBuilder();
        for (String paramKey : parameters.keySet()) {
            String value = parameters.getOrDefault(paramKey, "");
            parameterBuilder.append("&");
            parameterBuilder.append(paramKey);
            parameterBuilder.append("=");
            parameterBuilder.append(UriUtils.encode((String)value, (String)ENCODING));
        }
        String parameterString = parameterBuilder.toString();
        parameterString = parameterString.substring(1);
        log.debug("Proctorio parameterString: {}", (Object)parameterString);
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(proctorioUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(parameterString));
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity returnEntity = response.getEntity();
        String r = EntityUtils.toString((HttpEntity)returnEntity);
        log.debug("Proctorio return status={}, text={}", (Object)statusCode, (Object)r);
        if (statusCode == 200 && r.length() > 100) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode root = mapper.readTree(r);
                if (root.isArray()) {
                    String instructorUrl;
                    String studentUrl = root.get(0).asText();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{studentUrl, instructorUrl = root.get(1).asText()})) {
                        studentUrl = UriUtils.decode((String)studentUrl, (String)ENCODING);
                        instructorUrl = UriUtils.decode((String)instructorUrl, (String)ENCODING);
                    }
                    log.debug("Proctorio studentUrl={}, instructorUrl={}", (Object)studentUrl, (Object)instructorUrl);
                    return new String[]{studentUrl, instructorUrl};
                }
                log.warn("Proctorio JSON was not an array as expected={}", (Object)r);
            }
            catch (Exception e) {
                log.warn("Proctorio error", (Throwable)e);
            }
        } else {
            log.warn("Proctorio statusCode={}, return={}", (Object)statusCode, (Object)r);
        }
        return null;
    }

    private String validateOptions(String options) {
        String[] splitOptions;
        StringBuilder sb = new StringBuilder();
        for (String splitOption : splitOptions = StringUtils.split((String)options, (String)",")) {
            if (StringUtils.isBlank((CharSequence)splitOption)) continue;
            String o = splitOption.trim().toLowerCase();
            if (!Arrays.stream(VALID_OPTIONS).anyMatch(o::equals)) continue;
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(o);
        }
        String validatedOptions = sb.toString();
        if (!validatedOptions.equals(options)) {
            log.warn("Proctorio validated options from={} to={}", (Object)options, (Object)validatedOptions);
        }
        return validatedOptions;
    }
}

