/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.questionpool;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osid.shared.SharedException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.QuestionPoolServiceException;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.shared.api.questionpool.QuestionPoolServiceAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionPoolServiceImpl
implements QuestionPoolServiceAPI {
    private static final Logger log = LoggerFactory.getLogger(QuestionPoolServiceImpl.class);

    public List getAllPools(String agentId) {
        ArrayList<QuestionPoolFacade> list = new ArrayList<QuestionPoolFacade>();
        try {
            QuestionPoolService service = new QuestionPoolService();
            QuestionPoolIteratorFacade iter = service.getAllPools(agentId);
            while (iter.hasNext()) {
                QuestionPoolFacade pool = iter.next();
                list.add(pool);
            }
            return list;
        }
        catch (SharedException ex) {
            throw new QuestionPoolServiceException(ex);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getBasicInfoOfAllPools(String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getBasicInfoOfAllPools(agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public QuestionPoolDataIfc getPool(Long poolId, String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPool(poolId, agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getPoolIdsByItem(Long itemId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPoolIdsByItem(itemId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean hasItem(Long itemId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.hasItem(itemId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getPoolIdsByAgent(String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getPoolIdsByAgent(agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getSubPools(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getSubPools(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public long getSubPoolSize(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getSubPoolSize(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean hasSubPools(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.hasSubPools(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public List getAllItems(Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getAllItems(poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void addItemToPool(Long itemId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.addItemToPool(itemId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void moveItemToPool(Long itemId, Long sourceId, Long destId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.moveItemToPool(itemId, sourceId, destId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public boolean isDescendantOf(Long poolA, Long poolB, String agentId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.isDescendantOf(poolA, poolB, agentId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void movePool(String agentId, Long sourceId, Long destId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.movePool(agentId, sourceId, destId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void deletePool(Long poolId, String agentId, Tree tree) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.deletePool(poolId, agentId, tree);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void removeQuestionFromPool(Long questionId, Long poolId) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.removeQuestionFromPool(questionId, poolId);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            service.copyPool(tree, agentId, sourceId, destId, prependString1, prependString2);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public QuestionPoolDataIfc savePool(QuestionPoolDataIfc pool) {
        try {
            QuestionPoolService service = new QuestionPoolService();
            Long poolId = pool.getQuestionPoolId();
            String agentId = null;
            try {
                agentId = pool.getOwner().getIdString();
            }
            catch (Exception ax) {
                throw new QuestionPoolServiceException(ax);
            }
            QuestionPoolFacade facade = service.getPool(poolId, agentId);
            return service.savePool(facade);
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public Map getQuestionPoolItemMap() {
        try {
            QuestionPoolService service = new QuestionPoolService();
            return service.getQuestionPoolItemMap();
        }
        catch (Exception ex) {
            throw new QuestionPoolServiceException(ex);
        }
    }

    public String getUserPoolAttachmentReport(String userId, Long poolId, String contextToReplace) {
        String parsedText = null;
        UserPoolAttachmentReport upar = new UserPoolAttachmentReport();
        boolean flagQuestionPoolUpdated = false;
        boolean flagTextUpdated = false;
        boolean flagAttachmentUpdated = false;
        boolean flagAnswerUpdated = false;
        ItemService itemService = new ItemService();
        QuestionPoolDataIfc qpf = this.getPool(poolId, userId);
        if (qpf == null) {
            upar.addToReport("POOL ID: " + poolId + " NOT FOUND IN USER " + userId + ".");
            return upar.toString();
        }
        upar.addToReport("POOL ---> " + qpf.getTitle() + " - POOL ID: " + qpf.getQuestionPoolId() + "\n\n");
        for (ItemFacade itemData : this.getAllItems(poolId)) {
            Set<ItemTextIfc> misItemText = itemData.getItemTextSet();
            HashSet<ItemText> newItemTextSet = new HashSet<ItemText>();
            HashSet<Answer> newAnswerSet = new HashSet<Answer>();
            for (ItemText itemText : misItemText) {
                upar.addToReport("Question Text ---> " + itemText.getText() + "\n");
                parsedText = upar.findAttachmentsInText(itemText.getText(), contextToReplace);
                if (!parsedText.equals(itemText.getText())) {
                    flagTextUpdated = true;
                    itemText.setText(parsedText);
                }
                Set myAnswerSet = itemText.getAnswerSet();
                for (Answer myAnswer : myAnswerSet) {
                    parsedText = upar.findAttachmentsInText(myAnswer.getText(), contextToReplace);
                    if (!parsedText.equals(myAnswer.getText())) {
                        flagTextUpdated = true;
                        flagAnswerUpdated = true;
                        myAnswer.setText(parsedText);
                    }
                    newAnswerSet.add(myAnswer);
                }
                if (flagAnswerUpdated) {
                    itemText.setAnswerSet(newAnswerSet);
                }
                flagAnswerUpdated = false;
                newItemTextSet.add(itemText);
            }
            if (flagTextUpdated) {
                itemData.setItemTextSet(newItemTextSet);
            }
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList misAttachments = (ArrayList)itemData.getItemAttachmentList();
            if (misAttachments.size() > 0) {
                upar.addToReport("\nFound " + misAttachments.size() + " uploaded attachments in the question.\n\n");
            }
            for (int i = 0; i < misAttachments.size(); ++i) {
                ItemAttachmentIfc ia = (ItemAttachmentIfc)misAttachments.get(i);
                parsedText = upar.replaceAttachment(ia.getLocation(), contextToReplace);
                if (parsedText.equals(ia.getLocation())) continue;
                flagAttachmentUpdated = true;
                ia.setLocation(parsedText);
                misAttachments.set(i, ia);
            }
            if (flagAttachmentUpdated) {
                itemData.setItemAttachmentSet(new HashSet<ItemAttachmentIfc>(misAttachments));
            }
            if (flagTextUpdated || flagAttachmentUpdated) {
                flagQuestionPoolUpdated = true;
                itemService.saveItem(itemData);
            }
            flagTextUpdated = false;
            flagAttachmentUpdated = false;
        }
        if (flagQuestionPoolUpdated) {
            this.savePool(qpf);
        }
        return upar.getReport();
    }

    final class UserPoolAttachmentReport {
        private final StringBuilder report = new StringBuilder();

        public String getReport() {
            return this.report.toString();
        }

        private void addToReport(String info) {
            this.report.append(info);
        }

        public String findAttachmentsInText(String text, String contextToReplace) {
            if (text != null) {
                String[] sources = StringUtils.splitByWholeSeparator((String)text, (String)"src=\"");
                HashSet<String> attachments = new HashSet<String>();
                for (String source : sources) {
                    String theHref = StringUtils.substringBefore((String)source, (String)"\"");
                    if (!StringUtils.contains((CharSequence)theHref, (CharSequence)"/access/content/")) continue;
                    attachments.add(theHref);
                }
                if (attachments.size() > 0) {
                    this.addToReport("\nFound " + attachments.size() + " attachments buried in question or answer text.\n\n");
                    for (String attachment : attachments) {
                        String replacedAttachment = this.replaceAttachment(attachment, contextToReplace);
                        if (replacedAttachment.equals(attachment) || contextToReplace == null) continue;
                        text = StringUtils.replace((String)text, (String)attachment, (String)replacedAttachment);
                    }
                }
            }
            return text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String replaceAttachment(String attachment, String contextToReplace) {
            block9: {
                ContentResource cr = null;
                String resourceIdOrig = "/" + StringUtils.substringAfter((String)attachment, (String)"/access/content/");
                String resourceId = URLDecoder.decode(resourceIdOrig);
                String filename = StringUtils.substringAfterLast((String)attachment, (String)"/");
                try {
                    cr = AssessmentService.getContentHostingService().getResource(resourceId);
                }
                catch (IdUnusedException e) {
                    this.addToReport("\nCould not find attachment (" + resourceId + ").\n\n");
                }
                catch (TypeException e) {
                    this.addToReport("\nTypeException for resource (" + resourceId + ") that was embedded in a question or answer.\n\n");
                }
                catch (PermissionException e) {
                    this.addToReport("\nNo permission for attachment (" + resourceId + ").\n\n");
                    if (contextToReplace == null || !StringUtils.isNotEmpty((CharSequence)filename)) break block9;
                    SecurityService.pushAdvisor((SecurityAdvisor)new SecurityAdvisor(){

                        public SecurityAdvisor.SecurityAdvice isAllowed(String arg0, String arg1, String arg2) {
                            if ("content.read".equals(arg1)) {
                                return SecurityAdvisor.SecurityAdvice.ALLOWED;
                            }
                            return SecurityAdvisor.SecurityAdvice.PASS;
                        }
                    });
                    try {
                        cr = AssessmentService.getContentHostingService().getResource(resourceId);
                        ContentResource crCopy = new AssessmentService().createCopyOfContentResource(cr.getId(), filename, contextToReplace);
                        attachment = StringUtils.replace((String)attachment, (String)resourceIdOrig, (String)StringUtils.substringAfter((String)crCopy.getUrl(), (String)"/content"));
                        this.addToReport("\nCopied unusable attachment to new context resources folder: " + attachment + " .\n\n");
                    }
                    catch (Exception e2) {
                        this.addToReport("\nCould NOT copy old attachment " + attachment + " to new attachment in site " + contextToReplace + " .\n\n");
                        log.error(e2.getMessage(), (Throwable)e2);
                    }
                    finally {
                        SecurityService.popAdvisor();
                    }
                }
            }
            return attachment;
        }
    }
}

