/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.assessment.data.dao.assessment.ExtendedTime;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ExtendedTimeFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;

public class ExtendedTimeDeliveryService {
    private static final int MINS_IN_HOUR = 60;
    private static final int SECONDS_IN_MIN = 60;
    private String siteId;
    private AuthzGroupService authzGroupService;
    private boolean hasExtendedTime;
    private Integer timeLimit;
    private Date startDate;
    private Date dueDate;
    private Date retractDate;
    private Long publishedAssessmentId;
    private String agentId;

    public ExtendedTimeDeliveryService(PublishedAssessmentFacade publishedAssessment) {
        this(publishedAssessment, AgentFacade.getAgentString());
    }

    public ExtendedTimeDeliveryService(PublishedAssessmentFacade publishedAssessment, String agentId) {
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        if (!this.assessmentInitialized(publishedAssessment)) {
            publishedAssessment = publishedAssessmentService.getPublishedAssessmentQuick(publishedAssessment.getPublishedAssessmentId().toString());
        }
        this.authzGroupService = (AuthzGroupService)ComponentManager.get(AuthzGroupService.class);
        this.publishedAssessmentId = publishedAssessment.getPublishedAssessmentId();
        String pubId = this.publishedAssessmentId.toString();
        this.siteId = publishedAssessmentService.getPublishedAssessmentSiteId(pubId);
        PublishedAssessmentData pubData = publishedAssessmentService.getBasicInfoOfPublishedAssessment(pubId);
        this.agentId = agentId;
        ExtendedTimeFacade extendedTimeFacade = PersistenceService.getInstance().getExtendedTimeFacade();
        List<ExtendedTime> extendedTimes = extendedTimeFacade.getEntriesForPub((PublishedAssessmentIfc)pubData);
        List<String> groups = this.getGroups(extendedTimes);
        String group = this.isUserInGroups(groups, agentId);
        ExtendedTime extendedTime = extendedTimeFacade.getEntryForPubAndUser((PublishedAssessmentIfc)pubData, agentId);
        ExtendedTime groupExtendedTime = null;
        if (!group.isEmpty()) {
            groupExtendedTime = extendedTimeFacade.getEntryForPubAndGroup((PublishedAssessmentIfc)pubData, group);
        }
        boolean bl = this.hasExtendedTime = extendedTime != null || groupExtendedTime != null;
        if (this.hasExtendedTime) {
            ExtendedTime useMe = extendedTime != null ? extendedTime : groupExtendedTime;
            this.timeLimit = useMe.getTimeHours() * 60 * 60 + useMe.getTimeMinutes() * 60;
            this.startDate = useMe.getStartDate();
            this.dueDate = useMe.getDueDate();
            this.retractDate = useMe.getRetractDate();
        } else {
            this.timeLimit = 0;
            this.startDate = publishedAssessment.getStartDate();
            this.dueDate = publishedAssessment.getDueDate();
            this.retractDate = publishedAssessment.getRetractDate();
        }
    }

    private List<String> getGroups(List<ExtendedTime> extendedTimeList) {
        ArrayList<String> list = new ArrayList<String>();
        extendedTimeList.forEach(extendedTime -> {
            if (!"".equals(extendedTime.getGroup())) {
                list.add(extendedTime.getGroup());
            }
        });
        return list;
    }

    private boolean assessmentInitialized(PublishedAssessmentFacade publishedAssessment) {
        if (publishedAssessment == null) {
            return false;
        }
        if (publishedAssessment.getStartDate() != null) {
            return true;
        }
        if (publishedAssessment.getDueDate() != null) {
            return true;
        }
        if (publishedAssessment.getRetractDate() != null) {
            return true;
        }
        return publishedAssessment.getTimeLimit() != null;
    }

    private String isUserInGroups(List<String> groups, String agentId) {
        String returnString = "";
        if (groups != null && !groups.isEmpty()) {
            for (String group : groups) {
                if (!this.isUserInGroup(group, agentId)) continue;
                returnString = group;
            }
        }
        return returnString;
    }

    private boolean isUserInGroup(String groupId, String agentId) {
        String realmId = "/site/" + this.siteId + "/group/" + groupId;
        boolean isMember = false;
        try {
            AuthzGroup group = this.authzGroupService.getAuthzGroup(realmId);
            if (group.getUserRole(agentId) != null) {
                isMember = true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return isMember;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getRetractDate() {
        return this.retractDate;
    }

    public void setRetractDate(Date retractDate) {
        this.retractDate = retractDate;
    }

    public boolean hasExtendedTime() {
        return this.hasExtendedTime;
    }

    public void setHasExtendedTime(boolean hasExtendedTime) {
        this.hasExtendedTime = hasExtendedTime;
    }

    public Long getPublishedAssessmentId() {
        return this.publishedAssessmentId;
    }

    public String getAgentId() {
        return this.agentId;
    }
}

