/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.util.SamigoExpressionError;

public class SamigoExpressionParser {
    public static final String INFINITY = "Infinity";
    public static final String NaN = "NaN";
    public static final String[] oldSamigoParserVars = new String[]{"SIN", "COS", "TAN", "ASIN", "ACOS", "ATAN", "ABS", "EXP", "SGN", "SQRT", "LOG10", "LN", "PI", "E", "SIGN", "LOG", "log"};
    public static final String[] newSamigoParserVars = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "abs", "exp", "sgn", "sqrt", "log10", "ln", "pi", "e", "sgn", "ln", "ln"};
    public static final String OLD_FACTORIAL_PATTERN = "(?i)factorial\\((\\d+)\\)";
    public static final String NEW_FACTORIAL_PATTERN = "($1!)";
    private String expr = "";
    private BigDecimal ans;
    private String ans_str;
    private Map<String, BigDecimal> user_var = new HashMap<String, BigDecimal>();

    public SamigoExpressionParser() {
        mXparser.setEpsilon((double)1.0E-99);
    }

    public String parse(String new_expr) throws SamigoExpressionError {
        return this.parse(new_expr, 5);
    }

    public String parse(String new_expr, int decimals) throws SamigoExpressionError {
        try {
            this.expr = new_expr.trim();
            int cnt = oldSamigoParserVars.length;
            for (int i = 0; i < cnt; ++i) {
                this.expr = this.expr.replaceAll("\\b" + oldSamigoParserVars[i] + "\\b", newSamigoParserVars[i]);
            }
            this.expr = this.expr.replaceAll(OLD_FACTORIAL_PATTERN, NEW_FACTORIAL_PATTERN);
            this.ans = BigDecimal.valueOf(0.0);
            Expression e = null;
            try {
                e = new Expression(this.expr, new PrimitiveElement[0]);
                if (this.expr.contains("E")) {
                    mXparser.disableCanonicalRounding();
                    mXparser.disableUlpRounding();
                    mXparser.disableAlmostIntRounding();
                }
                double d = e.calculate();
                this.ans = new BigDecimal(d, MathContext.DECIMAL64);
            }
            catch (NumberFormatException nfe) {
                String errorMessage = e != null ? e.getErrorMessage() : this.expr;
                throw new SamigoExpressionError(401, errorMessage);
            }
            finally {
                mXparser.enableCanonicalRounding();
                mXparser.enableUlpRounding();
                mXparser.enableAlmostIntRounding();
            }
            GradingService service = new GradingService();
            this.ans_str = service.toScientificNotation(this.ans.toPlainString(), decimals);
            this.user_var.put("ANS", new BigDecimal(this.ans_str));
        }
        catch (SamigoExpressionError err) {
            this.ans_str = err.get();
            throw err;
        }
        return this.ans_str;
    }
}

