/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.event.api.LearningResourceStoreService;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class SamigoLRSStatements {
    private static final ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);
    private static final UserDirectoryService userDirectoryService = (UserDirectoryService)ComponentManager.get(UserDirectoryService.class);

    public static LearningResourceStoreService.LRS_Statement getStatementForTakeAssessment(String assessmentTitle, boolean pastDue, String releaseTo, boolean isViaURL) {
        StringBuffer lrssMetaInfo = new StringBuffer("Assesment: " + assessmentTitle);
        lrssMetaInfo.append(", Past Due?: " + pastDue);
        if (isViaURL) {
            lrssMetaInfo.append(", Assesment taken via URL.");
        }
        lrssMetaInfo.append(", Release to:" + AgentFacade.getCurrentSiteId());
        String url = serverConfigurationService.getPortalUrl();
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.attempted);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(url + "/assessment", "attempted-assessment");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "User attempted assessment");
        lrsObject.setActivityName(nameMap);
        HashMap<String, CallSite> descMap = new HashMap<String, CallSite>();
        descMap.put("en-US", (CallSite)((Object)("User attempted assessment: " + lrssMetaInfo)));
        lrsObject.setDescription(descMap);
        return new LearningResourceStoreService.LRS_Statement(null, verb, lrsObject);
    }

    public static LearningResourceStoreService.LRS_Statement getStatementForGradedAssessment(AssessmentGradingData gradingData, PublishedAssessmentFacade publishedAssessment) {
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.scored);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(serverConfigurationService.getPortalUrl() + "/assessment", "received-grade-assessment");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "User received a grade");
        lrsObject.setActivityName(nameMap);
        HashMap<String, CallSite> descMap = new HashMap<String, CallSite>();
        String userId = gradingData.getAgentId();
        String userIdLabel = "User Id";
        try {
            userId = userDirectoryService.getUserEid(gradingData.getAgentId());
            userIdLabel = "User Eid";
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        descMap.put("en-US", (CallSite)((Object)("User received a grade for their assessment: " + publishedAssessment.getTitle() + "; " + userIdLabel + ": " + userId + "; Release To: " + AgentFacade.getCurrentSiteId() + "; Submitted: " + (gradingData.getIsLate() != false ? "late" : "on time"))));
        lrsObject.setDescription(descMap);
        LearningResourceStoreService.LRS_Statement statement = new LearningResourceStoreService.LRS_Statement(null, verb, lrsObject, SamigoLRSStatements.getLRS_Result(gradingData, publishedAssessment), null);
        return statement;
    }

    public static LearningResourceStoreService.LRS_Statement getStatementForTotalScoreUpdate(AssessmentGradingData gradingData, PublishedAssessmentData publishedAssessment) {
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.scored);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(serverConfigurationService.getPortalUrl() + "/assessment", "total-score-update");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "Total score updated");
        lrsObject.setActivityName(nameMap);
        HashMap<String, CallSite> descMap = new HashMap<String, CallSite>();
        String userId = gradingData.getAgentId();
        String userIdLabel = "User Id";
        try {
            userId = userDirectoryService.getUserEid(gradingData.getAgentId());
            userIdLabel = "User Eid";
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        descMap.put("en-US", (CallSite)((Object)("Total score updated for Assessment Title: " + publishedAssessment.getTitle() + "; " + userIdLabel + ": " + userId + "; Release To: " + AgentFacade.getCurrentSiteId() + "; Submitted: " + (gradingData.getIsLate() != false ? "late" : "on time"))));
        lrsObject.setDescription(descMap);
        LearningResourceStoreService.LRS_Statement statement = new LearningResourceStoreService.LRS_Statement(null, verb, lrsObject, SamigoLRSStatements.getLRS_Result(gradingData, (PublishedAssessmentIfc)publishedAssessment), null);
        return statement;
    }

    public static LearningResourceStoreService.LRS_Statement getStatementForStudentScoreUpdate(AssessmentGradingData gradingData, PublishedAssessmentData publishedAssessment) {
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.scored);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(serverConfigurationService.getPortalUrl() + "/assessment", "student-score-update");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "Student score updated");
        lrsObject.setActivityName(nameMap);
        HashMap<String, CallSite> descMap = new HashMap<String, CallSite>();
        String userId = gradingData.getAgentId();
        String userIdLabel = "User Id";
        try {
            userId = userDirectoryService.getUserEid(gradingData.getAgentId());
            userIdLabel = "User Eid";
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        descMap.put("en-US", (CallSite)((Object)("Student score updated for: " + publishedAssessment.getTitle() + "; " + userIdLabel + ": " + userId + "; Release To: " + AgentFacade.getCurrentSiteId() + "; Submitted: " + (gradingData.getIsLate() != false ? "late" : "on time"))));
        lrsObject.setDescription(descMap);
        LearningResourceStoreService.LRS_Statement statement = new LearningResourceStoreService.LRS_Statement(null, verb, lrsObject, SamigoLRSStatements.getLRS_Result(gradingData, (PublishedAssessmentIfc)publishedAssessment), null);
        return statement;
    }

    public static LearningResourceStoreService.LRS_Statement getStatementForQuestionScoreUpdate(AssessmentGradingData gradingData, PublishedAssessmentData publishedAssessment, double newAutoScore, double oldAutoScore) {
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.scored);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(serverConfigurationService.getPortalUrl() + "/assessment", "question-score-update");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "Question score updated");
        lrsObject.setActivityName(nameMap);
        HashMap<String, CallSite> descMap = new HashMap<String, CallSite>();
        String userId = gradingData.getAgentId();
        String userIdLabel = "User Id";
        try {
            userId = userDirectoryService.getUserEid(gradingData.getAgentId());
            userIdLabel = "User Eid";
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        descMap.put("en-US", (CallSite)((Object)("Student score updated for: " + publishedAssessment.getTitle() + "; " + userIdLabel + ": " + userId + "; Release To: " + AgentFacade.getCurrentSiteId() + "; Submitted: " + (gradingData.getIsLate() != false ? "late" : "on time") + "; Old Auto Score: " + oldAutoScore + "; New Auto Score: " + newAutoScore)));
        lrsObject.setDescription(descMap);
        LearningResourceStoreService.LRS_Statement statement = new LearningResourceStoreService.LRS_Statement(null, verb, lrsObject, SamigoLRSStatements.getLRS_Result(gradingData, (PublishedAssessmentIfc)publishedAssessment), null);
        return statement;
    }

    private static LearningResourceStoreService.LRS_Result getLRS_Result(AssessmentGradingData gradingData, PublishedAssessmentIfc publishedAssessment) {
        double score = gradingData.getFinalScore();
        LearningResourceStoreService.LRS_Result result = new LearningResourceStoreService.LRS_Result((Number)score, null, (Number)publishedAssessment.getTotalScore(), null);
        result.setCompletion(Boolean.valueOf(true));
        return result;
    }
}

