/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;

public class PDFContentDigester
extends BaseContentDigester {
    private static Log log = LogFactory.getLog(PDFContentDigester.class);

    /*
     * Loose catch block
     */
    public String getContent(ContentResource contentResource) {
        block24: {
            IOException e222;
            InputStream contentStream;
            block23: {
                PDDocument pddoc;
                block20: {
                    IOException e222;
                    String string;
                    block21: {
                        if (contentResource == null) {
                            throw new RuntimeException("Null contentResource passed to getContent");
                        }
                        contentStream = null;
                        PDFParser parser = null;
                        pddoc = null;
                        contentStream = contentResource.streamContent();
                        parser = new PDFParser((InputStream)new BufferedInputStream(contentStream));
                        parser.parse();
                        pddoc = parser.getPDDocument();
                        if (pddoc == null) break block20;
                        PDFTextStripper stripper = new PDFTextStripper();
                        stripper.setLineSeparator("\n");
                        CharArrayWriter cw = new CharArrayWriter();
                        stripper.writeText(pddoc, (Writer)cw);
                        string = SearchUtils.appendCleanString((char[])cw.toCharArray(), null).toString();
                        Object var9_12 = null;
                        if (pddoc == null) break block21;
                        try {
                            pddoc.close();
                        }
                        catch (IOException e222) {
                            log.debug((Object)e222);
                        }
                    }
                    if (contentStream != null) {
                        try {
                            contentStream.close();
                        }
                        catch (IOException e222) {
                            log.debug((Object)e222);
                        }
                    }
                    return string;
                }
                try {
                    Object var9_13 = null;
                    if (pddoc == null) break block23;
                }
                catch (Throwable throwable) {
                    IOException e222;
                    Object var9_14 = null;
                    if (pddoc != null) {
                        try {
                            pddoc.close();
                        }
                        catch (IOException e222) {
                            log.debug((Object)e222);
                        }
                    }
                    if (contentStream != null) {
                        try {
                            contentStream.close();
                        }
                        catch (IOException e222) {
                            log.debug((Object)e222);
                        }
                    }
                    throw throwable;
                }
                try {
                    pddoc.close();
                }
                catch (IOException e222) {
                    log.debug((Object)e222);
                }
            }
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e222) {
                    log.debug((Object)e222);
                }
            }
            break block24;
            {
                catch (ServerOverloadException e3) {
                    String eMessage = e3.getMessage();
                    if (eMessage == null) {
                        eMessage = e3.toString();
                    }
                    throw new RuntimeException("Failed to get content for indexing: cause: ServerOverloadException: " + eMessage, e3);
                }
                catch (IOException e4) {
                    String eMessage = e4.getMessage();
                    if (eMessage == null) {
                        eMessage = e4.toString();
                    }
                    throw new RuntimeException("Failed to get content for indexing: cause: IOException:  " + eMessage, e4);
                }
            }
        }
        return null;
    }

    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }
}

