/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;

public class PoiContentDigester
extends BaseContentDigester {
    private static Log log = LogFactory.getLog(PoiContentDigester.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContent(ContentResource contentResource) {
        String string;
        log.debug((Object)"Digesting with PoiContentDigester");
        if (contentResource == null) {
            throw new RuntimeException("Attempt to digest null document!");
        }
        if (contentResource != null && contentResource.getContentLength() > (long)this.maxDigestSize) {
            throw new RuntimeException("Attempt to get too much content as a string on " + contentResource.getReference());
        }
        InputStream contentStream = null;
        try {
            try {
                contentStream = contentResource.streamContent();
                POITextExtractor DocExt = ExtractorFactory.createExtractor((InputStream)contentStream);
                string = DocExt.getText();
                Object var6_6 = null;
                if (contentStream == null) return string;
            }
            catch (Exception e) {
                log.warn((Object)("Poi can't digest: " + contentResource.getId() + " POI returned: " + e));
                throw new RuntimeException("Failed to read content for indexing ", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (contentStream == null) throw throwable;
            try {
                contentStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.debug((Object)e2);
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            log.debug((Object)e2);
            return string;
        }
        contentStream.close();
        return string;
    }

    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }

    static {
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.NullLogger");
    }
}

