/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;

public class XLContentDigester
extends BaseContentDigester {
    private static Log log = LogFactory.getLog(XLContentDigester.class);

    public void loadContent(Writer writer, ContentResource contentResource) {
        if (contentResource != null && contentResource.getContentLength() > (long)this.maxDigestSize) {
            throw new RuntimeException("Attempt to get too much content as a string on " + contentResource.getReference());
        }
        if (contentResource == null) {
            throw new RuntimeException("Null contentResource passed the loadContent");
        }
        InputStream contentStream = null;
        try {
            contentStream = contentResource.streamContent();
            POIFSFileSystem fs = new POIFSFileSystem(contentStream);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    Iterator cells = row.cellIterator();
                    while (cells.hasNext()) {
                        HSSFCell cell = (HSSFCell)cells.next();
                        switch (cell.getCellType()) {
                            case 0: {
                                String num = Double.toString(cell.getNumericCellValue()).trim();
                                if (num.length() <= 0) break;
                                writer.write(num + " ");
                                break;
                            }
                            case 1: {
                                String text = cell.getStringCellValue().trim();
                                if (text.length() <= 0) break;
                                writer.write(text + " ");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read content for indexing ", e);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            }
        }
    }

    public Reader getContentReader(ContentResource contentResource) {
        CharArrayWriter writer = new CharArrayWriter();
        this.loadContent(writer, contentResource);
        return new CharArrayReader(writer.toCharArray());
    }

    public String getContent(ContentResource contentResource) {
        CharArrayWriter writer = new CharArrayWriter();
        this.loadContent(writer, contentResource);
        return new String(writer.toCharArray());
    }

    static {
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.NullLogger");
    }
}

