/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.site;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.util.HTMLParser;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;

public class SiteContentProducer
implements EntityContentProducer {
    private static final Log log = LogFactory.getLog(SiteContentProducer.class);
    private EntityManager entityManager;
    private List<String> addEvents;
    private List<String> removeEvents;
    private SiteService siteService;
    private ServerConfigurationService serverConfigurationService;
    private SearchService searchService;
    private SearchIndexBuilder searchIndexBuilder;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void init() {
        this.addEvents = new ArrayList<String>();
        this.removeEvents = new ArrayList<String>();
        this.addEvents.add("site.add.course");
        this.addEvents.add("site.add");
        this.addEvents.add("site.add.usersite");
        this.addEvents.add("site.upd.grp.mbrshp");
        this.addEvents.add("site.upd");
        this.addEvents.add("site.upd.site.mbrshp");
        this.removeEvents.add("site.del");
        if ("true".equals(this.serverConfigurationService.getString("search.enable", "false"))) {
            Iterator<String> i = this.addEvents.iterator();
            while (i.hasNext()) {
                this.searchService.registerFunction(i.next());
            }
            i = this.removeEvents.iterator();
            while (i.hasNext()) {
                this.searchService.registerFunction(i.next());
            }
            this.searchIndexBuilder.registerEntityContentProducer((EntityContentProducer)this);
        }
    }

    public boolean canRead(String reference) {
        Reference ref = this.getReference(reference);
        EntityProducer ep = this.getProducer(ref);
        if (ep instanceof SiteService) {
            try {
                SiteService ss = (SiteService)ep;
                ss.getSite(ref.getId());
                return true;
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        return false;
    }

    private Reference getReference(String reference) {
        try {
            Reference r = this.entityManager.newReference(reference);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Site.getReference" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            log.debug((Object)ex);
            return null;
        }
    }

    private EntityProducer getProducer(Reference ref) {
        try {
            return ref.getEntityProducer();
        }
        catch (Exception ex) {
            log.debug((Object)ex);
            return null;
        }
    }

    public Integer getAction(Event event) {
        String evt = event.getEvent();
        if (evt == null) {
            return SearchBuilderItem.ACTION_UNKNOWN;
        }
        for (String match : this.addEvents) {
            if (!evt.equals(match)) continue;
            return SearchBuilderItem.ACTION_ADD;
        }
        for (String match : this.removeEvents) {
            if (!evt.equals(match)) continue;
            return SearchBuilderItem.ACTION_DELETE;
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public String getContainer(String ref) {
        Reference reference = this.getReference(ref);
        return reference.getId();
    }

    public String getContent(String reference) {
        Reference ref = this.getReference(reference);
        EntityProducer ep = this.getProducer(ref);
        if (ep instanceof SiteService) {
            try {
                SiteService ss = (SiteService)ep;
                Site s = ss.getSite(ref.getId());
                StringBuilder sb = new StringBuilder();
                SearchUtils.appendCleanString((String)s.getTitle(), (StringBuilder)sb);
                sb.append(" ");
                HTMLParser hp = new HTMLParser(s.getShortDescription());
                while (hp.hasNext()) {
                    SearchUtils.appendCleanString((String)hp.next(), (StringBuilder)sb);
                    sb.append(" ");
                }
                hp = new HTMLParser(s.getDescription());
                while (hp.hasNext()) {
                    SearchUtils.appendCleanString((String)hp.next(), (StringBuilder)sb);
                    sb.append(" ");
                }
                return sb.toString();
            }
            catch (IdUnusedException e) {
                throw new RuntimeException(" Failed to get message content ", e);
            }
        }
        throw new RuntimeException(" Not a Message Entity " + reference);
    }

    public Reader getContentReader(String reference) {
        return new StringReader(this.getContent(reference));
    }

    public Map getCustomProperties(String ref) {
        Reference reference = this.getReference(ref);
        Entity e = reference.getEntity();
        ResourceProperties rp = e.getProperties();
        HashMap<String, String> props = new HashMap<String, String>();
        Iterator i = rp.getPropertyNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            List l = rp.getPropertyList(key);
            StringBuilder sb = new StringBuilder();
            Iterator is = l.iterator();
            while (is.hasNext()) {
                sb.append(is.next()).append(" ");
            }
            props.put(key, sb.toString());
        }
        return props;
    }

    public String getCustomRDF(String ref) {
        return null;
    }

    public String getId(String ref) {
        Reference reference = this.getReference(ref);
        return reference.getId();
    }

    public List getSiteContent(String context) {
        ArrayList<String> all = new ArrayList<String>();
        try {
            Site s = this.siteService.getSite(context);
            all.add(s.getReference());
            return all;
        }
        catch (IdUnusedException idu) {
            log.debug((Object)("Site Not Found for context " + context), (Throwable)idu);
            return all;
        }
    }

    public Iterator getSiteContentIterator(String context) {
        List l = this.getSiteContent(context);
        return l.iterator();
    }

    public String getSiteId(String ref) {
        Reference reference = this.getReference(ref);
        Entity entity = reference.getEntity();
        if (entity instanceof Site) {
            Site s = (Site)entity;
            if (s.isPublished() && s.isPubView()) {
                return ".auth";
            }
            if (s.isPublished() && s.isJoinable()) {
                return ".anon";
            }
            return ".private";
        }
        return null;
    }

    public String getSubType(String ref) {
        return "";
    }

    public String getTitle(String ref) {
        Reference reference = this.getReference(ref);
        Site s = (Site)reference.getEntity();
        return SearchUtils.appendCleanString((String)s.getTitle(), null).toString();
    }

    public String getTool() {
        return "site";
    }

    public String getType(String ref) {
        Reference reference = this.getReference(ref);
        return reference.getType();
    }

    public String getUrl(String ref) {
        Reference reference = this.getReference(ref);
        return reference.getUrl();
    }

    public boolean isContentFromReader(String reference) {
        return false;
    }

    public boolean isForIndex(String ref) {
        Reference reference = this.getReference(ref);
        Site s = (Site)reference.getEntity();
        if (s != null) {
            return s.isPublished();
        }
        return false;
    }

    public boolean matches(String ref) {
        EntityProducer ecp;
        Reference reference = this.getReference(ref);
        return reference != null && (ecp = reference.getEntityProducer()) instanceof SiteService;
    }

    public boolean matches(Event event) {
        return this.addEvents.contains(event.getEvent()) || this.removeEvents.contains(event.getEvent());
    }
}

