/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.sakaiproject.search.dao.SearchBuilderItemDao;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.impl.SearchBuilderItemImpl;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchBuilderItemDaoImpl
extends HibernateDaoSupport
implements SearchBuilderItemDao {
    private static Log dlog = LogFactory.getLog(SearchBuilderItemDaoImpl.class);

    public SearchBuilderItem create() {
        return new SearchBuilderItemImpl();
    }

    public void update(SearchBuilderItem sb) {
        HibernateTemplate ht = this.getHibernateTemplate();
        ht.saveOrUpdate((Object)sb);
        ht.flush();
    }

    public List<SearchBuilderItem> getAll() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(SearchBuilderItemImpl.class).list();
            }
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }

    public SearchBuilderItem findByName(final String resourceName) {
        if (resourceName != null && resourceName.length() > 255) {
            dlog.warn((Object)("Entity Reference longer than 255 characters :" + resourceName));
            return null;
        }
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(SearchBuilderItemImpl.class).add((Criterion)Expression.eq((String)"name", (Object)resourceName)).list();
            }
        };
        List l = (List)this.getHibernateTemplate().execute(callback);
        if (l.size() == 0) {
            return null;
        }
        return (SearchBuilderItem)l.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int countPending(Connection connection) {
        ResultSet rst;
        PreparedStatement pst;
        block15: {
            pst = null;
            rst = null;
            pst = connection.prepareStatement("select count(*) from searchbuilderitem where searchstate = ? ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.STATE_PENDING);
            rst = pst.executeQuery();
            if (!rst.next()) break block15;
            int n = rst.getInt(1);
            Object var7_7 = null;
            try {
                rst.close();
            }
            catch (Exception ex) {
                dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
            }
            return n;
        }
        int n = 0;
        Object var7_8 = null;
        try {
            rst.close();
        }
        catch (Exception ex) {
            dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
        }
        try {
            pst.close();
        }
        catch (Exception ex) {
            dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
        }
        return n;
        catch (SQLException sqlex) {
            int n2;
            try {
                n2 = 0;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    rst.close();
                }
                catch (Exception ex) {
                    dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
                }
                try {
                    pst.close();
                }
                catch (Exception ex) {
                    dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
                }
                throw throwable;
            }
            try {
                rst.close();
            }
            catch (Exception ex) {
                dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                dlog.warn((Object)"Exception counting pending items", (Throwable)ex);
            }
            return n2;
        }
    }

    public int countPending() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return SearchBuilderItemDaoImpl.this.countPending(session.connection());
            }
        };
        return (Integer)this.getHibernateTemplate().execute(callback);
    }

    public List<SearchBuilderItem> getGlobalMasters() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(SearchBuilderItemImpl.class).add((Criterion)Expression.eq((String)"itemscope", (Object)SearchBuilderItem.ITEM_GLOBAL_MASTER)).list();
            }
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }

    public List<SearchBuilderItem> getSiteMasters() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(SearchBuilderItemImpl.class).add((Criterion)Expression.eq((String)"itemscope", (Object)SearchBuilderItem.ITEM_SITE_MASTER)).list();
            }
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }
}

