/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.search.api.SearchIndexBuilderWorker;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.component.service.impl.SearchIndexBuilderImpl;
import org.sakaiproject.search.dao.SearchIndexBuilderWorkerDao;
import org.sakaiproject.search.indexer.api.IndexQueueListener;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.SearchWriterLock;
import org.sakaiproject.search.model.impl.SearchWriterLockImpl;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndexBuilderWorkerImpl
implements Runnable,
SearchIndexBuilderWorker {
    private static Log log = LogFactory.getLog(SearchIndexBuilderWorkerImpl.class);
    public static final String LOCKKEY = "searchlockkey";
    protected static final Object GLOBAL_CONTEXT = null;
    private static final String NO_NODE = "none";
    private static final String NODE_LOCK = "nodelockkey";
    private final int numThreads = 2;
    public long sleepTime = 300000L;
    private long loadFactor = 1000L;
    private Thread[] indexBuilderThread = new Thread[2];
    private Object threadStartLock = new Object();
    private SearchIndexBuilderImpl searchIndexBuilder = null;
    private SearchService searchService = null;
    private ServerConfigurationService serverConfigurationService;
    private DataSource dataSource = null;
    private Object sem = new Object();
    private boolean enabled = false;
    private SessionManager sessionManager;
    private UserDirectoryService userDirectoryService;
    private EntityManager entityManager;
    private EventTrackingService eventTrackingService;
    private boolean runThreads = false;
    private ThreadLocal<String> nodeIDHolder = new ThreadLocal();
    private SearchIndexBuilderWorkerDao searchIndexBuilderWorkerDao = null;
    private long lastLock = System.currentTimeMillis();
    private long lastEvent = System.currentTimeMillis();
    private long lastIndex;
    private long startDocIndex;
    private String nowIndexing;
    private String lastIndexing;
    private boolean soakTest = false;
    private boolean started = false;
    private boolean indexExists = false;
    private static HashMap<String, String> nodeIDList = new HashMap();
    private static String lockedTo = null;
    private static String SELECT_LOCK_SQL = "select id, nodename, lockkey, expires from searchwriterlock where lockkey = ?";
    private static String UPDATE_LOCK_SQL = "update searchwriterlock set nodename = ?, expires = ? where id = ? and nodename = ? and lockkey = ? ";
    private static String INSERT_LOCK_SQL = "insert into searchwriterlock ( id,nodename,lockkey, expires ) values ( ?, ?, ?, ? )";
    private static String COUNT_WORK_SQL = " select count(*) from searchbuilderitem where searchstate = ? ";
    private static String CLEAR_LOCK_SQL = "update searchwriterlock set nodename = ?, expires = ? where nodename = ? and lockkey = ? ";
    private static String SELECT_NODE_LOCK_SQL = "select id, nodename, lockkey, expires from searchwriterlock where lockkey like 'nodelockkey%'";
    private static String UPDATE_NODE_LOCK_SQL = "update searchwriterlock set expires = ? where nodename = ? and lockkey = ? ";
    private static final String SELECT_EXPIRED_NODES_SQL = "select id from searchwriterlock where lockkey like 'nodelockkey%' and expires < ? ";
    private static final String DELETE_LOCKNODE_SQL = "delete from searchwriterlock where id = ? ";

    public void init() {
        if (this.started && !this.runThreads) {
            log.warn((Object)"JVM Shutdown in progress, will not startup");
            return;
        }
        if (ComponentManager.hasBeenClosed()) {
            log.warn((Object)"Component manager Shutdown in progress, will not startup");
            return;
        }
        this.started = true;
        this.runThreads = true;
        this.enabled = "true".equals(this.serverConfigurationService.getString("search.enable", "false"));
        this.enabled = this.enabled && this.serverConfigurationService.getBoolean("search.indexbuild", true);
        try {
            if (this.searchIndexBuilder == null) {
                log.error((Object)"Search Index Worker needs SearchIndexBuilder ");
            }
            if (this.searchService == null) {
                log.error((Object)"Search Index Worker needs SearchService ");
            }
            if (this.searchIndexBuilderWorkerDao == null) {
                log.error((Object)"Search Index Worker needs SearchIndexBuilderWorkerDao ");
            }
            if (this.eventTrackingService == null) {
                log.error((Object)"Search Index Worker needs EventTrackingService ");
            }
            if (this.entityManager == null) {
                log.error((Object)"Search Index Worker needs EntityManager ");
            }
            if (this.userDirectoryService == null) {
                log.error((Object)"Search Index Worker needs UserDirectortyService ");
            }
            if (this.sessionManager == null) {
                log.error((Object)"Search Index Worker needs SessionManager ");
            }
            log.debug((Object)"init start");
            for (int i = 0; i < this.indexBuilderThread.length; ++i) {
                this.indexBuilderThread[i] = new Thread(this);
                this.indexBuilderThread[i].setName("SearchBuilder_" + String.valueOf(i));
                this.indexBuilderThread[i].start();
            }
            this.eventTrackingService.addLocalObserver(new Observer(){

                public void update(Observable arg0, Object arg1) {
                    SearchIndexBuilderWorkerImpl.this.lastEvent = System.currentTimeMillis();
                }
            });
            this.searchIndexBuilder.addIndexQueueListener(new IndexQueueListener(){

                public void added(String name) {
                    SearchIndexBuilderWorkerImpl.this.checkRunning();
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    SearchIndexBuilderWorkerImpl.this.runThreads = false;
                }
            });
        }
        catch (Throwable t) {
            log.error((Object)"Failed to init ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.enabled) {
            return;
        }
        int threadno = -1;
        Thread tt = Thread.currentThread();
        for (int i = 0; i < this.indexBuilderThread.length; ++i) {
            if (this.indexBuilderThread[i] != tt) continue;
            threadno = i;
        }
        String nodeID = this.getNodeID();
        ComponentManager.waitTillConfigured();
        try {
            try {
                while (this.runThreads) {
                    log.debug((Object)"Run Processing Thread");
                    Session s = null;
                    if (s == null) {
                        s = this.sessionManager.startSession();
                        User u = this.userDirectoryService.getUser("admin");
                        s.setUserId(u.getId());
                    }
                    while (this.runThreads) {
                        Object var20_19;
                        block46: {
                            this.sessionManager.setCurrentSession(s);
                            try {
                                int totalDocs = this.searchIndexBuilder.getPendingDocuments();
                                long lastEvent = this.getLastEventTime();
                                long now = System.currentTimeMillis();
                                long interval = now - lastEvent;
                                boolean process = false;
                                boolean createIndex = false;
                                if (!this.indexExists) {
                                    if (!this.searchIndexBuilderWorkerDao.indexExists()) {
                                        process = true;
                                        createIndex = true;
                                        log.debug((Object)"No cluster Index exists, creating for the first time");
                                    } else {
                                        this.indexExists = true;
                                    }
                                } else {
                                    this.loadFactor = totalDocs > 200 ? 10L : 1000L;
                                    if (totalDocs == 0) {
                                        process = false;
                                    } else if (totalDocs < 20 && interval > 20L * this.loadFactor) {
                                        process = true;
                                    } else if (totalDocs >= 20 && totalDocs < 50 && interval > 10L * this.loadFactor) {
                                        process = true;
                                    } else if (totalDocs >= 50 && totalDocs < 90 && interval > 5L * this.loadFactor) {
                                        process = true;
                                    } else if ((long)totalDocs > 90L * this.loadFactor / 1000L) {
                                        process = true;
                                    }
                                }
                                long lastLockInterval = System.currentTimeMillis() - this.lastLock;
                                long lastLockMetric = lastLockInterval * (long)totalDocs;
                                log.debug((Object)("Activity " + (lastLockMetric > 10000L * this.loadFactor) + " " + (lastLockInterval > 60L * this.loadFactor) + " " + createIndex));
                                if (lastLockMetric > 10000L * this.loadFactor || lastLockInterval > 60L * this.loadFactor || createIndex) {
                                    log.debug((Object)("===" + process + "=============PROCESSING "));
                                    if (process && this.getLockTransaction(120000L, createIndex)) {
                                        log.debug((Object)("===" + nodeID + "=============PROCESSING "));
                                        if (lockedTo != null && lockedTo.equals(nodeID)) {
                                            log.error((Object)"+++++++++++++++Local Lock Collision+++++++++++++");
                                        }
                                        lockedTo = nodeID;
                                        this.lastLock = System.currentTimeMillis();
                                        if (createIndex) {
                                            log.info((Object)"=======================Search Index being created for the first time");
                                            this.searchIndexBuilderWorkerDao.createIndexTransaction((SearchIndexBuilderWorker)this);
                                            this.indexExists = true;
                                            log.info((Object)"=======================Done creating Search Index for the first time");
                                        } else {
                                            int batchSize = 100;
                                            if (totalDocs > 500) {
                                                batchSize = 200;
                                            } else if (totalDocs > 1000) {
                                                batchSize = 500;
                                            } else if (totalDocs > 10000) {
                                                batchSize = 1000;
                                            }
                                            this.searchIndexBuilderWorkerDao.processToDoListTransaction((SearchIndexBuilderWorker)this, batchSize);
                                        }
                                        this.lastLock = System.currentTimeMillis();
                                        if (lockedTo.equals(nodeID)) {
                                            lockedTo = null;
                                        } else {
                                            log.error((Object)"+++++++++++++++++++++++++++Lost Local Lock+++++++++++");
                                        }
                                        log.debug((Object)("===" + nodeID + "=============COMPLETED "));
                                        break block46;
                                    } else {
                                        var20_19 = null;
                                        this.clearLockTransaction();
                                        break;
                                    }
                                }
                                this.updateNodeLock(120000L);
                                log.debug((Object)"Not taking Lock, too much activity");
                            }
                            catch (Throwable throwable) {
                                var20_19 = null;
                                this.clearLockTransaction();
                                throw throwable;
                            }
                            var20_19 = null;
                            this.clearLockTransaction();
                            break;
                        }
                        var20_19 = null;
                        this.clearLockTransaction();
                    }
                    if (this.indexExists) {
                        try {
                            this.searchService.reload();
                        }
                        catch (Exception ex) {
                            log.info((Object)("No Search Segment exists at present, this is Ok on first start :" + ex.getMessage()));
                        }
                    }
                    if (!this.runThreads) break;
                    try {
                        log.debug((Object)"Sleeping Processing Thread");
                        Object ex = this.sem;
                        synchronized (ex) {
                            log.debug((Object)("++++++WAITING " + nodeID));
                            this.sem.wait(this.sleepTime);
                            log.debug((Object)("+++++ALIVE " + nodeID));
                        }
                        log.debug((Object)"Wakey Wakey Processing Thread");
                        if (ComponentManager.hasBeenClosed()) {
                            this.runThreads = false;
                            break;
                        }
                        if (!this.soakTest || this.searchService.getPendingDocs() != 0) continue;
                        log.error((Object)"SOAK TEST---SOAK TEST---SOAK TEST. Index Rebuild Started");
                        this.searchService.rebuildInstance();
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)(" Exit From sleep " + e.getMessage()));
                        break;
                    }
                }
                Object var23_21 = null;
            }
            catch (Throwable t) {
                log.warn((Object)("Failed in IndexBuilder when indexing document: " + this.getNowIndexing()), t);
                Object var23_22 = null;
                log.debug((Object)("IndexBuilder run exit " + tt.getName()));
                if (threadno == -1) return;
                this.indexBuilderThread[threadno] = null;
                return;
            }
            log.debug((Object)("IndexBuilder run exit " + tt.getName()));
            if (threadno == -1) return;
            this.indexBuilderThread[threadno] = null;
            return;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            log.debug((Object)("IndexBuilder run exit " + tt.getName()));
            if (threadno == -1) throw throwable;
            this.indexBuilderThread[threadno] = null;
            throw throwable;
        }
    }

    private String getNodeID() {
        String nodeID = this.nodeIDHolder.get();
        if (nodeID == null) {
            nodeID = UUID.randomUUID().toString();
            this.nodeIDHolder.set(nodeID);
            if (nodeIDList.get(nodeID) == null) {
                nodeIDList.put(nodeID, nodeID);
            } else {
                log.error((Object)("============NODE ID " + nodeID + " has already been issued, there must be a clash"));
            }
        }
        return nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateNodeLock(long lifeLeft) throws SQLException {
        block72: {
            SQLException e4;
            boolean savedautocommit;
            ResultSet resultSet;
            Statement insertLock;
            Statement selectExpiredNodeLock;
            PreparedStatement deleteExpiredNodeLock;
            PreparedStatement updateNodeLock;
            Connection connection;
            block66: {
                block65: {
                    connection = null;
                    String nodeID = this.getNodeID();
                    updateNodeLock = null;
                    deleteExpiredNodeLock = null;
                    selectExpiredNodeLock = null;
                    insertLock = null;
                    resultSet = null;
                    String threadID = Thread.currentThread().getName();
                    savedautocommit = false;
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    Timestamp nodeExpired = new Timestamp(now.getTime() + lifeLeft);
                    connection = this.dataSource.getConnection();
                    connection.setAutoCommit(false);
                    updateNodeLock = connection.prepareStatement(UPDATE_NODE_LOCK_SQL);
                    deleteExpiredNodeLock = connection.prepareStatement(DELETE_LOCKNODE_SQL);
                    selectExpiredNodeLock = connection.prepareStatement(SELECT_EXPIRED_NODES_SQL);
                    insertLock = connection.prepareStatement(INSERT_LOCK_SQL);
                    int retries = 5;
                    boolean updated = false;
                    while (!updated && retries > 0) {
                        try {
                            block64: {
                                try {
                                    insertLock.clearParameters();
                                    insertLock.setString(1, "Node:" + nodeID);
                                    insertLock.setString(2, nodeID);
                                    insertLock.setString(3, NODE_LOCK + nodeID);
                                    insertLock.setTimestamp(4, nodeExpired);
                                    log.debug((Object)(threadID + " Doing " + INSERT_LOCK_SQL + ":{" + "Node:" + nodeID + "}{" + nodeID + "}{" + NODE_LOCK + nodeID + "}{" + nodeExpired + "}"));
                                    insertLock.executeUpdate();
                                }
                                catch (SQLException ex) {
                                    updateNodeLock.clearParameters();
                                    updateNodeLock.setTimestamp(1, nodeExpired);
                                    updateNodeLock.setString(2, nodeID);
                                    updateNodeLock.setString(3, NODE_LOCK + nodeID);
                                    log.debug((Object)(threadID + " Doing " + UPDATE_NODE_LOCK_SQL + ":{" + nodeExpired + "}{" + nodeID + "}{" + NODE_LOCK + nodeID + "}"));
                                    if (updateNodeLock.executeUpdate() == 1) break block64;
                                    log.warn((Object)("Failed to update node heartbeat " + nodeID));
                                }
                            }
                            log.debug((Object)(threadID + " Doing Commit "));
                            connection.commit();
                            updated = true;
                        }
                        catch (SQLException e22) {
                            log.warn((Object)"Retrying ", (Throwable)e22);
                            try {
                                connection.rollback();
                            }
                            catch (Exception ex) {
                                log.debug((Object)ex);
                            }
                            --retries;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                log.debug((Object)ie);
                            }
                        }
                    }
                    if (!updated) {
                        log.error((Object)"Failed to update node lock, will try next time ");
                    } else {
                        log.debug((Object)("Updated Node Lock on " + nodeID + " to Expire at" + nodeExpired));
                    }
                    retries = 5;
                    updated = false;
                    while (!updated && retries > 0) {
                        try {
                            selectExpiredNodeLock.clearParameters();
                            selectExpiredNodeLock.setTimestamp(1, now);
                            log.debug((Object)(threadID + " Doing " + SELECT_EXPIRED_NODES_SQL + ":{" + now + "}"));
                            resultSet = selectExpiredNodeLock.executeQuery();
                            while (resultSet.next()) {
                                String id = resultSet.getString(1);
                                deleteExpiredNodeLock.clearParameters();
                                deleteExpiredNodeLock.setString(1, id);
                                deleteExpiredNodeLock.execute();
                                connection.commit();
                            }
                            log.debug((Object)(threadID + " Doing Commit"));
                            connection.commit();
                            resultSet.close();
                            updated = true;
                        }
                        catch (SQLException e3) {
                            log.info((Object)("Retrying Delete Due to  " + e3.getMessage()));
                            log.debug((Object)"Detailed Traceback  ", (Throwable)e3);
                            try {
                                resultSet.close();
                            }
                            catch (Exception ex) {
                                log.debug((Object)ex);
                            }
                            try {
                                connection.rollback();
                            }
                            catch (Exception ex) {
                                log.debug((Object)ex);
                            }
                            --retries;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                log.debug((Object)ie);
                            }
                        }
                    }
                    if (updated) break block65;
                    log.warn((Object)"Failed to clear old nodes, will try next time ");
                }
                Object var19_26 = null;
                if (resultSet == null) break block66;
                try {
                    resultSet.close();
                }
                catch (SQLException e4) {
                    log.debug((Object)e4);
                }
            }
            if (insertLock != null) {
                try {
                    insertLock.close();
                }
                catch (SQLException e4) {
                    log.debug((Object)e4);
                }
            }
            if (updateNodeLock != null) {
                try {
                    updateNodeLock.close();
                }
                catch (SQLException e4) {
                    log.debug((Object)e4);
                }
            }
            if (selectExpiredNodeLock != null) {
                try {
                    selectExpiredNodeLock.close();
                }
                catch (SQLException e4) {
                    log.debug((Object)e4);
                }
            }
            if (deleteExpiredNodeLock != null) {
                try {
                    deleteExpiredNodeLock.close();
                }
                catch (SQLException e4) {
                    log.debug((Object)e4);
                }
            }
            if (connection == null) break block72;
            try {
                connection.setAutoCommit(savedautocommit);
                connection.close();
            }
            catch (SQLException e4) {
                log.debug((Object)e4);
            }
            connection = null;
            {
                break block72;
                catch (Exception ex) {
                    log.error((Object)"Failed to register node ", (Throwable)ex);
                    connection.rollback();
                    Object var19_27 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e4) {
                            log.debug((Object)e4);
                        }
                    }
                    if (insertLock != null) {
                        try {
                            insertLock.close();
                        }
                        catch (SQLException e4) {
                            log.debug((Object)e4);
                        }
                    }
                    if (updateNodeLock != null) {
                        try {
                            updateNodeLock.close();
                        }
                        catch (SQLException e4) {
                            log.debug((Object)e4);
                        }
                    }
                    if (selectExpiredNodeLock != null) {
                        try {
                            selectExpiredNodeLock.close();
                        }
                        catch (SQLException e4) {
                            log.debug((Object)e4);
                        }
                    }
                    if (deleteExpiredNodeLock != null) {
                        try {
                            deleteExpiredNodeLock.close();
                        }
                        catch (SQLException e4) {
                            log.debug((Object)e4);
                        }
                    }
                    if (connection == null) break block72;
                    try {
                        connection.setAutoCommit(savedautocommit);
                        connection.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                Object var19_28 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                }
                if (insertLock != null) {
                    try {
                        insertLock.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                }
                if (updateNodeLock != null) {
                    try {
                        updateNodeLock.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                }
                if (selectExpiredNodeLock != null) {
                    try {
                        selectExpiredNodeLock.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                }
                if (deleteExpiredNodeLock != null) {
                    try {
                        deleteExpiredNodeLock.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                }
                if (connection != null) {
                    try {
                        connection.setAutoCommit(savedautocommit);
                        connection.close();
                    }
                    catch (SQLException e4) {
                        log.debug((Object)e4);
                    }
                    connection = null;
                }
                throw throwable;
            }
        }
    }

    public boolean getLockTransaction(long nodeLifetime) {
        return this.getLockTransaction(nodeLifetime, false);
    }

    public boolean getLockTransaction(long nodeLifetime, boolean forceLock) {
        if (this.searchIndexBuilderWorkerDao.isLockRequired()) {
            return this.getHardLock(nodeLifetime, forceLock);
        }
        try {
            this.updateNodeLock(nodeLifetime);
        }
        catch (SQLException e) {
            log.warn((Object)("Failed to update node lock " + e.getClass().getName() + " :" + e.getMessage()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean getHardLock(long nodeLifetime, boolean forceLock) {
        boolean locked;
        block76: {
            SQLException e2222;
            ResultSet resultSet;
            Statement countWork;
            Statement insertLock;
            Statement updateLock;
            Statement selectLock;
            boolean autoCommit;
            Connection connection;
            block69: {
                String nodeID = this.getNodeID();
                connection = null;
                locked = false;
                autoCommit = false;
                selectLock = null;
                updateLock = null;
                insertLock = null;
                countWork = null;
                resultSet = null;
                Timestamp now = new Timestamp(System.currentTimeMillis());
                Timestamp expiryDate = new Timestamp(now.getTime() + 600000L);
                this.updateNodeLock(nodeLifetime);
                connection = this.dataSource.getConnection();
                autoCommit = connection.getAutoCommit();
                if (autoCommit) {
                    connection.setAutoCommit(false);
                }
                selectLock = connection.prepareStatement(SELECT_LOCK_SQL);
                updateLock = connection.prepareStatement(UPDATE_LOCK_SQL);
                insertLock = connection.prepareStatement(INSERT_LOCK_SQL);
                countWork = connection.prepareStatement(COUNT_WORK_SQL);
                SearchWriterLockImpl swl = null;
                selectLock.clearParameters();
                selectLock.setString(1, LOCKKEY);
                resultSet = selectLock.executeQuery();
                if (resultSet.next()) {
                    swl = new SearchWriterLockImpl();
                    swl.setId(resultSet.getString(1));
                    swl.setNodename(resultSet.getString(2));
                    swl.setLockkey(resultSet.getString(3));
                    swl.setExpires((Date)resultSet.getTimestamp(4));
                    log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
                }
                resultSet.close();
                resultSet = null;
                boolean takelock = false;
                if (swl == null) {
                    log.debug((Object)"_-------------NO Lock Record");
                    takelock = true;
                } else if (NO_NODE.equals(swl.getNodename())) {
                    takelock = true;
                    log.debug((Object)(nodeID + "_-------------no lock"));
                } else if (nodeID.equals(swl.getNodename())) {
                    takelock = true;
                    log.debug((Object)(nodeID + "_------------matched threadid "));
                } else if (swl.getExpires() == null || swl.getExpires().before(now)) {
                    takelock = true;
                    log.debug((Object)(nodeID + "_------------thread dead "));
                }
                if (takelock) {
                    int nitems = 0;
                    if (!forceLock) {
                        countWork.clearParameters();
                        countWork.setInt(1, SearchBuilderItem.STATE_PENDING);
                        resultSet = countWork.executeQuery();
                        if (resultSet.next()) {
                            nitems = resultSet.getInt(1);
                        }
                        resultSet.close();
                        resultSet = null;
                    }
                    if (nitems > 0 || forceLock) {
                        try {
                            if (swl == null) {
                                insertLock.clearParameters();
                                insertLock.setString(1, nodeID);
                                insertLock.setString(2, nodeID);
                                insertLock.setString(3, LOCKKEY);
                                insertLock.setTimestamp(4, expiryDate);
                                if (insertLock.executeUpdate() == 1) {
                                    log.debug((Object)("INSERT Lock Record " + nodeID + "::" + nodeID + "::" + expiryDate));
                                    locked = true;
                                }
                            } else {
                                updateLock.clearParameters();
                                updateLock.setString(1, nodeID);
                                updateLock.setTimestamp(2, expiryDate);
                                updateLock.setString(3, swl.getId());
                                updateLock.setString(4, swl.getNodename());
                                updateLock.setString(5, swl.getLockkey());
                                if (updateLock.executeUpdate() == 1) {
                                    log.debug((Object)("UPDATED Lock Record " + swl.getId() + "::" + nodeID + "::" + expiryDate));
                                    locked = true;
                                }
                            }
                        }
                        catch (SQLException sqlex) {
                            locked = false;
                            log.debug((Object)"Failed to get lock, but this is Ok ", (Throwable)sqlex);
                        }
                    }
                }
                connection.commit();
                Object var20_20 = null;
                if (resultSet == null) break block69;
                try {
                    resultSet.close();
                }
                catch (SQLException e2222) {
                    log.debug((Object)e2222);
                }
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e2222) {
                    log.debug((Object)e2222);
                }
            }
            if (updateLock != null) {
                try {
                    updateLock.close();
                }
                catch (SQLException e2222) {
                    log.debug((Object)e2222);
                }
            }
            if (insertLock != null) {
                try {
                    insertLock.close();
                }
                catch (SQLException e2222) {
                    log.debug((Object)e2222);
                }
            }
            if (countWork != null) {
                try {
                    countWork.close();
                }
                catch (SQLException e2222) {
                    log.debug((Object)e2222);
                }
            }
            if (connection == null) break block76;
            try {
                connection.setAutoCommit(autoCommit);
            }
            catch (SQLException e2222) {
                // empty catch block
            }
            try {
                connection.close();
                log.debug((Object)"Connection Closed ");
            }
            catch (SQLException e2222) {
                log.error((Object)"Error Closing Connection ", (Throwable)e2222);
            }
            connection = null;
            {
                break block76;
                catch (Exception ex) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException e3) {
                            log.debug((Object)e3);
                        }
                    }
                    log.error((Object)("Failed to get lock " + ex.getMessage()));
                    locked = false;
                    Object var20_21 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e2222) {
                            log.debug((Object)e2222);
                        }
                    }
                    if (selectLock != null) {
                        try {
                            selectLock.close();
                        }
                        catch (SQLException e2222) {
                            log.debug((Object)e2222);
                        }
                    }
                    if (updateLock != null) {
                        try {
                            updateLock.close();
                        }
                        catch (SQLException e2222) {
                            log.debug((Object)e2222);
                        }
                    }
                    if (insertLock != null) {
                        try {
                            insertLock.close();
                        }
                        catch (SQLException e2222) {
                            log.debug((Object)e2222);
                        }
                    }
                    if (countWork != null) {
                        try {
                            countWork.close();
                        }
                        catch (SQLException e2222) {
                            log.debug((Object)e2222);
                        }
                    }
                    if (connection == null) break block76;
                    try {
                        connection.setAutoCommit(autoCommit);
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                    try {
                        connection.close();
                        log.debug((Object)"Connection Closed ");
                    }
                    catch (SQLException e2222) {
                        log.error((Object)"Error Closing Connection ", (Throwable)e2222);
                    }
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e2222) {
                        log.debug((Object)e2222);
                    }
                }
                if (selectLock != null) {
                    try {
                        selectLock.close();
                    }
                    catch (SQLException e2222) {
                        log.debug((Object)e2222);
                    }
                }
                if (updateLock != null) {
                    try {
                        updateLock.close();
                    }
                    catch (SQLException e2222) {
                        log.debug((Object)e2222);
                    }
                }
                if (insertLock != null) {
                    try {
                        insertLock.close();
                    }
                    catch (SQLException e2222) {
                        log.debug((Object)e2222);
                    }
                }
                if (countWork != null) {
                    try {
                        countWork.close();
                    }
                    catch (SQLException e2222) {
                        log.debug((Object)e2222);
                    }
                }
                if (connection != null) {
                    try {
                        connection.setAutoCommit(autoCommit);
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                    try {
                        connection.close();
                        log.debug((Object)"Connection Closed ");
                    }
                    catch (SQLException e2222) {
                        log.error((Object)"Error Closing Connection ", (Throwable)e2222);
                    }
                    connection = null;
                }
                throw throwable;
            }
        }
        return locked;
    }

    private void clearLockTransaction() {
        if (this.searchIndexBuilderWorkerDao.isLockRequired()) {
            this.clearHardLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void clearHardLock() {
        block23: {
            SQLException e222;
            PreparedStatement clearLock;
            Connection connection;
            block21: {
                String nodeID = this.getNodeID();
                connection = null;
                clearLock = null;
                connection = this.dataSource.getConnection();
                clearLock = connection.prepareStatement(CLEAR_LOCK_SQL);
                clearLock.clearParameters();
                clearLock.setString(1, NO_NODE);
                clearLock.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                clearLock.setString(3, nodeID);
                clearLock.setString(4, LOCKKEY);
                if (clearLock.executeUpdate() == 1) {
                    log.debug((Object)("UNLOCK - OK::" + nodeID + "::now"));
                } else {
                    log.debug((Object)("UNLOCK - no-lock::" + nodeID + "::now"));
                }
                connection.commit();
                Object var7_4 = null;
                if (clearLock == null) break block21;
                try {
                    clearLock.close();
                }
                catch (SQLException e222) {
                    log.error((Object)"Error Closing Prepared Statement ", (Throwable)e222);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed");
                }
                catch (SQLException e222) {
                    log.error((Object)"Error Closing Connection", (Throwable)e222);
                }
            }
            break block23;
            {
                catch (Exception ex) {
                    SQLException e222;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                    log.error((Object)("Failed to clear lock" + ex.getMessage()));
                    Object var7_5 = null;
                    if (clearLock != null) {
                        try {
                            clearLock.close();
                        }
                        catch (SQLException e222) {
                            log.error((Object)"Error Closing Prepared Statement ", (Throwable)e222);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                            log.debug((Object)"Connection Closed");
                        }
                        catch (SQLException e222) {
                            log.error((Object)"Error Closing Connection", (Throwable)e222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var7_6 = null;
                if (clearLock != null) {
                    try {
                        clearLock.close();
                    }
                    catch (SQLException e222) {
                        log.error((Object)"Error Closing Prepared Statement ", (Throwable)e222);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                        log.debug((Object)"Connection Closed");
                    }
                    catch (SQLException e222) {
                        log.error((Object)"Error Closing Connection", (Throwable)e222);
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean isRunning() {
        if (ComponentManager.hasBeenClosed()) {
            this.runThreads = false;
        }
        return this.runThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRunning() {
        if (!this.enabled) {
            return;
        }
        this.runThreads = true;
        Object object = this.threadStartLock;
        synchronized (object) {
            for (int i = 0; i < this.indexBuilderThread.length; ++i) {
                if (this.indexBuilderThread[i] != null) continue;
                this.indexBuilderThread[i] = new Thread(this);
                this.indexBuilderThread[i].setName(String.valueOf(i) + "::" + this.getClass().getName());
                this.indexBuilderThread[i].start();
            }
        }
        object = this.sem;
        synchronized (object) {
            log.debug((Object)"_________NOTIFY");
            this.sem.notify();
            log.debug((Object)"_________NOTIFY COMPLETE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.enabled) {
            return;
        }
        log.debug((Object)"Destroy SearchIndexBuilderWorker ");
        this.runThreads = false;
        Object object = this.sem;
        synchronized (object) {
            this.sem.notifyAll();
        }
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SearchIndexBuilderWorkerDao getSearchIndexBuilderWorkerDao() {
        return this.searchIndexBuilderWorkerDao;
    }

    public void setSearchIndexBuilderWorkerDao(SearchIndexBuilderWorkerDao searchIndexBuilderWorkerDao) {
        this.searchIndexBuilderWorkerDao = searchIndexBuilderWorkerDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SearchWriterLock getCurrentLock() {
        SQLException e222222;
        SearchWriterLockImpl searchWriterLockImpl;
        ResultSet resultSet;
        PreparedStatement selectLock;
        Connection connection;
        block24: {
            this.getNodeID();
            connection = null;
            selectLock = null;
            resultSet = null;
            connection = this.dataSource.getConnection();
            selectLock = connection.prepareStatement(SELECT_LOCK_SQL);
            SearchWriterLockImpl swl = null;
            selectLock.clearParameters();
            selectLock.setString(1, LOCKKEY);
            resultSet = selectLock.executeQuery();
            if (resultSet.next()) {
                swl = new SearchWriterLockImpl();
                swl.setId(resultSet.getString(1));
                swl.setNodename(resultSet.getString(2));
                swl.setLockkey(resultSet.getString(3));
                swl.setExpires((Date)resultSet.getTimestamp(4));
                log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
            }
            resultSet.close();
            resultSet = null;
            if (swl == null) {
                swl = new SearchWriterLockImpl();
                swl.setNodename(NO_NODE);
                swl.setLockkey(LOCKKEY);
                swl.setExpires((Date)new Timestamp(0L));
            }
            searchWriterLockImpl = swl;
            Object var8_8 = null;
            if (resultSet == null) break block24;
            try {
                resultSet.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (selectLock != null) {
            try {
                selectLock.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
                log.debug((Object)"Connection Closed ");
            }
            catch (SQLException e222222) {
                log.error((Object)"Error Closing Connection ", (Throwable)e222222);
            }
            connection = null;
        }
        return searchWriterLockImpl;
        catch (Exception ex) {
            SQLException e222222;
            SearchWriterLockImpl searchWriterLockImpl2;
            block27: {
                try {
                    log.error((Object)("Failed to get lock " + ex.getMessage()));
                    SearchWriterLockImpl swl = new SearchWriterLockImpl();
                    swl.setNodename(NO_NODE);
                    swl.setLockkey(LOCKKEY);
                    swl.setExpires((Date)new Timestamp(0L));
                    searchWriterLockImpl2 = swl;
                    Object var8_9 = null;
                    if (resultSet == null) break block27;
                }
                catch (Throwable throwable) {
                    block30: {
                        SQLException e222222;
                        Object var8_10 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e222222) {
                                // empty catch block
                            }
                        }
                        if (selectLock != null) {
                            try {
                                selectLock.close();
                            }
                            catch (SQLException e222222) {
                                // empty catch block
                            }
                        }
                        if (connection == null) break block30;
                        try {
                            connection.close();
                            log.debug((Object)"Connection Closed ");
                        }
                        catch (SQLException e222222) {
                            log.error((Object)"Error Closing Connection ", (Throwable)e222222);
                        }
                        connection = null;
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e222222) {
                    // empty catch block
                }
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e222222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e222222) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e222222);
                }
                connection = null;
            }
            return searchWriterLockImpl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<SearchWriterLock> getNodeStatus() {
        SQLException e222222;
        Object swl;
        ArrayList<SearchWriterLock> locks;
        ResultSet resultSet;
        PreparedStatement selectLock;
        Connection connection;
        block23: {
            this.getNodeID();
            connection = null;
            selectLock = null;
            resultSet = null;
            locks = new ArrayList<SearchWriterLock>();
            connection = this.dataSource.getConnection();
            selectLock = connection.prepareStatement(SELECT_NODE_LOCK_SQL);
            selectLock.clearParameters();
            resultSet = selectLock.executeQuery();
            while (resultSet.next()) {
                swl = new SearchWriterLockImpl();
                swl.setId(resultSet.getString(1));
                swl.setNodename(resultSet.getString(2));
                swl.setLockkey(resultSet.getString(3));
                swl.setExpires((Date)resultSet.getTimestamp(4));
                log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
                locks.add((SearchWriterLock)swl);
            }
            resultSet.close();
            resultSet = null;
            swl = locks;
            Object var8_7 = null;
            if (resultSet == null) break block23;
            try {
                resultSet.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (selectLock != null) {
            try {
                selectLock.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
                log.debug((Object)"Connection Closed ");
            }
            catch (SQLException e222222) {
                log.error((Object)"Error Closing Connection ", (Throwable)e222222);
            }
            connection = null;
        }
        return swl;
        catch (Exception ex) {
            SQLException e222222;
            ArrayList<SearchWriterLock> arrayList;
            block26: {
                try {
                    log.error((Object)"Failed to load nodes ", (Throwable)ex);
                    arrayList = locks;
                    Object var8_8 = null;
                    if (resultSet == null) break block26;
                }
                catch (Throwable throwable) {
                    block29: {
                        SQLException e222222;
                        Object var8_9 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e222222) {
                                // empty catch block
                            }
                        }
                        if (selectLock != null) {
                            try {
                                selectLock.close();
                            }
                            catch (SQLException e222222) {
                                // empty catch block
                            }
                        }
                        if (connection == null) break block29;
                        try {
                            connection.close();
                            log.debug((Object)"Connection Closed ");
                        }
                        catch (SQLException e222222) {
                            log.error((Object)"Error Closing Connection ", (Throwable)e222222);
                        }
                        connection = null;
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e222222) {
                    // empty catch block
                }
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e222222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e222222) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e222222);
                }
                connection = null;
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeWorkerLock() {
        block100: {
            block95: {
                block94: {
                    block93: {
                        block92: {
                            block70: {
                                block99: {
                                    block91: {
                                        block90: {
                                            block89: {
                                                block88: {
                                                    block71: {
                                                        block98: {
                                                            block87: {
                                                                block86: {
                                                                    block85: {
                                                                        block84: {
                                                                            block69: {
                                                                                block97: {
                                                                                    block83: {
                                                                                        block82: {
                                                                                            block81: {
                                                                                                block67: {
                                                                                                    block68: {
                                                                                                        connection = null;
                                                                                                        selectLock = null;
                                                                                                        selectNodeLock = null;
                                                                                                        clearLock = null;
                                                                                                        resultSet = null;
                                                                                                        try {
                                                                                                            try {
                                                                                                                connection = this.dataSource.getConnection();
                                                                                                                selectNodeLock = connection.prepareStatement(SearchIndexBuilderWorkerImpl.SELECT_NODE_LOCK_SQL);
                                                                                                                selectLock = connection.prepareStatement(SearchIndexBuilderWorkerImpl.SELECT_LOCK_SQL);
                                                                                                                clearLock = connection.prepareStatement(SearchIndexBuilderWorkerImpl.CLEAR_LOCK_SQL);
                                                                                                                swl = null;
                                                                                                                selectLock.clearParameters();
                                                                                                                selectLock.setString(1, "searchlockkey");
                                                                                                                resultSet = selectLock.executeQuery();
                                                                                                                if (resultSet.next()) {
                                                                                                                    swl = new SearchWriterLockImpl();
                                                                                                                    swl.setId(resultSet.getString(1));
                                                                                                                    swl.setNodename(resultSet.getString(2));
                                                                                                                    swl.setLockkey(resultSet.getString(3));
                                                                                                                    swl.setExpires((Date)resultSet.getTimestamp(4));
                                                                                                                    resultSet.close();
                                                                                                                    resultSet = null;
                                                                                                                    selectNodeLock.clearParameters();
                                                                                                                    resultSet = selectLock.executeQuery();
                                                                                                                } else {
                                                                                                                    connection.rollback();
                                                                                                                    var7_8 = true;
                                                                                                                    var10_13 = null;
                                                                                                                    if (resultSet == null) break block67;
                                                                                                                    break block68;
                                                                                                                }
                                                                                                                while (resultSet.next()) {
                                                                                                                    node = new SearchWriterLockImpl();
                                                                                                                    node.setId(resultSet.getString(1));
                                                                                                                    node.setNodename(resultSet.getString(2));
                                                                                                                    node.setLockkey(resultSet.getString(3));
                                                                                                                    node.setExpires((Date)resultSet.getTimestamp(4));
                                                                                                                    if (!swl.getNodename().equals(node.getNodename())) continue;
                                                                                                                    SearchIndexBuilderWorkerImpl.log.info((Object)("Cant remove Lock to node " + node.getNodename() + " node exists "));
                                                                                                                    connection.rollback();
                                                                                                                    var8_25 = false;
                                                                                                                    break block69;
                                                                                                                }
                                                                                                                resultSet.close();
                                                                                                                resultSet = null;
                                                                                                                clearLock.clearParameters();
                                                                                                                clearLock.setString(1, "none");
                                                                                                                clearLock.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                                                                                                                clearLock.setString(3, swl.getNodename());
                                                                                                                clearLock.setString(4, "searchlockkey");
                                                                                                                if (clearLock.executeUpdate() == 1) {
                                                                                                                    SearchIndexBuilderWorkerImpl.log.warn((Object)("NODE UNLOCKED BY USER " + swl.getNodename()));
                                                                                                                    connection.commit();
                                                                                                                    var7_11 = true;
                                                                                                                    break block70;
                                                                                                                }
                                                                                                                SearchIndexBuilderWorkerImpl.log.info((Object)("NODE NOT UNLOCKED BY USER " + swl.getNodename()));
                                                                                                                connection.commit();
                                                                                                                var7_10 = false;
                                                                                                                break block71;
                                                                                                            }
                                                                                                            catch (Exception ex) {
                                                                                                                SearchIndexBuilderWorkerImpl.log.error((Object)"Failed to unlock ", (Throwable)ex);
                                                                                                                var7_12 = false;
                                                                                                                var10_17 = null;
                                                                                                                if (resultSet != null) {
                                                                                                                    try {
                                                                                                                        resultSet.close();
                                                                                                                    }
                                                                                                                    catch (SQLException e) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                                if (selectLock != null) {
                                                                                                                    try {
                                                                                                                        selectLock.close();
                                                                                                                    }
                                                                                                                    catch (SQLException e) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                                if (selectNodeLock != null) {
                                                                                                                    try {
                                                                                                                        selectNodeLock.close();
                                                                                                                    }
                                                                                                                    catch (SQLException e) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                                if (clearLock != null) {
                                                                                                                    try {
                                                                                                                        clearLock.close();
                                                                                                                    }
                                                                                                                    catch (SQLException e) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                                if (connection == null) return var7_12;
                                                                                                                try {
                                                                                                                    connection.close();
                                                                                                                    SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
                                                                                                                }
                                                                                                                catch (SQLException e) {
                                                                                                                    SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
                                                                                                                }
                                                                                                                connection = null;
                                                                                                                return var7_12;
                                                                                                            }
                                                                                                        }
                                                                                                        catch (Throwable var9_26) {
                                                                                                            block96: {
                                                                                                                block80: {
                                                                                                                    block79: {
                                                                                                                        block78: {
                                                                                                                            block77: {
                                                                                                                                var10_18 = null;
                                                                                                                                if (resultSet != null) {
                                                                                                                                    ** try [egrp 2[TRYBLOCK] [10 : 578->588)] { 
lbl111:
                                                                                                                                    // 1 sources

                                                                                                                                    resultSet.close();
                                                                                                                                    break block77;
lbl113:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (SQLException e) {
                                                                                                                                        // empty catch block
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                            if (selectLock != null) {
                                                                                                                                ** try [egrp 3[TRYBLOCK] [11 : 594->603)] { 
lbl118:
                                                                                                                                // 1 sources

                                                                                                                                selectLock.close();
                                                                                                                                break block78;
lbl120:
                                                                                                                                // 1 sources

                                                                                                                                catch (SQLException e) {
                                                                                                                                    // empty catch block
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (selectNodeLock != null) {
                                                                                                                            ** try [egrp 4[TRYBLOCK] [12 : 609->618)] { 
lbl125:
                                                                                                                            // 1 sources

                                                                                                                            selectNodeLock.close();
                                                                                                                            break block79;
lbl127:
                                                                                                                            // 1 sources

                                                                                                                            catch (SQLException e) {
                                                                                                                                // empty catch block
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (clearLock != null) {
                                                                                                                        ** try [egrp 5[TRYBLOCK] [13 : 625->635)] { 
lbl132:
                                                                                                                        // 1 sources

                                                                                                                        clearLock.close();
                                                                                                                        break block80;
lbl134:
                                                                                                                        // 1 sources

                                                                                                                        catch (SQLException e) {
                                                                                                                            // empty catch block
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                                if (connection == null) throw var9_26;
                                                                                                                ** try [egrp 6[TRYBLOCK] [14 : 641->660)] { 
lbl139:
                                                                                                                // 1 sources

                                                                                                                connection.close();
                                                                                                                SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
                                                                                                                break block96;
lbl142:
                                                                                                                // 1 sources

                                                                                                                catch (SQLException e) {
                                                                                                                    SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
                                                                                                                }
                                                                                                            }
                                                                                                            connection = null;
                                                                                                            throw var9_26;
                                                                                                        }
                                                                                                    }
                                                                                                    ** try [egrp 2[TRYBLOCK] [10 : 578->588)] { 
lbl149:
                                                                                                    // 1 sources

                                                                                                    resultSet.close();
                                                                                                    break block67;
lbl151:
                                                                                                    // 1 sources

                                                                                                    catch (SQLException e) {
                                                                                                        // empty catch block
                                                                                                    }
                                                                                                }
                                                                                                if (selectLock != null) {
                                                                                                    ** try [egrp 3[TRYBLOCK] [11 : 594->603)] { 
lbl156:
                                                                                                    // 1 sources

                                                                                                    selectLock.close();
                                                                                                    break block81;
lbl158:
                                                                                                    // 1 sources

                                                                                                    catch (SQLException e) {
                                                                                                        // empty catch block
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if (selectNodeLock != null) {
                                                                                                ** try [egrp 4[TRYBLOCK] [12 : 609->618)] { 
lbl163:
                                                                                                // 1 sources

                                                                                                selectNodeLock.close();
                                                                                                break block82;
lbl165:
                                                                                                // 1 sources

                                                                                                catch (SQLException e) {
                                                                                                    // empty catch block
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (clearLock != null) {
                                                                                            ** try [egrp 5[TRYBLOCK] [13 : 625->635)] { 
lbl170:
                                                                                            // 1 sources

                                                                                            clearLock.close();
                                                                                            break block83;
lbl172:
                                                                                            // 1 sources

                                                                                            catch (SQLException e) {
                                                                                                // empty catch block
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (connection == null) return var7_8;
                                                                                    ** try [egrp 6[TRYBLOCK] [14 : 641->660)] { 
lbl177:
                                                                                    // 1 sources

                                                                                    connection.close();
                                                                                    SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
                                                                                    break block97;
lbl180:
                                                                                    // 1 sources

                                                                                    catch (SQLException e) {
                                                                                        SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
                                                                                    }
                                                                                }
                                                                                connection = null;
                                                                                return var7_8;
                                                                            }
                                                                            var10_14 = null;
                                                                            if (resultSet != null) {
                                                                                ** try [egrp 2[TRYBLOCK] [10 : 578->588)] { 
lbl189:
                                                                                // 1 sources

                                                                                resultSet.close();
                                                                                break block84;
lbl191:
                                                                                // 1 sources

                                                                                catch (SQLException e) {
                                                                                    // empty catch block
                                                                                }
                                                                            }
                                                                        }
                                                                        if (selectLock != null) {
                                                                            ** try [egrp 3[TRYBLOCK] [11 : 594->603)] { 
lbl196:
                                                                            // 1 sources

                                                                            selectLock.close();
                                                                            break block85;
lbl198:
                                                                            // 1 sources

                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    if (selectNodeLock != null) {
                                                                        ** try [egrp 4[TRYBLOCK] [12 : 609->618)] { 
lbl203:
                                                                        // 1 sources

                                                                        selectNodeLock.close();
                                                                        break block86;
lbl205:
                                                                        // 1 sources

                                                                        catch (SQLException e) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (clearLock != null) {
                                                                    ** try [egrp 5[TRYBLOCK] [13 : 625->635)] { 
lbl210:
                                                                    // 1 sources

                                                                    clearLock.close();
                                                                    break block87;
lbl212:
                                                                    // 1 sources

                                                                    catch (SQLException e) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            if (connection == null) return var8_25;
                                                            ** try [egrp 6[TRYBLOCK] [14 : 641->660)] { 
lbl217:
                                                            // 1 sources

                                                            connection.close();
                                                            SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
                                                            break block98;
lbl220:
                                                            // 1 sources

                                                            catch (SQLException e) {
                                                                SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
                                                            }
                                                        }
                                                        connection = null;
                                                        return var8_25;
                                                    }
                                                    var10_15 = null;
                                                    if (resultSet != null) {
                                                        ** try [egrp 2[TRYBLOCK] [10 : 578->588)] { 
lbl229:
                                                        // 1 sources

                                                        resultSet.close();
                                                        break block88;
lbl231:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (selectLock != null) {
                                                    ** try [egrp 3[TRYBLOCK] [11 : 594->603)] { 
lbl236:
                                                    // 1 sources

                                                    selectLock.close();
                                                    break block89;
lbl238:
                                                    // 1 sources

                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (selectNodeLock != null) {
                                                ** try [egrp 4[TRYBLOCK] [12 : 609->618)] { 
lbl243:
                                                // 1 sources

                                                selectNodeLock.close();
                                                break block90;
lbl245:
                                                // 1 sources

                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (clearLock != null) {
                                            ** try [egrp 5[TRYBLOCK] [13 : 625->635)] { 
lbl250:
                                            // 1 sources

                                            clearLock.close();
                                            break block91;
lbl252:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (connection == null) return var7_10;
                                    ** try [egrp 6[TRYBLOCK] [14 : 641->660)] { 
lbl257:
                                    // 1 sources

                                    connection.close();
                                    SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
                                    break block99;
lbl260:
                                    // 1 sources

                                    catch (SQLException e) {
                                        SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
                                    }
                                }
                                connection = null;
                                return var7_10;
                            }
                            var10_16 = null;
                            if (resultSet != null) {
                                ** try [egrp 2[TRYBLOCK] [10 : 578->588)] { 
lbl269:
                                // 1 sources

                                resultSet.close();
                                break block92;
lbl271:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (selectLock != null) {
                            ** try [egrp 3[TRYBLOCK] [11 : 594->603)] { 
lbl276:
                            // 1 sources

                            selectLock.close();
                            break block93;
lbl278:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (selectNodeLock != null) {
                        ** try [egrp 4[TRYBLOCK] [12 : 609->618)] { 
lbl283:
                        // 1 sources

                        selectNodeLock.close();
                        break block94;
lbl285:
                        // 1 sources

                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                }
                if (clearLock != null) {
                    ** try [egrp 5[TRYBLOCK] [13 : 625->635)] { 
lbl290:
                    // 1 sources

                    clearLock.close();
                    break block95;
lbl292:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (connection == null) return var7_11;
            ** try [egrp 6[TRYBLOCK] [14 : 641->660)] { 
lbl297:
            // 1 sources

            connection.close();
            SearchIndexBuilderWorkerImpl.log.debug((Object)"Connection Closed ");
            break block100;
lbl300:
            // 1 sources

            catch (SQLException e) {
                SearchIndexBuilderWorkerImpl.log.error((Object)"Error Closing Connection ", (Throwable)e);
            }
        }
        connection = null;
        return var7_11;
    }

    public long getLastEventTime() {
        return this.lastEvent;
    }

    public void setLastIndex(long l) {
        this.lastIndex = l;
    }

    public void setStartDocIndex(long startDocIndex) {
        this.startDocIndex = startDocIndex;
    }

    public void setNowIndexing(String reference) {
        this.lastIndexing = this.nowIndexing;
        this.nowIndexing = reference;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public String getNowIndexing() {
        return this.nowIndexing;
    }

    public long getStartDocIndex() {
        return this.startDocIndex;
    }

    public String getLastDocument() {
        return this.lastIndexing;
    }

    public String getLastElapsed() {
        long l = this.lastIndex;
        long h = l / 3600000L;
        long m = (l -= 3600000L * h) / 600000L;
        long s = (l -= 60000L * m) / 1000L;
        return "" + h + "h" + m + "m" + s + "." + (l -= 1000L * s) + "s";
    }

    public String getCurrentDocument() {
        return this.nowIndexing;
    }

    public String getCurrentElapsed() {
        long l = System.currentTimeMillis() - this.startDocIndex;
        long h = l / 3600000L;
        long m = (l -= 3600000L * h) / 60000L;
        long s = (l -= 60000L * m) / 1000L;
        return "" + h + "h" + m + "m" + s + "." + (l -= 1000L * s) + "s";
    }

    public long getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(long loadFactor) {
        this.loadFactor = loadFactor;
    }

    public boolean isLocalLock() {
        if (lockedTo == null) {
            return false;
        }
        return !this.getNodeID().equals(lockedTo);
    }

    public boolean getSoakTest() {
        return this.soakTest;
    }

    public void setSoakTest(boolean soakTest) {
        this.soakTest = soakTest;
        if (soakTest) {
            log.warn((Object)"SOAK TEST ACTIVE ======================DONT USE FOR PRODUCTION ");
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public SearchIndexBuilderImpl getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilderImpl searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }
}

