/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.PortalUrlEnabledProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.component.service.impl.SearchResultImpl;
import org.sakaiproject.search.filter.SearchItemFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchListImpl
implements SearchList {
    private static Log dlog = LogFactory.getLog(SearchListImpl.class);
    private Hits h;
    private Query query;
    private int start = 0;
    private int end = 500;
    private Analyzer analyzer;
    private SearchItemFilter filter;
    private SearchIndexBuilder searchIndexBuilder;
    private SearchService searchService;

    public SearchListImpl(Hits h, Query query, int start, int end, Analyzer analyzer, SearchItemFilter filter, SearchIndexBuilder searchIndexBuilder, SearchService searchService) {
        this.h = h;
        this.query = query;
        this.start = start;
        this.end = end;
        this.analyzer = analyzer;
        this.filter = filter;
        this.searchIndexBuilder = searchIndexBuilder;
        this.searchService = searchService;
    }

    public Iterator<SearchResult> iterator(final int startAt) {
        return new Iterator<SearchResult>(){
            int counter;
            {
                this.counter = Math.max(startAt, SearchListImpl.this.start);
            }

            @Override
            public boolean hasNext() {
                return this.counter < Math.min(SearchListImpl.this.h.length(), SearchListImpl.this.end);
            }

            @Override
            public SearchResult next() {
                try {
                    int thisHit = this.counter++;
                    SearchResultImpl result = new SearchResultImpl(SearchListImpl.this.h, thisHit, SearchListImpl.this.query, SearchListImpl.this.analyzer, SearchListImpl.this.searchIndexBuilder, SearchListImpl.this.searchService);
                    String url = this.checkUrl(result.getReference());
                    if (url != null) {
                        result.setUrl(url);
                    }
                    return SearchListImpl.this.filter.filter(result);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cant get Hit for some reason ", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not Implemented");
            }

            private String checkUrl(String reference) {
                if (SearchListImpl.this.searchIndexBuilder != null) {
                    EntityContentProducer ecp = SearchListImpl.this.searchIndexBuilder.newEntityContentProducer(reference);
                    if (ecp == null) {
                        return null;
                    }
                    if (PortalUrlEnabledProducer.class.isAssignableFrom(ecp.getClass())) {
                        return ecp.getUrl(reference);
                    }
                }
                return null;
            }
        };
    }

    public int size() {
        return Math.min(this.h.length(), this.end - this.start);
    }

    public int getFullSize() {
        return this.h.length();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Iterator<SearchResult> iterator() {
        return this.iterator(0);
    }

    public Object[] toArray() {
        Object[] o;
        try {
            o = new Object[this.size()];
            for (int i = 0; i < o.length; ++i) {
                o[i + this.start] = this.filter.filter(new SearchResultImpl(this.h, i + this.start, this.query, this.analyzer, this.searchIndexBuilder, this.searchService));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load all results ", e);
        }
        return o;
    }

    public Object[] toArray(Object[] arg0) {
        if (arg0 instanceof SearchResult[]) {
            return this.toArray();
        }
        return null;
    }

    public boolean add(SearchResult arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public SearchResult get(int arg0) {
        try {
            return this.filter.filter(new SearchResultImpl(this.h, arg0, this.query, this.analyzer, this.searchIndexBuilder, this.searchService));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve result ", e);
        }
    }

    public SearchResult set(int arg0, SearchResult arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public void add(int arg0, SearchResult arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public SearchResult remove(int arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public ListIterator<SearchResult> listIterator() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public ListIterator<SearchResult> listIterator(int arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public List<SearchResult> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int getStart() {
        return this.start;
    }
}

