/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.search.api.SearchIndexBuilderWorker;
import org.sakaiproject.search.api.SearchStatus;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.component.service.impl.BaseSearchServiceImpl;
import org.sakaiproject.search.model.SearchWriterLock;

public class SearchServiceImpl
extends BaseSearchServiceImpl {
    private static Log log = LogFactory.getLog(SearchServiceImpl.class);
    private SearchIndexBuilderWorker searchIndexBuilderWorker;
    private long reloadStart;
    private long reloadEnd;

    public void init() {
        super.init();
        try {
            try {
                if (this.autoDdl) {
                    SqlService.getInstance().ddl(this.getClass().getClassLoader(), "sakai_search");
                }
            }
            catch (Exception ex) {
                log.error((Object)"Perform additional SQL setup", (Throwable)ex);
            }
            this.initComplete = true;
        }
        catch (Throwable t) {
            log.error((Object)"Failed to start ", t);
        }
    }

    public String getStatus() {
        String lastLoad = new Date(this.reloadEnd).toString();
        String loadTime = String.valueOf(0.001 * (double)(this.reloadEnd - this.reloadStart));
        return Messages.getString("SearchServiceImpl.40") + lastLoad + Messages.getString("SearchServiceImpl.38") + loadTime + Messages.getString("SearchServiceImpl.37");
    }

    public SearchStatus getSearchStatus() {
        String ll = Messages.getString("SearchServiceImpl.36");
        String lt = "";
        if (this.reloadEnd != 0L) {
            ll = new Date(this.reloadEnd).toString();
            lt = String.valueOf(0.001 * (double)(this.reloadEnd - this.reloadStart));
        }
        final String lastLoad = ll;
        final String loadTime = lt;
        final SearchWriterLock lock = this.searchIndexBuilderWorker.getCurrentLock();
        final List lockNodes = this.searchIndexBuilderWorker.getNodeStatus();
        final String pdocs = String.valueOf(this.getPendingDocs());
        final String ndocs = String.valueOf(this.getNDocs());
        return new SearchStatus(){

            public String getLastLoad() {
                return lastLoad;
            }

            public String getLoadTime() {
                return loadTime;
            }

            public String getCurrentWorker() {
                return lock.getNodename();
            }

            public String getCurrentWorkerETC() {
                if (SecurityService.isSuperUser()) {
                    return MessageFormat.format(Messages.getString("SearchServiceImpl.35"), lock.getExpires(), SearchServiceImpl.this.searchIndexBuilderWorker.getLastDocument(), SearchServiceImpl.this.searchIndexBuilderWorker.getLastElapsed(), SearchServiceImpl.this.searchIndexBuilderWorker.getCurrentDocument(), SearchServiceImpl.this.searchIndexBuilderWorker.getCurrentElapsed(), ServerConfigurationService.getServerIdInstance());
                }
                return MessageFormat.format(Messages.getString("SearchServiceImpl.39"), lock.getExpires());
            }

            public List<Object[]> getWorkerNodes() {
                ArrayList<Object[]> l = new ArrayList<Object[]>();
                for (SearchWriterLock swl : lockNodes) {
                    Object[] result = new Object[]{swl.getNodename(), swl.getExpires(), lock.getNodename().equals(swl.getNodename()) ? Messages.getString("SearchServiceImpl.47") : Messages.getString("SearchServiceImpl.48")};
                    l.add(result);
                }
                return l;
            }

            public String getNDocuments() {
                return ndocs;
            }

            public String getPDocuments() {
                return pdocs;
            }
        };
    }

    public boolean removeWorkerLock() {
        return this.searchIndexBuilderWorker.removeWorkerLock();
    }

    public SearchIndexBuilderWorker getSearchIndexBuilderWorker() {
        return this.searchIndexBuilderWorker;
    }

    public void setSearchIndexBuilderWorker(SearchIndexBuilderWorker searchIndexBuilderWorker) {
        this.searchIndexBuilderWorker = searchIndexBuilderWorker;
    }
}

