/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.sakaiproject.search.index.AnalyzerFactory;
import org.sakaiproject.search.indexer.api.IndexUpdateTransaction;
import org.sakaiproject.search.indexer.api.IndexUpdateTransactionListener;
import org.sakaiproject.search.indexer.impl.IndexUpdateTransactionImpl;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.api.TransactionListener;
import org.sakaiproject.search.transaction.impl.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionIndexManagerImpl
extends TransactionManagerImpl {
    private static final Log log = LogFactory.getLog(TransactionIndexManagerImpl.class);
    protected static final String TEMP_INDEX_NAME = "indextx-";
    private AnalyzerFactory analyzerFactory = null;
    private JournalSettings journalSettings;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public IndexUpdateTransaction openTransaction(Map<String, Object> m) throws IndexTransactionException {
        IndexUpdateTransactionImpl it = new IndexUpdateTransactionImpl(this, this.journalSettings, m);
        it.open();
        return it;
    }

    protected File getTemporarySegment(long txid) throws IOException {
        File f = null;
        f = new File(this.journalSettings.getIndexerWorkingDirectory(), TEMP_INDEX_NAME + txid);
        if (f.exists() || !f.mkdirs()) {
            throw new IOException("Failed to create index transaction working space ");
        }
        return f;
    }

    public Analyzer getAnalyzer() {
        return this.analyzerFactory.newAnalyzer();
    }

    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(AnalyzerFactory analyzerFactory) {
        this.analyzerFactory = analyzerFactory;
    }

    @Override
    public void addTransactionListener(TransactionListener transactionListener) {
        if (!(transactionListener instanceof IndexUpdateTransactionListener)) {
            throw new RuntimeException("transactionListener must implement JournalTransactionListener " + transactionListener);
        }
        super.addTransactionListener(transactionListener);
    }

    @Override
    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        for (TransactionListener tl : transactionListeners) {
            if (tl instanceof IndexUpdateTransactionListener) continue;
            throw new RuntimeException("transactionListener must implement JournalTransactionListener " + tl);
        }
        super.setTransactionListeners(transactionListeners);
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }
}

